// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package servicefabricmesh

import original "github.com/Azure/azure-sdk-for-go/services/preview/servicefabricmesh/mgmt/2018-07-01-preview/servicefabricmesh"

type ApplicationClient = original.ApplicationClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type CodePackageClient = original.CodePackageClient
type ApplicationResourceStatus = original.ApplicationResourceStatus

const (
	Creating  ApplicationResourceStatus = original.Creating
	Deleting  ApplicationResourceStatus = original.Deleting
	Failed    ApplicationResourceStatus = original.Failed
	Invalid   ApplicationResourceStatus = original.Invalid
	Ready     ApplicationResourceStatus = original.Ready
	Upgrading ApplicationResourceStatus = original.Upgrading
)

type DiagnosticsSinkKind = original.DiagnosticsSinkKind

const (
	DiagnosticsSinkKindAzureInternalMonitoringPipeline DiagnosticsSinkKind = original.DiagnosticsSinkKindAzureInternalMonitoringPipeline
	DiagnosticsSinkKindInvalid                         DiagnosticsSinkKind = original.DiagnosticsSinkKindInvalid
)

type HealthState = original.HealthState

const (
	HealthStateError   HealthState = original.HealthStateError
	HealthStateInvalid HealthState = original.HealthStateInvalid
	HealthStateOk      HealthState = original.HealthStateOk
	HealthStateUnknown HealthState = original.HealthStateUnknown
	HealthStateWarning HealthState = original.HealthStateWarning
)

type IngressQoSLevel = original.IngressQoSLevel

const (
	Bronze IngressQoSLevel = original.Bronze
)

type Kind = original.Kind

const (
	KindAzureInternalMonitoringPipeline Kind = original.KindAzureInternalMonitoringPipeline
	KindDiagnosticsSinkProperties       Kind = original.KindDiagnosticsSinkProperties
)

type OperatingSystemTypes = original.OperatingSystemTypes

const (
	Linux   OperatingSystemTypes = original.Linux
	Windows OperatingSystemTypes = original.Windows
)

type ServiceResourceStatus = original.ServiceResourceStatus

const (
	ServiceResourceStatusActive    ServiceResourceStatus = original.ServiceResourceStatusActive
	ServiceResourceStatusCreating  ServiceResourceStatus = original.ServiceResourceStatusCreating
	ServiceResourceStatusDeleting  ServiceResourceStatus = original.ServiceResourceStatusDeleting
	ServiceResourceStatusFailed    ServiceResourceStatus = original.ServiceResourceStatusFailed
	ServiceResourceStatusUnknown   ServiceResourceStatus = original.ServiceResourceStatusUnknown
	ServiceResourceStatusUpgrading ServiceResourceStatus = original.ServiceResourceStatusUpgrading
)

type ApplicationProperties = original.ApplicationProperties
type ApplicationResourceDescription = original.ApplicationResourceDescription
type ApplicationResourceDescriptionList = original.ApplicationResourceDescriptionList
type ApplicationResourceDescriptionListIterator = original.ApplicationResourceDescriptionListIterator
type ApplicationResourceDescriptionListPage = original.ApplicationResourceDescriptionListPage
type ApplicationResourceProperties = original.ApplicationResourceProperties
type AvailableOperationDisplay = original.AvailableOperationDisplay
type AzureInternalMonitoringPipelineSinkDescription = original.AzureInternalMonitoringPipelineSinkDescription
type ContainerCodePackageProperties = original.ContainerCodePackageProperties
type ContainerEvent = original.ContainerEvent
type ContainerInstanceView = original.ContainerInstanceView
type ContainerLabel = original.ContainerLabel
type ContainerLogs = original.ContainerLogs
type ContainerState = original.ContainerState
type ContainerVolume = original.ContainerVolume
type DiagnosticsDescription = original.DiagnosticsDescription
type DiagnosticsRef = original.DiagnosticsRef
type BasicDiagnosticsSinkProperties = original.BasicDiagnosticsSinkProperties
type DiagnosticsSinkProperties = original.DiagnosticsSinkProperties
type EndpointProperties = original.EndpointProperties
type EnvironmentVariable = original.EnvironmentVariable
type ErrorModel = original.ErrorModel
type ImageRegistryCredential = original.ImageRegistryCredential
type IngressConfig = original.IngressConfig
type Layer4IngressConfig = original.Layer4IngressConfig
type ManagedProxyResource = original.ManagedProxyResource
type NetworkProperties = original.NetworkProperties
type NetworkRef = original.NetworkRef
type NetworkResourceDescription = original.NetworkResourceDescription
type NetworkResourceDescriptionList = original.NetworkResourceDescriptionList
type NetworkResourceDescriptionListIterator = original.NetworkResourceDescriptionListIterator
type NetworkResourceDescriptionListPage = original.NetworkResourceDescriptionListPage
type NetworkResourceProperties = original.NetworkResourceProperties
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResult = original.OperationResult
type ProvisionedResourceProperties = original.ProvisionedResourceProperties
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ResourceLimits = original.ResourceLimits
type ResourceRequests = original.ResourceRequests
type ResourceRequirements = original.ResourceRequirements
type ServiceList = original.ServiceList
type ServiceListIterator = original.ServiceListIterator
type ServiceListPage = original.ServiceListPage
type ServiceReplicaDescription = original.ServiceReplicaDescription
type ServiceReplicaList = original.ServiceReplicaList
type ServiceReplicaListIterator = original.ServiceReplicaListIterator
type ServiceReplicaListPage = original.ServiceReplicaListPage
type ServiceReplicaProperties = original.ServiceReplicaProperties
type ServiceResourceDescription = original.ServiceResourceDescription
type ServiceResourceProperties = original.ServiceResourceProperties
type Setting = original.Setting
type TrackedResource = original.TrackedResource
type VolumeProperties = original.VolumeProperties
type VolumeProviderParametersAzureFile = original.VolumeProviderParametersAzureFile
type VolumeResourceDescription = original.VolumeResourceDescription
type VolumeResourceDescriptionList = original.VolumeResourceDescriptionList
type VolumeResourceDescriptionListIterator = original.VolumeResourceDescriptionListIterator
type VolumeResourceDescriptionListPage = original.VolumeResourceDescriptionListPage
type VolumeResourceProperties = original.VolumeResourceProperties
type NetworkClient = original.NetworkClient
type OperationsClient = original.OperationsClient
type ReplicaClient = original.ReplicaClient
type ServiceClient = original.ServiceClient
type VolumeClient = original.VolumeClient

func NewApplicationClient(subscriptionID string) ApplicationClient {
	return original.NewApplicationClient(subscriptionID)
}
func NewApplicationClientWithBaseURI(baseURI string, subscriptionID string) ApplicationClient {
	return original.NewApplicationClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewCodePackageClient(subscriptionID string) CodePackageClient {
	return original.NewCodePackageClient(subscriptionID)
}
func NewCodePackageClientWithBaseURI(baseURI string, subscriptionID string) CodePackageClient {
	return original.NewCodePackageClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleApplicationResourceStatusValues() []ApplicationResourceStatus {
	return original.PossibleApplicationResourceStatusValues()
}
func PossibleDiagnosticsSinkKindValues() []DiagnosticsSinkKind {
	return original.PossibleDiagnosticsSinkKindValues()
}
func PossibleHealthStateValues() []HealthState {
	return original.PossibleHealthStateValues()
}
func PossibleIngressQoSLevelValues() []IngressQoSLevel {
	return original.PossibleIngressQoSLevelValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return original.PossibleOperatingSystemTypesValues()
}
func PossibleServiceResourceStatusValues() []ServiceResourceStatus {
	return original.PossibleServiceResourceStatusValues()
}
func NewNetworkClient(subscriptionID string) NetworkClient {
	return original.NewNetworkClient(subscriptionID)
}
func NewNetworkClientWithBaseURI(baseURI string, subscriptionID string) NetworkClient {
	return original.NewNetworkClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewReplicaClient(subscriptionID string) ReplicaClient {
	return original.NewReplicaClient(subscriptionID)
}
func NewReplicaClientWithBaseURI(baseURI string, subscriptionID string) ReplicaClient {
	return original.NewReplicaClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceClient(subscriptionID string) ServiceClient {
	return original.NewServiceClient(subscriptionID)
}
func NewServiceClientWithBaseURI(baseURI string, subscriptionID string) ServiceClient {
	return original.NewServiceClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewVolumeClient(subscriptionID string) VolumeClient {
	return original.NewVolumeClient(subscriptionID)
}
func NewVolumeClientWithBaseURI(baseURI string, subscriptionID string) VolumeClient {
	return original.NewVolumeClientWithBaseURI(baseURI, subscriptionID)
}
