// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/open-cluster-management/api/cluster/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePlacements implements PlacementInterface
type FakePlacements struct {
	Fake *FakeClusterV1alpha1
	ns   string
}

var placementsResource = schema.GroupVersionResource{Group: "cluster.open-cluster-management.io", Version: "v1alpha1", Resource: "placements"}

var placementsKind = schema.GroupVersionKind{Group: "cluster.open-cluster-management.io", Version: "v1alpha1", Kind: "Placement"}

// Get takes name of the placement, and returns the corresponding placement object, and an error if there is any.
func (c *FakePlacements) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Placement, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(placementsResource, c.ns, name), &v1alpha1.Placement{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Placement), err
}

// List takes label and field selectors, and returns the list of Placements that match those selectors.
func (c *FakePlacements) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PlacementList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(placementsResource, placementsKind, c.ns, opts), &v1alpha1.PlacementList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.PlacementList{ListMeta: obj.(*v1alpha1.PlacementList).ListMeta}
	for _, item := range obj.(*v1alpha1.PlacementList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested placements.
func (c *FakePlacements) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(placementsResource, c.ns, opts))

}

// Create takes the representation of a placement and creates it.  Returns the server's representation of the placement, and an error, if there is any.
func (c *FakePlacements) Create(ctx context.Context, placement *v1alpha1.Placement, opts v1.CreateOptions) (result *v1alpha1.Placement, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(placementsResource, c.ns, placement), &v1alpha1.Placement{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Placement), err
}

// Update takes the representation of a placement and updates it. Returns the server's representation of the placement, and an error, if there is any.
func (c *FakePlacements) Update(ctx context.Context, placement *v1alpha1.Placement, opts v1.UpdateOptions) (result *v1alpha1.Placement, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(placementsResource, c.ns, placement), &v1alpha1.Placement{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Placement), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePlacements) UpdateStatus(ctx context.Context, placement *v1alpha1.Placement, opts v1.UpdateOptions) (*v1alpha1.Placement, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(placementsResource, "status", c.ns, placement), &v1alpha1.Placement{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Placement), err
}

// Delete takes name of the placement and deletes it. Returns an error if one occurs.
func (c *FakePlacements) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(placementsResource, c.ns, name), &v1alpha1.Placement{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePlacements) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(placementsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.PlacementList{})
	return err
}

// Patch applies the patch and returns the patched placement.
func (c *FakePlacements) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Placement, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(placementsResource, c.ns, name, pt, data, subresources...), &v1alpha1.Placement{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Placement), err
}
