// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListEntitiesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *EntitiesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesDetectionJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListEntitiesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListEntitiesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	EntitiesDetectionJobPropertiesList []EntitiesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListEntitiesDetectionJobs = "ListEntitiesDetectionJobs"

// ListEntitiesDetectionJobsRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets a list of the entity detection jobs that you have submitted.
//
//    // Example sending a request using ListEntitiesDetectionJobsRequest.
//    req := client.ListEntitiesDetectionJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Client) ListEntitiesDetectionJobsRequest(input *ListEntitiesDetectionJobsInput) ListEntitiesDetectionJobsRequest {
	op := &aws.Operation{
		Name:       opListEntitiesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesDetectionJobsInput{}
	}

	req := c.newRequest(op, input, &ListEntitiesDetectionJobsOutput{})
	return ListEntitiesDetectionJobsRequest{Request: req, Input: input, Copy: c.ListEntitiesDetectionJobsRequest}
}

// ListEntitiesDetectionJobsRequest is the request type for the
// ListEntitiesDetectionJobs API operation.
type ListEntitiesDetectionJobsRequest struct {
	*aws.Request
	Input *ListEntitiesDetectionJobsInput
	Copy  func(*ListEntitiesDetectionJobsInput) ListEntitiesDetectionJobsRequest
}

// Send marshals and sends the ListEntitiesDetectionJobs API request.
func (r ListEntitiesDetectionJobsRequest) Send(ctx context.Context) (*ListEntitiesDetectionJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListEntitiesDetectionJobsResponse{
		ListEntitiesDetectionJobsOutput: r.Request.Data.(*ListEntitiesDetectionJobsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListEntitiesDetectionJobsRequestPaginator returns a paginator for ListEntitiesDetectionJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListEntitiesDetectionJobsRequest(input)
//   p := comprehend.NewListEntitiesDetectionJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListEntitiesDetectionJobsPaginator(req ListEntitiesDetectionJobsRequest) ListEntitiesDetectionJobsPaginator {
	return ListEntitiesDetectionJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListEntitiesDetectionJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListEntitiesDetectionJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListEntitiesDetectionJobsPaginator struct {
	aws.Pager
}

func (p *ListEntitiesDetectionJobsPaginator) CurrentPage() *ListEntitiesDetectionJobsOutput {
	return p.Pager.CurrentPage().(*ListEntitiesDetectionJobsOutput)
}

// ListEntitiesDetectionJobsResponse is the response type for the
// ListEntitiesDetectionJobs API operation.
type ListEntitiesDetectionJobsResponse struct {
	*ListEntitiesDetectionJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListEntitiesDetectionJobs request.
func (r *ListEntitiesDetectionJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
