// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Input for GetDataRetrievalPolicy.
type GetDataRetrievalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataRetrievalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataRetrievalPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDataRetrievalPolicyInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDataRetrievalPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the Amazon S3 Glacier response to the GetDataRetrievalPolicy request.
type GetDataRetrievalPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Contains the returned data retrieval policy in JSON format.
	Policy *DataRetrievalPolicy `type:"structure"`
}

// String returns the string representation
func (s GetDataRetrievalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDataRetrievalPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Policy", v, metadata)
	}
	return nil
}

const opGetDataRetrievalPolicy = "GetDataRetrievalPolicy"

// GetDataRetrievalPolicyRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation returns the current data retrieval policy for the account
// and region specified in the GET request. For more information about data
// retrieval policies, see Amazon Glacier Data Retrieval Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
//
//    // Example sending a request using GetDataRetrievalPolicyRequest.
//    req := client.GetDataRetrievalPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetDataRetrievalPolicyRequest(input *GetDataRetrievalPolicyInput) GetDataRetrievalPolicyRequest {
	op := &aws.Operation{
		Name:       opGetDataRetrievalPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/policies/data-retrieval",
	}

	if input == nil {
		input = &GetDataRetrievalPolicyInput{}
	}

	req := c.newRequest(op, input, &GetDataRetrievalPolicyOutput{})
	return GetDataRetrievalPolicyRequest{Request: req, Input: input, Copy: c.GetDataRetrievalPolicyRequest}
}

// GetDataRetrievalPolicyRequest is the request type for the
// GetDataRetrievalPolicy API operation.
type GetDataRetrievalPolicyRequest struct {
	*aws.Request
	Input *GetDataRetrievalPolicyInput
	Copy  func(*GetDataRetrievalPolicyInput) GetDataRetrievalPolicyRequest
}

// Send marshals and sends the GetDataRetrievalPolicy API request.
func (r GetDataRetrievalPolicyRequest) Send(ctx context.Context) (*GetDataRetrievalPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDataRetrievalPolicyResponse{
		GetDataRetrievalPolicyOutput: r.Request.Data.(*GetDataRetrievalPolicyOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDataRetrievalPolicyResponse is the response type for the
// GetDataRetrievalPolicy API operation.
type GetDataRetrievalPolicyResponse struct {
	*GetDataRetrievalPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDataRetrievalPolicy request.
func (r *GetDataRetrievalPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
