// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type DeleteBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketReplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketReplicationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketReplicationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketReplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the replication configuration from the bucket.
//
// To use this operation, you must have permissions to perform the s3:PutReplicationConfiguration
// action. The bucket owner has these permissions by default and can grant it
// to others. For more information about permissions, see Permissions Related
// to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// It can take a while for the deletion of a replication configuration to fully
// propagate.
//
// For information about replication configuration, see Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html)
// in the Amazon S3 Developer Guide.
//
// The following operations are related to DeleteBucketReplication:
//
//    * PutBucketReplication
//
//    * GetBucketReplication
//
//    // Example sending a request using DeleteBucketReplicationRequest.
//    req := client.DeleteBucketReplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication
func (c *Client) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) DeleteBucketReplicationRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	req := c.newRequest(op, input, &DeleteBucketReplicationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteBucketReplicationRequest{Request: req, Input: input, Copy: c.DeleteBucketReplicationRequest}
}

// DeleteBucketReplicationRequest is the request type for the
// DeleteBucketReplication API operation.
type DeleteBucketReplicationRequest struct {
	*aws.Request
	Input *DeleteBucketReplicationInput
	Copy  func(*DeleteBucketReplicationInput) DeleteBucketReplicationRequest
}

// Send marshals and sends the DeleteBucketReplication API request.
func (r DeleteBucketReplicationRequest) Send(ctx context.Context) (*DeleteBucketReplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBucketReplicationResponse{
		DeleteBucketReplicationOutput: r.Request.Data.(*DeleteBucketReplicationOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBucketReplicationResponse is the response type for the
// DeleteBucketReplication API operation.
type DeleteBucketReplicationResponse struct {
	*DeleteBucketReplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBucketReplication request.
func (r *DeleteBucketReplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
