// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateDRTRoleInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDRTRoleInput) String() string {
	return awsutil.Prettify(s)
}

type DisassociateDRTRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDRTRoleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateDRTRole = "DisassociateDRTRole"

// DisassociateDRTRoleRequest returns a request value for making API operation for
// AWS Shield.
//
// Removes the DDoS Response team's (DRT) access to your AWS account.
//
// To make a DisassociateDRTRole request, you must be subscribed to the Business
// Support plan (https://aws.amazon.com/premiumsupport/business-support/) or
// the Enterprise Support plan (https://aws.amazon.com/premiumsupport/enterprise-support/).
// However, if you are not subscribed to one of these support plans, but had
// been previously and had granted the DRT access to your account, you can submit
// a DisassociateDRTRole request to remove this access.
//
//    // Example sending a request using DisassociateDRTRoleRequest.
//    req := client.DisassociateDRTRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole
func (c *Client) DisassociateDRTRoleRequest(input *DisassociateDRTRoleInput) DisassociateDRTRoleRequest {
	op := &aws.Operation{
		Name:       opDisassociateDRTRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateDRTRoleInput{}
	}

	req := c.newRequest(op, input, &DisassociateDRTRoleOutput{})
	return DisassociateDRTRoleRequest{Request: req, Input: input, Copy: c.DisassociateDRTRoleRequest}
}

// DisassociateDRTRoleRequest is the request type for the
// DisassociateDRTRole API operation.
type DisassociateDRTRoleRequest struct {
	*aws.Request
	Input *DisassociateDRTRoleInput
	Copy  func(*DisassociateDRTRoleInput) DisassociateDRTRoleRequest
}

// Send marshals and sends the DisassociateDRTRole API request.
func (r DisassociateDRTRoleRequest) Send(ctx context.Context) (*DisassociateDRTRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateDRTRoleResponse{
		DisassociateDRTRoleOutput: r.Request.Data.(*DisassociateDRTRoleOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateDRTRoleResponse is the response type for the
// DisassociateDRTRole API operation.
type DisassociateDRTRoleResponse struct {
	*DisassociateDRTRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateDRTRole request.
func (r *DisassociateDRTRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
