//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package powerbidedicated

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/powerbidedicated/mgmt/2021-01-01/powerbidedicated"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CapacityProvisioningState = original.CapacityProvisioningState

const (
	CapacityProvisioningStateDeleting     CapacityProvisioningState = original.CapacityProvisioningStateDeleting
	CapacityProvisioningStateFailed       CapacityProvisioningState = original.CapacityProvisioningStateFailed
	CapacityProvisioningStatePaused       CapacityProvisioningState = original.CapacityProvisioningStatePaused
	CapacityProvisioningStatePausing      CapacityProvisioningState = original.CapacityProvisioningStatePausing
	CapacityProvisioningStatePreparing    CapacityProvisioningState = original.CapacityProvisioningStatePreparing
	CapacityProvisioningStateProvisioning CapacityProvisioningState = original.CapacityProvisioningStateProvisioning
	CapacityProvisioningStateResuming     CapacityProvisioningState = original.CapacityProvisioningStateResuming
	CapacityProvisioningStateScaling      CapacityProvisioningState = original.CapacityProvisioningStateScaling
	CapacityProvisioningStateSucceeded    CapacityProvisioningState = original.CapacityProvisioningStateSucceeded
	CapacityProvisioningStateSuspended    CapacityProvisioningState = original.CapacityProvisioningStateSuspended
	CapacityProvisioningStateSuspending   CapacityProvisioningState = original.CapacityProvisioningStateSuspending
	CapacityProvisioningStateUpdating     CapacityProvisioningState = original.CapacityProvisioningStateUpdating
)

type CapacitySkuTier = original.CapacitySkuTier

const (
	CapacitySkuTierAutoPremiumHost CapacitySkuTier = original.CapacitySkuTierAutoPremiumHost
	CapacitySkuTierPBIEAzure       CapacitySkuTier = original.CapacitySkuTierPBIEAzure
	CapacitySkuTierPremium         CapacitySkuTier = original.CapacitySkuTierPremium
)

type IdentityType = original.IdentityType

const (
	IdentityTypeApplication     IdentityType = original.IdentityTypeApplication
	IdentityTypeKey             IdentityType = original.IdentityTypeKey
	IdentityTypeManagedIdentity IdentityType = original.IdentityTypeManagedIdentity
	IdentityTypeUser            IdentityType = original.IdentityTypeUser
)

type Mode = original.Mode

const (
	ModeGen1 Mode = original.ModeGen1
	ModeGen2 Mode = original.ModeGen2
)

type State = original.State

const (
	StateDeleting     State = original.StateDeleting
	StateFailed       State = original.StateFailed
	StatePaused       State = original.StatePaused
	StatePausing      State = original.StatePausing
	StatePreparing    State = original.StatePreparing
	StateProvisioning State = original.StateProvisioning
	StateResuming     State = original.StateResuming
	StateScaling      State = original.StateScaling
	StateSucceeded    State = original.StateSucceeded
	StateSuspended    State = original.StateSuspended
	StateSuspending   State = original.StateSuspending
	StateUpdating     State = original.StateUpdating
)

type VCoreProvisioningState = original.VCoreProvisioningState

const (
	VCoreProvisioningStateSucceeded VCoreProvisioningState = original.VCoreProvisioningStateSucceeded
)

type VCoreSkuTier = original.VCoreSkuTier

const (
	VCoreSkuTierAutoScale VCoreSkuTier = original.VCoreSkuTierAutoScale
)

type AutoScaleVCore = original.AutoScaleVCore
type AutoScaleVCoreListResult = original.AutoScaleVCoreListResult
type AutoScaleVCoreMutableProperties = original.AutoScaleVCoreMutableProperties
type AutoScaleVCoreProperties = original.AutoScaleVCoreProperties
type AutoScaleVCoreSku = original.AutoScaleVCoreSku
type AutoScaleVCoreUpdateParameters = original.AutoScaleVCoreUpdateParameters
type AutoScaleVCoresClient = original.AutoScaleVCoresClient
type BaseClient = original.BaseClient
type CapacitiesClient = original.CapacitiesClient
type CapacitiesCreateFuture = original.CapacitiesCreateFuture
type CapacitiesDeleteFuture = original.CapacitiesDeleteFuture
type CapacitiesResumeFuture = original.CapacitiesResumeFuture
type CapacitiesSuspendFuture = original.CapacitiesSuspendFuture
type CapacitiesUpdateFuture = original.CapacitiesUpdateFuture
type CapacitySku = original.CapacitySku
type CheckCapacityNameAvailabilityParameters = original.CheckCapacityNameAvailabilityParameters
type CheckCapacityNameAvailabilityResult = original.CheckCapacityNameAvailabilityResult
type DedicatedCapacities = original.DedicatedCapacities
type DedicatedCapacity = original.DedicatedCapacity
type DedicatedCapacityAdministrators = original.DedicatedCapacityAdministrators
type DedicatedCapacityMutableProperties = original.DedicatedCapacityMutableProperties
type DedicatedCapacityProperties = original.DedicatedCapacityProperties
type DedicatedCapacityUpdateParameters = original.DedicatedCapacityUpdateParameters
type ErrorResponse = original.ErrorResponse
type ErrorResponseError = original.ErrorResponseError
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type Resource = original.Resource
type SkuDetailsForExistingResource = original.SkuDetailsForExistingResource
type SkuEnumerationForExistingResourceResult = original.SkuEnumerationForExistingResourceResult
type SkuEnumerationForNewResourceResult = original.SkuEnumerationForNewResourceResult
type SystemData = original.SystemData

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAutoScaleVCoresClient(subscriptionID string) AutoScaleVCoresClient {
	return original.NewAutoScaleVCoresClient(subscriptionID)
}
func NewAutoScaleVCoresClientWithBaseURI(baseURI string, subscriptionID string) AutoScaleVCoresClient {
	return original.NewAutoScaleVCoresClientWithBaseURI(baseURI, subscriptionID)
}
func NewCapacitiesClient(subscriptionID string) CapacitiesClient {
	return original.NewCapacitiesClient(subscriptionID)
}
func NewCapacitiesClientWithBaseURI(baseURI string, subscriptionID string) CapacitiesClient {
	return original.NewCapacitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleCapacityProvisioningStateValues() []CapacityProvisioningState {
	return original.PossibleCapacityProvisioningStateValues()
}
func PossibleCapacitySkuTierValues() []CapacitySkuTier {
	return original.PossibleCapacitySkuTierValues()
}
func PossibleIdentityTypeValues() []IdentityType {
	return original.PossibleIdentityTypeValues()
}
func PossibleModeValues() []Mode {
	return original.PossibleModeValues()
}
func PossibleStateValues() []State {
	return original.PossibleStateValues()
}
func PossibleVCoreProvisioningStateValues() []VCoreProvisioningState {
	return original.PossibleVCoreProvisioningStateValues()
}
func PossibleVCoreSkuTierValues() []VCoreSkuTier {
	return original.PossibleVCoreSkuTierValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
