//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package reservations

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/reservations/mgmt/2020-10-25/reservations"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AppliedScopeType = original.AppliedScopeType

const (
	Shared AppliedScopeType = original.Shared
	Single AppliedScopeType = original.Single
)

type CalculateExchangeOperationResultStatus = original.CalculateExchangeOperationResultStatus

const (
	Cancelled CalculateExchangeOperationResultStatus = original.Cancelled
	Failed    CalculateExchangeOperationResultStatus = original.Failed
	Pending   CalculateExchangeOperationResultStatus = original.Pending
	Succeeded CalculateExchangeOperationResultStatus = original.Succeeded
)

type ErrorResponseCode = original.ErrorResponseCode

const (
	ActivateQuoteFailed                           ErrorResponseCode = original.ActivateQuoteFailed
	AppliedScopesNotAssociatedWithCommerceAccount ErrorResponseCode = original.AppliedScopesNotAssociatedWithCommerceAccount
	AuthorizationFailed                           ErrorResponseCode = original.AuthorizationFailed
	BadRequest                                    ErrorResponseCode = original.BadRequest
	BillingCustomerInputError                     ErrorResponseCode = original.BillingCustomerInputError
	BillingError                                  ErrorResponseCode = original.BillingError
	BillingPaymentInstrumentHardError             ErrorResponseCode = original.BillingPaymentInstrumentHardError
	BillingPaymentInstrumentSoftError             ErrorResponseCode = original.BillingPaymentInstrumentSoftError
	BillingScopeIDCannotBeChanged                 ErrorResponseCode = original.BillingScopeIDCannotBeChanged
	BillingTransientError                         ErrorResponseCode = original.BillingTransientError
	CalculatePriceFailed                          ErrorResponseCode = original.CalculatePriceFailed
	CapacityUpdateScopesFailed                    ErrorResponseCode = original.CapacityUpdateScopesFailed
	ClientCertificateThumbprintNotSet             ErrorResponseCode = original.ClientCertificateThumbprintNotSet
	CreateQuoteFailed                             ErrorResponseCode = original.CreateQuoteFailed
	Forbidden                                     ErrorResponseCode = original.Forbidden
	FulfillmentConfigurationError                 ErrorResponseCode = original.FulfillmentConfigurationError
	FulfillmentError                              ErrorResponseCode = original.FulfillmentError
	FulfillmentOutOfStockError                    ErrorResponseCode = original.FulfillmentOutOfStockError
	FulfillmentTransientError                     ErrorResponseCode = original.FulfillmentTransientError
	HTTPMethodNotSupported                        ErrorResponseCode = original.HTTPMethodNotSupported
	InternalServerError                           ErrorResponseCode = original.InternalServerError
	InvalidAccessToken                            ErrorResponseCode = original.InvalidAccessToken
	InvalidFulfillmentRequestParameters           ErrorResponseCode = original.InvalidFulfillmentRequestParameters
	InvalidHealthCheckType                        ErrorResponseCode = original.InvalidHealthCheckType
	InvalidLocationID                             ErrorResponseCode = original.InvalidLocationID
	InvalidRefundQuantity                         ErrorResponseCode = original.InvalidRefundQuantity
	InvalidRequestContent                         ErrorResponseCode = original.InvalidRequestContent
	InvalidRequestURI                             ErrorResponseCode = original.InvalidRequestURI
	InvalidReservationID                          ErrorResponseCode = original.InvalidReservationID
	InvalidReservationOrderID                     ErrorResponseCode = original.InvalidReservationOrderID
	InvalidSingleAppliedScopesCount               ErrorResponseCode = original.InvalidSingleAppliedScopesCount
	InvalidSubscriptionID                         ErrorResponseCode = original.InvalidSubscriptionID
	InvalidTenantID                               ErrorResponseCode = original.InvalidTenantID
	MissingAppliedScopesForSingle                 ErrorResponseCode = original.MissingAppliedScopesForSingle
	MissingTenantID                               ErrorResponseCode = original.MissingTenantID
	NonsupportedAccountID                         ErrorResponseCode = original.NonsupportedAccountID
	NotSpecified                                  ErrorResponseCode = original.NotSpecified
	NotSupportedCountry                           ErrorResponseCode = original.NotSupportedCountry
	NoValidReservationsToReRate                   ErrorResponseCode = original.NoValidReservationsToReRate
	OperationCannotBePerformedInCurrentState      ErrorResponseCode = original.OperationCannotBePerformedInCurrentState
	OperationFailed                               ErrorResponseCode = original.OperationFailed
	PatchValuesSameAsExisting                     ErrorResponseCode = original.PatchValuesSameAsExisting
	PaymentInstrumentNotFound                     ErrorResponseCode = original.PaymentInstrumentNotFound
	PurchaseError                                 ErrorResponseCode = original.PurchaseError
	ReRateOnlyAllowedForEA                        ErrorResponseCode = original.ReRateOnlyAllowedForEA
	ReservationIDNotInReservationOrder            ErrorResponseCode = original.ReservationIDNotInReservationOrder
	ReservationOrderCreationFailed                ErrorResponseCode = original.ReservationOrderCreationFailed
	ReservationOrderIDAlreadyExists               ErrorResponseCode = original.ReservationOrderIDAlreadyExists
	ReservationOrderNotEnabled                    ErrorResponseCode = original.ReservationOrderNotEnabled
	ReservationOrderNotFound                      ErrorResponseCode = original.ReservationOrderNotFound
	RiskCheckFailed                               ErrorResponseCode = original.RiskCheckFailed
	RoleAssignmentCreationFailed                  ErrorResponseCode = original.RoleAssignmentCreationFailed
	ServerTimeout                                 ErrorResponseCode = original.ServerTimeout
	UnauthenticatedRequestsThrottled              ErrorResponseCode = original.UnauthenticatedRequestsThrottled
	UnsupportedReservationTerm                    ErrorResponseCode = original.UnsupportedReservationTerm
)

type ExchangeOperationResultStatus = original.ExchangeOperationResultStatus

const (
	ExchangeOperationResultStatusCancelled        ExchangeOperationResultStatus = original.ExchangeOperationResultStatusCancelled
	ExchangeOperationResultStatusFailed           ExchangeOperationResultStatus = original.ExchangeOperationResultStatusFailed
	ExchangeOperationResultStatusPendingPurchases ExchangeOperationResultStatus = original.ExchangeOperationResultStatusPendingPurchases
	ExchangeOperationResultStatusPendingRefunds   ExchangeOperationResultStatus = original.ExchangeOperationResultStatusPendingRefunds
	ExchangeOperationResultStatusSucceeded        ExchangeOperationResultStatus = original.ExchangeOperationResultStatusSucceeded
)

type InstanceFlexibility = original.InstanceFlexibility

const (
	Off InstanceFlexibility = original.Off
	On  InstanceFlexibility = original.On
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusCancelled OperationStatus = original.OperationStatusCancelled
	OperationStatusFailed    OperationStatus = original.OperationStatusFailed
	OperationStatusPending   OperationStatus = original.OperationStatusPending
	OperationStatusSucceeded OperationStatus = original.OperationStatusSucceeded
)

type PaymentStatus = original.PaymentStatus

const (
	PaymentStatusCancelled PaymentStatus = original.PaymentStatusCancelled
	PaymentStatusFailed    PaymentStatus = original.PaymentStatusFailed
	PaymentStatusScheduled PaymentStatus = original.PaymentStatusScheduled
	PaymentStatusSucceeded PaymentStatus = original.PaymentStatusSucceeded
)

type ReservationBillingPlan = original.ReservationBillingPlan

const (
	Monthly ReservationBillingPlan = original.Monthly
	Upfront ReservationBillingPlan = original.Upfront
)

type ReservationTerm = original.ReservationTerm

const (
	P1Y ReservationTerm = original.P1Y
	P3Y ReservationTerm = original.P3Y
)

type ReservedResourceType = original.ReservedResourceType

const (
	AppService            ReservedResourceType = original.AppService
	AzureDataExplorer     ReservedResourceType = original.AzureDataExplorer
	BlockBlob             ReservedResourceType = original.BlockBlob
	CosmosDb              ReservedResourceType = original.CosmosDb
	Databricks            ReservedResourceType = original.Databricks
	DedicatedHost         ReservedResourceType = original.DedicatedHost
	ManagedDisk           ReservedResourceType = original.ManagedDisk
	MariaDb               ReservedResourceType = original.MariaDb
	MySQL                 ReservedResourceType = original.MySQL
	PostgreSQL            ReservedResourceType = original.PostgreSQL
	RedHat                ReservedResourceType = original.RedHat
	RedHatOsa             ReservedResourceType = original.RedHatOsa
	RedisCache            ReservedResourceType = original.RedisCache
	SapHana               ReservedResourceType = original.SapHana
	SQLAzureHybridBenefit ReservedResourceType = original.SQLAzureHybridBenefit
	SQLDatabases          ReservedResourceType = original.SQLDatabases
	SQLDataWarehouse      ReservedResourceType = original.SQLDataWarehouse
	SuseLinux             ReservedResourceType = original.SuseLinux
	VirtualMachines       ReservedResourceType = original.VirtualMachines
	VMwareCloudSimple     ReservedResourceType = original.VMwareCloudSimple
)

type StatusCode = original.StatusCode

const (
	StatusCodeActive                 StatusCode = original.StatusCodeActive
	StatusCodeExpired                StatusCode = original.StatusCodeExpired
	StatusCodeMerged                 StatusCode = original.StatusCodeMerged
	StatusCodeNone                   StatusCode = original.StatusCodeNone
	StatusCodePaymentInstrumentError StatusCode = original.StatusCodePaymentInstrumentError
	StatusCodePending                StatusCode = original.StatusCodePending
	StatusCodePurchaseError          StatusCode = original.StatusCodePurchaseError
	StatusCodeSplit                  StatusCode = original.StatusCodeSplit
	StatusCodeSucceeded              StatusCode = original.StatusCodeSucceeded
)

type AppliedReservationList = original.AppliedReservationList
type AppliedReservations = original.AppliedReservations
type AppliedReservationsProperties = original.AppliedReservationsProperties
type AvailableScopeProperties = original.AvailableScopeProperties
type AvailableScopeRequest = original.AvailableScopeRequest
type AvailableScopeRequestProperties = original.AvailableScopeRequestProperties
type BaseClient = original.BaseClient
type BillingInformation = original.BillingInformation
type CalculateExchangeClient = original.CalculateExchangeClient
type CalculateExchangeOperationResultResponse = original.CalculateExchangeOperationResultResponse
type CalculateExchangePostFuture = original.CalculateExchangePostFuture
type CalculateExchangeRequest = original.CalculateExchangeRequest
type CalculateExchangeRequestProperties = original.CalculateExchangeRequestProperties
type CalculateExchangeResponseProperties = original.CalculateExchangeResponseProperties
type CalculatePriceResponse = original.CalculatePriceResponse
type CalculatePriceResponseProperties = original.CalculatePriceResponseProperties
type CalculatePriceResponsePropertiesBillingCurrencyTotal = original.CalculatePriceResponsePropertiesBillingCurrencyTotal
type CalculatePriceResponsePropertiesPricingCurrencyTotal = original.CalculatePriceResponsePropertiesPricingCurrencyTotal
type Catalog = original.Catalog
type Client = original.Client
type CreateGenericQuotaRequestParameters = original.CreateGenericQuotaRequestParameters
type CurrentQuotaLimit = original.CurrentQuotaLimit
type CurrentQuotaLimitBase = original.CurrentQuotaLimitBase
type Error = original.Error
type ExceptionResponse = original.ExceptionResponse
type ExchangeClient = original.ExchangeClient
type ExchangeOperationResultResponse = original.ExchangeOperationResultResponse
type ExchangePolicyError = original.ExchangePolicyError
type ExchangePolicyErrors = original.ExchangePolicyErrors
type ExchangePostFuture = original.ExchangePostFuture
type ExchangeRequest = original.ExchangeRequest
type ExchangeRequestProperties = original.ExchangeRequestProperties
type ExchangeResponseProperties = original.ExchangeResponseProperties
type ExtendedErrorInfo = original.ExtendedErrorInfo
type ExtendedStatusInfo = original.ExtendedStatusInfo
type List = original.List
type ListCatalog = original.ListCatalog
type ListIterator = original.ListIterator
type ListPage = original.ListPage
type ListResponse = original.ListResponse
type MergeProperties = original.MergeProperties
type MergePropertiesType = original.MergePropertiesType
type MergeRequest = original.MergeRequest
type OperationClient = original.OperationClient
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type OperationResponse = original.OperationResponse
type OperationResultError = original.OperationResultError
type OrderBillingPlanInformation = original.OrderBillingPlanInformation
type OrderClient = original.OrderClient
type OrderList = original.OrderList
type OrderListIterator = original.OrderListIterator
type OrderListPage = original.OrderListPage
type OrderProperties = original.OrderProperties
type OrderPurchaseFuture = original.OrderPurchaseFuture
type OrderResponse = original.OrderResponse
type Patch = original.Patch
type PatchProperties = original.PatchProperties
type PatchPropertiesRenewProperties = original.PatchPropertiesRenewProperties
type PaymentDetail = original.PaymentDetail
type Price = original.Price
type Properties = original.Properties
type PurchaseRequest = original.PurchaseRequest
type PurchaseRequestProperties = original.PurchaseRequestProperties
type PurchaseRequestPropertiesReservedResourceProperties = original.PurchaseRequestPropertiesReservedResourceProperties
type QuotaClient = original.QuotaClient
type QuotaCreateOrUpdateFuture = original.QuotaCreateOrUpdateFuture
type QuotaLimits = original.QuotaLimits
type QuotaLimitsIterator = original.QuotaLimitsIterator
type QuotaLimitsPage = original.QuotaLimitsPage
type QuotaLimitsResponse = original.QuotaLimitsResponse
type QuotaProperties = original.QuotaProperties
type QuotaRequestDetails = original.QuotaRequestDetails
type QuotaRequestDetailsList = original.QuotaRequestDetailsList
type QuotaRequestDetailsListIterator = original.QuotaRequestDetailsListIterator
type QuotaRequestDetailsListPage = original.QuotaRequestDetailsListPage
type QuotaRequestOneResourceProperties = original.QuotaRequestOneResourceProperties
type QuotaRequestOneResourceSubmitResponse = original.QuotaRequestOneResourceSubmitResponse
type QuotaRequestProperties = original.QuotaRequestProperties
type QuotaRequestStatusClient = original.QuotaRequestStatusClient
type QuotaRequestStatusDetails = original.QuotaRequestStatusDetails
type QuotaRequestSubmitResponse = original.QuotaRequestSubmitResponse
type QuotaRequestSubmitResponse201 = original.QuotaRequestSubmitResponse201
type QuotaUpdateFuture = original.QuotaUpdateFuture
type RenewPropertiesResponse = original.RenewPropertiesResponse
type RenewPropertiesResponseBillingCurrencyTotal = original.RenewPropertiesResponseBillingCurrencyTotal
type RenewPropertiesResponsePricingCurrencyTotal = original.RenewPropertiesResponsePricingCurrencyTotal
type ReservationAvailableScopesFuture = original.ReservationAvailableScopesFuture
type ReservationMergeFuture = original.ReservationMergeFuture
type ReservationUpdateFuture = original.ReservationUpdateFuture
type ResourceName = original.ResourceName
type Response = original.Response
type ScopeProperties = original.ScopeProperties
type ServiceError = original.ServiceError
type ServiceErrorDetail = original.ServiceErrorDetail
type SetObject = original.SetObject
type SkuName = original.SkuName
type SkuProperty = original.SkuProperty
type SkuRestriction = original.SkuRestriction
type SplitFuture = original.SplitFuture
type SplitProperties = original.SplitProperties
type SplitPropertiesType = original.SplitPropertiesType
type SplitRequest = original.SplitRequest
type SubRequest = original.SubRequest
type SubscriptionScopeProperties = original.SubscriptionScopeProperties
type ToExchange = original.ToExchange
type ToPurchaseCalculateExchange = original.ToPurchaseCalculateExchange
type ToPurchaseExchange = original.ToPurchaseExchange
type ToReturn = original.ToReturn
type ToReturnForExchange = original.ToReturnForExchange

func New() BaseClient {
	return original.New()
}
func NewCalculateExchangeClient() CalculateExchangeClient {
	return original.NewCalculateExchangeClient()
}
func NewCalculateExchangeClientWithBaseURI(baseURI string) CalculateExchangeClient {
	return original.NewCalculateExchangeClientWithBaseURI(baseURI)
}
func NewClient() Client {
	return original.NewClient()
}
func NewClientWithBaseURI(baseURI string) Client {
	return original.NewClientWithBaseURI(baseURI)
}
func NewExchangeClient() ExchangeClient {
	return original.NewExchangeClient()
}
func NewExchangeClientWithBaseURI(baseURI string) ExchangeClient {
	return original.NewExchangeClientWithBaseURI(baseURI)
}
func NewListIterator(page ListPage) ListIterator {
	return original.NewListIterator(page)
}
func NewListPage(cur List, getNextPage func(context.Context, List) (List, error)) ListPage {
	return original.NewListPage(cur, getNextPage)
}
func NewOperationClient() OperationClient {
	return original.NewOperationClient()
}
func NewOperationClientWithBaseURI(baseURI string) OperationClient {
	return original.NewOperationClientWithBaseURI(baseURI)
}
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return original.NewOperationListIterator(page)
}
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return original.NewOperationListPage(cur, getNextPage)
}
func NewOrderClient() OrderClient {
	return original.NewOrderClient()
}
func NewOrderClientWithBaseURI(baseURI string) OrderClient {
	return original.NewOrderClientWithBaseURI(baseURI)
}
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return original.NewOrderListIterator(page)
}
func NewOrderListPage(cur OrderList, getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return original.NewOrderListPage(cur, getNextPage)
}
func NewQuotaClient() QuotaClient {
	return original.NewQuotaClient()
}
func NewQuotaClientWithBaseURI(baseURI string) QuotaClient {
	return original.NewQuotaClientWithBaseURI(baseURI)
}
func NewQuotaLimitsIterator(page QuotaLimitsPage) QuotaLimitsIterator {
	return original.NewQuotaLimitsIterator(page)
}
func NewQuotaLimitsPage(cur QuotaLimits, getNextPage func(context.Context, QuotaLimits) (QuotaLimits, error)) QuotaLimitsPage {
	return original.NewQuotaLimitsPage(cur, getNextPage)
}
func NewQuotaRequestDetailsListIterator(page QuotaRequestDetailsListPage) QuotaRequestDetailsListIterator {
	return original.NewQuotaRequestDetailsListIterator(page)
}
func NewQuotaRequestDetailsListPage(cur QuotaRequestDetailsList, getNextPage func(context.Context, QuotaRequestDetailsList) (QuotaRequestDetailsList, error)) QuotaRequestDetailsListPage {
	return original.NewQuotaRequestDetailsListPage(cur, getNextPage)
}
func NewQuotaRequestStatusClient() QuotaRequestStatusClient {
	return original.NewQuotaRequestStatusClient()
}
func NewQuotaRequestStatusClientWithBaseURI(baseURI string) QuotaRequestStatusClient {
	return original.NewQuotaRequestStatusClientWithBaseURI(baseURI)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleAppliedScopeTypeValues() []AppliedScopeType {
	return original.PossibleAppliedScopeTypeValues()
}
func PossibleCalculateExchangeOperationResultStatusValues() []CalculateExchangeOperationResultStatus {
	return original.PossibleCalculateExchangeOperationResultStatusValues()
}
func PossibleErrorResponseCodeValues() []ErrorResponseCode {
	return original.PossibleErrorResponseCodeValues()
}
func PossibleExchangeOperationResultStatusValues() []ExchangeOperationResultStatus {
	return original.PossibleExchangeOperationResultStatusValues()
}
func PossibleInstanceFlexibilityValues() []InstanceFlexibility {
	return original.PossibleInstanceFlexibilityValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossiblePaymentStatusValues() []PaymentStatus {
	return original.PossiblePaymentStatusValues()
}
func PossibleReservationBillingPlanValues() []ReservationBillingPlan {
	return original.PossibleReservationBillingPlanValues()
}
func PossibleReservationTermValues() []ReservationTerm {
	return original.PossibleReservationTermValues()
}
func PossibleReservedResourceTypeValues() []ReservedResourceType {
	return original.PossibleReservedResourceTypeValues()
}
func PossibleStatusCodeValues() []StatusCode {
	return original.PossibleStatusCodeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
