// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []string `type:"list"`

	// Indicates whether the Auto Scaling group decrements the desired capacity
	// value by the number of instances detached.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s DetachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachInstancesInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetachInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to detaching the instances from the Auto Scaling group.
	Activities []Activity `type:"list"`
}

// String returns the string representation
func (s DetachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetachInstances = "DetachInstances"

// DetachInstancesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Removes one or more instances from the specified Auto Scaling group.
//
// After the instances are detached, you can manage them independent of the
// Auto Scaling group.
//
// If you do not specify the option to decrement the desired capacity, Amazon
// EC2 Auto Scaling launches instances to replace the ones that are detached.
//
// If there is a Classic Load Balancer attached to the Auto Scaling group, the
// instances are deregistered from the load balancer. If there are target groups
// attached to the Auto Scaling group, the instances are deregistered from the
// target groups.
//
// For more information, see Detach EC2 Instances from Your Auto Scaling Group
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using DetachInstancesRequest.
//    req := client.DetachInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances
func (c *Client) DetachInstancesRequest(input *DetachInstancesInput) DetachInstancesRequest {
	op := &aws.Operation{
		Name:       opDetachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesInput{}
	}

	req := c.newRequest(op, input, &DetachInstancesOutput{})
	return DetachInstancesRequest{Request: req, Input: input, Copy: c.DetachInstancesRequest}
}

// DetachInstancesRequest is the request type for the
// DetachInstances API operation.
type DetachInstancesRequest struct {
	*aws.Request
	Input *DetachInstancesInput
	Copy  func(*DetachInstancesInput) DetachInstancesRequest
}

// Send marshals and sends the DetachInstances API request.
func (r DetachInstancesRequest) Send(ctx context.Context) (*DetachInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachInstancesResponse{
		DetachInstancesOutput: r.Request.Data.(*DetachInstancesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachInstancesResponse is the response type for the
// DetachInstances API operation.
type DetachInstancesResponse struct {
	*DetachInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachInstances request.
func (r *DetachInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
