package openanalytics

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseProductAccount invokes the openanalytics.CloseProductAccount API synchronously
// api document: https://help.aliyun.com/api/openanalytics/closeproductaccount.html
func (client *Client) CloseProductAccount(request *CloseProductAccountRequest) (response *CloseProductAccountResponse, err error) {
	response = CreateCloseProductAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CloseProductAccountWithChan invokes the openanalytics.CloseProductAccount API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/closeproductaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloseProductAccountWithChan(request *CloseProductAccountRequest) (<-chan *CloseProductAccountResponse, <-chan error) {
	responseChan := make(chan *CloseProductAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseProductAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseProductAccountWithCallback invokes the openanalytics.CloseProductAccount API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/closeproductaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloseProductAccountWithCallback(request *CloseProductAccountRequest, callback func(response *CloseProductAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseProductAccountResponse
		var err error
		defer close(result)
		response, err = client.CloseProductAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseProductAccountRequest is the request struct for api CloseProductAccount
type CloseProductAccountRequest struct {
	*requests.RpcRequest
	ProductCode      string `position:"Body" name:"ProductCode"`
	ProductAccessKey string `position:"Body" name:"ProductAccessKey"`
	TargetUid        string `position:"Body" name:"TargetUid"`
	TargetArnRole    string `position:"Body" name:"TargetArnRole"`
}

// CloseProductAccountResponse is the response struct for api CloseProductAccount
type CloseProductAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RegionId  string `json:"RegionId" xml:"RegionId"`
}

// CreateCloseProductAccountRequest creates a request to invoke CloseProductAccount API
func CreateCloseProductAccountRequest() (request *CloseProductAccountRequest) {
	request = &CloseProductAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics", "2018-03-01", "CloseProductAccount", "openanalytics", "openAPI")
	return
}

// CreateCloseProductAccountResponse creates a response to parse from CloseProductAccount response
func CreateCloseProductAccountResponse() (response *CloseProductAccountResponse) {
	response = &CloseProductAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
