package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumMembers invokes the baas.DescribeConsortiumMembers API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiummembers.html
func (client *Client) DescribeConsortiumMembers(request *DescribeConsortiumMembersRequest) (response *DescribeConsortiumMembersResponse, err error) {
	response = CreateDescribeConsortiumMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumMembersWithChan invokes the baas.DescribeConsortiumMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiummembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumMembersWithChan(request *DescribeConsortiumMembersRequest) (<-chan *DescribeConsortiumMembersResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumMembersWithCallback invokes the baas.DescribeConsortiumMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiummembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumMembersWithCallback(request *DescribeConsortiumMembersRequest, callback func(response *DescribeConsortiumMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumMembersResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumMembersRequest is the request struct for api DescribeConsortiumMembers
type DescribeConsortiumMembersRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Body" name:"ConsortiumId"`
}

// DescribeConsortiumMembersResponse is the response struct for api DescribeConsortiumMembers
type DescribeConsortiumMembersResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Success   bool                       `json:"Success" xml:"Success"`
	ErrorCode int                        `json:"ErrorCode" xml:"ErrorCode"`
	Result    []DescribeConsortiumMember `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumMembersRequest creates a request to invoke DescribeConsortiumMembers API
func CreateDescribeConsortiumMembersRequest() (request *DescribeConsortiumMembersRequest) {
	request = &DescribeConsortiumMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumMembers", "", "")
	return
}

// CreateDescribeConsortiumMembersResponse creates a response to parse from DescribeConsortiumMembers response
func CreateDescribeConsortiumMembersResponse() (response *DescribeConsortiumMembersResponse) {
	response = &DescribeConsortiumMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
