//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSubscriptionInstanceStatus invokes the dts.DescribeSubscriptionInstanceStatus API synchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptioninstancestatus.html
func (client *Client) DescribeSubscriptionInstanceStatus(request *DescribeSubscriptionInstanceStatusRequest) (response *DescribeSubscriptionInstanceStatusResponse, err error) {
	response = CreateDescribeSubscriptionInstanceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSubscriptionInstanceStatusWithChan invokes the dts.DescribeSubscriptionInstanceStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptioninstancestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSubscriptionInstanceStatusWithChan(request *DescribeSubscriptionInstanceStatusRequest) (<-chan *DescribeSubscriptionInstanceStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeSubscriptionInstanceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSubscriptionInstanceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSubscriptionInstanceStatusWithCallback invokes the dts.DescribeSubscriptionInstanceStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptioninstancestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSubscriptionInstanceStatusWithCallback(request *DescribeSubscriptionInstanceStatusRequest, callback func(response *DescribeSubscriptionInstanceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSubscriptionInstanceStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeSubscriptionInstanceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSubscriptionInstanceStatusRequest is the request struct for api DescribeSubscriptionInstanceStatus
type DescribeSubscriptionInstanceStatusRequest struct {
	*requests.RpcRequest
	SubscriptionInstanceId string `position:"Query" name:"SubscriptionInstanceId"`
	OwnerId                string `position:"Query" name:"OwnerId"`
}

// DescribeSubscriptionInstanceStatusResponse is the response struct for api DescribeSubscriptionInstanceStatus
type DescribeSubscriptionInstanceStatusResponse struct {
	*responses.BaseResponse
	SubscriptionInstanceID   string                                                  `json:"SubscriptionInstanceID" xml:"SubscriptionInstanceID"`
	SubscriptionInstanceName string                                                  `json:"SubscriptionInstanceName" xml:"SubscriptionInstanceName"`
	PayType                  string                                                  `json:"PayType" xml:"PayType"`
	Status                   string                                                  `json:"Status" xml:"Status"`
	ErrorMessage             string                                                  `json:"ErrorMessage" xml:"ErrorMessage"`
	ConsumptionCheckpoint    string                                                  `json:"ConsumptionCheckpoint" xml:"ConsumptionCheckpoint"`
	BeginTimestamp           string                                                  `json:"BeginTimestamp" xml:"BeginTimestamp"`
	EndTimestamp             string                                                  `json:"EndTimestamp" xml:"EndTimestamp"`
	ConsumptionClient        string                                                  `json:"ConsumptionClient" xml:"ConsumptionClient"`
	SubscriptionObject       DescribeSubscriptionInstanceStatusSubscriptionObject0   `json:"SubscriptionObject" xml:"SubscriptionObject"`
	SourceEndpoint           DescribeSubscriptionInstanceStatusSourceEndpoint0       `json:"SourceEndpoint" xml:"SourceEndpoint"`
	SubscriptionDataType     DescribeSubscriptionInstanceStatusSubscriptionDataType0 `json:"SubscriptionDataType" xml:"SubscriptionDataType"`
}

type DescribeSubscriptionInstanceStatusSubscriptionObject0 struct {
	SynchronousObject []DescribeSubscriptionInstanceStatusSynchronousObject1 `json:"SynchronousObject" xml:"SynchronousObject"`
}

type DescribeSubscriptionInstanceStatusSynchronousObject1 struct {
	DatabaseName  string   `json:"DatabaseName" xml:"DatabaseName"`
	WholeDatabase string   `json:"WholeDatabase" xml:"WholeDatabase"`
	TableList     []string `json:"TableList" xml:"TableList"`
}

type DescribeSubscriptionInstanceStatusSourceEndpoint0 struct {
	InstanceID   string `json:"InstanceID" xml:"InstanceID"`
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
}

type DescribeSubscriptionInstanceStatusSubscriptionDataType0 struct {
	DDL bool `json:"DDL" xml:"DDL"`
	DML bool `json:"DML" xml:"DML"`
}

// CreateDescribeSubscriptionInstanceStatusRequest creates a request to invoke DescribeSubscriptionInstanceStatus API
func CreateDescribeSubscriptionInstanceStatusRequest() (request *DescribeSubscriptionInstanceStatusRequest) {
	request = &DescribeSubscriptionInstanceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeSubscriptionInstanceStatus", "dts", "openAPI")
	return
}

// CreateDescribeSubscriptionInstanceStatusResponse creates a response to parse from DescribeSubscriptionInstanceStatus response
func CreateDescribeSubscriptionInstanceStatusResponse() (response *DescribeSubscriptionInstanceStatusResponse) {
	response = &DescribeSubscriptionInstanceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
