package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachClusterForNote invokes the emr.AttachClusterForNote API synchronously
// api document: https://help.aliyun.com/api/emr/attachclusterfornote.html
func (client *Client) AttachClusterForNote(request *AttachClusterForNoteRequest) (response *AttachClusterForNoteResponse, err error) {
	response = CreateAttachClusterForNoteResponse()
	err = client.DoAction(request, response)
	return
}

// AttachClusterForNoteWithChan invokes the emr.AttachClusterForNote API asynchronously
// api document: https://help.aliyun.com/api/emr/attachclusterfornote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AttachClusterForNoteWithChan(request *AttachClusterForNoteRequest) (<-chan *AttachClusterForNoteResponse, <-chan error) {
	responseChan := make(chan *AttachClusterForNoteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachClusterForNote(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachClusterForNoteWithCallback invokes the emr.AttachClusterForNote API asynchronously
// api document: https://help.aliyun.com/api/emr/attachclusterfornote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AttachClusterForNoteWithCallback(request *AttachClusterForNoteRequest, callback func(response *AttachClusterForNoteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachClusterForNoteResponse
		var err error
		defer close(result)
		response, err = client.AttachClusterForNote(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachClusterForNoteRequest is the request struct for api AttachClusterForNote
type AttachClusterForNoteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// AttachClusterForNoteResponse is the response struct for api AttachClusterForNote
type AttachClusterForNoteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachClusterForNoteRequest creates a request to invoke AttachClusterForNote API
func CreateAttachClusterForNoteRequest() (request *AttachClusterForNoteRequest) {
	request = &AttachClusterForNoteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "AttachClusterForNote", "emr", "openAPI")
	return
}

// CreateAttachClusterForNoteResponse creates a response to parse from AttachClusterForNote response
func CreateAttachClusterForNoteResponse() (response *AttachClusterForNoteResponse) {
	response = &AttachClusterForNoteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
