package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceByTags invokes the iot.QueryDeviceByTags API synchronously
// api document: https://help.aliyun.com/api/iot/querydevicebytags.html
func (client *Client) QueryDeviceByTags(request *QueryDeviceByTagsRequest) (response *QueryDeviceByTagsResponse, err error) {
	response = CreateQueryDeviceByTagsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceByTagsWithChan invokes the iot.QueryDeviceByTags API asynchronously
// api document: https://help.aliyun.com/api/iot/querydevicebytags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryDeviceByTagsWithChan(request *QueryDeviceByTagsRequest) (<-chan *QueryDeviceByTagsResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceByTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceByTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceByTagsWithCallback invokes the iot.QueryDeviceByTags API asynchronously
// api document: https://help.aliyun.com/api/iot/querydevicebytags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryDeviceByTagsWithCallback(request *QueryDeviceByTagsRequest, callback func(response *QueryDeviceByTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceByTagsResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceByTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceByTagsRequest is the request struct for api QueryDeviceByTags
type QueryDeviceByTagsRequest struct {
	*requests.RpcRequest
	IotInstanceId string                  `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer        `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer        `position:"Query" name:"CurrentPage"`
	Tag           *[]QueryDeviceByTagsTag `position:"Query" name:"Tag"  type:"Repeated"`
}

// QueryDeviceByTagsTag is a repeated param struct in QueryDeviceByTagsRequest
type QueryDeviceByTagsTag struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// QueryDeviceByTagsResponse is the response struct for api QueryDeviceByTags
type QueryDeviceByTagsResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	Success      bool                    `json:"Success" xml:"Success"`
	Code         string                  `json:"Code" xml:"Code"`
	ErrorMessage string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	Page         int                     `json:"Page" xml:"Page"`
	PageSize     int                     `json:"PageSize" xml:"PageSize"`
	PageCount    int                     `json:"PageCount" xml:"PageCount"`
	Total        int                     `json:"Total" xml:"Total"`
	Data         DataInQueryDeviceByTags `json:"Data" xml:"Data"`
}

// CreateQueryDeviceByTagsRequest creates a request to invoke QueryDeviceByTags API
func CreateQueryDeviceByTagsRequest() (request *QueryDeviceByTagsRequest) {
	request = &QueryDeviceByTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceByTags", "iot", "openAPI")
	return
}

// CreateQueryDeviceByTagsResponse creates a response to parse from QueryDeviceByTags response
func CreateQueryDeviceByTagsResponse() (response *QueryDeviceByTagsResponse) {
	response = &QueryDeviceByTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
