package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeParameters invokes the r_kvstore.DescribeParameters API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeparameters.html
func (client *Client) DescribeParameters(request *DescribeParametersRequest) (response *DescribeParametersResponse, err error) {
	response = CreateDescribeParametersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeParametersWithChan invokes the r_kvstore.DescribeParameters API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeparameters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeParametersWithChan(request *DescribeParametersRequest) (<-chan *DescribeParametersResponse, <-chan error) {
	responseChan := make(chan *DescribeParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeParametersWithCallback invokes the r_kvstore.DescribeParameters API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeparameters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeParametersWithCallback(request *DescribeParametersRequest, callback func(response *DescribeParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeParametersResponse
		var err error
		defer close(result)
		response, err = client.DescribeParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeParametersRequest is the request struct for api DescribeParameters
type DescribeParametersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NodeId               string           `position:"Query" name:"NodeId"`
}

// DescribeParametersResponse is the response struct for api DescribeParameters
type DescribeParametersResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Engine            string            `json:"Engine" xml:"Engine"`
	EngineVersion     string            `json:"EngineVersion" xml:"EngineVersion"`
	ConfigParameters  ConfigParameters  `json:"ConfigParameters" xml:"ConfigParameters"`
	RunningParameters RunningParameters `json:"RunningParameters" xml:"RunningParameters"`
}

// CreateDescribeParametersRequest creates a request to invoke DescribeParameters API
func CreateDescribeParametersRequest() (request *DescribeParametersRequest) {
	request = &DescribeParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeParameters", "redisa", "openAPI")
	return
}

// CreateDescribeParametersResponse creates a response to parse from DescribeParameters response
func CreateDescribeParametersResponse() (response *DescribeParametersResponse) {
	response = &DescribeParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
