// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/helper/resource"
)

func TestAccIapAppEngineServiceIamBindingGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix":   randString(t, 10),
		"role":            "roles/iap.httpsResourceAccessor",
		"project_id":      fmt.Sprintf("tf-test%s", randString(t, 10)),
		"org_id":          getTestOrgFromEnv(t),
		"billing_account": getTestBillingAccountFromEnv(t),
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccIapAppEngineServiceIamBinding_basicGenerated(context),
			},
			{
				ResourceName:      "google_iap_app_engine_service_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/iap_web/appengine-%s/services/%s roles/iap.httpsResourceAccessor", context["project_id"], context["project_id"], "default"),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				// Test Iam Binding update
				Config: testAccIapAppEngineServiceIamBinding_updateGenerated(context),
			},
			{
				ResourceName:      "google_iap_app_engine_service_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/iap_web/appengine-%s/services/%s roles/iap.httpsResourceAccessor", context["project_id"], context["project_id"], "default"),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccIapAppEngineServiceIamMemberGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix":   randString(t, 10),
		"role":            "roles/iap.httpsResourceAccessor",
		"project_id":      fmt.Sprintf("tf-test%s", randString(t, 10)),
		"org_id":          getTestOrgFromEnv(t),
		"billing_account": getTestBillingAccountFromEnv(t),
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				// Test Iam Member creation (no update for member, no need to test)
				Config: testAccIapAppEngineServiceIamMember_basicGenerated(context),
			},
			{
				ResourceName:      "google_iap_app_engine_service_iam_member.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/iap_web/appengine-%s/services/%s roles/iap.httpsResourceAccessor user:admin@hashicorptest.com", context["project_id"], context["project_id"], "default"),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccIapAppEngineServiceIamPolicyGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix":   randString(t, 10),
		"role":            "roles/iap.httpsResourceAccessor",
		"project_id":      fmt.Sprintf("tf-test%s", randString(t, 10)),
		"org_id":          getTestOrgFromEnv(t),
		"billing_account": getTestBillingAccountFromEnv(t),
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccIapAppEngineServiceIamPolicy_basicGenerated(context),
			},
			{
				ResourceName:      "google_iap_app_engine_service_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/iap_web/appengine-%s/services/%s", context["project_id"], context["project_id"], "default"),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				Config: testAccIapAppEngineServiceIamPolicy_emptyBinding(context),
			},
			{
				ResourceName:      "google_iap_app_engine_service_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/iap_web/appengine-%s/services/%s", context["project_id"], context["project_id"], "default"),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccIapAppEngineServiceIamMember_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_project" "my_project" {
  name            = "%{project_id}"
  project_id      = "%{project_id}"
  org_id          = "%{org_id}"
  billing_account = "%{billing_account}"
}

resource "google_project_service" "project_service" {
  project = google_project.my_project.project_id
  service = "iap.googleapis.com"
}

resource "google_project_service" "cloudbuild_service" {
  project = google_project_service.project_service.project
  service = "cloudbuild.googleapis.com"
}

resource "google_app_engine_application" "app" {
  project     = google_project_service.cloudbuild_service.project
  location_id = "us-central"
}

resource "google_storage_bucket" "bucket" {
  project = google_app_engine_application.app.project
  name    = "appengine-static-content-%{random_suffix}"
}

resource "google_storage_bucket_object" "object" {
  name   = "hello-world.zip"
  bucket = google_storage_bucket.bucket.name
  source = "./test-fixtures/appengine/hello-world.zip"
}

resource "google_app_engine_standard_app_version" "version" {
  project         = google_app_engine_application.app.project
  version_id      = "v2"
  service         = "default"
  runtime         = "nodejs10"
  noop_on_destroy = true
  entrypoint {
    shell = "node ./app.js"
  }
  deployment {
    zip {
      source_url = "https://storage.googleapis.com/${google_storage_bucket.bucket.name}/hello-world.zip"
    }
  }
  env_variables = {
    port = "8080"
  }
}

resource "google_iap_app_engine_service_iam_member" "foo" {
  project = "${google_app_engine_standard_app_version.version.project}"
  app_id = "${google_app_engine_standard_app_version.version.project}"
  service = "${google_app_engine_standard_app_version.version.service}"
  role = "%{role}"
  member = "user:admin@hashicorptest.com"
}
`, context)
}

func testAccIapAppEngineServiceIamPolicy_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_project" "my_project" {
  name            = "%{project_id}"
  project_id      = "%{project_id}"
  org_id          = "%{org_id}"
  billing_account = "%{billing_account}"
}

resource "google_project_service" "project_service" {
  project = google_project.my_project.project_id
  service = "iap.googleapis.com"
}

resource "google_project_service" "cloudbuild_service" {
  project = google_project_service.project_service.project
  service = "cloudbuild.googleapis.com"
}

resource "google_app_engine_application" "app" {
  project     = google_project_service.cloudbuild_service.project
  location_id = "us-central"
}

resource "google_storage_bucket" "bucket" {
  project = google_app_engine_application.app.project
  name    = "appengine-static-content-%{random_suffix}"
}

resource "google_storage_bucket_object" "object" {
  name   = "hello-world.zip"
  bucket = google_storage_bucket.bucket.name
  source = "./test-fixtures/appengine/hello-world.zip"
}

resource "google_app_engine_standard_app_version" "version" {
  project         = google_app_engine_application.app.project
  version_id      = "v2"
  service         = "default"
  runtime         = "nodejs10"
  noop_on_destroy = true
  entrypoint {
    shell = "node ./app.js"
  }
  deployment {
    zip {
      source_url = "https://storage.googleapis.com/${google_storage_bucket.bucket.name}/hello-world.zip"
    }
  }
  env_variables = {
    port = "8080"
  }
}

data "google_iam_policy" "foo" {
  binding {
    role = "%{role}"
    members = ["user:admin@hashicorptest.com"]
  }
}

resource "google_iap_app_engine_service_iam_policy" "foo" {
  project = "${google_app_engine_standard_app_version.version.project}"
  app_id = "${google_app_engine_standard_app_version.version.project}"
  service = "${google_app_engine_standard_app_version.version.service}"
  policy_data = data.google_iam_policy.foo.policy_data
}
`, context)
}

func testAccIapAppEngineServiceIamPolicy_emptyBinding(context map[string]interface{}) string {
	return Nprintf(`
resource "google_project" "my_project" {
  name            = "%{project_id}"
  project_id      = "%{project_id}"
  org_id          = "%{org_id}"
  billing_account = "%{billing_account}"
}

resource "google_project_service" "project_service" {
  project = google_project.my_project.project_id
  service = "iap.googleapis.com"
}

resource "google_project_service" "cloudbuild_service" {
  project = google_project_service.project_service.project
  service = "cloudbuild.googleapis.com"
}

resource "google_app_engine_application" "app" {
  project     = google_project_service.cloudbuild_service.project
  location_id = "us-central"
}

resource "google_storage_bucket" "bucket" {
  project = google_app_engine_application.app.project
  name    = "appengine-static-content-%{random_suffix}"
}

resource "google_storage_bucket_object" "object" {
  name   = "hello-world.zip"
  bucket = google_storage_bucket.bucket.name
  source = "./test-fixtures/appengine/hello-world.zip"
}

resource "google_app_engine_standard_app_version" "version" {
  project         = google_app_engine_application.app.project
  version_id      = "v2"
  service         = "default"
  runtime         = "nodejs10"
  noop_on_destroy = true
  entrypoint {
    shell = "node ./app.js"
  }
  deployment {
    zip {
      source_url = "https://storage.googleapis.com/${google_storage_bucket.bucket.name}/hello-world.zip"
    }
  }
  env_variables = {
    port = "8080"
  }
}

data "google_iam_policy" "foo" {
}

resource "google_iap_app_engine_service_iam_policy" "foo" {
  project = "${google_app_engine_standard_app_version.version.project}"
  app_id = "${google_app_engine_standard_app_version.version.project}"
  service = "${google_app_engine_standard_app_version.version.service}"
  policy_data = data.google_iam_policy.foo.policy_data
}
`, context)
}

func testAccIapAppEngineServiceIamBinding_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_project" "my_project" {
  name            = "%{project_id}"
  project_id      = "%{project_id}"
  org_id          = "%{org_id}"
  billing_account = "%{billing_account}"
}

resource "google_project_service" "project_service" {
  project = google_project.my_project.project_id
  service = "iap.googleapis.com"
}

resource "google_project_service" "cloudbuild_service" {
  project = google_project_service.project_service.project
  service = "cloudbuild.googleapis.com"
}

resource "google_app_engine_application" "app" {
  project     = google_project_service.cloudbuild_service.project
  location_id = "us-central"
}

resource "google_storage_bucket" "bucket" {
  project = google_app_engine_application.app.project
  name    = "appengine-static-content-%{random_suffix}"
}

resource "google_storage_bucket_object" "object" {
  name   = "hello-world.zip"
  bucket = google_storage_bucket.bucket.name
  source = "./test-fixtures/appengine/hello-world.zip"
}

resource "google_app_engine_standard_app_version" "version" {
  project         = google_app_engine_application.app.project
  version_id      = "v2"
  service         = "default"
  runtime         = "nodejs10"
  noop_on_destroy = true
  entrypoint {
    shell = "node ./app.js"
  }
  deployment {
    zip {
      source_url = "https://storage.googleapis.com/${google_storage_bucket.bucket.name}/hello-world.zip"
    }
  }
  env_variables = {
    port = "8080"
  }
}

resource "google_iap_app_engine_service_iam_binding" "foo" {
  project = "${google_app_engine_standard_app_version.version.project}"
  app_id = "${google_app_engine_standard_app_version.version.project}"
  service = "${google_app_engine_standard_app_version.version.service}"
  role = "%{role}"
  members = ["user:admin@hashicorptest.com"]
}
`, context)
}

func testAccIapAppEngineServiceIamBinding_updateGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_project" "my_project" {
  name            = "%{project_id}"
  project_id      = "%{project_id}"
  org_id          = "%{org_id}"
  billing_account = "%{billing_account}"
}

resource "google_project_service" "project_service" {
  project = google_project.my_project.project_id
  service = "iap.googleapis.com"
}

resource "google_project_service" "cloudbuild_service" {
  project = google_project_service.project_service.project
  service = "cloudbuild.googleapis.com"
}

resource "google_app_engine_application" "app" {
  project     = google_project_service.cloudbuild_service.project
  location_id = "us-central"
}

resource "google_storage_bucket" "bucket" {
  project = google_app_engine_application.app.project
  name    = "appengine-static-content-%{random_suffix}"
}

resource "google_storage_bucket_object" "object" {
  name   = "hello-world.zip"
  bucket = google_storage_bucket.bucket.name
  source = "./test-fixtures/appengine/hello-world.zip"
}

resource "google_app_engine_standard_app_version" "version" {
  project         = google_app_engine_application.app.project
  version_id      = "v2"
  service         = "default"
  runtime         = "nodejs10"
  noop_on_destroy = true
  entrypoint {
    shell = "node ./app.js"
  }
  deployment {
    zip {
      source_url = "https://storage.googleapis.com/${google_storage_bucket.bucket.name}/hello-world.zip"
    }
  }
  env_variables = {
    port = "8080"
  }
}

resource "google_iap_app_engine_service_iam_binding" "foo" {
  project = "${google_app_engine_standard_app_version.version.project}"
  app_id = "${google_app_engine_standard_app_version.version.project}"
  service = "${google_app_engine_standard_app_version.version.service}"
  role = "%{role}"
  members = ["user:admin@hashicorptest.com", "user:paddy@hashicorp.com"]
}
`, context)
}
