package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserAlarmThreshold invokes the bssopenapi.QueryUserAlarmThreshold API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryuseralarmthreshold.html
func (client *Client) QueryUserAlarmThreshold(request *QueryUserAlarmThresholdRequest) (response *QueryUserAlarmThresholdResponse, err error) {
	response = CreateQueryUserAlarmThresholdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserAlarmThresholdWithChan invokes the bssopenapi.QueryUserAlarmThreshold API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryuseralarmthreshold.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryUserAlarmThresholdWithChan(request *QueryUserAlarmThresholdRequest) (<-chan *QueryUserAlarmThresholdResponse, <-chan error) {
	responseChan := make(chan *QueryUserAlarmThresholdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserAlarmThreshold(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserAlarmThresholdWithCallback invokes the bssopenapi.QueryUserAlarmThreshold API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryuseralarmthreshold.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryUserAlarmThresholdWithCallback(request *QueryUserAlarmThresholdRequest, callback func(response *QueryUserAlarmThresholdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserAlarmThresholdResponse
		var err error
		defer close(result)
		response, err = client.QueryUserAlarmThreshold(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserAlarmThresholdRequest is the request struct for api QueryUserAlarmThreshold
type QueryUserAlarmThresholdRequest struct {
	*requests.RpcRequest
	Uid             requests.Integer `position:"Query" name:"Uid"`
	AlarmType       string           `position:"Query" name:"AlarmType"`
	AlarmThresholds string           `position:"Query" name:"AlarmThresholds"`
	Bid             string           `position:"Query" name:"Bid"`
}

// QueryUserAlarmThresholdResponse is the response struct for api QueryUserAlarmThreshold
type QueryUserAlarmThresholdResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Code      string                         `json:"Code" xml:"Code"`
	Message   string                         `json:"Message" xml:"Message"`
	Success   bool                           `json:"Success" xml:"Success"`
	Count     int                            `json:"Count" xml:"Count"`
	Datas     DatasInQueryUserAlarmThreshold `json:"Datas" xml:"Datas"`
}

// CreateQueryUserAlarmThresholdRequest creates a request to invoke QueryUserAlarmThreshold API
func CreateQueryUserAlarmThresholdRequest() (request *QueryUserAlarmThresholdRequest) {
	request = &QueryUserAlarmThresholdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryUserAlarmThreshold", "", "")
	return
}

// CreateQueryUserAlarmThresholdResponse creates a response to parse from QueryUserAlarmThreshold response
func CreateQueryUserAlarmThresholdResponse() (response *QueryUserAlarmThresholdResponse) {
	response = &QueryUserAlarmThresholdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
