// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/policy.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Key of the violation. The key is used for referring to a violation
// when filing an exemption request.
type PolicyViolationKey struct {
	// Unique ID of the violated policy.
	PolicyName *wrappers.StringValue `protobuf:"bytes,1,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// The text that violates the policy if specified.
	// Otherwise, refers to the policy in general
	// (e.g., when requesting to be exempt from the whole policy).
	// If not specified for criterion exemptions, the whole policy is implied.
	// Must be specified for ad exemptions.
	ViolatingText        *wrappers.StringValue `protobuf:"bytes,2,opt,name=violating_text,json=violatingText,proto3" json:"violating_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyViolationKey) Reset()         { *m = PolicyViolationKey{} }
func (m *PolicyViolationKey) String() string { return proto.CompactTextString(m) }
func (*PolicyViolationKey) ProtoMessage()    {}
func (*PolicyViolationKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{0}
}

func (m *PolicyViolationKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyViolationKey.Unmarshal(m, b)
}
func (m *PolicyViolationKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyViolationKey.Marshal(b, m, deterministic)
}
func (m *PolicyViolationKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyViolationKey.Merge(m, src)
}
func (m *PolicyViolationKey) XXX_Size() int {
	return xxx_messageInfo_PolicyViolationKey.Size(m)
}
func (m *PolicyViolationKey) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyViolationKey.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyViolationKey proto.InternalMessageInfo

func (m *PolicyViolationKey) GetPolicyName() *wrappers.StringValue {
	if m != nil {
		return m.PolicyName
	}
	return nil
}

func (m *PolicyViolationKey) GetViolatingText() *wrappers.StringValue {
	if m != nil {
		return m.ViolatingText
	}
	return nil
}

// Parameter for controlling how policy exemption is done. Ignorable policy
// topics are only usable with expanded text ads and responsive search ads. All
// other ad types must use policy violation keys.
type PolicyValidationParameter struct {
	// The list of policy topics that should not cause a PolicyFindingError to
	// be reported. This field is currently only compatible with Enhanced Text Ad.
	// It corresponds to the PolicyTopicEntry.topic field.
	//
	// Resources violating these policies will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	IgnorablePolicyTopics []*wrappers.StringValue `protobuf:"bytes,1,rep,name=ignorable_policy_topics,json=ignorablePolicyTopics,proto3" json:"ignorable_policy_topics,omitempty"`
	// The list of policy violation keys that should not cause a
	// PolicyViolationError to be reported. Not all policy violations are
	// exemptable, please refer to the is_exemptible field in the returned
	// PolicyViolationError.
	//
	// Resources violating these polices will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	ExemptPolicyViolationKeys []*PolicyViolationKey `protobuf:"bytes,2,rep,name=exempt_policy_violation_keys,json=exemptPolicyViolationKeys,proto3" json:"exempt_policy_violation_keys,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}              `json:"-"`
	XXX_unrecognized          []byte                `json:"-"`
	XXX_sizecache             int32                 `json:"-"`
}

func (m *PolicyValidationParameter) Reset()         { *m = PolicyValidationParameter{} }
func (m *PolicyValidationParameter) String() string { return proto.CompactTextString(m) }
func (*PolicyValidationParameter) ProtoMessage()    {}
func (*PolicyValidationParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{1}
}

func (m *PolicyValidationParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyValidationParameter.Unmarshal(m, b)
}
func (m *PolicyValidationParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyValidationParameter.Marshal(b, m, deterministic)
}
func (m *PolicyValidationParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyValidationParameter.Merge(m, src)
}
func (m *PolicyValidationParameter) XXX_Size() int {
	return xxx_messageInfo_PolicyValidationParameter.Size(m)
}
func (m *PolicyValidationParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyValidationParameter.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyValidationParameter proto.InternalMessageInfo

func (m *PolicyValidationParameter) GetIgnorablePolicyTopics() []*wrappers.StringValue {
	if m != nil {
		return m.IgnorablePolicyTopics
	}
	return nil
}

func (m *PolicyValidationParameter) GetExemptPolicyViolationKeys() []*PolicyViolationKey {
	if m != nil {
		return m.ExemptPolicyViolationKeys
	}
	return nil
}

// Policy finding attached to a resource (e.g. alcohol policy associated with
// a site that sells alcohol).
//
// Each PolicyTopicEntry has a topic that indicates the specific ads policy
// the entry is about and a type to indicate the effect that the entry will have
// on serving. It may optionally have one or more evidences that indicate the
// reason for the finding. It may also optionally have one or more constraints
// that provide details about how serving may be restricted.
type PolicyTopicEntry struct {
	// Policy topic this finding refers to. For example, "ALCOHOL",
	// "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
	// policy topics is not fixed for a particular API version and may change
	// at any time.
	Topic *wrappers.StringValue `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Describes the negative or positive effect this policy will have on serving.
	Type enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType" json:"type,omitempty"`
	// Additional information that explains policy finding
	// (e.g. the brand name for a trademark finding).
	Evidences []*PolicyTopicEvidence `protobuf:"bytes,3,rep,name=evidences,proto3" json:"evidences,omitempty"`
	// Indicates how serving of this resource may be affected (e.g. not serving
	// in a country).
	Constraints          []*PolicyTopicConstraint `protobuf:"bytes,4,rep,name=constraints,proto3" json:"constraints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PolicyTopicEntry) Reset()         { *m = PolicyTopicEntry{} }
func (m *PolicyTopicEntry) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEntry) ProtoMessage()    {}
func (*PolicyTopicEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{2}
}

func (m *PolicyTopicEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEntry.Unmarshal(m, b)
}
func (m *PolicyTopicEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEntry.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEntry.Merge(m, src)
}
func (m *PolicyTopicEntry) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEntry.Size(m)
}
func (m *PolicyTopicEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEntry.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEntry proto.InternalMessageInfo

func (m *PolicyTopicEntry) GetTopic() *wrappers.StringValue {
	if m != nil {
		return m.Topic
	}
	return nil
}

func (m *PolicyTopicEntry) GetType() enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType {
	if m != nil {
		return m.Type
	}
	return enums.PolicyTopicEntryTypeEnum_UNSPECIFIED
}

func (m *PolicyTopicEntry) GetEvidences() []*PolicyTopicEvidence {
	if m != nil {
		return m.Evidences
	}
	return nil
}

func (m *PolicyTopicEntry) GetConstraints() []*PolicyTopicConstraint {
	if m != nil {
		return m.Constraints
	}
	return nil
}

// Additional information that explains a policy finding.
type PolicyTopicEvidence struct {
	// Specific evidence information depending on the evidence type.
	//
	// Types that are valid to be assigned to Value:
	//	*PolicyTopicEvidence_HttpCode
	//	*PolicyTopicEvidence_WebsiteList_
	//	*PolicyTopicEvidence_TextList_
	//	*PolicyTopicEvidence_LanguageCode
	//	*PolicyTopicEvidence_DestinationTextList_
	//	*PolicyTopicEvidence_DestinationMismatch_
	//	*PolicyTopicEvidence_DestinationNotWorking_
	Value                isPolicyTopicEvidence_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *PolicyTopicEvidence) Reset()         { *m = PolicyTopicEvidence{} }
func (m *PolicyTopicEvidence) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence) ProtoMessage()    {}
func (*PolicyTopicEvidence) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{3}
}

func (m *PolicyTopicEvidence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence.Merge(m, src)
}
func (m *PolicyTopicEvidence) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence.Size(m)
}
func (m *PolicyTopicEvidence) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence proto.InternalMessageInfo

type isPolicyTopicEvidence_Value interface {
	isPolicyTopicEvidence_Value()
}

type PolicyTopicEvidence_HttpCode struct {
	HttpCode *wrappers.Int32Value `protobuf:"bytes,2,opt,name=http_code,json=httpCode,proto3,oneof"`
}

type PolicyTopicEvidence_WebsiteList_ struct {
	WebsiteList *PolicyTopicEvidence_WebsiteList `protobuf:"bytes,3,opt,name=website_list,json=websiteList,proto3,oneof"`
}

type PolicyTopicEvidence_TextList_ struct {
	TextList *PolicyTopicEvidence_TextList `protobuf:"bytes,4,opt,name=text_list,json=textList,proto3,oneof"`
}

type PolicyTopicEvidence_LanguageCode struct {
	LanguageCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationTextList_ struct {
	DestinationTextList *PolicyTopicEvidence_DestinationTextList `protobuf:"bytes,6,opt,name=destination_text_list,json=destinationTextList,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationMismatch_ struct {
	DestinationMismatch *PolicyTopicEvidence_DestinationMismatch `protobuf:"bytes,7,opt,name=destination_mismatch,json=destinationMismatch,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationNotWorking_ struct {
	DestinationNotWorking *PolicyTopicEvidence_DestinationNotWorking `protobuf:"bytes,8,opt,name=destination_not_working,json=destinationNotWorking,proto3,oneof"`
}

func (*PolicyTopicEvidence_HttpCode) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_WebsiteList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_TextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_LanguageCode) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationTextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationMismatch_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationNotWorking_) isPolicyTopicEvidence_Value() {}

func (m *PolicyTopicEvidence) GetValue() isPolicyTopicEvidence_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PolicyTopicEvidence) GetHttpCode() *wrappers.Int32Value {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_HttpCode); ok {
		return x.HttpCode
	}
	return nil
}

func (m *PolicyTopicEvidence) GetWebsiteList() *PolicyTopicEvidence_WebsiteList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_WebsiteList_); ok {
		return x.WebsiteList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetTextList() *PolicyTopicEvidence_TextList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_TextList_); ok {
		return x.TextList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetLanguageCode() *wrappers.StringValue {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_LanguageCode); ok {
		return x.LanguageCode
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationTextList() *PolicyTopicEvidence_DestinationTextList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationTextList_); ok {
		return x.DestinationTextList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationMismatch() *PolicyTopicEvidence_DestinationMismatch {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationMismatch_); ok {
		return x.DestinationMismatch
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationNotWorking() *PolicyTopicEvidence_DestinationNotWorking {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationNotWorking_); ok {
		return x.DestinationNotWorking
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PolicyTopicEvidence) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PolicyTopicEvidence_HttpCode)(nil),
		(*PolicyTopicEvidence_WebsiteList_)(nil),
		(*PolicyTopicEvidence_TextList_)(nil),
		(*PolicyTopicEvidence_LanguageCode)(nil),
		(*PolicyTopicEvidence_DestinationTextList_)(nil),
		(*PolicyTopicEvidence_DestinationMismatch_)(nil),
		(*PolicyTopicEvidence_DestinationNotWorking_)(nil),
	}
}

// A list of fragments of text that violated a policy.
type PolicyTopicEvidence_TextList struct {
	// The fragments of text from the resource that caused the policy finding.
	Texts                []*wrappers.StringValue `protobuf:"bytes,1,rep,name=texts,proto3" json:"texts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_TextList) Reset()         { *m = PolicyTopicEvidence_TextList{} }
func (m *PolicyTopicEvidence_TextList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_TextList) ProtoMessage()    {}
func (*PolicyTopicEvidence_TextList) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{3, 0}
}

func (m *PolicyTopicEvidence_TextList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_TextList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_TextList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_TextList.Merge(m, src)
}
func (m *PolicyTopicEvidence_TextList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Size(m)
}
func (m *PolicyTopicEvidence_TextList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_TextList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_TextList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_TextList) GetTexts() []*wrappers.StringValue {
	if m != nil {
		return m.Texts
	}
	return nil
}

// A list of websites that caused a policy finding. Used for
// ONE_WEBSITE_PER_AD_GROUP policy topic, for example. In case there are more
// than five websites, only the top five (those that appear in resources the
// most) will be listed here.
type PolicyTopicEvidence_WebsiteList struct {
	// Websites that caused the policy finding.
	Websites             []*wrappers.StringValue `protobuf:"bytes,1,rep,name=websites,proto3" json:"websites,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_WebsiteList) Reset()         { *m = PolicyTopicEvidence_WebsiteList{} }
func (m *PolicyTopicEvidence_WebsiteList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_WebsiteList) ProtoMessage()    {}
func (*PolicyTopicEvidence_WebsiteList) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{3, 1}
}

func (m *PolicyTopicEvidence_WebsiteList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Merge(m, src)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Size(m)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_WebsiteList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_WebsiteList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_WebsiteList) GetWebsites() []*wrappers.StringValue {
	if m != nil {
		return m.Websites
	}
	return nil
}

// A list of strings found in a destination page that caused a policy
// finding.
type PolicyTopicEvidence_DestinationTextList struct {
	// List of text found in the resource's destination page.
	DestinationTexts     []*wrappers.StringValue `protobuf:"bytes,1,rep,name=destination_texts,json=destinationTexts,proto3" json:"destination_texts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationTextList) Reset() {
	*m = PolicyTopicEvidence_DestinationTextList{}
}
func (m *PolicyTopicEvidence_DestinationTextList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationTextList) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationTextList) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{3, 2}
}

func (m *PolicyTopicEvidence_DestinationTextList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Merge(m, src)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Size(m)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationTextList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationTextList) GetDestinationTexts() []*wrappers.StringValue {
	if m != nil {
		return m.DestinationTexts
	}
	return nil
}

// Evidence of mismatches between the URLs of a resource.
type PolicyTopicEvidence_DestinationMismatch struct {
	// The set of URLs that did not match each other.
	UrlTypes             []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType `protobuf:"varint,1,rep,packed,name=url_types,json=urlTypes,proto3,enum=google.ads.googleads.v1.enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType" json:"url_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                                                `json:"-"`
	XXX_unrecognized     []byte                                                                                                  `json:"-"`
	XXX_sizecache        int32                                                                                                   `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationMismatch) Reset() {
	*m = PolicyTopicEvidence_DestinationMismatch{}
}
func (m *PolicyTopicEvidence_DestinationMismatch) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationMismatch) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationMismatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{3, 3}
}

func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Merge(m, src)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Size(m)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationMismatch) GetUrlTypes() []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType {
	if m != nil {
		return m.UrlTypes
	}
	return nil
}

// Evidence details when the destination is returning an HTTP error
// code or isn't functional in all locations for commonly used devices.
type PolicyTopicEvidence_DestinationNotWorking struct {
	// The full URL that didn't work.
	ExpandedUrl *wrappers.StringValue `protobuf:"bytes,3,opt,name=expanded_url,json=expandedUrl,proto3" json:"expanded_url,omitempty"`
	// The type of device that failed to load the URL.
	Device enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice `protobuf:"varint,4,opt,name=device,proto3,enum=google.ads.googleads.v1.enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice" json:"device,omitempty"`
	// The time the URL was last checked.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	LastCheckedDateTime  *wrappers.StringValue `protobuf:"bytes,5,opt,name=last_checked_date_time,json=lastCheckedDateTime,proto3" json:"last_checked_date_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationNotWorking) Reset() {
	*m = PolicyTopicEvidence_DestinationNotWorking{}
}
func (m *PolicyTopicEvidence_DestinationNotWorking) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationNotWorking) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationNotWorking) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{3, 4}
}

func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Merge(m, src)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Size(m)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationNotWorking) GetExpandedUrl() *wrappers.StringValue {
	if m != nil {
		return m.ExpandedUrl
	}
	return nil
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetDevice() enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice {
	if m != nil {
		return m.Device
	}
	return enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_UNSPECIFIED
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetLastCheckedDateTime() *wrappers.StringValue {
	if m != nil {
		return m.LastCheckedDateTime
	}
	return nil
}

// Describes the effect on serving that a policy topic entry will have.
type PolicyTopicConstraint struct {
	// Specific information about the constraint.
	//
	// Types that are valid to be assigned to Value:
	//	*PolicyTopicConstraint_CountryConstraintList_
	//	*PolicyTopicConstraint_ResellerConstraint_
	//	*PolicyTopicConstraint_CertificateMissingInCountryList
	//	*PolicyTopicConstraint_CertificateDomainMismatchInCountryList
	Value                isPolicyTopicConstraint_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PolicyTopicConstraint) Reset()         { *m = PolicyTopicConstraint{} }
func (m *PolicyTopicConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{4}
}

func (m *PolicyTopicConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint.Merge(m, src)
}
func (m *PolicyTopicConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint.Size(m)
}
func (m *PolicyTopicConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint proto.InternalMessageInfo

type isPolicyTopicConstraint_Value interface {
	isPolicyTopicConstraint_Value()
}

type PolicyTopicConstraint_CountryConstraintList_ struct {
	CountryConstraintList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,1,opt,name=country_constraint_list,json=countryConstraintList,proto3,oneof"`
}

type PolicyTopicConstraint_ResellerConstraint_ struct {
	ResellerConstraint *PolicyTopicConstraint_ResellerConstraint `protobuf:"bytes,2,opt,name=reseller_constraint,json=resellerConstraint,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateMissingInCountryList struct {
	CertificateMissingInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,3,opt,name=certificate_missing_in_country_list,json=certificateMissingInCountryList,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateDomainMismatchInCountryList struct {
	CertificateDomainMismatchInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,4,opt,name=certificate_domain_mismatch_in_country_list,json=certificateDomainMismatchInCountryList,proto3,oneof"`
}

func (*PolicyTopicConstraint_CountryConstraintList_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_ResellerConstraint_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateMissingInCountryList) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateDomainMismatchInCountryList) isPolicyTopicConstraint_Value() {}

func (m *PolicyTopicConstraint) GetValue() isPolicyTopicConstraint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCountryConstraintList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CountryConstraintList_); ok {
		return x.CountryConstraintList
	}
	return nil
}

func (m *PolicyTopicConstraint) GetResellerConstraint() *PolicyTopicConstraint_ResellerConstraint {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_ResellerConstraint_); ok {
		return x.ResellerConstraint
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCertificateMissingInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CertificateMissingInCountryList); ok {
		return x.CertificateMissingInCountryList
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCertificateDomainMismatchInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList); ok {
		return x.CertificateDomainMismatchInCountryList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PolicyTopicConstraint) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PolicyTopicConstraint_CountryConstraintList_)(nil),
		(*PolicyTopicConstraint_ResellerConstraint_)(nil),
		(*PolicyTopicConstraint_CertificateMissingInCountryList)(nil),
		(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList)(nil),
	}
}

// A list of countries where a resource's serving is constrained.
type PolicyTopicConstraint_CountryConstraintList struct {
	// Total number of countries targeted by the resource.
	TotalTargetedCountries *wrappers.Int32Value `protobuf:"bytes,1,opt,name=total_targeted_countries,json=totalTargetedCountries,proto3" json:"total_targeted_countries,omitempty"`
	// Countries in which serving is restricted.
	Countries            []*PolicyTopicConstraint_CountryConstraint `protobuf:"bytes,2,rep,name=countries,proto3" json:"countries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *PolicyTopicConstraint_CountryConstraintList) Reset() {
	*m = PolicyTopicConstraint_CountryConstraintList{}
}
func (m *PolicyTopicConstraint_CountryConstraintList) String() string {
	return proto.CompactTextString(m)
}
func (*PolicyTopicConstraint_CountryConstraintList) ProtoMessage() {}
func (*PolicyTopicConstraint_CountryConstraintList) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{4, 0}
}

func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Merge(m, src)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Size(m)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList proto.InternalMessageInfo

func (m *PolicyTopicConstraint_CountryConstraintList) GetTotalTargetedCountries() *wrappers.Int32Value {
	if m != nil {
		return m.TotalTargetedCountries
	}
	return nil
}

func (m *PolicyTopicConstraint_CountryConstraintList) GetCountries() []*PolicyTopicConstraint_CountryConstraint {
	if m != nil {
		return m.Countries
	}
	return nil
}

// Indicates that a policy topic was constrained due to disapproval of the
// website for reseller purposes.
type PolicyTopicConstraint_ResellerConstraint struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PolicyTopicConstraint_ResellerConstraint) Reset() {
	*m = PolicyTopicConstraint_ResellerConstraint{}
}
func (m *PolicyTopicConstraint_ResellerConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint_ResellerConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint_ResellerConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{4, 1}
}

func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Merge(m, src)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Size(m)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint proto.InternalMessageInfo

// Indicates that a resource's ability to serve in a particular country is
// constrained.
type PolicyTopicConstraint_CountryConstraint struct {
	// Geo target constant resource name of the country in which serving is
	// constrained.
	CountryCriterion     *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_criterion,json=countryCriterion,proto3" json:"country_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyTopicConstraint_CountryConstraint) Reset() {
	*m = PolicyTopicConstraint_CountryConstraint{}
}
func (m *PolicyTopicConstraint_CountryConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint_CountryConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint_CountryConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_abac22fabf79a39c, []int{4, 2}
}

func (m *PolicyTopicConstraint_CountryConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Merge(m, src)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Size(m)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_CountryConstraint proto.InternalMessageInfo

func (m *PolicyTopicConstraint_CountryConstraint) GetCountryCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CountryCriterion
	}
	return nil
}

func init() {
	proto.RegisterType((*PolicyViolationKey)(nil), "google.ads.googleads.v1.common.PolicyViolationKey")
	proto.RegisterType((*PolicyValidationParameter)(nil), "google.ads.googleads.v1.common.PolicyValidationParameter")
	proto.RegisterType((*PolicyTopicEntry)(nil), "google.ads.googleads.v1.common.PolicyTopicEntry")
	proto.RegisterType((*PolicyTopicEvidence)(nil), "google.ads.googleads.v1.common.PolicyTopicEvidence")
	proto.RegisterType((*PolicyTopicEvidence_TextList)(nil), "google.ads.googleads.v1.common.PolicyTopicEvidence.TextList")
	proto.RegisterType((*PolicyTopicEvidence_WebsiteList)(nil), "google.ads.googleads.v1.common.PolicyTopicEvidence.WebsiteList")
	proto.RegisterType((*PolicyTopicEvidence_DestinationTextList)(nil), "google.ads.googleads.v1.common.PolicyTopicEvidence.DestinationTextList")
	proto.RegisterType((*PolicyTopicEvidence_DestinationMismatch)(nil), "google.ads.googleads.v1.common.PolicyTopicEvidence.DestinationMismatch")
	proto.RegisterType((*PolicyTopicEvidence_DestinationNotWorking)(nil), "google.ads.googleads.v1.common.PolicyTopicEvidence.DestinationNotWorking")
	proto.RegisterType((*PolicyTopicConstraint)(nil), "google.ads.googleads.v1.common.PolicyTopicConstraint")
	proto.RegisterType((*PolicyTopicConstraint_CountryConstraintList)(nil), "google.ads.googleads.v1.common.PolicyTopicConstraint.CountryConstraintList")
	proto.RegisterType((*PolicyTopicConstraint_ResellerConstraint)(nil), "google.ads.googleads.v1.common.PolicyTopicConstraint.ResellerConstraint")
	proto.RegisterType((*PolicyTopicConstraint_CountryConstraint)(nil), "google.ads.googleads.v1.common.PolicyTopicConstraint.CountryConstraint")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/policy.proto", fileDescriptor_abac22fabf79a39c)
}

var fileDescriptor_abac22fabf79a39c = []byte{
	// 1167 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xcb, 0x6e, 0x1b, 0x37,
	0x14, 0xf5, 0xc8, 0x2f, 0x99, 0x72, 0x0c, 0x87, 0x8e, 0x62, 0x45, 0x35, 0xd2, 0x40, 0x05, 0x8a,
	0x02, 0x01, 0x46, 0xb0, 0x8c, 0x02, 0x85, 0xd2, 0x36, 0xb0, 0xe5, 0xc0, 0x32, 0xf2, 0x80, 0x33,
	0x95, 0xed, 0xa2, 0x35, 0x3a, 0xa1, 0x67, 0x98, 0x31, 0xe1, 0x19, 0x72, 0x30, 0xa4, 0x64, 0x0b,
	0x7d, 0xa0, 0x40, 0xd1, 0x7f, 0x68, 0xd1, 0x5d, 0x97, 0xd9, 0x76, 0xdf, 0x6d, 0x81, 0xae, 0xba,
	0x68, 0x7f, 0x21, 0x8b, 0x7e, 0x45, 0x31, 0x24, 0xe7, 0x11, 0x49, 0x8e, 0xe5, 0x47, 0x57, 0xa6,
	0xc9, 0x7b, 0xce, 0x3d, 0x3c, 0x73, 0x79, 0x49, 0x81, 0xfb, 0x1e, 0x63, 0x9e, 0x8f, 0xeb, 0xc8,
	0xe5, 0x75, 0x35, 0x8c, 0x47, 0xbd, 0xd5, 0xba, 0xc3, 0x82, 0x80, 0xd1, 0x7a, 0xc8, 0x7c, 0xe2,
	0xf4, 0xcd, 0x30, 0x62, 0x82, 0xc1, 0xbb, 0x2a, 0xc2, 0x44, 0x2e, 0x37, 0xd3, 0x60, 0xb3, 0xb7,
	0x6a, 0xaa, 0xe0, 0xea, 0x83, 0xb3, 0xc8, 0x30, 0xed, 0x06, 0x5c, 0x73, 0xd9, 0x82, 0x85, 0xc4,
	0xb1, 0x31, 0x15, 0x51, 0xdf, 0x16, 0xfd, 0x10, 0x2b, 0xf2, 0xea, 0xfe, 0x45, 0xc0, 0x3d, 0xe2,
	0x62, 0xea, 0x60, 0xdb, 0xc5, 0x5c, 0x10, 0x8a, 0x04, 0x61, 0xd4, 0x0e, 0x08, 0x0f, 0x90, 0x70,
	0x8e, 0xec, 0x6e, 0xe4, 0xe7, 0x89, 0x3f, 0xbf, 0x2a, 0x31, 0x65, 0xc2, 0x3e, 0x61, 0xd1, 0x31,
	0xa1, 0x9e, 0xed, 0xe2, 0x1e, 0x71, 0x12, 0xe6, 0x95, 0x84, 0x39, 0x24, 0x75, 0x44, 0x29, 0x13,
	0x32, 0x9e, 0xeb, 0x55, 0xed, 0x56, 0x5d, 0xfe, 0x77, 0xd8, 0x7d, 0x59, 0x3f, 0x89, 0x50, 0x18,
	0xe2, 0x48, 0xaf, 0xd7, 0x7e, 0x32, 0x00, 0xdc, 0x91, 0xc9, 0xf7, 0x08, 0xf3, 0x25, 0xf4, 0x31,
	0xee, 0xc3, 0x4f, 0x40, 0x49, 0x4b, 0xa2, 0x28, 0xc0, 0x15, 0xe3, 0x9e, 0xf1, 0x41, 0xa9, 0xb1,
	0xa2, 0xfd, 0x36, 0x13, 0x32, 0xf3, 0x33, 0x11, 0x11, 0xea, 0xed, 0x21, 0xbf, 0x8b, 0x2d, 0xa0,
	0x00, 0xcf, 0x50, 0x80, 0x61, 0x0b, 0x2c, 0xf4, 0x14, 0x1d, 0xf5, 0x6c, 0x81, 0x4f, 0x45, 0xa5,
	0x30, 0x06, 0xc3, 0x8d, 0x14, 0xd3, 0xc1, 0xa7, 0xa2, 0xf6, 0xda, 0x00, 0x77, 0xb4, 0x34, 0xe4,
	0x13, 0x57, 0x6a, 0xdb, 0x41, 0x11, 0x0a, 0xb0, 0xc0, 0x11, 0xec, 0x80, 0x65, 0xe2, 0x51, 0x16,
	0xa1, 0x43, 0x1f, 0xdb, 0x79, 0xfb, 0x78, 0xc5, 0xb8, 0x37, 0x79, 0x6e, 0xae, 0x72, 0x0a, 0x56,
	0x29, 0x3a, 0x12, 0x0a, 0x39, 0x58, 0xc1, 0xa7, 0x38, 0x08, 0x45, 0x42, 0xd9, 0x4b, 0x5c, 0xb1,
	0x8f, 0x71, 0x9f, 0x57, 0x0a, 0x92, 0xba, 0x61, 0xbe, 0xbd, 0x06, 0xcd, 0x61, 0x47, 0xad, 0x3b,
	0x8a, 0x77, 0x78, 0x85, 0xd7, 0xfe, 0x2e, 0x80, 0xc5, 0x9c, 0x8a, 0x47, 0x71, 0x51, 0xc2, 0x06,
	0x98, 0x96, 0xdb, 0x19, 0xcb, 0x7b, 0x15, 0x0a, 0x5f, 0x80, 0xa9, 0xb8, 0xe4, 0xa4, 0xd9, 0x0b,
	0x8d, 0x27, 0x67, 0xaa, 0x94, 0x35, 0x67, 0x0e, 0xa6, 0xec, 0xf4, 0x43, 0xfc, 0x88, 0x76, 0x83,
	0x91, 0x0b, 0x96, 0x64, 0x86, 0xcf, 0xc1, 0x5c, 0x52, 0x9d, 0xbc, 0x32, 0x29, 0xcd, 0x58, 0x1b,
	0xcf, 0x0c, 0x45, 0xa7, 0xb1, 0x56, 0xc6, 0x02, 0xf7, 0x41, 0xc9, 0x61, 0x94, 0x8b, 0x08, 0x11,
	0x2a, 0x78, 0x65, 0x4a, 0x92, 0x7e, 0x78, 0x01, 0xd2, 0x56, 0x8a, 0xb6, 0xf2, 0x4c, 0xb5, 0xbf,
	0x4a, 0x60, 0x69, 0x44, 0x6e, 0xd8, 0x04, 0x73, 0x47, 0x42, 0x84, 0xb6, 0xc3, 0x5c, 0xac, 0xeb,
	0xf2, 0x9d, 0x21, 0x77, 0xb7, 0xa9, 0x58, 0x6b, 0x48, 0x73, 0xdb, 0x13, 0x56, 0x31, 0x8e, 0x6f,
	0x31, 0x17, 0x43, 0x17, 0xcc, 0x9f, 0xe0, 0x43, 0x4e, 0x04, 0xb6, 0x7d, 0xc2, 0x45, 0x65, 0x52,
	0xc2, 0x1f, 0x5e, 0xc2, 0x02, 0x73, 0x5f, 0xf1, 0x3c, 0x21, 0x5c, 0xb4, 0x27, 0xac, 0xd2, 0x49,
	0xf6, 0x2f, 0xfc, 0x12, 0xcc, 0xc5, 0x87, 0x46, 0xa5, 0x98, 0x92, 0x29, 0x3e, 0xbe, 0x4c, 0x8a,
	0xf8, 0x18, 0x69, 0xfe, 0xa2, 0xd0, 0x63, 0xd8, 0x02, 0x37, 0x7c, 0x44, 0xbd, 0x2e, 0xf2, 0xb0,
	0xb2, 0x60, 0xfa, 0xfc, 0x02, 0x6b, 0x4f, 0x58, 0xf3, 0x09, 0x48, 0xfa, 0xf0, 0x2d, 0x28, 0xe7,
	0x9b, 0x53, 0xa6, 0x76, 0x46, 0x92, 0x6d, 0x5d, 0x46, 0xed, 0x66, 0x46, 0x98, 0x13, 0xbe, 0xe4,
	0x0e, 0x4f, 0xc3, 0x6f, 0xc0, 0xad, 0x51, 0x4d, 0xb7, 0x32, 0x7b, 0x2d, 0xd9, 0x9f, 0x6a, 0xba,
	0x81, 0xec, 0xc9, 0x34, 0xfc, 0xc1, 0x00, 0xcb, 0x67, 0xb4, 0xe6, 0x4a, 0x51, 0x2a, 0xd8, 0xbe,
	0xa2, 0x82, 0x67, 0x4c, 0xec, 0x2b, 0xc2, 0xf6, 0x84, 0x95, 0x77, 0x3a, 0x5b, 0xa8, 0x7e, 0x0a,
	0x8a, 0xa9, 0x1f, 0x71, 0xb3, 0xc0, 0xa7, 0x62, 0xbc, 0xd6, 0xa7, 0x42, 0xab, 0x5b, 0xa0, 0x94,
	0x2b, 0x41, 0xf8, 0x11, 0x28, 0xea, 0x12, 0x1c, 0x8f, 0x25, 0x8d, 0xae, 0xbe, 0x00, 0x4b, 0x23,
	0x3e, 0x1d, 0xdc, 0x06, 0x37, 0x07, 0x4b, 0x64, 0x3c, 0xe6, 0xc5, 0x81, 0x2f, 0xce, 0xab, 0xbf,
	0x19, 0x6f, 0xa4, 0x48, 0x3f, 0xc4, 0x2f, 0x06, 0x98, 0x4b, 0xee, 0x59, 0xc5, 0xbd, 0xd0, 0xf8,
	0xee, 0x02, 0x5d, 0x4f, 0x3b, 0x3f, 0x82, 0x7a, 0x37, 0xf2, 0x47, 0xb6, 0xc3, 0x73, 0x11, 0x56,
	0xb1, 0xab, 0x06, 0xbc, 0xfa, 0x47, 0x01, 0x94, 0x47, 0x7e, 0x53, 0xf8, 0x10, 0xcc, 0xe3, 0xd3,
	0x10, 0x51, 0x17, 0xbb, 0xf1, 0x3b, 0x41, 0x77, 0x91, 0xb7, 0xbb, 0x52, 0x4a, 0x10, 0xbb, 0x91,
	0x0f, 0x7f, 0x36, 0xc0, 0x8c, 0x7a, 0x04, 0xc8, 0xf6, 0xb0, 0xd0, 0xf8, 0xde, 0xb8, 0xd2, 0xb6,
	0x33, 0x6d, 0x9b, 0x92, 0x75, 0x8c, 0x7d, 0x0f, 0x42, 0x2c, 0x2d, 0x08, 0x3e, 0x07, 0xb7, 0x7d,
	0xc4, 0x85, 0xed, 0x1c, 0x61, 0xe7, 0x18, 0xbb, 0xb6, 0x8b, 0x04, 0xb6, 0x05, 0x09, 0xc6, 0x6a,
	0x34, 0xd6, 0x52, 0x8c, 0x6d, 0x29, 0xe8, 0x26, 0x12, 0xb8, 0x43, 0x02, 0xbc, 0x31, 0x0b, 0xa6,
	0x7b, 0xf1, 0x6a, 0xed, 0xf7, 0x59, 0x50, 0x1e, 0xd9, 0xf9, 0xe1, 0x8f, 0x06, 0x58, 0x76, 0x58,
	0x57, 0xbe, 0xe7, 0xb2, 0x4b, 0x40, 0xf5, 0x24, 0x75, 0x83, 0x3e, 0xbe, 0xd4, 0x95, 0x62, 0xb6,
	0x14, 0x69, 0x36, 0xa3, 0xfb, 0x52, 0xd9, 0x19, 0xb5, 0x00, 0xbf, 0x06, 0x4b, 0x11, 0xe6, 0xd8,
	0xf7, 0x71, 0x94, 0xd3, 0xa1, 0xaf, 0x99, 0xf6, 0xe5, 0x24, 0x58, 0x9a, 0x30, 0x9b, 0x6a, 0x4f,
	0x58, 0x30, 0x1a, 0x9a, 0x8d, 0xcf, 0xc3, 0x7b, 0x0e, 0x8e, 0x04, 0x79, 0x49, 0x9c, 0xd8, 0xf5,
	0x80, 0x70, 0x1e, 0xbf, 0xc0, 0x08, 0xb5, 0x13, 0x6f, 0x72, 0xb7, 0xd6, 0x35, 0x1b, 0xf2, 0x6e,
	0x2e, 0xf3, 0x53, 0x95, 0x78, 0x9b, 0xea, 0x60, 0x69, 0xcd, 0x2b, 0x03, 0xdc, 0xcf, 0xab, 0x73,
	0x59, 0x80, 0x48, 0xee, 0xc5, 0x3c, 0xa8, 0x72, 0xea, 0xff, 0x50, 0xf9, 0x7e, 0x4e, 0xc1, 0xa6,
	0x14, 0x90, 0x1c, 0xe0, 0x37, 0xc4, 0x56, 0xff, 0x31, 0x40, 0x79, 0x24, 0x07, 0xdc, 0x05, 0x15,
	0xc1, 0x04, 0xf2, 0x6d, 0x81, 0x22, 0x0f, 0x0b, 0xec, 0x6a, 0xd5, 0x44, 0xb6, 0xa0, 0xf3, 0x5e,
	0x13, 0xd6, 0x6d, 0x09, 0xee, 0x68, 0x6c, 0x2b, 0x81, 0x42, 0x0c, 0xe6, 0x32, 0x1e, 0xf5, 0xcc,
	0xdc, 0xba, 0xa6, 0xad, 0x5b, 0x19, 0x73, 0xf5, 0x16, 0x80, 0xc3, 0xe5, 0x54, 0xfd, 0x0a, 0xdc,
	0x1c, 0x42, 0xc5, 0x0d, 0x3c, 0x3d, 0x51, 0x11, 0x11, 0x38, 0x22, 0x8c, 0x8e, 0xf5, 0x1a, 0x5d,
	0x4c, 0x8e, 0x46, 0x82, 0x4a, 0x0f, 0xf0, 0xc6, 0x6b, 0x03, 0xd4, 0x1c, 0x16, 0x9c, 0xb3, 0xb1,
	0x8d, 0x92, 0xda, 0xd9, 0x4e, 0xcc, 0xbe, 0x63, 0x7c, 0xb1, 0xa9, 0xc3, 0x3d, 0x16, 0x3f, 0x42,
	0x4c, 0x16, 0x79, 0x75, 0x0f, 0x53, 0x99, 0x3b, 0xf9, 0x31, 0x15, 0x12, 0x7e, 0xd6, 0xcf, 0xc7,
	0x07, 0xea, 0xcf, 0xaf, 0x85, 0xc9, 0xad, 0xf5, 0xf5, 0x57, 0x85, 0xbb, 0x5b, 0x8a, 0x6c, 0xdd,
	0xe5, 0xa6, 0x1a, 0xc6, 0xa3, 0xbd, 0x55, 0xb3, 0x25, 0xc3, 0xfe, 0x4c, 0x02, 0x0e, 0xd6, 0x5d,
	0x7e, 0x90, 0x06, 0x1c, 0xec, 0xad, 0x1e, 0xa8, 0x80, 0x7f, 0x0b, 0x35, 0x35, 0xdb, 0x6c, 0xae,
	0xbb, 0xbc, 0xd9, 0x4c, 0x43, 0x9a, 0xcd, 0xbd, 0xd5, 0x66, 0x53, 0x05, 0x1d, 0xce, 0x48, 0x75,
	0x6b, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x9e, 0xa6, 0x20, 0xbb, 0xdb, 0x0e, 0x00, 0x00,
}
