// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchDetectDominantLanguage = "BatchDetectDominantLanguage"

// BatchDetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectDominantLanguage for more information on using the BatchDetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectDominantLanguageRequest method.
//    req, resp := client.BatchDetectDominantLanguageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguageRequest(input *BatchDetectDominantLanguageInput) (req *request.Request, output *BatchDetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opBatchDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectDominantLanguageInput{}
	}

	output = &BatchDetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text for a batch of documents.
// For a list of languages that Amazon Comprehend can detect, see Amazon Comprehend
// Supported Languages (http://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectDominantLanguage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguage(input *BatchDetectDominantLanguageInput) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	return out, req.Send()
}

// BatchDetectDominantLanguageWithContext is the same as BatchDetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectDominantLanguageWithContext(ctx aws.Context, input *BatchDetectDominantLanguageInput, opts ...request.Option) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectEntities = "BatchDetectEntities"

// BatchDetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectEntities for more information on using the BatchDetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectEntitiesRequest method.
//    req, resp := client.BatchDetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntitiesRequest(input *BatchDetectEntitiesInput) (req *request.Request, output *BatchDetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectEntitiesInput{}
	}

	output = &BatchDetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectEntities API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents for named entities and returns
// information about them. For more information about named entities, see how-entities
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntities(input *BatchDetectEntitiesInput) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	return out, req.Send()
}

// BatchDetectEntitiesWithContext is the same as BatchDetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectEntitiesWithContext(ctx aws.Context, input *BatchDetectEntitiesInput, opts ...request.Option) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectKeyPhrases = "BatchDetectKeyPhrases"

// BatchDetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectKeyPhrases for more information on using the BatchDetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectKeyPhrasesRequest method.
//    req, resp := client.BatchDetectKeyPhrasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrasesRequest(input *BatchDetectKeyPhrasesInput) (req *request.Request, output *BatchDetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectKeyPhrasesInput{}
	}

	output = &BatchDetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in a batch of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectKeyPhrases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrases(input *BatchDetectKeyPhrasesInput) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// BatchDetectKeyPhrasesWithContext is the same as BatchDetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectKeyPhrasesWithContext(ctx aws.Context, input *BatchDetectKeyPhrasesInput, opts ...request.Option) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSentiment = "BatchDetectSentiment"

// BatchDetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSentiment for more information on using the BatchDetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectSentimentRequest method.
//    req, resp := client.BatchDetectSentimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentimentRequest(input *BatchDetectSentimentInput) (req *request.Request, output *BatchDetectSentimentOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSentimentInput{}
	}

	output = &BatchDetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSentiment API operation for Amazon Comprehend.
//
// Inspects a batch of documents and returns an inference of the prevailing
// sentiment, POSITIVE, NEUTRAL, MIXED, or NEGATIVE, in each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSentiment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentiment(input *BatchDetectSentimentInput) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	return out, req.Send()
}

// BatchDetectSentimentWithContext is the same as BatchDetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSentimentWithContext(ctx aws.Context, input *BatchDetectSentimentInput, opts ...request.Option) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSyntax = "BatchDetectSyntax"

// BatchDetectSyntaxRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSyntax operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSyntax for more information on using the BatchDetectSyntax
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectSyntaxRequest method.
//    req, resp := client.BatchDetectSyntaxRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax
func (c *Comprehend) BatchDetectSyntaxRequest(input *BatchDetectSyntaxInput) (req *request.Request, output *BatchDetectSyntaxOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSyntax,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSyntaxInput{}
	}

	output = &BatchDetectSyntaxOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSyntax API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents for the syntax and part of speech
// of the words in the document and returns information about them. For more
// information, see how-syntax.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSyntax for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax
func (c *Comprehend) BatchDetectSyntax(input *BatchDetectSyntaxInput) (*BatchDetectSyntaxOutput, error) {
	req, out := c.BatchDetectSyntaxRequest(input)
	return out, req.Send()
}

// BatchDetectSyntaxWithContext is the same as BatchDetectSyntax with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSyntax for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSyntaxWithContext(ctx aws.Context, input *BatchDetectSyntaxInput, opts ...request.Option) (*BatchDetectSyntaxOutput, error) {
	req, out := c.BatchDetectSyntaxRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDominantLanguageDetectionJob = "DescribeDominantLanguageDetectionJob"

// DescribeDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDominantLanguageDetectionJob for more information on using the DescribeDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDominantLanguageDetectionJobRequest method.
//    req, resp := client.DescribeDominantLanguageDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob
func (c *Comprehend) DescribeDominantLanguageDetectionJobRequest(input *DescribeDominantLanguageDetectionJobInput) (req *request.Request, output *DescribeDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDominantLanguageDetectionJobInput{}
	}

	output = &DescribeDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a dominant language detection job. Use
// this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob
func (c *Comprehend) DescribeDominantLanguageDetectionJob(input *DescribeDominantLanguageDetectionJobInput) (*DescribeDominantLanguageDetectionJobOutput, error) {
	req, out := c.DescribeDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeDominantLanguageDetectionJobWithContext is the same as DescribeDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDominantLanguageDetectionJobWithContext(ctx aws.Context, input *DescribeDominantLanguageDetectionJobInput, opts ...request.Option) (*DescribeDominantLanguageDetectionJobOutput, error) {
	req, out := c.DescribeDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntitiesDetectionJob = "DescribeEntitiesDetectionJob"

// DescribeEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntitiesDetectionJob for more information on using the DescribeEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEntitiesDetectionJobRequest method.
//    req, resp := client.DescribeEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob
func (c *Comprehend) DescribeEntitiesDetectionJobRequest(input *DescribeEntitiesDetectionJobInput) (req *request.Request, output *DescribeEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntitiesDetectionJobInput{}
	}

	output = &DescribeEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with an entities detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEntitiesDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob
func (c *Comprehend) DescribeEntitiesDetectionJob(input *DescribeEntitiesDetectionJobInput) (*DescribeEntitiesDetectionJobOutput, error) {
	req, out := c.DescribeEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeEntitiesDetectionJobWithContext is the same as DescribeEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEntitiesDetectionJobWithContext(ctx aws.Context, input *DescribeEntitiesDetectionJobInput, opts ...request.Option) (*DescribeEntitiesDetectionJobOutput, error) {
	req, out := c.DescribeEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeKeyPhrasesDetectionJob = "DescribeKeyPhrasesDetectionJob"

// DescribeKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKeyPhrasesDetectionJob for more information on using the DescribeKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeKeyPhrasesDetectionJobRequest method.
//    req, resp := client.DescribeKeyPhrasesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Comprehend) DescribeKeyPhrasesDetectionJobRequest(input *DescribeKeyPhrasesDetectionJobInput) (req *request.Request, output *DescribeKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPhrasesDetectionJobInput{}
	}

	output = &DescribeKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a key phrases detection job. Use this
// operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Comprehend) DescribeKeyPhrasesDetectionJob(input *DescribeKeyPhrasesDetectionJobInput) (*DescribeKeyPhrasesDetectionJobOutput, error) {
	req, out := c.DescribeKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeKeyPhrasesDetectionJobWithContext is the same as DescribeKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *DescribeKeyPhrasesDetectionJobInput, opts ...request.Option) (*DescribeKeyPhrasesDetectionJobOutput, error) {
	req, out := c.DescribeKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSentimentDetectionJob = "DescribeSentimentDetectionJob"

// DescribeSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSentimentDetectionJob for more information on using the DescribeSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSentimentDetectionJobRequest method.
//    req, resp := client.DescribeSentimentDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Comprehend) DescribeSentimentDetectionJobRequest(input *DescribeSentimentDetectionJobInput) (req *request.Request, output *DescribeSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSentimentDetectionJobInput{}
	}

	output = &DescribeSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSentimentDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a sentiment detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeSentimentDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Comprehend) DescribeSentimentDetectionJob(input *DescribeSentimentDetectionJobInput) (*DescribeSentimentDetectionJobOutput, error) {
	req, out := c.DescribeSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeSentimentDetectionJobWithContext is the same as DescribeSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeSentimentDetectionJobWithContext(ctx aws.Context, input *DescribeSentimentDetectionJobInput, opts ...request.Option) (*DescribeSentimentDetectionJobOutput, error) {
	req, out := c.DescribeSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicsDetectionJob = "DescribeTopicsDetectionJob"

// DescribeTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicsDetectionJob for more information on using the DescribeTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTopicsDetectionJobRequest method.
//    req, resp := client.DescribeTopicsDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJobRequest(input *DescribeTopicsDetectionJobInput) (req *request.Request, output *DescribeTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsDetectionJobInput{}
	}

	output = &DescribeTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicsDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a topic detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeTopicsDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJob(input *DescribeTopicsDetectionJobInput) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeTopicsDetectionJobWithContext is the same as DescribeTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeTopicsDetectionJobWithContext(ctx aws.Context, input *DescribeTopicsDetectionJobInput, opts ...request.Option) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectDominantLanguage = "DetectDominantLanguage"

// DetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the DetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectDominantLanguage for more information on using the DetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectDominantLanguageRequest method.
//    req, resp := client.DetectDominantLanguageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguageRequest(input *DetectDominantLanguageInput) (req *request.Request, output *DetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDominantLanguageInput{}
	}

	output = &DetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text. For a list of languages
// that Amazon Comprehend can detect, see Amazon Comprehend Supported Languages
// (http://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectDominantLanguage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguage(input *DetectDominantLanguageInput) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	return out, req.Send()
}

// DetectDominantLanguageWithContext is the same as DetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See DetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectDominantLanguageWithContext(ctx aws.Context, input *DetectDominantLanguageInput, opts ...request.Option) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntities for more information on using the DetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectEntitiesRequest method.
//    req, resp := client.DetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntitiesRequest(input *DetectEntitiesInput) (req *request.Request, output *DetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	output = &DetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntities API operation for Amazon Comprehend.
//
// Inspects text for named entities, and returns information about them. For
// more information, about named entities, see how-entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntities(input *DetectEntitiesInput) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	return out, req.Send()
}

// DetectEntitiesWithContext is the same as DetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectEntitiesWithContext(ctx aws.Context, input *DetectEntitiesInput, opts ...request.Option) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectKeyPhrases = "DetectKeyPhrases"

// DetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the DetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectKeyPhrases for more information on using the DetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectKeyPhrasesRequest method.
//    req, resp := client.DetectKeyPhrasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrasesRequest(input *DetectKeyPhrasesInput) (req *request.Request, output *DetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectKeyPhrasesInput{}
	}

	output = &DetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in the text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectKeyPhrases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrases(input *DetectKeyPhrasesInput) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// DetectKeyPhrasesWithContext is the same as DetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See DetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectKeyPhrasesWithContext(ctx aws.Context, input *DetectKeyPhrasesInput, opts ...request.Option) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSentiment = "DetectSentiment"

// DetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the DetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSentiment for more information on using the DetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectSentimentRequest method.
//    req, resp := client.DetectSentimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentimentRequest(input *DetectSentimentInput) (req *request.Request, output *DetectSentimentOutput) {
	op := &request.Operation{
		Name:       opDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSentimentInput{}
	}

	output = &DetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSentiment API operation for Amazon Comprehend.
//
// Inspects text and returns an inference of the prevailing sentiment (POSITIVE,
// NEUTRAL, MIXED, or NEGATIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSentiment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentiment(input *DetectSentimentInput) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	return out, req.Send()
}

// DetectSentimentWithContext is the same as DetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSentimentWithContext(ctx aws.Context, input *DetectSentimentInput, opts ...request.Option) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSyntax = "DetectSyntax"

// DetectSyntaxRequest generates a "aws/request.Request" representing the
// client's request for the DetectSyntax operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSyntax for more information on using the DetectSyntax
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectSyntaxRequest method.
//    req, resp := client.DetectSyntaxRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax
func (c *Comprehend) DetectSyntaxRequest(input *DetectSyntaxInput) (req *request.Request, output *DetectSyntaxOutput) {
	op := &request.Operation{
		Name:       opDetectSyntax,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSyntaxInput{}
	}

	output = &DetectSyntaxOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSyntax API operation for Amazon Comprehend.
//
// Inspects text for syntax and the part of speech of words in the document.
// For more information, how-syntax.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSyntax for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax
func (c *Comprehend) DetectSyntax(input *DetectSyntaxInput) (*DetectSyntaxOutput, error) {
	req, out := c.DetectSyntaxRequest(input)
	return out, req.Send()
}

// DetectSyntaxWithContext is the same as DetectSyntax with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSyntax for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSyntaxWithContext(ctx aws.Context, input *DetectSyntaxInput, opts ...request.Option) (*DetectSyntaxOutput, error) {
	req, out := c.DetectSyntaxRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDominantLanguageDetectionJobs = "ListDominantLanguageDetectionJobs"

// ListDominantLanguageDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDominantLanguageDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDominantLanguageDetectionJobs for more information on using the ListDominantLanguageDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDominantLanguageDetectionJobsRequest method.
//    req, resp := client.ListDominantLanguageDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs
func (c *Comprehend) ListDominantLanguageDetectionJobsRequest(input *ListDominantLanguageDetectionJobsInput) (req *request.Request, output *ListDominantLanguageDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListDominantLanguageDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDominantLanguageDetectionJobsInput{}
	}

	output = &ListDominantLanguageDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDominantLanguageDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the dominant language detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDominantLanguageDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the ListTopicDetectionJobs operation is invalid.
//   Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs
func (c *Comprehend) ListDominantLanguageDetectionJobs(input *ListDominantLanguageDetectionJobsInput) (*ListDominantLanguageDetectionJobsOutput, error) {
	req, out := c.ListDominantLanguageDetectionJobsRequest(input)
	return out, req.Send()
}

// ListDominantLanguageDetectionJobsWithContext is the same as ListDominantLanguageDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDominantLanguageDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDominantLanguageDetectionJobsWithContext(ctx aws.Context, input *ListDominantLanguageDetectionJobsInput, opts ...request.Option) (*ListDominantLanguageDetectionJobsOutput, error) {
	req, out := c.ListDominantLanguageDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDominantLanguageDetectionJobsPages iterates over the pages of a ListDominantLanguageDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDominantLanguageDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDominantLanguageDetectionJobs operation.
//    pageNum := 0
//    err := client.ListDominantLanguageDetectionJobsPages(params,
//        func(page *ListDominantLanguageDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListDominantLanguageDetectionJobsPages(input *ListDominantLanguageDetectionJobsInput, fn func(*ListDominantLanguageDetectionJobsOutput, bool) bool) error {
	return c.ListDominantLanguageDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDominantLanguageDetectionJobsPagesWithContext same as ListDominantLanguageDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDominantLanguageDetectionJobsPagesWithContext(ctx aws.Context, input *ListDominantLanguageDetectionJobsInput, fn func(*ListDominantLanguageDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDominantLanguageDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDominantLanguageDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDominantLanguageDetectionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListEntitiesDetectionJobs = "ListEntitiesDetectionJobs"

// ListEntitiesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitiesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitiesDetectionJobs for more information on using the ListEntitiesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntitiesDetectionJobsRequest method.
//    req, resp := client.ListEntitiesDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Comprehend) ListEntitiesDetectionJobsRequest(input *ListEntitiesDetectionJobsInput) (req *request.Request, output *ListEntitiesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListEntitiesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesDetectionJobsInput{}
	}

	output = &ListEntitiesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitiesDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEntitiesDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the ListTopicDetectionJobs operation is invalid.
//   Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Comprehend) ListEntitiesDetectionJobs(input *ListEntitiesDetectionJobsInput) (*ListEntitiesDetectionJobsOutput, error) {
	req, out := c.ListEntitiesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListEntitiesDetectionJobsWithContext is the same as ListEntitiesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitiesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntitiesDetectionJobsWithContext(ctx aws.Context, input *ListEntitiesDetectionJobsInput, opts ...request.Option) (*ListEntitiesDetectionJobsOutput, error) {
	req, out := c.ListEntitiesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitiesDetectionJobsPages iterates over the pages of a ListEntitiesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntitiesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEntitiesDetectionJobs operation.
//    pageNum := 0
//    err := client.ListEntitiesDetectionJobsPages(params,
//        func(page *ListEntitiesDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListEntitiesDetectionJobsPages(input *ListEntitiesDetectionJobsInput, fn func(*ListEntitiesDetectionJobsOutput, bool) bool) error {
	return c.ListEntitiesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitiesDetectionJobsPagesWithContext same as ListEntitiesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntitiesDetectionJobsPagesWithContext(ctx aws.Context, input *ListEntitiesDetectionJobsInput, fn func(*ListEntitiesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitiesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitiesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEntitiesDetectionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListKeyPhrasesDetectionJobs = "ListKeyPhrasesDetectionJobs"

// ListKeyPhrasesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyPhrasesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeyPhrasesDetectionJobs for more information on using the ListKeyPhrasesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListKeyPhrasesDetectionJobsRequest method.
//    req, resp := client.ListKeyPhrasesDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Comprehend) ListKeyPhrasesDetectionJobsRequest(input *ListKeyPhrasesDetectionJobsInput) (req *request.Request, output *ListKeyPhrasesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListKeyPhrasesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeyPhrasesDetectionJobsInput{}
	}

	output = &ListKeyPhrasesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeyPhrasesDetectionJobs API operation for Amazon Comprehend.
//
// Get a list of key phrase detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListKeyPhrasesDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the ListTopicDetectionJobs operation is invalid.
//   Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Comprehend) ListKeyPhrasesDetectionJobs(input *ListKeyPhrasesDetectionJobsInput) (*ListKeyPhrasesDetectionJobsOutput, error) {
	req, out := c.ListKeyPhrasesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListKeyPhrasesDetectionJobsWithContext is the same as ListKeyPhrasesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeyPhrasesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListKeyPhrasesDetectionJobsWithContext(ctx aws.Context, input *ListKeyPhrasesDetectionJobsInput, opts ...request.Option) (*ListKeyPhrasesDetectionJobsOutput, error) {
	req, out := c.ListKeyPhrasesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeyPhrasesDetectionJobsPages iterates over the pages of a ListKeyPhrasesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeyPhrasesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKeyPhrasesDetectionJobs operation.
//    pageNum := 0
//    err := client.ListKeyPhrasesDetectionJobsPages(params,
//        func(page *ListKeyPhrasesDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListKeyPhrasesDetectionJobsPages(input *ListKeyPhrasesDetectionJobsInput, fn func(*ListKeyPhrasesDetectionJobsOutput, bool) bool) error {
	return c.ListKeyPhrasesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeyPhrasesDetectionJobsPagesWithContext same as ListKeyPhrasesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListKeyPhrasesDetectionJobsPagesWithContext(ctx aws.Context, input *ListKeyPhrasesDetectionJobsInput, fn func(*ListKeyPhrasesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeyPhrasesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeyPhrasesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListKeyPhrasesDetectionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListSentimentDetectionJobs = "ListSentimentDetectionJobs"

// ListSentimentDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSentimentDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSentimentDetectionJobs for more information on using the ListSentimentDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSentimentDetectionJobsRequest method.
//    req, resp := client.ListSentimentDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Comprehend) ListSentimentDetectionJobsRequest(input *ListSentimentDetectionJobsInput) (req *request.Request, output *ListSentimentDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListSentimentDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSentimentDetectionJobsInput{}
	}

	output = &ListSentimentDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSentimentDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of sentiment detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListSentimentDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the ListTopicDetectionJobs operation is invalid.
//   Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Comprehend) ListSentimentDetectionJobs(input *ListSentimentDetectionJobsInput) (*ListSentimentDetectionJobsOutput, error) {
	req, out := c.ListSentimentDetectionJobsRequest(input)
	return out, req.Send()
}

// ListSentimentDetectionJobsWithContext is the same as ListSentimentDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSentimentDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListSentimentDetectionJobsWithContext(ctx aws.Context, input *ListSentimentDetectionJobsInput, opts ...request.Option) (*ListSentimentDetectionJobsOutput, error) {
	req, out := c.ListSentimentDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSentimentDetectionJobsPages iterates over the pages of a ListSentimentDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSentimentDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSentimentDetectionJobs operation.
//    pageNum := 0
//    err := client.ListSentimentDetectionJobsPages(params,
//        func(page *ListSentimentDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListSentimentDetectionJobsPages(input *ListSentimentDetectionJobsInput, fn func(*ListSentimentDetectionJobsOutput, bool) bool) error {
	return c.ListSentimentDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSentimentDetectionJobsPagesWithContext same as ListSentimentDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListSentimentDetectionJobsPagesWithContext(ctx aws.Context, input *ListSentimentDetectionJobsInput, fn func(*ListSentimentDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSentimentDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSentimentDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSentimentDetectionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTopicsDetectionJobs = "ListTopicsDetectionJobs"

// ListTopicsDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicsDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicsDetectionJobs for more information on using the ListTopicsDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTopicsDetectionJobsRequest method.
//    req, resp := client.ListTopicsDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobsRequest(input *ListTopicsDetectionJobsInput) (req *request.Request, output *ListTopicsDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListTopicsDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsDetectionJobsInput{}
	}

	output = &ListTopicsDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicsDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the topic detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTopicsDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the ListTopicDetectionJobs operation is invalid.
//   Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobs(input *ListTopicsDetectionJobsInput) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	return out, req.Send()
}

// ListTopicsDetectionJobsWithContext is the same as ListTopicsDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicsDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, opts ...request.Option) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTopicsDetectionJobsPages iterates over the pages of a ListTopicsDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTopicsDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTopicsDetectionJobs operation.
//    pageNum := 0
//    err := client.ListTopicsDetectionJobsPages(params,
//        func(page *ListTopicsDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListTopicsDetectionJobsPages(input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool) error {
	return c.ListTopicsDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTopicsDetectionJobsPagesWithContext same as ListTopicsDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsPagesWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTopicsDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTopicsDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTopicsDetectionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartDominantLanguageDetectionJob = "StartDominantLanguageDetectionJob"

// StartDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDominantLanguageDetectionJob for more information on using the StartDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDominantLanguageDetectionJobRequest method.
//    req, resp := client.StartDominantLanguageDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob
func (c *Comprehend) StartDominantLanguageDetectionJobRequest(input *StartDominantLanguageDetectionJobInput) (req *request.Request, output *StartDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDominantLanguageDetectionJobInput{}
	}

	output = &StartDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous dominant language detection job for a collection of
// documents. Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob
func (c *Comprehend) StartDominantLanguageDetectionJob(input *StartDominantLanguageDetectionJobInput) (*StartDominantLanguageDetectionJobOutput, error) {
	req, out := c.StartDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// StartDominantLanguageDetectionJobWithContext is the same as StartDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartDominantLanguageDetectionJobWithContext(ctx aws.Context, input *StartDominantLanguageDetectionJobInput, opts ...request.Option) (*StartDominantLanguageDetectionJobOutput, error) {
	req, out := c.StartDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEntitiesDetectionJob = "StartEntitiesDetectionJob"

// StartEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEntitiesDetectionJob for more information on using the StartEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartEntitiesDetectionJobRequest method.
//    req, resp := client.StartEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob
func (c *Comprehend) StartEntitiesDetectionJobRequest(input *StartEntitiesDetectionJobInput) (req *request.Request, output *StartEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEntitiesDetectionJobInput{}
	}

	output = &StartEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous entity detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartEntitiesDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob
func (c *Comprehend) StartEntitiesDetectionJob(input *StartEntitiesDetectionJobInput) (*StartEntitiesDetectionJobOutput, error) {
	req, out := c.StartEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StartEntitiesDetectionJobWithContext is the same as StartEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartEntitiesDetectionJobWithContext(ctx aws.Context, input *StartEntitiesDetectionJobInput, opts ...request.Option) (*StartEntitiesDetectionJobOutput, error) {
	req, out := c.StartEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartKeyPhrasesDetectionJob = "StartKeyPhrasesDetectionJob"

// StartKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartKeyPhrasesDetectionJob for more information on using the StartKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartKeyPhrasesDetectionJobRequest method.
//    req, resp := client.StartKeyPhrasesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob
func (c *Comprehend) StartKeyPhrasesDetectionJobRequest(input *StartKeyPhrasesDetectionJobInput) (req *request.Request, output *StartKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartKeyPhrasesDetectionJobInput{}
	}

	output = &StartKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous key phrase detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob
func (c *Comprehend) StartKeyPhrasesDetectionJob(input *StartKeyPhrasesDetectionJobInput) (*StartKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StartKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// StartKeyPhrasesDetectionJobWithContext is the same as StartKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *StartKeyPhrasesDetectionJobInput, opts ...request.Option) (*StartKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StartKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSentimentDetectionJob = "StartSentimentDetectionJob"

// StartSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSentimentDetectionJob for more information on using the StartSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSentimentDetectionJobRequest method.
//    req, resp := client.StartSentimentDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob
func (c *Comprehend) StartSentimentDetectionJobRequest(input *StartSentimentDetectionJobInput) (req *request.Request, output *StartSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSentimentDetectionJobInput{}
	}

	output = &StartSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSentimentDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous sentiment detection job for a collection of documents.
// use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartSentimentDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob
func (c *Comprehend) StartSentimentDetectionJob(input *StartSentimentDetectionJobInput) (*StartSentimentDetectionJobOutput, error) {
	req, out := c.StartSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StartSentimentDetectionJobWithContext is the same as StartSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartSentimentDetectionJobWithContext(ctx aws.Context, input *StartSentimentDetectionJobInput, opts ...request.Option) (*StartSentimentDetectionJobOutput, error) {
	req, out := c.StartSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTopicsDetectionJob = "StartTopicsDetectionJob"

// StartTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTopicsDetectionJob for more information on using the StartTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTopicsDetectionJobRequest method.
//    req, resp := client.StartTopicsDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJobRequest(input *StartTopicsDetectionJobInput) (req *request.Request, output *StartTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTopicsDetectionJobInput{}
	}

	output = &StartTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTopicsDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous topic detection job. Use the DescribeTopicDetectionJob
// operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartTopicsDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJob(input *StartTopicsDetectionJobInput) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// StartTopicsDetectionJobWithContext is the same as StartTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartTopicsDetectionJobWithContext(ctx aws.Context, input *StartTopicsDetectionJobInput, opts ...request.Option) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDominantLanguageDetectionJob = "StopDominantLanguageDetectionJob"

// StopDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDominantLanguageDetectionJob for more information on using the StopDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDominantLanguageDetectionJobRequest method.
//    req, resp := client.StopDominantLanguageDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Comprehend) StopDominantLanguageDetectionJobRequest(input *StopDominantLanguageDetectionJobInput) (req *request.Request, output *StopDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDominantLanguageDetectionJobInput{}
	}

	output = &StopDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Stops a dominant language detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Comprehend) StopDominantLanguageDetectionJob(input *StopDominantLanguageDetectionJobInput) (*StopDominantLanguageDetectionJobOutput, error) {
	req, out := c.StopDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// StopDominantLanguageDetectionJobWithContext is the same as StopDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopDominantLanguageDetectionJobWithContext(ctx aws.Context, input *StopDominantLanguageDetectionJobInput, opts ...request.Option) (*StopDominantLanguageDetectionJobOutput, error) {
	req, out := c.StopDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEntitiesDetectionJob = "StopEntitiesDetectionJob"

// StopEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEntitiesDetectionJob for more information on using the StopEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopEntitiesDetectionJobRequest method.
//    req, resp := client.StopEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Comprehend) StopEntitiesDetectionJobRequest(input *StopEntitiesDetectionJobInput) (req *request.Request, output *StopEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEntitiesDetectionJobInput{}
	}

	output = &StopEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Stops an entities detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopEntitiesDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Comprehend) StopEntitiesDetectionJob(input *StopEntitiesDetectionJobInput) (*StopEntitiesDetectionJobOutput, error) {
	req, out := c.StopEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StopEntitiesDetectionJobWithContext is the same as StopEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopEntitiesDetectionJobWithContext(ctx aws.Context, input *StopEntitiesDetectionJobInput, opts ...request.Option) (*StopEntitiesDetectionJobOutput, error) {
	req, out := c.StopEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopKeyPhrasesDetectionJob = "StopKeyPhrasesDetectionJob"

// StopKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopKeyPhrasesDetectionJob for more information on using the StopKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopKeyPhrasesDetectionJobRequest method.
//    req, resp := client.StopKeyPhrasesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob
func (c *Comprehend) StopKeyPhrasesDetectionJobRequest(input *StopKeyPhrasesDetectionJobInput) (req *request.Request, output *StopKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopKeyPhrasesDetectionJobInput{}
	}

	output = &StopKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Stops a key phrases detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob
func (c *Comprehend) StopKeyPhrasesDetectionJob(input *StopKeyPhrasesDetectionJobInput) (*StopKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StopKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// StopKeyPhrasesDetectionJobWithContext is the same as StopKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *StopKeyPhrasesDetectionJobInput, opts ...request.Option) (*StopKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StopKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSentimentDetectionJob = "StopSentimentDetectionJob"

// StopSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSentimentDetectionJob for more information on using the StopSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopSentimentDetectionJobRequest method.
//    req, resp := client.StopSentimentDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob
func (c *Comprehend) StopSentimentDetectionJobRequest(input *StopSentimentDetectionJobInput) (req *request.Request, output *StopSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopSentimentDetectionJobInput{}
	}

	output = &StopSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopSentimentDetectionJob API operation for Amazon Comprehend.
//
// Stops a sentiment detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is be stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopSentimentDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob
func (c *Comprehend) StopSentimentDetectionJob(input *StopSentimentDetectionJobInput) (*StopSentimentDetectionJobOutput, error) {
	req, out := c.StopSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StopSentimentDetectionJobWithContext is the same as StopSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopSentimentDetectionJobWithContext(ctx aws.Context, input *StopSentimentDetectionJobInput, opts ...request.Option) (*StopSentimentDetectionJobOutput, error) {
	req, out := c.StopSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchDetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document should contain at least 20 characters
	// and must contain fewer than 5,000 bytes of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectDominantLanguageInput"}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectDominantLanguageInput) SetTextList(v []*string) *BatchDetectDominantLanguageInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectDominantLanguageItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more DominantLanguage objects describing the dominant languages in
	// the document.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectDominantLanguageItemResult) SetIndex(v int64) *BatchDetectDominantLanguageItemResult {
	s.Index = &v
	return s
}

// SetLanguages sets the Languages field's value.
func (s *BatchDetectDominantLanguageItemResult) SetLanguages(v []*DominantLanguage) *BatchDetectDominantLanguageItemResult {
	s.Languages = v
	return s
}

type BatchDetectDominantLanguageOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectDominantLanguageItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectDominantLanguageOutput) SetErrorList(v []*BatchItemError) *BatchDetectDominantLanguageOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectDominantLanguageOutput) SetResultList(v []*BatchDetectDominantLanguageItemResult) *BatchDetectDominantLanguageOutput {
	s.ResultList = v
	return s
}

type BatchDetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer than 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectEntitiesInput) SetLanguageCode(v string) *BatchDetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectEntitiesInput) SetTextList(v []*string) *BatchDetectEntitiesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectEntitiesItemResult struct {
	_ struct{} `type:"structure"`

	// One or more Entity objects, one for each entity detected in the document.
	Entities []*Entity `type:"list"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchDetectEntitiesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesItemResult) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *BatchDetectEntitiesItemResult) SetEntities(v []*Entity) *BatchDetectEntitiesItemResult {
	s.Entities = v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchDetectEntitiesItemResult) SetIndex(v int64) *BatchDetectEntitiesItemResult {
	s.Index = &v
	return s
}

type BatchDetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectEntitiesItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectEntitiesOutput) SetErrorList(v []*BatchItemError) *BatchDetectEntitiesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectEntitiesOutput) SetResultList(v []*BatchDetectEntitiesItemResult) *BatchDetectEntitiesOutput {
	s.ResultList = v
	return s
}

type BatchDetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectKeyPhrasesInput) SetLanguageCode(v string) *BatchDetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectKeyPhrasesInput) SetTextList(v []*string) *BatchDetectKeyPhrasesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectKeyPhrasesItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more KeyPhrase objects, one for each key phrase detected in the document.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetIndex(v int64) *BatchDetectKeyPhrasesItemResult {
	s.Index = &v
	return s
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetKeyPhrases(v []*KeyPhrase) *BatchDetectKeyPhrasesItemResult {
	s.KeyPhrases = v
	return s
}

type BatchDetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectKeyPhrasesItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetErrorList(v []*BatchItemError) *BatchDetectKeyPhrasesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetResultList(v []*BatchDetectKeyPhrasesItemResult) *BatchDetectKeyPhrasesOutput {
	s.ResultList = v
	return s
}

type BatchDetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSentimentInput) SetLanguageCode(v string) *BatchDetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSentimentInput) SetTextList(v []*string) *BatchDetectSentimentInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectSentimentItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The sentiment detected in the document.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// sentiment detection.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s BatchDetectSentimentItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSentimentItemResult) SetIndex(v int64) *BatchDetectSentimentItemResult {
	s.Index = &v
	return s
}

// SetSentiment sets the Sentiment field's value.
func (s *BatchDetectSentimentItemResult) SetSentiment(v string) *BatchDetectSentimentItemResult {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *BatchDetectSentimentItemResult) SetSentimentScore(v *SentimentScore) *BatchDetectSentimentItemResult {
	s.SentimentScore = v
	return s
}

type BatchDetectSentimentOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSentimentItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSentimentOutput) SetErrorList(v []*BatchItemError) *BatchDetectSentimentOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSentimentOutput) SetResultList(v []*BatchDetectSentimentItemResult) *BatchDetectSentimentOutput {
	s.ResultList = v
	return s
}

type BatchDetectSyntaxInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"SyntaxLanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSyntaxInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSyntaxInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSyntaxInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSyntaxInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSyntaxInput) SetLanguageCode(v string) *BatchDetectSyntaxInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSyntaxInput) SetTextList(v []*string) *BatchDetectSyntaxInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object that
// is successfully processed by the operation.
type BatchDetectSyntaxItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The syntax tokens for the words in the document, one token for each word.
	SyntaxTokens []*SyntaxToken `type:"list"`
}

// String returns the string representation
func (s BatchDetectSyntaxItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSyntaxItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSyntaxItemResult) SetIndex(v int64) *BatchDetectSyntaxItemResult {
	s.Index = &v
	return s
}

// SetSyntaxTokens sets the SyntaxTokens field's value.
func (s *BatchDetectSyntaxItemResult) SetSyntaxTokens(v []*SyntaxToken) *BatchDetectSyntaxItemResult {
	s.SyntaxTokens = v
	return s
}

type BatchDetectSyntaxOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSyntaxItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSyntaxOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSyntaxOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSyntaxOutput) SetErrorList(v []*BatchItemError) *BatchDetectSyntaxOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSyntaxOutput) SetResultList(v []*BatchDetectSyntaxItemResult) *BatchDetectSyntaxOutput {
	s.ResultList = v
	return s
}

// Describes an error that occurred while processing a document in a batch.
// The operation returns on BatchItemError object for each document that contained
// an error.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The numeric error code of the error.
	ErrorCode *string `min:"1" type:"string"`

	// A text description of the error.
	ErrorMessage *string `min:"1" type:"string"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchItemError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchItemError) SetErrorCode(v string) *BatchItemError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchItemError) SetErrorMessage(v string) *BatchItemError {
	s.ErrorMessage = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchItemError) SetIndex(v int64) *BatchItemError {
	s.Index = &v
	return s
}

type DescribeDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDominantLanguageDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDominantLanguageDetectionJobInput) SetJobId(v string) *DescribeDominantLanguageDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a dominant language
	// detection job.
	DominantLanguageDetectionJobProperties *DominantLanguageDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetDominantLanguageDetectionJobProperties sets the DominantLanguageDetectionJobProperties field's value.
func (s *DescribeDominantLanguageDetectionJobOutput) SetDominantLanguageDetectionJobProperties(v *DominantLanguageDetectionJobProperties) *DescribeDominantLanguageDetectionJobOutput {
	s.DominantLanguageDetectionJobProperties = v
	return s
}

type DescribeEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeEntitiesDetectionJobInput) SetJobId(v string) *DescribeEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with an entities detection
	// job.
	EntitiesDetectionJobProperties *EntitiesDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetEntitiesDetectionJobProperties sets the EntitiesDetectionJobProperties field's value.
func (s *DescribeEntitiesDetectionJobOutput) SetEntitiesDetectionJobProperties(v *EntitiesDetectionJobProperties) *DescribeEntitiesDetectionJobOutput {
	s.EntitiesDetectionJobProperties = v
	return s
}

type DescribeKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyPhrasesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeKeyPhrasesDetectionJobInput) SetJobId(v string) *DescribeKeyPhrasesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a key phrases detection
	// job.
	KeyPhrasesDetectionJobProperties *KeyPhrasesDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetKeyPhrasesDetectionJobProperties sets the KeyPhrasesDetectionJobProperties field's value.
func (s *DescribeKeyPhrasesDetectionJobOutput) SetKeyPhrasesDetectionJobProperties(v *KeyPhrasesDetectionJobProperties) *DescribeKeyPhrasesDetectionJobOutput {
	s.KeyPhrasesDetectionJobProperties = v
	return s
}

type DescribeSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeSentimentDetectionJobInput) SetJobId(v string) *DescribeSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a sentiment detection
	// job.
	SentimentDetectionJobProperties *SentimentDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetSentimentDetectionJobProperties sets the SentimentDetectionJobProperties field's value.
func (s *DescribeSentimentDetectionJobOutput) SetSentimentDetectionJobProperties(v *SentimentDetectionJobProperties) *DescribeSentimentDetectionJobOutput {
	s.SentimentDetectionJobProperties = v
	return s
}

type DescribeTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier assigned by the user to the detection job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicsDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTopicsDetectionJobInput) SetJobId(v string) *DescribeTopicsDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties for the requested job.
	TopicsDetectionJobProperties *TopicsDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetTopicsDetectionJobProperties sets the TopicsDetectionJobProperties field's value.
func (s *DescribeTopicsDetectionJobOutput) SetTopicsDetectionJobProperties(v *TopicsDetectionJobProperties) *DescribeTopicsDetectionJobOutput {
	s.TopicsDetectionJobProperties = v
	return s
}

type DetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string. Each string should contain at least 20 characters and
	// must contain fewer that 5,000 bytes of UTF-8 encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectDominantLanguageInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectDominantLanguageInput) SetText(v string) *DetectDominantLanguageInput {
	s.Text = &v
	return s
}

type DetectDominantLanguageOutput struct {
	_ struct{} `type:"structure"`

	// The languages that Amazon Comprehend detected in the input text. For each
	// language, the response returns the RFC 5646 language code and the level of
	// confidence that Amazon Comprehend has in the accuracy of its inference. For
	// more information about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation
func (s DetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetLanguages sets the Languages field's value.
func (s *DetectDominantLanguageOutput) SetLanguages(v []*DominantLanguage) *DetectDominantLanguageOutput {
	s.Languages = v
	return s
}

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectEntitiesInput) SetLanguageCode(v string) *DetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectEntitiesInput) SetText(v string) *DetectEntitiesInput {
	s.Text = &v
	return s
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of entities identified in the input text. For each entity, the
	// response provides the entity text, entity type, where the entity text begins
	// and ends, and the level of confidence that Amazon Comprehend has in the detection.
	// For a list of entity types, see how-entities.
	Entities []*Entity `type:"list"`
}

// String returns the string representation
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesOutput) SetEntities(v []*Entity) *DetectEntitiesOutput {
	s.Entities = v
	return s
}

type DetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectKeyPhrasesInput) SetLanguageCode(v string) *DetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectKeyPhrasesInput) SetText(v string) *DetectKeyPhrasesInput {
	s.Text = &v
	return s
}

type DetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of key phrases that Amazon Comprehend identified in the input
	// text. For each key phrase, the response provides the text of the key phrase,
	// where the key phrase begins and ends, and the level of confidence that Amazon
	// Comprehend has in the accuracy of the detection.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation
func (s DetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *DetectKeyPhrasesOutput) SetKeyPhrases(v []*KeyPhrase) *DetectKeyPhrasesOutput {
	s.KeyPhrases = v
	return s
}

type DetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSentimentInput) SetLanguageCode(v string) *DetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSentimentInput) SetText(v string) *DetectSentimentInput {
	s.Text = &v
	return s
}

type DetectSentimentOutput struct {
	_ struct{} `type:"structure"`

	// The inferred sentiment that Amazon Comprehend has the highest level of confidence
	// in.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// An object that lists the sentiments, and their corresponding confidence levels.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s DetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSentimentOutput) GoString() string {
	return s.String()
}

// SetSentiment sets the Sentiment field's value.
func (s *DetectSentimentOutput) SetSentiment(v string) *DetectSentimentOutput {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *DetectSentimentOutput) SetSentimentScore(v *SentimentScore) *DetectSentimentOutput {
	s.SentimentScore = v
	return s
}

type DetectSyntaxInput struct {
	_ struct{} `type:"structure"`

	// The language code of the input documents. You can specify English ("en")
	// or Spanish ("es").
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"SyntaxLanguageCode"`

	// A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
	// characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectSyntaxInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSyntaxInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSyntaxInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSyntaxInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSyntaxInput) SetLanguageCode(v string) *DetectSyntaxInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSyntaxInput) SetText(v string) *DetectSyntaxInput {
	s.Text = &v
	return s
}

type DetectSyntaxOutput struct {
	_ struct{} `type:"structure"`

	// A collection of syntax tokens describing the text. For each token, the response
	// provides the text, the token type, where the text begins and ends, and the
	// level of confidence that Amazon Comprehend has that the token is correct.
	// For a list of token types, see how-syntax.
	SyntaxTokens []*SyntaxToken `type:"list"`
}

// String returns the string representation
func (s DetectSyntaxOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSyntaxOutput) GoString() string {
	return s.String()
}

// SetSyntaxTokens sets the SyntaxTokens field's value.
func (s *DetectSyntaxOutput) SetSyntaxTokens(v []*SyntaxToken) *DetectSyntaxOutput {
	s.SyntaxTokens = v
	return s
}

// Returns the code for the dominant language in the input text and the level
// of confidence that Amazon Comprehend has in the accuracy of the detection.
type DominantLanguage struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the dominant language. For more information
	// about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	LanguageCode *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DominantLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguage) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DominantLanguage) SetLanguageCode(v string) *DominantLanguage {
	s.LanguageCode = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DominantLanguage) SetScore(v float64) *DominantLanguage {
	s.Score = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type DominantLanguageDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DominantLanguageDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguageDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DominantLanguageDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DominantLanguageDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *DominantLanguageDetectionJobFilter) SetJobName(v string) *DominantLanguageDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DominantLanguageDetectionJobFilter) SetJobStatus(v string) *DominantLanguageDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DominantLanguageDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *DominantLanguageDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DominantLanguageDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *DominantLanguageDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a dominant language detection job.
type DominantLanguageDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `type:"string"`

	// The time that the dominant language detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the dominant
	// language detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the dominant language detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the dominant language detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the dominant language detection job. If the status
	// is FAILED, the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the dominant
	// language detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the dominant language detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DominantLanguageDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguageDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DominantLanguageDetectionJobProperties) SetDataAccessRoleArn(v string) *DominantLanguageDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DominantLanguageDetectionJobProperties) SetEndTime(v time.Time) *DominantLanguageDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *DominantLanguageDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobId(v string) *DominantLanguageDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobName(v string) *DominantLanguageDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobStatus(v string) *DominantLanguageDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DominantLanguageDetectionJobProperties) SetMessage(v string) *DominantLanguageDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *DominantLanguageDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DominantLanguageDetectionJobProperties) SetSubmitTime(v time.Time) *DominantLanguageDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type EntitiesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EntitiesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntitiesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntitiesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntitiesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *EntitiesDetectionJobFilter) SetJobName(v string) *EntitiesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EntitiesDetectionJobFilter) SetJobStatus(v string) *EntitiesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *EntitiesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *EntitiesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *EntitiesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *EntitiesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about an entities detection job.
type EntitiesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `type:"string"`

	// The time that the entities detection job completed
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the entities
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the entities detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the entities detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the entities detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the entities
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the entities detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EntitiesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntitiesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EntitiesDetectionJobProperties) SetDataAccessRoleArn(v string) *EntitiesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *EntitiesDetectionJobProperties) SetEndTime(v time.Time) *EntitiesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *EntitiesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *EntitiesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *EntitiesDetectionJobProperties) SetJobId(v string) *EntitiesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *EntitiesDetectionJobProperties) SetJobName(v string) *EntitiesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EntitiesDetectionJobProperties) SetJobStatus(v string) *EntitiesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EntitiesDetectionJobProperties) SetLanguageCode(v string) *EntitiesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EntitiesDetectionJobProperties) SetMessage(v string) *EntitiesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *EntitiesDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *EntitiesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *EntitiesDetectionJobProperties) SetSubmitTime(v time.Time) *EntitiesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// Provides information about an entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the entity begins (the
	// first character is at position 0). The offset returns the position of each
	// UTF-8 code point in the string. A code point is the abstract character from
	// a particular graphical representation. For example, a multi-byte UTF-8 character
	// maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text that shows where the entity ends. The
	// offset returns the position of each UTF-8 code point in the string. A code
	// point is the abstract character from a particular graphical representation.
	// For example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of the entity.
	Text *string `min:"1" type:"string"`

	// The entity's type.
	Type *string `type:"string" enum:"EntityType"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entity) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Entity) SetBeginOffset(v int64) *Entity {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Entity) SetEndOffset(v int64) *Entity {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Entity) SetScore(v float64) *Entity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Entity) SetText(v string) *Entity {
	s.Text = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// The input properties for a topic detection job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// Specifies how the text in an input file should be processed:
	//
	//    * ONE_DOC_PER_FILE - Each file is considered a separate document. Use
	//    this option when you are processing large documents, such as newspaper
	//    articles or scientific papers.
	//
	//    * ONE_DOC_PER_LINE - Each line in a file is considered a separate document.
	//    Use this option when you are processing many short documents, such as
	//    text messages.
	InputFormat *string `type:"string" enum:"InputFormat"`

	// The Amazon S3 URI for the input data. The URI must be in same region as the
	// API endpoint that you are calling. The URI can point to a single input file
	// or it can provide the prefix for a collection of data files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputFormat sets the InputFormat field's value.
func (s *InputDataConfig) SetInputFormat(v string) *InputDataConfig {
	s.InputFormat = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// Describes a key noun phrase.
type KeyPhrase struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the key phrase begins
	// (the first character is at position 0). The offset returns the position of
	// each UTF-8 code point in the string. A code point is the abstract character
	// from a particular graphical representation. For example, a multi-byte UTF-8
	// character maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text where the key phrase ends. The offset
	// returns the position of each UTF-8 code point in the string. A code point
	// is the abstract character from a particular graphical representation. For
	// example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of a key noun phrase.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPhrase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrase) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *KeyPhrase) SetBeginOffset(v int64) *KeyPhrase {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *KeyPhrase) SetEndOffset(v int64) *KeyPhrase {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *KeyPhrase) SetScore(v float64) *KeyPhrase {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *KeyPhrase) SetText(v string) *KeyPhrase {
	s.Text = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type KeyPhrasesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s KeyPhrasesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrasesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyPhrasesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyPhrasesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *KeyPhrasesDetectionJobFilter) SetJobName(v string) *KeyPhrasesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *KeyPhrasesDetectionJobFilter) SetJobStatus(v string) *KeyPhrasesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *KeyPhrasesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *KeyPhrasesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *KeyPhrasesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *KeyPhrasesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a key phrases detection job.
type KeyPhrasesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `type:"string"`

	// The time that the key phrases detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the key phrases
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the key phrases detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the key phrases detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the key phrases detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the key
	// phrases detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the key phrases detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s KeyPhrasesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrasesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *KeyPhrasesDetectionJobProperties) SetDataAccessRoleArn(v string) *KeyPhrasesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *KeyPhrasesDetectionJobProperties) SetEndTime(v time.Time) *KeyPhrasesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *KeyPhrasesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobId(v string) *KeyPhrasesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobName(v string) *KeyPhrasesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobStatus(v string) *KeyPhrasesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *KeyPhrasesDetectionJobProperties) SetLanguageCode(v string) *KeyPhrasesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *KeyPhrasesDetectionJobProperties) SetMessage(v string) *KeyPhrasesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *KeyPhrasesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *KeyPhrasesDetectionJobProperties) SetSubmitTime(v time.Time) *KeyPhrasesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

type ListDominantLanguageDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters that jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DominantLanguageDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDominantLanguageDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDominantLanguageDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDominantLanguageDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDominantLanguageDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetFilter(v *DominantLanguageDetectionJobFilter) *ListDominantLanguageDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetMaxResults(v int64) *ListDominantLanguageDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetNextToken(v string) *ListDominantLanguageDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListDominantLanguageDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	DominantLanguageDetectionJobPropertiesList []*DominantLanguageDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDominantLanguageDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDominantLanguageDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetDominantLanguageDetectionJobPropertiesList sets the DominantLanguageDetectionJobPropertiesList field's value.
func (s *ListDominantLanguageDetectionJobsOutput) SetDominantLanguageDetectionJobPropertiesList(v []*DominantLanguageDetectionJobProperties) *ListDominantLanguageDetectionJobsOutput {
	s.DominantLanguageDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDominantLanguageDetectionJobsOutput) SetNextToken(v string) *ListDominantLanguageDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *EntitiesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntitiesDetectionJobsInput) SetFilter(v *EntitiesDetectionJobFilter) *ListEntitiesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesDetectionJobsInput) SetMaxResults(v int64) *ListEntitiesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionJobsInput) SetNextToken(v string) *ListEntitiesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	EntitiesDetectionJobPropertiesList []*EntitiesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetEntitiesDetectionJobPropertiesList sets the EntitiesDetectionJobPropertiesList field's value.
func (s *ListEntitiesDetectionJobsOutput) SetEntitiesDetectionJobPropertiesList(v []*EntitiesDetectionJobProperties) *ListEntitiesDetectionJobsOutput {
	s.EntitiesDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionJobsOutput) SetNextToken(v string) *ListEntitiesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListKeyPhrasesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *KeyPhrasesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPhrasesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPhrasesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyPhrasesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeyPhrasesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetFilter(v *KeyPhrasesDetectionJobFilter) *ListKeyPhrasesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetMaxResults(v int64) *ListKeyPhrasesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetNextToken(v string) *ListKeyPhrasesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListKeyPhrasesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	KeyPhrasesDetectionJobPropertiesList []*KeyPhrasesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPhrasesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPhrasesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetKeyPhrasesDetectionJobPropertiesList sets the KeyPhrasesDetectionJobPropertiesList field's value.
func (s *ListKeyPhrasesDetectionJobsOutput) SetKeyPhrasesDetectionJobPropertiesList(v []*KeyPhrasesDetectionJobProperties) *ListKeyPhrasesDetectionJobsOutput {
	s.KeyPhrasesDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyPhrasesDetectionJobsOutput) SetNextToken(v string) *ListKeyPhrasesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListSentimentDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *SentimentDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSentimentDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSentimentDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSentimentDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSentimentDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSentimentDetectionJobsInput) SetFilter(v *SentimentDetectionJobFilter) *ListSentimentDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSentimentDetectionJobsInput) SetMaxResults(v int64) *ListSentimentDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSentimentDetectionJobsInput) SetNextToken(v string) *ListSentimentDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListSentimentDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	SentimentDetectionJobPropertiesList []*SentimentDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListSentimentDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSentimentDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSentimentDetectionJobsOutput) SetNextToken(v string) *ListSentimentDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetSentimentDetectionJobPropertiesList sets the SentimentDetectionJobPropertiesList field's value.
func (s *ListSentimentDetectionJobsOutput) SetSentimentDetectionJobPropertiesList(v []*SentimentDetectionJobProperties) *ListSentimentDetectionJobsOutput {
	s.SentimentDetectionJobPropertiesList = v
	return s
}

type ListTopicsDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. Jobs can be filtered on their name, status,
	// or the date and time that they were submitted. You can set only one filter
	// at a time.
	Filter *TopicsDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTopicsDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTopicsDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTopicsDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTopicsDetectionJobsInput) SetFilter(v *TopicsDetectionJobFilter) *ListTopicsDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTopicsDetectionJobsInput) SetMaxResults(v int64) *ListTopicsDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsInput) SetNextToken(v string) *ListTopicsDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListTopicsDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	TopicsDetectionJobPropertiesList []*TopicsDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListTopicsDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsOutput) SetNextToken(v string) *ListTopicsDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetTopicsDetectionJobPropertiesList sets the TopicsDetectionJobPropertiesList field's value.
func (s *ListTopicsDetectionJobsOutput) SetTopicsDetectionJobPropertiesList(v []*TopicsDetectionJobProperties) *ListTopicsDetectionJobsOutput {
	s.TopicsDetectionJobPropertiesList = v
	return s
}

// Provides configuration parameters for the output of topic detection jobs.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output
	// file.
	//
	// When the topic detection job is finished, the service creates an output file
	// in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the ouput of the operation.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// Identifies the part of speech represented by the token and gives the confidence
// that Amazon Comprehend has that the part of speech was correctly identified.
// For more information about the parts of speech that Amazon Comprehend can
// identify, see how-syntax.
type PartOfSpeechTag struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Comprehend has that the part of speech was correctly
	// identified.
	Score *float64 `type:"float"`

	// Identifies the part of speech that the token represents.
	Tag *string `type:"string" enum:"PartOfSpeechTagType"`
}

// String returns the string representation
func (s PartOfSpeechTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartOfSpeechTag) GoString() string {
	return s.String()
}

// SetScore sets the Score field's value.
func (s *PartOfSpeechTag) SetScore(v float64) *PartOfSpeechTag {
	s.Score = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *PartOfSpeechTag) SetTag(v string) *PartOfSpeechTag {
	s.Tag = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type SentimentDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SentimentDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SentimentDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SentimentDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *SentimentDetectionJobFilter) SetJobName(v string) *SentimentDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SentimentDetectionJobFilter) SetJobStatus(v string) *SentimentDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *SentimentDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *SentimentDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *SentimentDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *SentimentDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a sentiment detection job.
type SentimentDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `type:"string"`

	// The time that the sentiment detection job ended.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the sentiment
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the sentiment detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the sentiment detection job
	JobName *string `min:"1" type:"string"`

	// The current status of the sentiment detection job. If the status is FAILED,
	// the Messages field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the sentiment
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the sentiment detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SentimentDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *SentimentDetectionJobProperties) SetDataAccessRoleArn(v string) *SentimentDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SentimentDetectionJobProperties) SetEndTime(v time.Time) *SentimentDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *SentimentDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *SentimentDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SentimentDetectionJobProperties) SetJobId(v string) *SentimentDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SentimentDetectionJobProperties) SetJobName(v string) *SentimentDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SentimentDetectionJobProperties) SetJobStatus(v string) *SentimentDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *SentimentDetectionJobProperties) SetLanguageCode(v string) *SentimentDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *SentimentDetectionJobProperties) SetMessage(v string) *SentimentDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *SentimentDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *SentimentDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *SentimentDetectionJobProperties) SetSubmitTime(v time.Time) *SentimentDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// Describes the level of confidence that Amazon Comprehend has in the accuracy
// of its detection of sentiments.
type SentimentScore struct {
	_ struct{} `type:"structure"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float64 `type:"float"`
}

// String returns the string representation
func (s SentimentScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentScore) GoString() string {
	return s.String()
}

// SetMixed sets the Mixed field's value.
func (s *SentimentScore) SetMixed(v float64) *SentimentScore {
	s.Mixed = &v
	return s
}

// SetNegative sets the Negative field's value.
func (s *SentimentScore) SetNegative(v float64) *SentimentScore {
	s.Negative = &v
	return s
}

// SetNeutral sets the Neutral field's value.
func (s *SentimentScore) SetNeutral(v float64) *SentimentScore {
	s.Neutral = &v
	return s
}

// SetPositive sets the Positive field's value.
func (s *SentimentScore) SetPositive(v float64) *SentimentScore {
	s.Positive = &v
	return s
}

type StartDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// An identifier for the job.
	JobName *string `min:"1" type:"string"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDominantLanguageDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDominantLanguageDetectionJobInput) SetClientRequestToken(v string) *StartDominantLanguageDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartDominantLanguageDetectionJobInput) SetDataAccessRoleArn(v string) *StartDominantLanguageDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartDominantLanguageDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartDominantLanguageDetectionJobInput) SetJobName(v string) *StartDominantLanguageDetectionJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartDominantLanguageDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobId(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobStatus(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEntitiesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartEntitiesDetectionJobInput) SetClientRequestToken(v string) *StartEntitiesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartEntitiesDetectionJobInput) SetDataAccessRoleArn(v string) *StartEntitiesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartEntitiesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartEntitiesDetectionJobInput) SetJobName(v string) *StartEntitiesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartEntitiesDetectionJobInput) SetLanguageCode(v string) *StartEntitiesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartEntitiesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobId(v string) *StartEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobStatus(v string) *StartEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartKeyPhrasesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetClientRequestToken(v string) *StartKeyPhrasesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetDataAccessRoleArn(v string) *StartKeyPhrasesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartKeyPhrasesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetJobName(v string) *StartKeyPhrasesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetLanguageCode(v string) *StartKeyPhrasesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartKeyPhrasesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobId(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobStatus(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify English ("en") or Spanish
	// ("es"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSentimentDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSentimentDetectionJobInput) SetClientRequestToken(v string) *StartSentimentDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartSentimentDetectionJobInput) SetDataAccessRoleArn(v string) *StartSentimentDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartSentimentDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartSentimentDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartSentimentDetectionJobInput) SetJobName(v string) *StartSentimentDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartSentimentDetectionJobInput) SetLanguageCode(v string) *StartSentimentDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartSentimentDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartSentimentDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartSentimentDetectionJobOutput) SetJobId(v string) *StartSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartSentimentDetectionJobOutput) SetJobStatus(v string) *StartSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The number of topics to detect.
	NumberOfTopics *int64 `min:"1" type:"integer"`

	// Specifies where to send the output files. The output is a compressed archive
	// with two files, topic-terms.csv that lists the terms associated with each
	// topic, and doc-topics.csv that lists the documents associated with each topic
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTopicsDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.NumberOfTopics != nil && *s.NumberOfTopics < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfTopics", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTopicsDetectionJobInput) SetClientRequestToken(v string) *StartTopicsDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTopicsDetectionJobInput) SetDataAccessRoleArn(v string) *StartTopicsDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartTopicsDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTopicsDetectionJobInput) SetJobName(v string) *StartTopicsDetectionJobInput {
	s.JobName = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *StartTopicsDetectionJobInput) SetNumberOfTopics(v int64) *StartTopicsDetectionJobInput {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTopicsDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the DescribeTopicDetectionJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job:
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTopicDetectionJob
	//    operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTopicsDetectionJobOutput) SetJobId(v string) *StartTopicsDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTopicsDetectionJobOutput) SetJobStatus(v string) *StartTopicsDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDominantLanguageDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopDominantLanguageDetectionJobInput) SetJobId(v string) *StopDominantLanguageDetectionJobInput {
	s.JobId = &v
	return s
}

type StopDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopDominantLanguageDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopDominantLanguageDetectionJobOutput) SetJobId(v string) *StopDominantLanguageDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopDominantLanguageDetectionJobOutput) SetJobStatus(v string) *StopDominantLanguageDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionJobInput) SetJobId(v string) *StopEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopEntitiesDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionJobOutput) SetJobId(v string) *StopEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopEntitiesDetectionJobOutput) SetJobStatus(v string) *StopEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the key phrases detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopKeyPhrasesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopKeyPhrasesDetectionJobInput) SetJobId(v string) *StopKeyPhrasesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the key phrases detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopKeyPhrasesDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopKeyPhrasesDetectionJobOutput) SetJobId(v string) *StopKeyPhrasesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopKeyPhrasesDetectionJobOutput) SetJobStatus(v string) *StopKeyPhrasesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the sentiment detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopSentimentDetectionJobInput) SetJobId(v string) *StopSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type StopSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the sentiment detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopSentimentDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopSentimentDetectionJobOutput) SetJobId(v string) *StopSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopSentimentDetectionJobOutput) SetJobStatus(v string) *StopSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

// Represents a work in the input text that was recognized and assigned a part
// of speech. There is one syntax token record for each word in the source text.
type SyntaxToken struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the word.
	BeginOffset *int64 `type:"integer"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the word.
	EndOffset *int64 `type:"integer"`

	// Provides the part of speech label and the confidence level that Amazon Comprehend
	// has that the part of speech was correctly identified. For more information,
	// see how-syntax.
	PartOfSpeech *PartOfSpeechTag `type:"structure"`

	// The word that was recognized in the source text.
	Text *string `min:"1" type:"string"`

	// A unique identifier for a token.
	TokenId *int64 `type:"integer"`
}

// String returns the string representation
func (s SyntaxToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SyntaxToken) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *SyntaxToken) SetBeginOffset(v int64) *SyntaxToken {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *SyntaxToken) SetEndOffset(v int64) *SyntaxToken {
	s.EndOffset = &v
	return s
}

// SetPartOfSpeech sets the PartOfSpeech field's value.
func (s *SyntaxToken) SetPartOfSpeech(v *PartOfSpeechTag) *SyntaxToken {
	s.PartOfSpeech = v
	return s
}

// SetText sets the Text field's value.
func (s *SyntaxToken) SetText(v string) *SyntaxToken {
	s.Text = &v
	return s
}

// SetTokenId sets the TokenId field's value.
func (s *SyntaxToken) SetTokenId(v int64) *SyntaxToken {
	s.TokenId = &v
	return s
}

// Provides information for filtering topic detection jobs. For more information,
// see .
type TopicsDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	JobName *string `min:"1" type:"string"`

	// Filters the list of topic detection jobs based on job status. Returns only
	// jobs with the specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TopicsDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicsDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicsDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *TopicsDetectionJobFilter) SetJobName(v string) *TopicsDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TopicsDetectionJobFilter) SetJobStatus(v string) *TopicsDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *TopicsDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *TopicsDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *TopicsDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *TopicsDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a topic detection job.
type TopicsDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The time that the topic detection job was completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration supplied when you created the topic detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the topic detection job.
	JobId *string `min:"1" type:"string"`

	// The name of the topic detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the topic detection job. If the status is Failed, the
	// reason for the failure is shown in the Message field.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The number of topics to detect supplied when you created the topic detection
	// job. The default is 10.
	NumberOfTopics *int64 `type:"integer"`

	// The output data configuration supplied when you created the topic detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the topic detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TopicsDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsDetectionJobProperties) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TopicsDetectionJobProperties) SetEndTime(v time.Time) *TopicsDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *TopicsDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *TopicsDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *TopicsDetectionJobProperties) SetJobId(v string) *TopicsDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *TopicsDetectionJobProperties) SetJobName(v string) *TopicsDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TopicsDetectionJobProperties) SetJobStatus(v string) *TopicsDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TopicsDetectionJobProperties) SetMessage(v string) *TopicsDetectionJobProperties {
	s.Message = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *TopicsDetectionJobProperties) SetNumberOfTopics(v int64) *TopicsDetectionJobProperties {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *TopicsDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *TopicsDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *TopicsDetectionJobProperties) SetSubmitTime(v time.Time) *TopicsDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

const (
	// EntityTypePerson is a EntityType enum value
	EntityTypePerson = "PERSON"

	// EntityTypeLocation is a EntityType enum value
	EntityTypeLocation = "LOCATION"

	// EntityTypeOrganization is a EntityType enum value
	EntityTypeOrganization = "ORGANIZATION"

	// EntityTypeCommercialItem is a EntityType enum value
	EntityTypeCommercialItem = "COMMERCIAL_ITEM"

	// EntityTypeEvent is a EntityType enum value
	EntityTypeEvent = "EVENT"

	// EntityTypeDate is a EntityType enum value
	EntityTypeDate = "DATE"

	// EntityTypeQuantity is a EntityType enum value
	EntityTypeQuantity = "QUANTITY"

	// EntityTypeTitle is a EntityType enum value
	EntityTypeTitle = "TITLE"

	// EntityTypeOther is a EntityType enum value
	EntityTypeOther = "OTHER"
)

const (
	// InputFormatOneDocPerFile is a InputFormat enum value
	InputFormatOneDocPerFile = "ONE_DOC_PER_FILE"

	// InputFormatOneDocPerLine is a InputFormat enum value
	InputFormatOneDocPerLine = "ONE_DOC_PER_LINE"
)

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusStopRequested is a JobStatus enum value
	JobStatusStopRequested = "STOP_REQUESTED"

	// JobStatusStopped is a JobStatus enum value
	JobStatusStopped = "STOPPED"
)

const (
	// LanguageCodeEn is a LanguageCode enum value
	LanguageCodeEn = "en"

	// LanguageCodeEs is a LanguageCode enum value
	LanguageCodeEs = "es"
)

const (
	// PartOfSpeechTagTypeAdj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAdj = "ADJ"

	// PartOfSpeechTagTypeAdp is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAdp = "ADP"

	// PartOfSpeechTagTypeAdv is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAdv = "ADV"

	// PartOfSpeechTagTypeAux is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAux = "AUX"

	// PartOfSpeechTagTypeConj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeConj = "CONJ"

	// PartOfSpeechTagTypeDet is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeDet = "DET"

	// PartOfSpeechTagTypeIntj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeIntj = "INTJ"

	// PartOfSpeechTagTypeNoun is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeNoun = "NOUN"

	// PartOfSpeechTagTypeNum is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeNum = "NUM"

	// PartOfSpeechTagTypeO is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeO = "O"

	// PartOfSpeechTagTypePart is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePart = "PART"

	// PartOfSpeechTagTypePron is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePron = "PRON"

	// PartOfSpeechTagTypePropn is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePropn = "PROPN"

	// PartOfSpeechTagTypePunct is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePunct = "PUNCT"

	// PartOfSpeechTagTypeSconj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeSconj = "SCONJ"

	// PartOfSpeechTagTypeSym is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeSym = "SYM"

	// PartOfSpeechTagTypeVerb is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeVerb = "VERB"
)

const (
	// SentimentTypePositive is a SentimentType enum value
	SentimentTypePositive = "POSITIVE"

	// SentimentTypeNegative is a SentimentType enum value
	SentimentTypeNegative = "NEGATIVE"

	// SentimentTypeNeutral is a SentimentType enum value
	SentimentTypeNeutral = "NEUTRAL"

	// SentimentTypeMixed is a SentimentType enum value
	SentimentTypeMixed = "MIXED"
)

const (
	// SyntaxLanguageCodeEn is a SyntaxLanguageCode enum value
	SyntaxLanguageCodeEn = "en"
)
