// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/data_labeling_service.proto

package datalabeling

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Image labeling task feature.
type LabelImageRequest_Feature int32

const (
	LabelImageRequest_FEATURE_UNSPECIFIED LabelImageRequest_Feature = 0
	// Label whole image with one or more of labels.
	LabelImageRequest_CLASSIFICATION LabelImageRequest_Feature = 1
	// Label image with bounding boxes for labels.
	LabelImageRequest_BOUNDING_BOX LabelImageRequest_Feature = 2
	// Label oriented bounding box. The box does not have to be parallel to
	// horizontal line.
	LabelImageRequest_ORIENTED_BOUNDING_BOX LabelImageRequest_Feature = 6
	// Label images with bounding poly. A bounding poly is a plane figure that
	// is bounded by a finite chain of straight line segments closing in a loop.
	LabelImageRequest_BOUNDING_POLY LabelImageRequest_Feature = 3
	// Label images with polyline. Polyline is formed by connected line segments
	// which are not in closed form.
	LabelImageRequest_POLYLINE LabelImageRequest_Feature = 4
	// Label images with segmentation. Segmentation is different from bounding
	// poly since it is more fine-grained, pixel level annotation.
	LabelImageRequest_SEGMENTATION LabelImageRequest_Feature = 5
)

var LabelImageRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "CLASSIFICATION",
	2: "BOUNDING_BOX",
	6: "ORIENTED_BOUNDING_BOX",
	3: "BOUNDING_POLY",
	4: "POLYLINE",
	5: "SEGMENTATION",
}

var LabelImageRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":   0,
	"CLASSIFICATION":        1,
	"BOUNDING_BOX":          2,
	"ORIENTED_BOUNDING_BOX": 6,
	"BOUNDING_POLY":         3,
	"POLYLINE":              4,
	"SEGMENTATION":          5,
}

func (x LabelImageRequest_Feature) String() string {
	return proto.EnumName(LabelImageRequest_Feature_name, int32(x))
}

func (LabelImageRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{14, 0}
}

// Video labeling task feature.
type LabelVideoRequest_Feature int32

const (
	LabelVideoRequest_FEATURE_UNSPECIFIED LabelVideoRequest_Feature = 0
	// Label whole video or video segment with one or more labels.
	LabelVideoRequest_CLASSIFICATION LabelVideoRequest_Feature = 1
	// Label objects with bounding box on image frames extracted from the video.
	LabelVideoRequest_OBJECT_DETECTION LabelVideoRequest_Feature = 2
	// Label and track objects in video.
	LabelVideoRequest_OBJECT_TRACKING LabelVideoRequest_Feature = 3
	// Label the range of video for the specified events.
	LabelVideoRequest_EVENT LabelVideoRequest_Feature = 4
)

var LabelVideoRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "CLASSIFICATION",
	2: "OBJECT_DETECTION",
	3: "OBJECT_TRACKING",
	4: "EVENT",
}

var LabelVideoRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED": 0,
	"CLASSIFICATION":      1,
	"OBJECT_DETECTION":    2,
	"OBJECT_TRACKING":     3,
	"EVENT":               4,
}

func (x LabelVideoRequest_Feature) String() string {
	return proto.EnumName(LabelVideoRequest_Feature_name, int32(x))
}

func (LabelVideoRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{15, 0}
}

// Text labeling task feature.
type LabelTextRequest_Feature int32

const (
	LabelTextRequest_FEATURE_UNSPECIFIED LabelTextRequest_Feature = 0
	// Label text content to one of more labels.
	LabelTextRequest_TEXT_CLASSIFICATION LabelTextRequest_Feature = 1
	// Label entities and their span in text.
	LabelTextRequest_TEXT_ENTITY_EXTRACTION LabelTextRequest_Feature = 2
)

var LabelTextRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "TEXT_CLASSIFICATION",
	2: "TEXT_ENTITY_EXTRACTION",
}

var LabelTextRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":    0,
	"TEXT_CLASSIFICATION":    1,
	"TEXT_ENTITY_EXTRACTION": 2,
}

func (x LabelTextRequest_Feature) String() string {
	return proto.EnumName(LabelTextRequest_Feature_name, int32(x))
}

func (LabelTextRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{16, 0}
}

// Request message for CreateDataset.
type CreateDatasetRequest struct {
	// Required. Dataset resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The dataset to be created.
	Dataset              *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatasetRequest) Reset()         { *m = CreateDatasetRequest{} }
func (m *CreateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatasetRequest) ProtoMessage()    {}
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{0}
}

func (m *CreateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatasetRequest.Unmarshal(m, b)
}
func (m *CreateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *CreateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatasetRequest.Merge(m, src)
}
func (m *CreateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatasetRequest.Size(m)
}
func (m *CreateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatasetRequest proto.InternalMessageInfo

func (m *CreateDatasetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

// Request message for GetDataSet.
type GetDatasetRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatasetRequest) Reset()         { *m = GetDatasetRequest{} }
func (m *GetDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatasetRequest) ProtoMessage()    {}
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{1}
}

func (m *GetDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatasetRequest.Unmarshal(m, b)
}
func (m *GetDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatasetRequest.Marshal(b, m, deterministic)
}
func (m *GetDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatasetRequest.Merge(m, src)
}
func (m *GetDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatasetRequest.Size(m)
}
func (m *GetDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatasetRequest proto.InternalMessageInfo

func (m *GetDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListDataset.
type ListDatasetsRequest struct {
	// Required. Dataset resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter on dataset is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListDatasetsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListDatasetsResponse.next_page_token]
	// of the previous [DataLabelingService.ListDatasets] call. Returns the first
	// page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsRequest) Reset()         { *m = ListDatasetsRequest{} }
func (m *ListDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsRequest) ProtoMessage()    {}
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{2}
}

func (m *ListDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsRequest.Unmarshal(m, b)
}
func (m *ListDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsRequest.Marshal(b, m, deterministic)
}
func (m *ListDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsRequest.Merge(m, src)
}
func (m *ListDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsRequest.Size(m)
}
func (m *ListDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsRequest proto.InternalMessageInfo

func (m *ListDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing datasets within a project.
type ListDatasetsResponse struct {
	// The list of datasets to return.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsResponse) Reset()         { *m = ListDatasetsResponse{} }
func (m *ListDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsResponse) ProtoMessage()    {}
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{3}
}

func (m *ListDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsResponse.Unmarshal(m, b)
}
func (m *ListDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsResponse.Marshal(b, m, deterministic)
}
func (m *ListDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsResponse.Merge(m, src)
}
func (m *ListDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsResponse.Size(m)
}
func (m *ListDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsResponse proto.InternalMessageInfo

func (m *ListDatasetsResponse) GetDatasets() []*Dataset {
	if m != nil {
		return m.Datasets
	}
	return nil
}

func (m *ListDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteDataset.
type DeleteDatasetRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatasetRequest) Reset()         { *m = DeleteDatasetRequest{} }
func (m *DeleteDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatasetRequest) ProtoMessage()    {}
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{4}
}

func (m *DeleteDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatasetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatasetRequest.Merge(m, src)
}
func (m *DeleteDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatasetRequest.Size(m)
}
func (m *DeleteDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatasetRequest proto.InternalMessageInfo

func (m *DeleteDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ImportData API.
type ImportDataRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify the input source of the data.
	InputConfig *InputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Email of the user who started the import task and should be notified by
	// email. If empty no notification will be sent.
	UserEmailAddress     string   `protobuf:"bytes,3,opt,name=user_email_address,json=userEmailAddress,proto3" json:"user_email_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDataRequest) Reset()         { *m = ImportDataRequest{} }
func (m *ImportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDataRequest) ProtoMessage()    {}
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{5}
}

func (m *ImportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataRequest.Unmarshal(m, b)
}
func (m *ImportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataRequest.Marshal(b, m, deterministic)
}
func (m *ImportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataRequest.Merge(m, src)
}
func (m *ImportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDataRequest.Size(m)
}
func (m *ImportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataRequest proto.InternalMessageInfo

func (m *ImportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDataRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *ImportDataRequest) GetUserEmailAddress() string {
	if m != nil {
		return m.UserEmailAddress
	}
	return ""
}

// Request message for ExportData API.
type ExportDataRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Annotated dataset resource name. DataItem in
	// Dataset and their annotations in specified annotated dataset will be
	// exported. It's in format of
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	AnnotatedDataset string `protobuf:"bytes,2,opt,name=annotated_dataset,json=annotatedDataset,proto3" json:"annotated_dataset,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Specify the output destination.
	OutputConfig *OutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Email of the user who started the export task and should be notified by
	// email. If empty no notification will be sent.
	UserEmailAddress     string   `protobuf:"bytes,5,opt,name=user_email_address,json=userEmailAddress,proto3" json:"user_email_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportDataRequest) Reset()         { *m = ExportDataRequest{} }
func (m *ExportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDataRequest) ProtoMessage()    {}
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{6}
}

func (m *ExportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataRequest.Unmarshal(m, b)
}
func (m *ExportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataRequest.Marshal(b, m, deterministic)
}
func (m *ExportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataRequest.Merge(m, src)
}
func (m *ExportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDataRequest.Size(m)
}
func (m *ExportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataRequest proto.InternalMessageInfo

func (m *ExportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDataRequest) GetAnnotatedDataset() string {
	if m != nil {
		return m.AnnotatedDataset
	}
	return ""
}

func (m *ExportDataRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ExportDataRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *ExportDataRequest) GetUserEmailAddress() string {
	if m != nil {
		return m.UserEmailAddress
	}
	return ""
}

// Request message for GetDataItem.
type GetDataItemRequest struct {
	// Required. The name of the data item to get, format:
	// projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDataItemRequest) Reset()         { *m = GetDataItemRequest{} }
func (m *GetDataItemRequest) String() string { return proto.CompactTextString(m) }
func (*GetDataItemRequest) ProtoMessage()    {}
func (*GetDataItemRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{7}
}

func (m *GetDataItemRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDataItemRequest.Unmarshal(m, b)
}
func (m *GetDataItemRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDataItemRequest.Marshal(b, m, deterministic)
}
func (m *GetDataItemRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDataItemRequest.Merge(m, src)
}
func (m *GetDataItemRequest) XXX_Size() int {
	return xxx_messageInfo_GetDataItemRequest.Size(m)
}
func (m *GetDataItemRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDataItemRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDataItemRequest proto.InternalMessageInfo

func (m *GetDataItemRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListDataItems.
type ListDataItemsRequest struct {
	// Required. Name of the dataset to list data items, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListDataItemsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListDataItemsResponse.next_page_token]
	// of the previous [DataLabelingService.ListDataItems] call. Return first page
	// if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataItemsRequest) Reset()         { *m = ListDataItemsRequest{} }
func (m *ListDataItemsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDataItemsRequest) ProtoMessage()    {}
func (*ListDataItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{8}
}

func (m *ListDataItemsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataItemsRequest.Unmarshal(m, b)
}
func (m *ListDataItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataItemsRequest.Marshal(b, m, deterministic)
}
func (m *ListDataItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataItemsRequest.Merge(m, src)
}
func (m *ListDataItemsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDataItemsRequest.Size(m)
}
func (m *ListDataItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataItemsRequest proto.InternalMessageInfo

func (m *ListDataItemsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDataItemsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDataItemsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDataItemsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing data items in a dataset.
type ListDataItemsResponse struct {
	// The list of data items to return.
	DataItems []*DataItem `protobuf:"bytes,1,rep,name=data_items,json=dataItems,proto3" json:"data_items,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataItemsResponse) Reset()         { *m = ListDataItemsResponse{} }
func (m *ListDataItemsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDataItemsResponse) ProtoMessage()    {}
func (*ListDataItemsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{9}
}

func (m *ListDataItemsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataItemsResponse.Unmarshal(m, b)
}
func (m *ListDataItemsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataItemsResponse.Marshal(b, m, deterministic)
}
func (m *ListDataItemsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataItemsResponse.Merge(m, src)
}
func (m *ListDataItemsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDataItemsResponse.Size(m)
}
func (m *ListDataItemsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataItemsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataItemsResponse proto.InternalMessageInfo

func (m *ListDataItemsResponse) GetDataItems() []*DataItem {
	if m != nil {
		return m.DataItems
	}
	return nil
}

func (m *ListDataItemsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for GetAnnotatedDataset.
type GetAnnotatedDatasetRequest struct {
	// Required. Name of the annotated dataset to get, format:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAnnotatedDatasetRequest) Reset()         { *m = GetAnnotatedDatasetRequest{} }
func (m *GetAnnotatedDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetAnnotatedDatasetRequest) ProtoMessage()    {}
func (*GetAnnotatedDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{10}
}

func (m *GetAnnotatedDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAnnotatedDatasetRequest.Unmarshal(m, b)
}
func (m *GetAnnotatedDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAnnotatedDatasetRequest.Marshal(b, m, deterministic)
}
func (m *GetAnnotatedDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAnnotatedDatasetRequest.Merge(m, src)
}
func (m *GetAnnotatedDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetAnnotatedDatasetRequest.Size(m)
}
func (m *GetAnnotatedDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAnnotatedDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAnnotatedDatasetRequest proto.InternalMessageInfo

func (m *GetAnnotatedDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListAnnotatedDatasets.
type ListAnnotatedDatasetsRequest struct {
	// Required. Name of the dataset to list annotated datasets, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListAnnotatedDatasetsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsResponse.next_page_token]
	// of the previous [DataLabelingService.ListAnnotatedDatasets] call. Return
	// first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotatedDatasetsRequest) Reset()         { *m = ListAnnotatedDatasetsRequest{} }
func (m *ListAnnotatedDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAnnotatedDatasetsRequest) ProtoMessage()    {}
func (*ListAnnotatedDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{11}
}

func (m *ListAnnotatedDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotatedDatasetsRequest.Unmarshal(m, b)
}
func (m *ListAnnotatedDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotatedDatasetsRequest.Marshal(b, m, deterministic)
}
func (m *ListAnnotatedDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotatedDatasetsRequest.Merge(m, src)
}
func (m *ListAnnotatedDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAnnotatedDatasetsRequest.Size(m)
}
func (m *ListAnnotatedDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotatedDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotatedDatasetsRequest proto.InternalMessageInfo

func (m *ListAnnotatedDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAnnotatedDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAnnotatedDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAnnotatedDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing annotated datasets for a dataset.
type ListAnnotatedDatasetsResponse struct {
	// The list of annotated datasets to return.
	AnnotatedDatasets []*AnnotatedDataset `protobuf:"bytes,1,rep,name=annotated_datasets,json=annotatedDatasets,proto3" json:"annotated_datasets,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotatedDatasetsResponse) Reset()         { *m = ListAnnotatedDatasetsResponse{} }
func (m *ListAnnotatedDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAnnotatedDatasetsResponse) ProtoMessage()    {}
func (*ListAnnotatedDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{12}
}

func (m *ListAnnotatedDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotatedDatasetsResponse.Unmarshal(m, b)
}
func (m *ListAnnotatedDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotatedDatasetsResponse.Marshal(b, m, deterministic)
}
func (m *ListAnnotatedDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotatedDatasetsResponse.Merge(m, src)
}
func (m *ListAnnotatedDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAnnotatedDatasetsResponse.Size(m)
}
func (m *ListAnnotatedDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotatedDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotatedDatasetsResponse proto.InternalMessageInfo

func (m *ListAnnotatedDatasetsResponse) GetAnnotatedDatasets() []*AnnotatedDataset {
	if m != nil {
		return m.AnnotatedDatasets
	}
	return nil
}

func (m *ListAnnotatedDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteAnnotatedDataset.
type DeleteAnnotatedDatasetRequest struct {
	// Required. Name of the annotated dataset to delete, format:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAnnotatedDatasetRequest) Reset()         { *m = DeleteAnnotatedDatasetRequest{} }
func (m *DeleteAnnotatedDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAnnotatedDatasetRequest) ProtoMessage()    {}
func (*DeleteAnnotatedDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{13}
}

func (m *DeleteAnnotatedDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAnnotatedDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAnnotatedDatasetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAnnotatedDatasetRequest.Merge(m, src)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAnnotatedDatasetRequest.Size(m)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAnnotatedDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAnnotatedDatasetRequest proto.InternalMessageInfo

func (m *DeleteAnnotatedDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for starting an image labeling task.
type LabelImageRequest struct {
	// Required. Config for labeling tasks. The type of request config must
	// match the selected feature.
	//
	// Types that are valid to be assigned to RequestConfig:
	//	*LabelImageRequest_ImageClassificationConfig
	//	*LabelImageRequest_BoundingPolyConfig
	//	*LabelImageRequest_PolylineConfig
	//	*LabelImageRequest_SegmentationConfig
	RequestConfig isLabelImageRequest_RequestConfig `protobuf_oneof:"request_config"`
	// Required. Name of the dataset to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of image labeling task.
	Feature              LabelImageRequest_Feature `protobuf:"varint,3,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelImageRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *LabelImageRequest) Reset()         { *m = LabelImageRequest{} }
func (m *LabelImageRequest) String() string { return proto.CompactTextString(m) }
func (*LabelImageRequest) ProtoMessage()    {}
func (*LabelImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{14}
}

func (m *LabelImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageRequest.Unmarshal(m, b)
}
func (m *LabelImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageRequest.Marshal(b, m, deterministic)
}
func (m *LabelImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageRequest.Merge(m, src)
}
func (m *LabelImageRequest) XXX_Size() int {
	return xxx_messageInfo_LabelImageRequest.Size(m)
}
func (m *LabelImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageRequest proto.InternalMessageInfo

type isLabelImageRequest_RequestConfig interface {
	isLabelImageRequest_RequestConfig()
}

type LabelImageRequest_ImageClassificationConfig struct {
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,4,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type LabelImageRequest_BoundingPolyConfig struct {
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,5,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type LabelImageRequest_PolylineConfig struct {
	PolylineConfig *PolylineConfig `protobuf:"bytes,6,opt,name=polyline_config,json=polylineConfig,proto3,oneof"`
}

type LabelImageRequest_SegmentationConfig struct {
	SegmentationConfig *SegmentationConfig `protobuf:"bytes,7,opt,name=segmentation_config,json=segmentationConfig,proto3,oneof"`
}

func (*LabelImageRequest_ImageClassificationConfig) isLabelImageRequest_RequestConfig() {}

func (*LabelImageRequest_BoundingPolyConfig) isLabelImageRequest_RequestConfig() {}

func (*LabelImageRequest_PolylineConfig) isLabelImageRequest_RequestConfig() {}

func (*LabelImageRequest_SegmentationConfig) isLabelImageRequest_RequestConfig() {}

func (m *LabelImageRequest) GetRequestConfig() isLabelImageRequest_RequestConfig {
	if m != nil {
		return m.RequestConfig
	}
	return nil
}

func (m *LabelImageRequest) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (m *LabelImageRequest) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (m *LabelImageRequest) GetPolylineConfig() *PolylineConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_PolylineConfig); ok {
		return x.PolylineConfig
	}
	return nil
}

func (m *LabelImageRequest) GetSegmentationConfig() *SegmentationConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_SegmentationConfig); ok {
		return x.SegmentationConfig
	}
	return nil
}

func (m *LabelImageRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelImageRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelImageRequest) GetFeature() LabelImageRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelImageRequest_FEATURE_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LabelImageRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LabelImageRequest_ImageClassificationConfig)(nil),
		(*LabelImageRequest_BoundingPolyConfig)(nil),
		(*LabelImageRequest_PolylineConfig)(nil),
		(*LabelImageRequest_SegmentationConfig)(nil),
	}
}

// Request message for LabelVideo.
type LabelVideoRequest struct {
	// Required. Config for labeling tasks. The type of request config must
	// match the selected feature.
	//
	// Types that are valid to be assigned to RequestConfig:
	//	*LabelVideoRequest_VideoClassificationConfig
	//	*LabelVideoRequest_ObjectDetectionConfig
	//	*LabelVideoRequest_ObjectTrackingConfig
	//	*LabelVideoRequest_EventConfig
	RequestConfig isLabelVideoRequest_RequestConfig `protobuf_oneof:"request_config"`
	// Required. Name of the dataset to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of video labeling task.
	Feature              LabelVideoRequest_Feature `protobuf:"varint,3,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelVideoRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *LabelVideoRequest) Reset()         { *m = LabelVideoRequest{} }
func (m *LabelVideoRequest) String() string { return proto.CompactTextString(m) }
func (*LabelVideoRequest) ProtoMessage()    {}
func (*LabelVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{15}
}

func (m *LabelVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelVideoRequest.Unmarshal(m, b)
}
func (m *LabelVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelVideoRequest.Marshal(b, m, deterministic)
}
func (m *LabelVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelVideoRequest.Merge(m, src)
}
func (m *LabelVideoRequest) XXX_Size() int {
	return xxx_messageInfo_LabelVideoRequest.Size(m)
}
func (m *LabelVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelVideoRequest proto.InternalMessageInfo

type isLabelVideoRequest_RequestConfig interface {
	isLabelVideoRequest_RequestConfig()
}

type LabelVideoRequest_VideoClassificationConfig struct {
	VideoClassificationConfig *VideoClassificationConfig `protobuf:"bytes,4,opt,name=video_classification_config,json=videoClassificationConfig,proto3,oneof"`
}

type LabelVideoRequest_ObjectDetectionConfig struct {
	ObjectDetectionConfig *ObjectDetectionConfig `protobuf:"bytes,5,opt,name=object_detection_config,json=objectDetectionConfig,proto3,oneof"`
}

type LabelVideoRequest_ObjectTrackingConfig struct {
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,6,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type LabelVideoRequest_EventConfig struct {
	EventConfig *EventConfig `protobuf:"bytes,7,opt,name=event_config,json=eventConfig,proto3,oneof"`
}

func (*LabelVideoRequest_VideoClassificationConfig) isLabelVideoRequest_RequestConfig() {}

func (*LabelVideoRequest_ObjectDetectionConfig) isLabelVideoRequest_RequestConfig() {}

func (*LabelVideoRequest_ObjectTrackingConfig) isLabelVideoRequest_RequestConfig() {}

func (*LabelVideoRequest_EventConfig) isLabelVideoRequest_RequestConfig() {}

func (m *LabelVideoRequest) GetRequestConfig() isLabelVideoRequest_RequestConfig {
	if m != nil {
		return m.RequestConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetVideoClassificationConfig() *VideoClassificationConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_VideoClassificationConfig); ok {
		return x.VideoClassificationConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetObjectDetectionConfig() *ObjectDetectionConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_ObjectDetectionConfig); ok {
		return x.ObjectDetectionConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetEventConfig() *EventConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_EventConfig); ok {
		return x.EventConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelVideoRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetFeature() LabelVideoRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelVideoRequest_FEATURE_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LabelVideoRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LabelVideoRequest_VideoClassificationConfig)(nil),
		(*LabelVideoRequest_ObjectDetectionConfig)(nil),
		(*LabelVideoRequest_ObjectTrackingConfig)(nil),
		(*LabelVideoRequest_EventConfig)(nil),
	}
}

// Request message for LabelText.
type LabelTextRequest struct {
	// Required. Config for labeling tasks. The type of request config must
	// match the selected feature.
	//
	// Types that are valid to be assigned to RequestConfig:
	//	*LabelTextRequest_TextClassificationConfig
	//	*LabelTextRequest_TextEntityExtractionConfig
	RequestConfig isLabelTextRequest_RequestConfig `protobuf_oneof:"request_config"`
	// Required. Name of the data set to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of text labeling task.
	Feature              LabelTextRequest_Feature `protobuf:"varint,6,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelTextRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LabelTextRequest) Reset()         { *m = LabelTextRequest{} }
func (m *LabelTextRequest) String() string { return proto.CompactTextString(m) }
func (*LabelTextRequest) ProtoMessage()    {}
func (*LabelTextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{16}
}

func (m *LabelTextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelTextRequest.Unmarshal(m, b)
}
func (m *LabelTextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelTextRequest.Marshal(b, m, deterministic)
}
func (m *LabelTextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelTextRequest.Merge(m, src)
}
func (m *LabelTextRequest) XXX_Size() int {
	return xxx_messageInfo_LabelTextRequest.Size(m)
}
func (m *LabelTextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelTextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelTextRequest proto.InternalMessageInfo

type isLabelTextRequest_RequestConfig interface {
	isLabelTextRequest_RequestConfig()
}

type LabelTextRequest_TextClassificationConfig struct {
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,4,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

type LabelTextRequest_TextEntityExtractionConfig struct {
	TextEntityExtractionConfig *TextEntityExtractionConfig `protobuf:"bytes,5,opt,name=text_entity_extraction_config,json=textEntityExtractionConfig,proto3,oneof"`
}

func (*LabelTextRequest_TextClassificationConfig) isLabelTextRequest_RequestConfig() {}

func (*LabelTextRequest_TextEntityExtractionConfig) isLabelTextRequest_RequestConfig() {}

func (m *LabelTextRequest) GetRequestConfig() isLabelTextRequest_RequestConfig {
	if m != nil {
		return m.RequestConfig
	}
	return nil
}

func (m *LabelTextRequest) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := m.GetRequestConfig().(*LabelTextRequest_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (m *LabelTextRequest) GetTextEntityExtractionConfig() *TextEntityExtractionConfig {
	if x, ok := m.GetRequestConfig().(*LabelTextRequest_TextEntityExtractionConfig); ok {
		return x.TextEntityExtractionConfig
	}
	return nil
}

func (m *LabelTextRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelTextRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelTextRequest) GetFeature() LabelTextRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelTextRequest_FEATURE_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LabelTextRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LabelTextRequest_TextClassificationConfig)(nil),
		(*LabelTextRequest_TextEntityExtractionConfig)(nil),
	}
}

// Request message for GetExample
type GetExampleRequest struct {
	// Required. Name of example, format:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}/examples/{example_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An expression for filtering Examples. Filter by
	// annotation_spec.display_name is supported. Format
	// "annotation_spec.display_name = {display_name}"
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetExampleRequest) Reset()         { *m = GetExampleRequest{} }
func (m *GetExampleRequest) String() string { return proto.CompactTextString(m) }
func (*GetExampleRequest) ProtoMessage()    {}
func (*GetExampleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{17}
}

func (m *GetExampleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetExampleRequest.Unmarshal(m, b)
}
func (m *GetExampleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetExampleRequest.Marshal(b, m, deterministic)
}
func (m *GetExampleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetExampleRequest.Merge(m, src)
}
func (m *GetExampleRequest) XXX_Size() int {
	return xxx_messageInfo_GetExampleRequest.Size(m)
}
func (m *GetExampleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetExampleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetExampleRequest proto.InternalMessageInfo

func (m *GetExampleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetExampleRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Request message for ListExamples.
type ListExamplesRequest struct {
	// Required. Example resource parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression for filtering Examples. For annotated datasets that
	// have annotation spec set, filter by
	// annotation_spec.display_name is supported. Format
	// "annotation_spec.display_name = {display_name}"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListExamplesResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListExamplesResponse.next_page_token]
	// of the previous [DataLabelingService.ListExamples] call. Return first page
	// if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExamplesRequest) Reset()         { *m = ListExamplesRequest{} }
func (m *ListExamplesRequest) String() string { return proto.CompactTextString(m) }
func (*ListExamplesRequest) ProtoMessage()    {}
func (*ListExamplesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{18}
}

func (m *ListExamplesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListExamplesRequest.Unmarshal(m, b)
}
func (m *ListExamplesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListExamplesRequest.Marshal(b, m, deterministic)
}
func (m *ListExamplesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExamplesRequest.Merge(m, src)
}
func (m *ListExamplesRequest) XXX_Size() int {
	return xxx_messageInfo_ListExamplesRequest.Size(m)
}
func (m *ListExamplesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExamplesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExamplesRequest proto.InternalMessageInfo

func (m *ListExamplesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListExamplesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListExamplesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListExamplesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing Examples in and annotated dataset.
type ListExamplesResponse struct {
	// The list of examples to return.
	Examples []*Example `protobuf:"bytes,1,rep,name=examples,proto3" json:"examples,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExamplesResponse) Reset()         { *m = ListExamplesResponse{} }
func (m *ListExamplesResponse) String() string { return proto.CompactTextString(m) }
func (*ListExamplesResponse) ProtoMessage()    {}
func (*ListExamplesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{19}
}

func (m *ListExamplesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListExamplesResponse.Unmarshal(m, b)
}
func (m *ListExamplesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListExamplesResponse.Marshal(b, m, deterministic)
}
func (m *ListExamplesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExamplesResponse.Merge(m, src)
}
func (m *ListExamplesResponse) XXX_Size() int {
	return xxx_messageInfo_ListExamplesResponse.Size(m)
}
func (m *ListExamplesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExamplesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListExamplesResponse proto.InternalMessageInfo

func (m *ListExamplesResponse) GetExamples() []*Example {
	if m != nil {
		return m.Examples
	}
	return nil
}

func (m *ListExamplesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for CreateAnnotationSpecSet.
type CreateAnnotationSpecSetRequest struct {
	// Required. AnnotationSpecSet resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Annotation spec set to create. Annotation specs must be included.
	// Only one annotation spec will be accepted for annotation specs with same
	// display_name.
	AnnotationSpecSet    *AnnotationSpecSet `protobuf:"bytes,2,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateAnnotationSpecSetRequest) Reset()         { *m = CreateAnnotationSpecSetRequest{} }
func (m *CreateAnnotationSpecSetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAnnotationSpecSetRequest) ProtoMessage()    {}
func (*CreateAnnotationSpecSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{20}
}

func (m *CreateAnnotationSpecSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAnnotationSpecSetRequest.Unmarshal(m, b)
}
func (m *CreateAnnotationSpecSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAnnotationSpecSetRequest.Marshal(b, m, deterministic)
}
func (m *CreateAnnotationSpecSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAnnotationSpecSetRequest.Merge(m, src)
}
func (m *CreateAnnotationSpecSetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAnnotationSpecSetRequest.Size(m)
}
func (m *CreateAnnotationSpecSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAnnotationSpecSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAnnotationSpecSetRequest proto.InternalMessageInfo

func (m *CreateAnnotationSpecSetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAnnotationSpecSetRequest) GetAnnotationSpecSet() *AnnotationSpecSet {
	if m != nil {
		return m.AnnotationSpecSet
	}
	return nil
}

// Request message for GetAnnotationSpecSet.
type GetAnnotationSpecSetRequest struct {
	// Required. AnnotationSpecSet resource name, format:
	// projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAnnotationSpecSetRequest) Reset()         { *m = GetAnnotationSpecSetRequest{} }
func (m *GetAnnotationSpecSetRequest) String() string { return proto.CompactTextString(m) }
func (*GetAnnotationSpecSetRequest) ProtoMessage()    {}
func (*GetAnnotationSpecSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{21}
}

func (m *GetAnnotationSpecSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAnnotationSpecSetRequest.Unmarshal(m, b)
}
func (m *GetAnnotationSpecSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAnnotationSpecSetRequest.Marshal(b, m, deterministic)
}
func (m *GetAnnotationSpecSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAnnotationSpecSetRequest.Merge(m, src)
}
func (m *GetAnnotationSpecSetRequest) XXX_Size() int {
	return xxx_messageInfo_GetAnnotationSpecSetRequest.Size(m)
}
func (m *GetAnnotationSpecSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAnnotationSpecSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAnnotationSpecSetRequest proto.InternalMessageInfo

func (m *GetAnnotationSpecSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListAnnotationSpecSets.
type ListAnnotationSpecSetsRequest struct {
	// Required. Parent of AnnotationSpecSet resource, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListAnnotationSpecSetsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsResponse.next_page_token]
	// of the previous [DataLabelingService.ListAnnotationSpecSets] call. Return
	// first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotationSpecSetsRequest) Reset()         { *m = ListAnnotationSpecSetsRequest{} }
func (m *ListAnnotationSpecSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAnnotationSpecSetsRequest) ProtoMessage()    {}
func (*ListAnnotationSpecSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{22}
}

func (m *ListAnnotationSpecSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotationSpecSetsRequest.Unmarshal(m, b)
}
func (m *ListAnnotationSpecSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotationSpecSetsRequest.Marshal(b, m, deterministic)
}
func (m *ListAnnotationSpecSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotationSpecSetsRequest.Merge(m, src)
}
func (m *ListAnnotationSpecSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAnnotationSpecSetsRequest.Size(m)
}
func (m *ListAnnotationSpecSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotationSpecSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotationSpecSetsRequest proto.InternalMessageInfo

func (m *ListAnnotationSpecSetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAnnotationSpecSetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAnnotationSpecSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAnnotationSpecSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing annotation spec set under a project.
type ListAnnotationSpecSetsResponse struct {
	// The list of annotation spec sets.
	AnnotationSpecSets []*AnnotationSpecSet `protobuf:"bytes,1,rep,name=annotation_spec_sets,json=annotationSpecSets,proto3" json:"annotation_spec_sets,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotationSpecSetsResponse) Reset()         { *m = ListAnnotationSpecSetsResponse{} }
func (m *ListAnnotationSpecSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAnnotationSpecSetsResponse) ProtoMessage()    {}
func (*ListAnnotationSpecSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{23}
}

func (m *ListAnnotationSpecSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotationSpecSetsResponse.Unmarshal(m, b)
}
func (m *ListAnnotationSpecSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotationSpecSetsResponse.Marshal(b, m, deterministic)
}
func (m *ListAnnotationSpecSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotationSpecSetsResponse.Merge(m, src)
}
func (m *ListAnnotationSpecSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAnnotationSpecSetsResponse.Size(m)
}
func (m *ListAnnotationSpecSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotationSpecSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotationSpecSetsResponse proto.InternalMessageInfo

func (m *ListAnnotationSpecSetsResponse) GetAnnotationSpecSets() []*AnnotationSpecSet {
	if m != nil {
		return m.AnnotationSpecSets
	}
	return nil
}

func (m *ListAnnotationSpecSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteAnnotationSpecSet.
type DeleteAnnotationSpecSetRequest struct {
	// Required. AnnotationSpec resource name, format:
	// `projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAnnotationSpecSetRequest) Reset()         { *m = DeleteAnnotationSpecSetRequest{} }
func (m *DeleteAnnotationSpecSetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAnnotationSpecSetRequest) ProtoMessage()    {}
func (*DeleteAnnotationSpecSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{24}
}

func (m *DeleteAnnotationSpecSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAnnotationSpecSetRequest.Unmarshal(m, b)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAnnotationSpecSetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAnnotationSpecSetRequest.Merge(m, src)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAnnotationSpecSetRequest.Size(m)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAnnotationSpecSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAnnotationSpecSetRequest proto.InternalMessageInfo

func (m *DeleteAnnotationSpecSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for CreateInstruction.
type CreateInstructionRequest struct {
	// Required. Instruction resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Instruction of how to perform the labeling task.
	Instruction          *Instruction `protobuf:"bytes,2,opt,name=instruction,proto3" json:"instruction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateInstructionRequest) Reset()         { *m = CreateInstructionRequest{} }
func (m *CreateInstructionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstructionRequest) ProtoMessage()    {}
func (*CreateInstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{25}
}

func (m *CreateInstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstructionRequest.Unmarshal(m, b)
}
func (m *CreateInstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstructionRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstructionRequest.Merge(m, src)
}
func (m *CreateInstructionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstructionRequest.Size(m)
}
func (m *CreateInstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstructionRequest proto.InternalMessageInfo

func (m *CreateInstructionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstructionRequest) GetInstruction() *Instruction {
	if m != nil {
		return m.Instruction
	}
	return nil
}

// Request message for GetInstruction.
type GetInstructionRequest struct {
	// Required. Instruction resource name, format:
	// projects/{project_id}/instructions/{instruction_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstructionRequest) Reset()         { *m = GetInstructionRequest{} }
func (m *GetInstructionRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstructionRequest) ProtoMessage()    {}
func (*GetInstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{26}
}

func (m *GetInstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstructionRequest.Unmarshal(m, b)
}
func (m *GetInstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstructionRequest.Marshal(b, m, deterministic)
}
func (m *GetInstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstructionRequest.Merge(m, src)
}
func (m *GetInstructionRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstructionRequest.Size(m)
}
func (m *GetInstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstructionRequest proto.InternalMessageInfo

func (m *GetInstructionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for DeleteInstruction.
type DeleteInstructionRequest struct {
	// Required. Instruction resource name, format:
	// projects/{project_id}/instructions/{instruction_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstructionRequest) Reset()         { *m = DeleteInstructionRequest{} }
func (m *DeleteInstructionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstructionRequest) ProtoMessage()    {}
func (*DeleteInstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{27}
}

func (m *DeleteInstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstructionRequest.Unmarshal(m, b)
}
func (m *DeleteInstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstructionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstructionRequest.Merge(m, src)
}
func (m *DeleteInstructionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstructionRequest.Size(m)
}
func (m *DeleteInstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstructionRequest proto.InternalMessageInfo

func (m *DeleteInstructionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListInstructions.
type ListInstructionsRequest struct {
	// Required. Instruction resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListInstructionsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListInstructionsResponse.next_page_token]
	// of the previous [DataLabelingService.ListInstructions] call. Return first
	// page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstructionsRequest) Reset()         { *m = ListInstructionsRequest{} }
func (m *ListInstructionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstructionsRequest) ProtoMessage()    {}
func (*ListInstructionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{28}
}

func (m *ListInstructionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstructionsRequest.Unmarshal(m, b)
}
func (m *ListInstructionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstructionsRequest.Marshal(b, m, deterministic)
}
func (m *ListInstructionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstructionsRequest.Merge(m, src)
}
func (m *ListInstructionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstructionsRequest.Size(m)
}
func (m *ListInstructionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstructionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstructionsRequest proto.InternalMessageInfo

func (m *ListInstructionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstructionsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListInstructionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstructionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing instructions under a project.
type ListInstructionsResponse struct {
	// The list of Instructions to return.
	Instructions []*Instruction `protobuf:"bytes,1,rep,name=instructions,proto3" json:"instructions,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstructionsResponse) Reset()         { *m = ListInstructionsResponse{} }
func (m *ListInstructionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstructionsResponse) ProtoMessage()    {}
func (*ListInstructionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{29}
}

func (m *ListInstructionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstructionsResponse.Unmarshal(m, b)
}
func (m *ListInstructionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstructionsResponse.Marshal(b, m, deterministic)
}
func (m *ListInstructionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstructionsResponse.Merge(m, src)
}
func (m *ListInstructionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstructionsResponse.Size(m)
}
func (m *ListInstructionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstructionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstructionsResponse proto.InternalMessageInfo

func (m *ListInstructionsResponse) GetInstructions() []*Instruction {
	if m != nil {
		return m.Instructions
	}
	return nil
}

func (m *ListInstructionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for GetEvaluation.
type GetEvaluationRequest struct {
	// Required. Name of the evaluation. Format:
	// 'projects/{project_id}/datasets/{dataset_id}/evaluations/{evaluation_id}'
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEvaluationRequest) Reset()         { *m = GetEvaluationRequest{} }
func (m *GetEvaluationRequest) String() string { return proto.CompactTextString(m) }
func (*GetEvaluationRequest) ProtoMessage()    {}
func (*GetEvaluationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{30}
}

func (m *GetEvaluationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEvaluationRequest.Unmarshal(m, b)
}
func (m *GetEvaluationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEvaluationRequest.Marshal(b, m, deterministic)
}
func (m *GetEvaluationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEvaluationRequest.Merge(m, src)
}
func (m *GetEvaluationRequest) XXX_Size() int {
	return xxx_messageInfo_GetEvaluationRequest.Size(m)
}
func (m *GetEvaluationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEvaluationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEvaluationRequest proto.InternalMessageInfo

func (m *GetEvaluationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for SearchEvaluation.
type SearchEvaluationsRequest struct {
	// Required. Evaluation search parent. Format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Support filtering by model id, job state, start and end time.
	// Format:
	// "evaluation_job.evaluation_job_id = {evaluation_job_id} AND
	// evaluation_job.evaluation_job_run_time_start = {timestamp} AND
	// evaluation_job.evaluation_job_run_time_end = {timestamp} AND
	// annotation_spec.display_name = {display_name}"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [SearchEvaluationsResponse.next_page_token][google.cloud.datalabeling.v1beta1.SearchEvaluationsResponse.next_page_token]
	// of the previous [DataLabelingService.SearchEvaluations] call. Return first
	// page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchEvaluationsRequest) Reset()         { *m = SearchEvaluationsRequest{} }
func (m *SearchEvaluationsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchEvaluationsRequest) ProtoMessage()    {}
func (*SearchEvaluationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{31}
}

func (m *SearchEvaluationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchEvaluationsRequest.Unmarshal(m, b)
}
func (m *SearchEvaluationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchEvaluationsRequest.Marshal(b, m, deterministic)
}
func (m *SearchEvaluationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchEvaluationsRequest.Merge(m, src)
}
func (m *SearchEvaluationsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchEvaluationsRequest.Size(m)
}
func (m *SearchEvaluationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchEvaluationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchEvaluationsRequest proto.InternalMessageInfo

func (m *SearchEvaluationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchEvaluationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *SearchEvaluationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchEvaluationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of searching evaluations.
type SearchEvaluationsResponse struct {
	// The list of evaluations to return.
	Evaluations []*Evaluation `protobuf:"bytes,1,rep,name=evaluations,proto3" json:"evaluations,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchEvaluationsResponse) Reset()         { *m = SearchEvaluationsResponse{} }
func (m *SearchEvaluationsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchEvaluationsResponse) ProtoMessage()    {}
func (*SearchEvaluationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{32}
}

func (m *SearchEvaluationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchEvaluationsResponse.Unmarshal(m, b)
}
func (m *SearchEvaluationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchEvaluationsResponse.Marshal(b, m, deterministic)
}
func (m *SearchEvaluationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchEvaluationsResponse.Merge(m, src)
}
func (m *SearchEvaluationsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchEvaluationsResponse.Size(m)
}
func (m *SearchEvaluationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchEvaluationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchEvaluationsResponse proto.InternalMessageInfo

func (m *SearchEvaluationsResponse) GetEvaluations() []*Evaluation {
	if m != nil {
		return m.Evaluations
	}
	return nil
}

func (m *SearchEvaluationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message of SearchExampleComparisons.
type SearchExampleComparisonsRequest struct {
	// Required. Name of the Evaluation resource to search example comparison
	// from. Format:
	// projects/{project_id}/datasets/{dataset_id}/evaluations/{evaluation_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [SearchExampleComparisons.next_page_token][] of the previous
	// [DataLabelingService.SearchExampleComparisons] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchExampleComparisonsRequest) Reset()         { *m = SearchExampleComparisonsRequest{} }
func (m *SearchExampleComparisonsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchExampleComparisonsRequest) ProtoMessage()    {}
func (*SearchExampleComparisonsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{33}
}

func (m *SearchExampleComparisonsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchExampleComparisonsRequest.Unmarshal(m, b)
}
func (m *SearchExampleComparisonsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchExampleComparisonsRequest.Marshal(b, m, deterministic)
}
func (m *SearchExampleComparisonsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchExampleComparisonsRequest.Merge(m, src)
}
func (m *SearchExampleComparisonsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchExampleComparisonsRequest.Size(m)
}
func (m *SearchExampleComparisonsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchExampleComparisonsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchExampleComparisonsRequest proto.InternalMessageInfo

func (m *SearchExampleComparisonsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchExampleComparisonsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchExampleComparisonsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of searching example comparisons.
type SearchExampleComparisonsResponse struct {
	ExampleComparisons []*SearchExampleComparisonsResponse_ExampleComparison `protobuf:"bytes,1,rep,name=example_comparisons,json=exampleComparisons,proto3" json:"example_comparisons,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchExampleComparisonsResponse) Reset()         { *m = SearchExampleComparisonsResponse{} }
func (m *SearchExampleComparisonsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchExampleComparisonsResponse) ProtoMessage()    {}
func (*SearchExampleComparisonsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{34}
}

func (m *SearchExampleComparisonsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchExampleComparisonsResponse.Unmarshal(m, b)
}
func (m *SearchExampleComparisonsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchExampleComparisonsResponse.Marshal(b, m, deterministic)
}
func (m *SearchExampleComparisonsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchExampleComparisonsResponse.Merge(m, src)
}
func (m *SearchExampleComparisonsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchExampleComparisonsResponse.Size(m)
}
func (m *SearchExampleComparisonsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchExampleComparisonsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchExampleComparisonsResponse proto.InternalMessageInfo

func (m *SearchExampleComparisonsResponse) GetExampleComparisons() []*SearchExampleComparisonsResponse_ExampleComparison {
	if m != nil {
		return m.ExampleComparisons
	}
	return nil
}

func (m *SearchExampleComparisonsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Example comparisons containing annotation comparison between groundtruth
// and predictions.
type SearchExampleComparisonsResponse_ExampleComparison struct {
	GroundTruthExample   *Example   `protobuf:"bytes,1,opt,name=ground_truth_example,json=groundTruthExample,proto3" json:"ground_truth_example,omitempty"`
	ModelCreatedExamples []*Example `protobuf:"bytes,2,rep,name=model_created_examples,json=modelCreatedExamples,proto3" json:"model_created_examples,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SearchExampleComparisonsResponse_ExampleComparison) Reset() {
	*m = SearchExampleComparisonsResponse_ExampleComparison{}
}
func (m *SearchExampleComparisonsResponse_ExampleComparison) String() string {
	return proto.CompactTextString(m)
}
func (*SearchExampleComparisonsResponse_ExampleComparison) ProtoMessage() {}
func (*SearchExampleComparisonsResponse_ExampleComparison) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{34, 0}
}

func (m *SearchExampleComparisonsResponse_ExampleComparison) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchExampleComparisonsResponse_ExampleComparison.Unmarshal(m, b)
}
func (m *SearchExampleComparisonsResponse_ExampleComparison) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchExampleComparisonsResponse_ExampleComparison.Marshal(b, m, deterministic)
}
func (m *SearchExampleComparisonsResponse_ExampleComparison) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchExampleComparisonsResponse_ExampleComparison.Merge(m, src)
}
func (m *SearchExampleComparisonsResponse_ExampleComparison) XXX_Size() int {
	return xxx_messageInfo_SearchExampleComparisonsResponse_ExampleComparison.Size(m)
}
func (m *SearchExampleComparisonsResponse_ExampleComparison) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchExampleComparisonsResponse_ExampleComparison.DiscardUnknown(m)
}

var xxx_messageInfo_SearchExampleComparisonsResponse_ExampleComparison proto.InternalMessageInfo

func (m *SearchExampleComparisonsResponse_ExampleComparison) GetGroundTruthExample() *Example {
	if m != nil {
		return m.GroundTruthExample
	}
	return nil
}

func (m *SearchExampleComparisonsResponse_ExampleComparison) GetModelCreatedExamples() []*Example {
	if m != nil {
		return m.ModelCreatedExamples
	}
	return nil
}

// Request message for CreateEvaluationJob.
type CreateEvaluationJobRequest struct {
	// Required. Evaluation job resource parent, format:
	// projects/{project_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The evaluation job to create.
	Job                  *EvaluationJob `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CreateEvaluationJobRequest) Reset()         { *m = CreateEvaluationJobRequest{} }
func (m *CreateEvaluationJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEvaluationJobRequest) ProtoMessage()    {}
func (*CreateEvaluationJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{35}
}

func (m *CreateEvaluationJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEvaluationJobRequest.Unmarshal(m, b)
}
func (m *CreateEvaluationJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEvaluationJobRequest.Marshal(b, m, deterministic)
}
func (m *CreateEvaluationJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEvaluationJobRequest.Merge(m, src)
}
func (m *CreateEvaluationJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEvaluationJobRequest.Size(m)
}
func (m *CreateEvaluationJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEvaluationJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEvaluationJobRequest proto.InternalMessageInfo

func (m *CreateEvaluationJobRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEvaluationJobRequest) GetJob() *EvaluationJob {
	if m != nil {
		return m.Job
	}
	return nil
}

// Request message for UpdateEvaluationJob.
type UpdateEvaluationJobRequest struct {
	// Required. Evaluation job that is going to be updated.
	EvaluationJob *EvaluationJob `protobuf:"bytes,1,opt,name=evaluation_job,json=evaluationJob,proto3" json:"evaluation_job,omitempty"`
	// Optional. Mask for which field in evaluation_job should be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEvaluationJobRequest) Reset()         { *m = UpdateEvaluationJobRequest{} }
func (m *UpdateEvaluationJobRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEvaluationJobRequest) ProtoMessage()    {}
func (*UpdateEvaluationJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{36}
}

func (m *UpdateEvaluationJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEvaluationJobRequest.Unmarshal(m, b)
}
func (m *UpdateEvaluationJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEvaluationJobRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEvaluationJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEvaluationJobRequest.Merge(m, src)
}
func (m *UpdateEvaluationJobRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEvaluationJobRequest.Size(m)
}
func (m *UpdateEvaluationJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEvaluationJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEvaluationJobRequest proto.InternalMessageInfo

func (m *UpdateEvaluationJobRequest) GetEvaluationJob() *EvaluationJob {
	if m != nil {
		return m.EvaluationJob
	}
	return nil
}

func (m *UpdateEvaluationJobRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for GetEvaluationJob.
type GetEvaluationJobRequest struct {
	// Required. Name of the evaluation job. Format:
	// 'projects/{project_id}/evaluationJobs/{evaluation_job_id}'
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEvaluationJobRequest) Reset()         { *m = GetEvaluationJobRequest{} }
func (m *GetEvaluationJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetEvaluationJobRequest) ProtoMessage()    {}
func (*GetEvaluationJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{37}
}

func (m *GetEvaluationJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEvaluationJobRequest.Unmarshal(m, b)
}
func (m *GetEvaluationJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEvaluationJobRequest.Marshal(b, m, deterministic)
}
func (m *GetEvaluationJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEvaluationJobRequest.Merge(m, src)
}
func (m *GetEvaluationJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetEvaluationJobRequest.Size(m)
}
func (m *GetEvaluationJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEvaluationJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEvaluationJobRequest proto.InternalMessageInfo

func (m *GetEvaluationJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for PauseEvaluationJob.
type PauseEvaluationJobRequest struct {
	// Required. Name of the evaluation job that is going to be paused. Format:
	// 'projects/{project_id}/evaluationJobs/{evaluation_job_id}'
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PauseEvaluationJobRequest) Reset()         { *m = PauseEvaluationJobRequest{} }
func (m *PauseEvaluationJobRequest) String() string { return proto.CompactTextString(m) }
func (*PauseEvaluationJobRequest) ProtoMessage()    {}
func (*PauseEvaluationJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{38}
}

func (m *PauseEvaluationJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PauseEvaluationJobRequest.Unmarshal(m, b)
}
func (m *PauseEvaluationJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PauseEvaluationJobRequest.Marshal(b, m, deterministic)
}
func (m *PauseEvaluationJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PauseEvaluationJobRequest.Merge(m, src)
}
func (m *PauseEvaluationJobRequest) XXX_Size() int {
	return xxx_messageInfo_PauseEvaluationJobRequest.Size(m)
}
func (m *PauseEvaluationJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PauseEvaluationJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PauseEvaluationJobRequest proto.InternalMessageInfo

func (m *PauseEvaluationJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message ResumeEvaluationJob.
type ResumeEvaluationJobRequest struct {
	// Required. Name of the evaluation job that is going to be resumed. Format:
	// 'projects/{project_id}/evaluationJobs/{evaluation_job_id}'
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResumeEvaluationJobRequest) Reset()         { *m = ResumeEvaluationJobRequest{} }
func (m *ResumeEvaluationJobRequest) String() string { return proto.CompactTextString(m) }
func (*ResumeEvaluationJobRequest) ProtoMessage()    {}
func (*ResumeEvaluationJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{39}
}

func (m *ResumeEvaluationJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResumeEvaluationJobRequest.Unmarshal(m, b)
}
func (m *ResumeEvaluationJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResumeEvaluationJobRequest.Marshal(b, m, deterministic)
}
func (m *ResumeEvaluationJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResumeEvaluationJobRequest.Merge(m, src)
}
func (m *ResumeEvaluationJobRequest) XXX_Size() int {
	return xxx_messageInfo_ResumeEvaluationJobRequest.Size(m)
}
func (m *ResumeEvaluationJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResumeEvaluationJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResumeEvaluationJobRequest proto.InternalMessageInfo

func (m *ResumeEvaluationJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message DeleteEvaluationJob.
type DeleteEvaluationJobRequest struct {
	// Required. Name of the evaluation job that is going to be deleted. Format:
	// 'projects/{project_id}/evaluationJobs/{evaluation_job_id}'
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEvaluationJobRequest) Reset()         { *m = DeleteEvaluationJobRequest{} }
func (m *DeleteEvaluationJobRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEvaluationJobRequest) ProtoMessage()    {}
func (*DeleteEvaluationJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{40}
}

func (m *DeleteEvaluationJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEvaluationJobRequest.Unmarshal(m, b)
}
func (m *DeleteEvaluationJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEvaluationJobRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEvaluationJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEvaluationJobRequest.Merge(m, src)
}
func (m *DeleteEvaluationJobRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEvaluationJobRequest.Size(m)
}
func (m *DeleteEvaluationJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEvaluationJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEvaluationJobRequest proto.InternalMessageInfo

func (m *DeleteEvaluationJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListEvaluationJobs.
type ListEvaluationJobsRequest struct {
	// Required. Evaluation resource parent. Format:
	// "projects/{project_id}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Only support filter by model id and job state. Format:
	// "evaluation_job.model_id = {model_id} AND evaluation_job.state =
	// {EvaluationJob::State}"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListEvaluationJobs.next_page_token][] of the previous
	// [DataLabelingService.ListEvaluationJobs] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEvaluationJobsRequest) Reset()         { *m = ListEvaluationJobsRequest{} }
func (m *ListEvaluationJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListEvaluationJobsRequest) ProtoMessage()    {}
func (*ListEvaluationJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{41}
}

func (m *ListEvaluationJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEvaluationJobsRequest.Unmarshal(m, b)
}
func (m *ListEvaluationJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEvaluationJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListEvaluationJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEvaluationJobsRequest.Merge(m, src)
}
func (m *ListEvaluationJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListEvaluationJobsRequest.Size(m)
}
func (m *ListEvaluationJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEvaluationJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEvaluationJobsRequest proto.InternalMessageInfo

func (m *ListEvaluationJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEvaluationJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListEvaluationJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEvaluationJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results for listing evaluation jobs.
type ListEvaluationJobsResponse struct {
	// The list of evaluation jobs to return.
	EvaluationJobs []*EvaluationJob `protobuf:"bytes,1,rep,name=evaluation_jobs,json=evaluationJobs,proto3" json:"evaluation_jobs,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEvaluationJobsResponse) Reset()         { *m = ListEvaluationJobsResponse{} }
func (m *ListEvaluationJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEvaluationJobsResponse) ProtoMessage()    {}
func (*ListEvaluationJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21c40690da1750b, []int{42}
}

func (m *ListEvaluationJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEvaluationJobsResponse.Unmarshal(m, b)
}
func (m *ListEvaluationJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEvaluationJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListEvaluationJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEvaluationJobsResponse.Merge(m, src)
}
func (m *ListEvaluationJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEvaluationJobsResponse.Size(m)
}
func (m *ListEvaluationJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEvaluationJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEvaluationJobsResponse proto.InternalMessageInfo

func (m *ListEvaluationJobsResponse) GetEvaluationJobs() []*EvaluationJob {
	if m != nil {
		return m.EvaluationJobs
	}
	return nil
}

func (m *ListEvaluationJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelImageRequest_Feature", LabelImageRequest_Feature_name, LabelImageRequest_Feature_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelVideoRequest_Feature", LabelVideoRequest_Feature_name, LabelVideoRequest_Feature_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelTextRequest_Feature", LabelTextRequest_Feature_name, LabelTextRequest_Feature_value)
	proto.RegisterType((*CreateDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateDatasetRequest")
	proto.RegisterType((*GetDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.GetDatasetRequest")
	proto.RegisterType((*ListDatasetsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListDatasetsRequest")
	proto.RegisterType((*ListDatasetsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListDatasetsResponse")
	proto.RegisterType((*DeleteDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteDatasetRequest")
	proto.RegisterType((*ImportDataRequest)(nil), "google.cloud.datalabeling.v1beta1.ImportDataRequest")
	proto.RegisterType((*ExportDataRequest)(nil), "google.cloud.datalabeling.v1beta1.ExportDataRequest")
	proto.RegisterType((*GetDataItemRequest)(nil), "google.cloud.datalabeling.v1beta1.GetDataItemRequest")
	proto.RegisterType((*ListDataItemsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListDataItemsRequest")
	proto.RegisterType((*ListDataItemsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListDataItemsResponse")
	proto.RegisterType((*GetAnnotatedDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.GetAnnotatedDatasetRequest")
	proto.RegisterType((*ListAnnotatedDatasetsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsRequest")
	proto.RegisterType((*ListAnnotatedDatasetsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsResponse")
	proto.RegisterType((*DeleteAnnotatedDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteAnnotatedDatasetRequest")
	proto.RegisterType((*LabelImageRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelImageRequest")
	proto.RegisterType((*LabelVideoRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelVideoRequest")
	proto.RegisterType((*LabelTextRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelTextRequest")
	proto.RegisterType((*GetExampleRequest)(nil), "google.cloud.datalabeling.v1beta1.GetExampleRequest")
	proto.RegisterType((*ListExamplesRequest)(nil), "google.cloud.datalabeling.v1beta1.ListExamplesRequest")
	proto.RegisterType((*ListExamplesResponse)(nil), "google.cloud.datalabeling.v1beta1.ListExamplesResponse")
	proto.RegisterType((*CreateAnnotationSpecSetRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateAnnotationSpecSetRequest")
	proto.RegisterType((*GetAnnotationSpecSetRequest)(nil), "google.cloud.datalabeling.v1beta1.GetAnnotationSpecSetRequest")
	proto.RegisterType((*ListAnnotationSpecSetsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsRequest")
	proto.RegisterType((*ListAnnotationSpecSetsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsResponse")
	proto.RegisterType((*DeleteAnnotationSpecSetRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteAnnotationSpecSetRequest")
	proto.RegisterType((*CreateInstructionRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateInstructionRequest")
	proto.RegisterType((*GetInstructionRequest)(nil), "google.cloud.datalabeling.v1beta1.GetInstructionRequest")
	proto.RegisterType((*DeleteInstructionRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteInstructionRequest")
	proto.RegisterType((*ListInstructionsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListInstructionsRequest")
	proto.RegisterType((*ListInstructionsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListInstructionsResponse")
	proto.RegisterType((*GetEvaluationRequest)(nil), "google.cloud.datalabeling.v1beta1.GetEvaluationRequest")
	proto.RegisterType((*SearchEvaluationsRequest)(nil), "google.cloud.datalabeling.v1beta1.SearchEvaluationsRequest")
	proto.RegisterType((*SearchEvaluationsResponse)(nil), "google.cloud.datalabeling.v1beta1.SearchEvaluationsResponse")
	proto.RegisterType((*SearchExampleComparisonsRequest)(nil), "google.cloud.datalabeling.v1beta1.SearchExampleComparisonsRequest")
	proto.RegisterType((*SearchExampleComparisonsResponse)(nil), "google.cloud.datalabeling.v1beta1.SearchExampleComparisonsResponse")
	proto.RegisterType((*SearchExampleComparisonsResponse_ExampleComparison)(nil), "google.cloud.datalabeling.v1beta1.SearchExampleComparisonsResponse.ExampleComparison")
	proto.RegisterType((*CreateEvaluationJobRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateEvaluationJobRequest")
	proto.RegisterType((*UpdateEvaluationJobRequest)(nil), "google.cloud.datalabeling.v1beta1.UpdateEvaluationJobRequest")
	proto.RegisterType((*GetEvaluationJobRequest)(nil), "google.cloud.datalabeling.v1beta1.GetEvaluationJobRequest")
	proto.RegisterType((*PauseEvaluationJobRequest)(nil), "google.cloud.datalabeling.v1beta1.PauseEvaluationJobRequest")
	proto.RegisterType((*ResumeEvaluationJobRequest)(nil), "google.cloud.datalabeling.v1beta1.ResumeEvaluationJobRequest")
	proto.RegisterType((*DeleteEvaluationJobRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteEvaluationJobRequest")
	proto.RegisterType((*ListEvaluationJobsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListEvaluationJobsRequest")
	proto.RegisterType((*ListEvaluationJobsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListEvaluationJobsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/data_labeling_service.proto", fileDescriptor_a21c40690da1750b)
}

var fileDescriptor_a21c40690da1750b = []byte{
	// 2850 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5b, 0xdd, 0x6f, 0x23, 0x57,
	0xd9, 0xef, 0xd9, 0x6c, 0xb2, 0xcd, 0x93, 0x8f, 0x75, 0x8e, 0xb3, 0x49, 0x76, 0xb6, 0xdb, 0x37,
	0xef, 0xa0, 0xd2, 0xad, 0xc3, 0xda, 0xc9, 0x66, 0xbb, 0xbb, 0x4d, 0x9a, 0xb6, 0x4e, 0x32, 0x49,
	0xbd, 0xa4, 0x71, 0x70, 0x9c, 0x7e, 0x51, 0x69, 0x18, 0xdb, 0x27, 0xce, 0xec, 0xda, 0x33, 0xc6,
	0x33, 0x4e, 0xb3, 0xad, 0x8a, 0x44, 0x05, 0x45, 0xa2, 0x17, 0x5c, 0x80, 0x7a, 0x01, 0xa2, 0x88,
	0x0b, 0x50, 0x51, 0x29, 0x42, 0x08, 0xee, 0x60, 0xef, 0x00, 0x89, 0xaf, 0x0b, 0x2a, 0x71, 0x81,
	0xc4, 0x1d, 0x7f, 0x00, 0xd7, 0xdc, 0x80, 0xe6, 0xcc, 0x99, 0x2f, 0xcf, 0x8c, 0x7d, 0xc6, 0xbb,
	0x52, 0xc4, 0x9d, 0xe7, 0x9c, 0xf3, 0x3c, 0xcf, 0xef, 0xf9, 0x3a, 0x1f, 0xcf, 0x23, 0xc3, 0x5a,
	0x5d, 0xd7, 0xeb, 0x0d, 0x92, 0xab, 0x36, 0xf4, 0x4e, 0x2d, 0x57, 0x53, 0x4c, 0xa5, 0xa1, 0x54,
	0x48, 0x43, 0xd5, 0xea, 0xb9, 0xe3, 0xa5, 0x0a, 0x31, 0x95, 0x25, 0x3a, 0x28, 0x3b, 0xa3, 0xb2,
	0x41, 0xda, 0xc7, 0x6a, 0x95, 0x64, 0x5b, 0x6d, 0xdd, 0xd4, 0xf1, 0xff, 0xdb, 0xe4, 0x59, 0x4a,
	0x9e, 0xf5, 0x93, 0x67, 0x19, 0xb9, 0xf0, 0x18, 0x93, 0xa0, 0xb4, 0xd4, 0x9c, 0xa2, 0x69, 0xba,
	0xa9, 0x98, 0xaa, 0xae, 0x19, 0x36, 0x03, 0x61, 0xd6, 0x37, 0x5b, 0x6d, 0xa8, 0x44, 0x33, 0xd9,
	0xc4, 0xb5, 0xfe, 0xc0, 0x3c, 0x6e, 0x8c, 0x66, 0x35, 0x09, 0x8d, 0x6c, 0xb4, 0x48, 0x55, 0x36,
	0x88, 0x23, 0x30, 0xc7, 0x67, 0x09, 0x8f, 0x80, 0x03, 0x21, 0x39, 0x56, 0x1a, 0x1d, 0x3f, 0xc2,
	0x1b, 0x49, 0x68, 0xe4, 0x3b, 0x7a, 0x85, 0xd1, 0x3d, 0xdf, 0x9f, 0xee, 0xa8, 0xd3, 0x54, 0x34,
	0xd9, 0xa7, 0x5f, 0x55, 0xd7, 0x0e, 0xd5, 0x3a, 0x63, 0xb0, 0xdc, 0x9f, 0x81, 0xaa, 0x19, 0x66,
	0xbb, 0x53, 0xf5, 0xa1, 0xe5, 0xd0, 0x50, 0x6f, 0x91, 0x76, 0xc0, 0xa1, 0x9f, 0x61, 0x34, 0x0d,
	0x5d, 0xab, 0xb7, 0x3b, 0x9a, 0x66, 0x2d, 0x0e, 0x2d, 0xba, 0xc4, 0x16, 0xd1, 0xaf, 0x4a, 0xe7,
	0x30, 0x47, 0x9a, 0x2d, 0xf3, 0x1e, 0x9b, 0x9c, 0xef, 0x9e, 0x3c, 0x54, 0x49, 0xa3, 0x26, 0x37,
	0x15, 0xe3, 0xae, 0xbd, 0x42, 0x34, 0x61, 0x7a, 0xa3, 0x4d, 0x14, 0x93, 0x6c, 0xda, 0x0e, 0x29,
	0x91, 0x2f, 0x77, 0x88, 0x61, 0xe2, 0x19, 0x18, 0x69, 0x29, 0x6d, 0xa2, 0x99, 0x73, 0x68, 0x1e,
	0x5d, 0x19, 0x2d, 0xb1, 0x2f, 0xbc, 0x09, 0xe7, 0x98, 0xeb, 0xe6, 0xce, 0xcc, 0xa3, 0x2b, 0x63,
	0xd7, 0x32, 0xd9, 0xbe, 0x71, 0x9b, 0x75, 0x78, 0x3b, 0xa4, 0xe2, 0x93, 0x30, 0xb5, 0x4d, 0xcc,
	0x2e, 0x91, 0x18, 0xce, 0x6a, 0x4a, 0x93, 0x30, 0x81, 0xf4, 0xb7, 0xf8, 0x55, 0x04, 0xe9, 0x1d,
	0xd5, 0x70, 0x96, 0x1a, 0xfd, 0xe0, 0xcd, 0xc0, 0xc8, 0xa1, 0xda, 0x30, 0x49, 0x9b, 0xa2, 0x1b,
	0x2d, 0xb1, 0x2f, 0x7c, 0x09, 0x46, 0x5b, 0x4a, 0x9d, 0xc8, 0x86, 0xfa, 0x16, 0x99, 0x1b, 0x9a,
	0x47, 0x57, 0x86, 0x4b, 0x8f, 0x5a, 0x03, 0xfb, 0xea, 0x5b, 0x04, 0x5f, 0x06, 0xa0, 0x93, 0xa6,
	0x7e, 0x97, 0x68, 0x73, 0x67, 0x29, 0x21, 0x5d, 0x5e, 0xb6, 0x06, 0xc4, 0xf7, 0x10, 0x4c, 0x07,
	0x31, 0x18, 0x2d, 0x5d, 0x33, 0x08, 0xde, 0x82, 0x47, 0x99, 0x42, 0xc6, 0x1c, 0x9a, 0x1f, 0x4a,
	0x68, 0x0c, 0x97, 0x16, 0x7f, 0x16, 0xce, 0x6b, 0xe4, 0xc4, 0x94, 0x7d, 0x20, 0x6c, 0xf4, 0x13,
	0xd6, 0xf0, 0x9e, 0x0b, 0x24, 0x03, 0xd3, 0x9b, 0xa4, 0x41, 0x42, 0xbe, 0x8a, 0x32, 0xdc, 0x47,
	0x08, 0xa6, 0x0a, 0xcd, 0x96, 0xde, 0xa6, 0xb0, 0x7b, 0xac, 0xc4, 0x5f, 0x80, 0x71, 0x55, 0x6b,
	0x75, 0x4c, 0x16, 0xe4, 0xcc, 0xad, 0x59, 0x0e, 0x4d, 0x0a, 0x16, 0xd9, 0x06, 0xa5, 0x2a, 0x8d,
	0xa9, 0xde, 0x07, 0xfe, 0x1c, 0xe0, 0x8e, 0x41, 0xda, 0x32, 0x69, 0x2a, 0x6a, 0x43, 0x56, 0x6a,
	0xb5, 0x36, 0x31, 0x0c, 0x6a, 0xf6, 0xd1, 0x52, 0xca, 0x9a, 0x91, 0xac, 0x89, 0xbc, 0x3d, 0x2e,
	0xfe, 0x0b, 0xc1, 0x94, 0x74, 0xc2, 0x03, 0x75, 0x01, 0xa6, 0x58, 0x52, 0x92, 0x9a, 0xec, 0x0f,
	0xc3, 0xd1, 0x52, 0xca, 0x9d, 0x60, 0xc6, 0xf1, 0x85, 0xc2, 0x50, 0x20, 0x14, 0xca, 0x30, 0xa1,
	0x77, 0x4c, 0x9f, 0xc2, 0x67, 0xa9, 0xc2, 0x39, 0x0e, 0x85, 0x8b, 0x94, 0x8e, 0x69, 0x3c, 0xae,
	0xfb, 0xbe, 0x62, 0x54, 0x1e, 0x8e, 0x51, 0xf9, 0x0a, 0x60, 0x16, 0xff, 0x05, 0x93, 0x34, 0x7b,
	0xf9, 0xf1, 0x5d, 0x5f, 0xf0, 0x59, 0x6b, 0x4f, 0x25, 0x03, 0xde, 0x47, 0x70, 0xa1, 0x0b, 0x04,
	0x4b, 0x81, 0xdb, 0x00, 0xf4, 0x4c, 0x53, 0xad, 0x51, 0x96, 0x04, 0x0b, 0x9c, 0x49, 0x40, 0x55,
	0x1f, 0xad, 0x39, 0x3c, 0xb9, 0xd3, 0x60, 0x11, 0x84, 0x6d, 0x62, 0xe6, 0xbb, 0xfc, 0xdd, 0xcb,
	0x88, 0xdf, 0x44, 0xf0, 0x98, 0x85, 0xbf, 0x9b, 0xe6, 0x54, 0x8c, 0xf9, 0x31, 0x82, 0xcb, 0x31,
	0x60, 0x98, 0x51, 0x2b, 0x80, 0x43, 0x61, 0xee, 0x18, 0x77, 0x99, 0xc3, 0xb8, 0x21, 0xd3, 0x4c,
	0x75, 0x27, 0x07, 0xbf, 0xb1, 0x97, 0xe1, 0xb2, 0xbd, 0xe7, 0x24, 0xb1, 0xf7, 0xfd, 0x11, 0x98,
	0xda, 0xb1, 0x50, 0x15, 0x9a, 0x4a, 0x9d, 0x38, 0x2b, 0xbf, 0x02, 0x97, 0x54, 0xeb, 0x5b, 0xae,
	0x36, 0x14, 0xc3, 0x50, 0x0f, 0xd5, 0xaa, 0xff, 0x70, 0x65, 0x69, 0xf8, 0x2c, 0xcf, 0xbe, 0x63,
	0x71, 0xd9, 0x08, 0x30, 0xb1, 0xb3, 0xf0, 0xc5, 0x47, 0x4a, 0x17, 0xd5, 0xb8, 0x49, 0xac, 0xc2,
	0x74, 0x45, 0xef, 0x68, 0x35, 0xeb, 0xea, 0xd5, 0xd2, 0x1b, 0xf7, 0x1c, 0xc1, 0xc3, 0x54, 0xf0,
	0xd3, 0x1c, 0x82, 0xd7, 0x19, 0xf9, 0x9e, 0xde, 0xb8, 0xe7, 0x4a, 0xc4, 0x95, 0xd0, 0x28, 0x7e,
	0x03, 0xce, 0x5b, 0x12, 0x1a, 0xaa, 0x46, 0x1c, 0x29, 0x23, 0x54, 0xca, 0x12, 0x87, 0x94, 0x3d,
	0x46, 0xe9, 0x4a, 0x98, 0x6c, 0x05, 0x46, 0xf0, 0x11, 0xa4, 0x0d, 0x52, 0x6f, 0x12, 0x2d, 0x70,
	0x3b, 0x99, 0x3b, 0xc7, 0xad, 0xc7, 0xbe, 0x8f, 0xda, 0xd3, 0xc3, 0x08, 0x8d, 0xc6, 0xe6, 0xc5,
	0x17, 0x61, 0xbc, 0xa2, 0x18, 0x6a, 0x35, 0x78, 0x66, 0xdc, 0xe2, 0x10, 0xfd, 0xa2, 0x75, 0xb5,
	0xca, 0xbb, 0x37, 0x2b, 0xe7, 0xf4, 0xa0, 0xdc, 0x98, 0xd0, 0x97, 0xe1, 0xdc, 0x21, 0x51, 0xcc,
	0x4e, 0xdb, 0x4e, 0xad, 0x49, 0xae, 0x98, 0x08, 0x85, 0x5b, 0x76, 0xcb, 0xe6, 0x51, 0x72, 0x98,
	0x89, 0x1f, 0x20, 0x38, 0xc7, 0x06, 0xf1, 0x2c, 0xa4, 0xb7, 0xa4, 0x7c, 0xf9, 0xa0, 0x24, 0xc9,
	0x07, 0xbb, 0xfb, 0x7b, 0xd2, 0x46, 0x61, 0xab, 0x20, 0x6d, 0xa6, 0x1e, 0xc1, 0x18, 0x26, 0x37,
	0x76, 0xf2, 0xfb, 0xfb, 0x85, 0xad, 0xc2, 0x46, 0xbe, 0x5c, 0x28, 0xee, 0xa6, 0x10, 0x4e, 0xc1,
	0xf8, 0x7a, 0xf1, 0x60, 0x77, 0xb3, 0xb0, 0xbb, 0x2d, 0xaf, 0x17, 0x5f, 0x4d, 0x9d, 0xc1, 0x17,
	0xe1, 0x42, 0xb1, 0x54, 0x90, 0x76, 0xcb, 0xd2, 0xa6, 0x1c, 0x98, 0x1a, 0xc1, 0x53, 0x30, 0xe1,
	0x8e, 0xec, 0x15, 0x77, 0x5e, 0x4b, 0x0d, 0xe1, 0x71, 0x78, 0xd4, 0xfa, 0xb5, 0x53, 0xd8, 0x95,
	0x52, 0x67, 0x2d, 0x6e, 0xfb, 0xd2, 0xf6, 0x4b, 0xd2, 0x6e, 0xd9, 0xe6, 0x3f, 0xbc, 0x9e, 0x82,
	0xc9, 0xb6, 0x0d, 0x9a, 0xd9, 0x53, 0xfc, 0xae, 0x93, 0x40, 0x2f, 0xab, 0x35, 0xa2, 0xfb, 0x12,
	0xe8, 0xd8, 0xfa, 0x7e, 0xe0, 0x04, 0xa2, 0x5c, 0xe3, 0x12, 0xe8, 0x38, 0x6e, 0x12, 0xb7, 0x61,
	0x56, 0xaf, 0xdc, 0x21, 0x55, 0x53, 0xae, 0x11, 0x93, 0x54, 0xfd, 0xb2, 0x87, 0xb9, 0x03, 0xa0,
	0x48, 0x39, 0x6c, 0x3a, 0x0c, 0x5c, 0xb9, 0x17, 0xf4, 0xa8, 0x09, 0xac, 0xc3, 0x0c, 0x93, 0x69,
	0xb6, 0x95, 0xea, 0x5d, 0x2b, 0x77, 0x03, 0x09, 0x75, 0x93, 0x5b, 0x64, 0x99, 0xd1, 0xbb, 0x12,
	0xa7, 0xf5, 0x88, 0x71, 0xbc, 0x0f, 0xe3, 0xe4, 0x98, 0x68, 0x66, 0x30, 0xab, 0x78, 0xae, 0x43,
	0x92, 0x45, 0xe6, 0x72, 0x1f, 0x23, 0xde, 0xe7, 0xff, 0x5a, 0x1e, 0xf9, 0xa3, 0x2e, 0x9c, 0x47,
	0x8d, 0x01, 0xd3, 0x68, 0x1a, 0x52, 0xc5, 0xf5, 0xdb, 0xd2, 0x46, 0x59, 0xde, 0x94, 0xca, 0xd2,
	0x06, 0x1d, 0x3d, 0x83, 0xd3, 0x70, 0x9e, 0x8d, 0x96, 0x4b, 0xf9, 0x8d, 0xcf, 0x17, 0x76, 0xb7,
	0x53, 0x43, 0x78, 0x14, 0x86, 0xa5, 0x97, 0xa5, 0xdd, 0x72, 0xea, 0x6c, 0x44, 0x72, 0xfc, 0xf1,
	0x2c, 0xa4, 0x28, 0xcc, 0x32, 0x39, 0x71, 0x8f, 0xa1, 0xb7, 0x41, 0x30, 0xad, 0xf3, 0xac, 0x57,
	0x6a, 0xac, 0x72, 0xe8, 0x6f, 0xf1, 0x8c, 0xc9, 0x8c, 0x39, 0x33, 0x66, 0x0e, 0xbf, 0x8b, 0xe0,
	0x32, 0x95, 0x4e, 0x34, 0x53, 0x35, 0xef, 0xc9, 0xe4, 0xc4, 0x0a, 0xd6, 0x70, 0x7e, 0xac, 0x71,
	0x02, 0x90, 0x28, 0x1b, 0xc9, 0xe5, 0xe2, 0x42, 0xa0, 0x3a, 0x46, 0xcf, 0x9e, 0x4e, 0x8c, 0x1d,
	0x78, 0x31, 0x36, 0x42, 0x63, 0x6c, 0x95, 0x37, 0xc6, 0x7c, 0xce, 0x0b, 0x87, 0xd8, 0x2b, 0x1c,
	0x21, 0x36, 0x0b, 0xe9, 0xb2, 0xf4, 0x6a, 0x59, 0x0e, 0xc5, 0x99, 0x00, 0x33, 0x74, 0x42, 0xda,
	0x2d, 0x17, 0xca, 0xaf, 0xc9, 0xd2, 0xab, 0x56, 0x60, 0xd9, 0xd1, 0x16, 0x11, 0x4d, 0xcf, 0xd3,
	0xa7, 0xa8, 0x74, 0xa2, 0x34, 0x5b, 0x0d, 0xd2, 0xeb, 0xf1, 0x11, 0x73, 0x17, 0x74, 0x9f, 0xa8,
	0x8c, 0xc5, 0xa9, 0x3e, 0x51, 0x3d, 0x0c, 0xde, 0x13, 0x95, 0xb0, 0xb1, 0x04, 0x4f, 0x54, 0xc7,
	0x1a, 0x2e, 0x2d, 0xf7, 0x75, 0xf1, 0x43, 0x04, 0x8f, 0xdb, 0xf5, 0x04, 0x2f, 0x6e, 0xf6, 0x5b,
	0xa4, 0xba, 0xdf, 0xbf, 0xb2, 0x50, 0x83, 0x74, 0x44, 0x45, 0x89, 0x85, 0xeb, 0x75, 0xfe, 0x6b,
	0xaf, 0x4f, 0xe2, 0x94, 0xd2, 0x3d, 0x24, 0x2e, 0xc1, 0x25, 0xef, 0xf1, 0x10, 0x06, 0x17, 0x75,
	0x9b, 0x7d, 0x3f, 0x78, 0x61, 0xf7, 0x88, 0x4e, 0xc5, 0xd5, 0x3f, 0x47, 0xf0, 0x78, 0x1c, 0x1a,
	0xe6, 0xf4, 0x43, 0x98, 0x8e, 0xb0, 0xa4, 0x13, 0x00, 0x83, 0x99, 0x12, 0x87, 0x4c, 0xc9, 0x1f,
	0x14, 0xd7, 0xe1, 0xf1, 0xc0, 0x1b, 0x82, 0xcf, 0xec, 0x5f, 0x43, 0x30, 0x67, 0x87, 0x52, 0xc1,
	0xab, 0xa6, 0xf5, 0xb3, 0xf8, 0x1e, 0x8c, 0xf9, 0x6a, 0x6f, 0x89, 0x6a, 0x19, 0x9e, 0x0c, 0x3f,
	0x0b, 0x71, 0x01, 0x2e, 0x6c, 0x13, 0x33, 0x02, 0x42, 0x14, 0xe6, 0x2c, 0xcc, 0xd9, 0x9a, 0x72,
	0xae, 0xff, 0x3a, 0x82, 0x59, 0xcb, 0x99, 0xbe, 0xe5, 0xa7, 0x12, 0x54, 0x1f, 0x20, 0x98, 0x0b,
	0xe3, 0x60, 0xe1, 0x54, 0x82, 0x71, 0x9f, 0x41, 0x9c, 0x30, 0x4a, 0x6a, 0xd4, 0x00, 0x8f, 0x24,
	0x25, 0x2f, 0x6b, 0x77, 0x76, 0xeb, 0xb8, 0xbd, 0x8c, 0xf9, 0x1e, 0x82, 0xb9, 0x7d, 0xa2, 0xb4,
	0xab, 0x47, 0xde, 0xfa, 0x53, 0xb1, 0xe6, 0x77, 0x10, 0x5c, 0x8c, 0x00, 0xc2, 0xcc, 0x59, 0x84,
	0x31, 0xaf, 0x2e, 0xed, 0x58, 0xf3, 0x2a, 0xd7, 0xfd, 0xd2, 0xb5, 0x82, 0x9f, 0x03, 0xb7, 0x2d,
	0x3b, 0xf0, 0x7f, 0x0c, 0x95, 0xbd, 0xab, 0x6f, 0xe8, 0xcd, 0x96, 0xd2, 0x56, 0x0d, 0x0e, 0x2b,
	0x05, 0xac, 0x71, 0xa6, 0xa7, 0x35, 0x86, 0xba, 0xad, 0xf1, 0x93, 0x21, 0x98, 0x8f, 0x97, 0xcb,
	0x8c, 0xf2, 0x1e, 0x82, 0x34, 0x3b, 0x6c, 0xe4, 0xaa, 0x37, 0xcf, 0xac, 0x73, 0xc0, 0xf5, 0xa6,
	0xed, 0x2d, 0x22, 0x1b, 0x9a, 0x2a, 0x61, 0x12, 0x5a, 0xcd, 0x6b, 0x4c, 0xe1, 0x53, 0x5a, 0xb4,
	0xec, 0x22, 0xc7, 0x6f, 0xc0, 0x74, 0xbd, 0xad, 0x77, 0xb4, 0x9a, 0x6c, 0xb6, 0x3b, 0xe6, 0x91,
	0xcc, 0x04, 0x50, 0x6b, 0x26, 0x3b, 0x7a, 0xb1, 0xcd, 0xa7, 0x6c, 0xb1, 0x61, 0x63, 0xf8, 0x4b,
	0x30, 0xd3, 0xd4, 0x6b, 0xa4, 0x21, 0x57, 0xe9, 0xb6, 0x58, 0x93, 0xdd, 0xa3, 0xfd, 0x4c, 0xe2,
	0xa3, 0x7d, 0x9a, 0x72, 0xb2, 0xf7, 0xd7, 0x9a, 0x73, 0x6d, 0x10, 0x4f, 0x40, 0xb0, 0x87, 0xbc,
	0x58, 0xbb, 0xad, 0x57, 0xfa, 0x45, 0xc7, 0x3a, 0x0c, 0xdd, 0xd1, 0x2b, 0x6c, 0xb3, 0x5d, 0x4c,
	0x14, 0xc9, 0x16, 0x77, 0x8b, 0x58, 0xfc, 0x05, 0x02, 0xe1, 0xa0, 0x55, 0x8b, 0x13, 0xfd, 0x0a,
	0x4c, 0x06, 0x9b, 0x39, 0xcc, 0xa4, 0xc9, 0xa5, 0x4d, 0x10, 0xff, 0x27, 0x5e, 0x85, 0xb1, 0x0e,
	0x15, 0x4b, 0x9b, 0x22, 0x4c, 0x07, 0xc1, 0xe1, 0xea, 0xf4, 0x4d, 0xb2, 0x5b, 0x2a, 0x69, 0xd4,
	0x5e, 0x52, 0x8c, 0xbb, 0x25, 0xb0, 0x97, 0x5b, 0xbf, 0xc5, 0xab, 0x30, 0x1b, 0xd8, 0x9d, 0x7c,
	0x80, 0xa3, 0x36, 0xa8, 0x1c, 0x5c, 0xdc, 0x53, 0x3a, 0x06, 0xe1, 0x26, 0x58, 0x04, 0xa1, 0x44,
	0x8c, 0x4e, 0x33, 0x11, 0x85, 0x7d, 0x00, 0x71, 0x53, 0x7c, 0x03, 0xc1, 0x45, 0x7a, 0x75, 0xf4,
	0x13, 0x9c, 0xca, 0xb6, 0xf9, 0x03, 0x04, 0x42, 0x14, 0x12, 0xb6, 0x45, 0xbc, 0x06, 0xe7, 0x83,
	0x21, 0xe0, 0xec, 0x0e, 0xc9, 0x63, 0x60, 0x32, 0x10, 0x03, 0xdc, 0x49, 0x7f, 0xed, 0xdf, 0x4b,
	0x90, 0xde, 0x54, 0x4c, 0x65, 0x87, 0xb1, 0xdf, 0xb7, 0x1b, 0xb8, 0xf8, 0xc7, 0x08, 0x26, 0x02,
	0x5d, 0x34, 0xcc, 0x53, 0x96, 0x88, 0xea, 0xbb, 0x09, 0x09, 0x3a, 0x48, 0xe2, 0xe2, 0xbb, 0x9f,
	0xfe, 0xf3, 0xdb, 0x67, 0x32, 0xe2, 0x13, 0x6e, 0x0b, 0xf1, 0x6d, 0xdb, 0x3d, 0x6b, 0xad, 0xb6,
	0x7e, 0x87, 0x54, 0x4d, 0x23, 0x97, 0x79, 0xc7, 0xe9, 0xb4, 0x1a, 0x2b, 0x28, 0x83, 0xbf, 0x8f,
	0x00, 0xbc, 0xc6, 0x1b, 0xe6, 0xb9, 0x0a, 0x86, 0xfa, 0x74, 0x89, 0x20, 0x5e, 0xa5, 0x10, 0x9f,
	0xc4, 0x3e, 0x88, 0x56, 0xd4, 0xf9, 0x00, 0xba, 0xf8, 0x72, 0x99, 0x77, 0xf0, 0xcf, 0x10, 0x8c,
	0xfb, 0x5b, 0x6d, 0xf8, 0x06, 0xcf, 0x73, 0x32, 0xdc, 0x1f, 0x14, 0x6e, 0x26, 0xa6, 0xb3, 0xa3,
	0x2c, 0x0a, 0x70, 0x0f, 0x9b, 0xe2, 0x6f, 0x21, 0x98, 0x08, 0xf4, 0xe4, 0xb8, 0x3c, 0x1f, 0xd5,
	0xc5, 0x13, 0x66, 0x42, 0x9b, 0x8e, 0xd4, 0x6c, 0x99, 0xf7, 0x1c, 0x44, 0x19, 0x4e, 0x13, 0x7e,
	0x88, 0x00, 0xbc, 0xc6, 0x1f, 0x97, 0x8b, 0x43, 0x7d, 0x42, 0xe1, 0xb2, 0x43, 0xe5, 0x6b, 0x3d,
	0x67, 0x8b, 0x4e, 0xeb, 0x59, 0x5c, 0xa5, 0x90, 0x9e, 0x16, 0x17, 0xb9, 0x20, 0xad, 0xa8, 0x2e,
	0x7f, 0x2b, 0x06, 0x2d, 0x80, 0x5e, 0xbb, 0x8f, 0x0b, 0x60, 0xa8, 0x3b, 0xf8, 0x90, 0x01, 0x92,
	0x13, 0x3f, 0xc0, 0x9f, 0x22, 0x18, 0xf3, 0x75, 0xe7, 0xf0, 0xd3, 0xfc, 0x59, 0xe2, 0xeb, 0xe6,
	0x09, 0x49, 0xda, 0x60, 0xe2, 0x33, 0x14, 0xf0, 0x32, 0x5e, 0xe2, 0x01, 0x9c, 0x73, 0x7b, 0x66,
	0x96, 0xc3, 0x7f, 0x83, 0x60, 0x22, 0xd0, 0x9c, 0xc3, 0x49, 0x82, 0xdf, 0xdf, 0x53, 0x14, 0x6e,
	0x25, 0x27, 0x64, 0x69, 0x13, 0x81, 0x3f, 0x94, 0x36, 0x7e, 0x93, 0x7b, 0x2a, 0xe0, 0x3f, 0x21,
	0x48, 0x47, 0xf4, 0xf3, 0xf0, 0x1a, 0x9f, 0xd9, 0x63, 0xfa, 0x52, 0xc2, 0x20, 0x8d, 0x32, 0x31,
	0x4f, 0xd5, 0x58, 0xc5, 0xcf, 0x70, 0xb9, 0x21, 0xd4, 0x55, 0xb3, 0xdc, 0xf1, 0x0f, 0xd6, 0x2b,
	0x0d, 0xb5, 0xf7, 0xf0, 0xf3, 0x9c, 0xd6, 0x8d, 0xeb, 0x52, 0x0a, 0x2f, 0x0c, 0xce, 0x80, 0xb9,
	0x29, 0x42, 0xbf, 0xde, 0x6e, 0x0a, 0x37, 0x0e, 0x7f, 0x85, 0x60, 0x26, 0xba, 0x23, 0x88, 0x5f,
	0xe0, 0xde, 0xfa, 0xe2, 0x9c, 0x16, 0xb7, 0x07, 0x32, 0xdc, 0x99, 0x07, 0xf0, 0xcb, 0x0f, 0x11,
	0x80, 0xd7, 0x24, 0xe2, 0xda, 0x76, 0x42, 0x3d, 0xa5, 0x7e, 0xdb, 0xce, 0x73, 0x14, 0xe6, 0x2d,
	0x71, 0x99, 0xd7, 0xbc, 0xb4, 0x59, 0xb9, 0x42, 0x05, 0x5b, 0x3b, 0x8f, 0x8b, 0x91, 0x16, 0xe0,
	0xf9, 0x31, 0xfa, 0xeb, 0xf5, 0x0f, 0x1d, 0x23, 0xed, 0x07, 0x79, 0x18, 0x3f, 0x44, 0x30, 0xea,
	0x16, 0x70, 0xf1, 0xf2, 0x00, 0xe5, 0xde, 0x7e, 0x08, 0xd7, 0x28, 0xc2, 0x9b, 0xe2, 0x35, 0x5e,
	0x84, 0x26, 0x39, 0x31, 0x3d, 0x80, 0xbf, 0xb6, 0xef, 0x38, 0xce, 0xa3, 0x89, 0xf3, 0x8e, 0x13,
	0x2c, 0x00, 0x0b, 0x09, 0x9e, 0x52, 0xe2, 0x0e, 0xc5, 0xbb, 0x85, 0x37, 0x07, 0x0d, 0xce, 0x9c,
	0xf3, 0x8e, 0xb3, 0xe2, 0xf4, 0xcf, 0xec, 0x0a, 0xe4, 0xbc, 0xc9, 0xb8, 0xaf, 0x40, 0x5d, 0xf5,
	0x67, 0xee, 0x2b, 0x50, 0x77, 0xcd, 0x38, 0x4a, 0x9f, 0x5e, 0xf6, 0x8f, 0x4c, 0x37, 0x57, 0x25,
	0xfc, 0x17, 0x04, 0xb3, 0x31, 0x15, 0x61, 0x9c, 0xe7, 0xbe, 0x25, 0xc7, 0x55, 0x0e, 0x85, 0x81,
	0xaa, 0x99, 0xe2, 0x0a, 0x55, 0xf1, 0xba, 0x98, 0xeb, 0x79, 0xcb, 0x0b, 0x97, 0x3c, 0xad, 0xf8,
	0xfa, 0x2d, 0xa2, 0x35, 0xa9, 0xb0, 0x36, 0xcf, 0x25, 0x3a, 0xb0, 0x1e, 0x96, 0x2a, 0x37, 0xa9,
	0x2a, 0x4b, 0x38, 0x17, 0x1f, 0x7d, 0x61, 0x3d, 0xac, 0x40, 0xfb, 0x1b, 0x82, 0x99, 0xe8, 0x42,
	0x32, 0x4e, 0x78, 0xd0, 0x84, 0x2b, 0xe2, 0x42, 0xfe, 0x01, 0x38, 0xb0, 0x30, 0x8c, 0x50, 0x8c,
	0xcb, 0x47, 0xf8, 0x13, 0x04, 0xb3, 0x31, 0xf5, 0x66, 0xae, 0x88, 0xeb, 0x5d, 0xab, 0x8e, 0x3d,
	0xa3, 0x18, 0xde, 0x4c, 0x62, 0x47, 0xfc, 0x08, 0xc1, 0x54, 0xa8, 0xd0, 0x8d, 0x57, 0xb9, 0x73,
	0x23, 0x5c, 0x6b, 0xee, 0xb7, 0xc3, 0x5e, 0xa7, 0x50, 0xb3, 0xe2, 0x53, 0x3d, 0x4d, 0xeb, 0x2f,
	0xd8, 0x5a, 0x81, 0xff, 0x09, 0x82, 0xc9, 0x60, 0x29, 0x1c, 0xdf, 0xe2, 0x0b, 0xf9, 0x08, 0x84,
	0x09, 0xcb, 0xc7, 0xe2, 0x12, 0x85, 0xbc, 0x80, 0x9f, 0x8a, 0xb7, 0xae, 0x1f, 0xaf, 0x65, 0xd7,
	0xfb, 0x08, 0x52, 0xdd, 0x45, 0x6d, 0xbc, 0xc2, 0x19, 0x98, 0x11, 0x15, 0x79, 0x61, 0x75, 0x20,
	0x5a, 0x16, 0xce, 0x11, 0x0a, 0xf4, 0xb1, 0x39, 0xfe, 0x1e, 0x82, 0xa9, 0x50, 0x3b, 0x81, 0x2b,
	0x30, 0xe2, 0x9a, 0x10, 0xb1, 0xc1, 0xcb, 0xd0, 0x65, 0x12, 0x98, 0xf7, 0x97, 0x08, 0x26, 0x02,
	0xd5, 0x2f, 0xae, 0x77, 0x47, 0x54, 0x35, 0x5f, 0x48, 0x56, 0xfd, 0x76, 0x5e, 0x77, 0x78, 0x99,
	0xeb, 0xc0, 0xf5, 0x95, 0xca, 0x2d, 0xd8, 0xbf, 0x47, 0x30, 0x15, 0x2a, 0xce, 0x73, 0x19, 0x35,
	0xae, 0xb7, 0x20, 0x3c, 0x3b, 0x18, 0x71, 0xa2, 0x7d, 0xce, 0xa7, 0xc5, 0x8a, 0x41, 0x79, 0xe1,
	0xff, 0x78, 0xfd, 0x8e, 0x70, 0x1d, 0x7b, 0xfd, 0x81, 0x4a, 0xe6, 0xb6, 0x5e, 0x1b, 0x0f, 0xa1,
	0xec, 0x2e, 0xbe, 0x4e, 0xd5, 0x2b, 0x8b, 0x45, 0xce, 0xdb, 0x44, 0xd0, 0x5d, 0xb9, 0x70, 0x89,
	0x9e, 0xa9, 0x6f, 0xed, 0x48, 0xf7, 0x11, 0xa4, 0x23, 0xea, 0xd5, 0x5c, 0x4f, 0xc7, 0xf8, 0x3a,
	0xb7, 0x90, 0xb8, 0xa0, 0x28, 0xde, 0xa0, 0x4a, 0x2e, 0x8a, 0x0b, 0x9c, 0x3e, 0xbc, 0xad, 0x57,
	0xe8, 0x96, 0xfa, 0x77, 0x04, 0xe9, 0x88, 0xaa, 0x37, 0x97, 0x02, 0xf1, 0xd5, 0xf2, 0x01, 0x14,
	0x28, 0x51, 0x05, 0x76, 0xae, 0xad, 0x78, 0x0a, 0x74, 0xfd, 0x79, 0xa2, 0x3b, 0xc3, 0x82, 0xca,
	0xe4, 0x32, 0xef, 0xac, 0x74, 0x55, 0xe8, 0xad, 0x97, 0x62, 0xaa, 0xbb, 0x3c, 0xce, 0xb5, 0xff,
	0xc6, 0xd4, 0xd4, 0x07, 0x50, 0x6b, 0x99, 0xaa, 0x75, 0x15, 0x2f, 0xc4, 0xef, 0x14, 0x21, 0x3d,
	0xf0, 0x47, 0x08, 0x70, 0xb8, 0x4e, 0x8f, 0x79, 0xb2, 0x3c, 0xb6, 0xbc, 0x1f, 0xbb, 0xf1, 0x3e,
	0x4b, 0x11, 0xde, 0x10, 0x97, 0x12, 0x20, 0x5c, 0x69, 0x59, 0x62, 0xac, 0xf8, 0xf9, 0x18, 0x41,
	0x3a, 0xa2, 0x43, 0xc0, 0x15, 0x3f, 0xf1, 0x9d, 0x85, 0x58, 0xb0, 0x11, 0x2f, 0xb3, 0xfe, 0x60,
	0xdb, 0x54, 0x0e, 0x7b, 0xde, 0xa6, 0x23, 0xba, 0x13, 0x5c, 0x68, 0xe3, 0xbb, 0x1a, 0xb1, 0x68,
	0x99, 0xf3, 0x33, 0x89, 0x9c, 0xff, 0x3b, 0x04, 0x38, 0xdc, 0x84, 0xe0, 0x72, 0x7e, 0x6c, 0x17,
	0x45, 0x58, 0x1b, 0x90, 0x9a, 0x6d, 0xa1, 0x11, 0x51, 0xdc, 0x77, 0x77, 0x11, 0x8a, 0x7f, 0xc8,
	0x5f, 0x0a, 0x08, 0xb2, 0x21, 0x28, 0x2d, 0xd5, 0xc8, 0x56, 0xf5, 0xe6, 0x5f, 0xf3, 0xd9, 0x23,
	0xd3, 0x6c, 0x19, 0x2b, 0xb9, 0xdc, 0x9b, 0x6f, 0xbe, 0xd9, 0x35, 0x99, 0x53, 0x3a, 0xe6, 0x91,
	0xfd, 0x57, 0xa5, 0xab, 0xad, 0x86, 0x62, 0x1e, 0xea, 0xed, 0xe6, 0xfa, 0x09, 0x3c, 0x51, 0xd5,
	0x9b, 0xfd, 0x35, 0xd9, 0x43, 0xaf, 0xbf, 0xc4, 0x16, 0xd5, 0xf5, 0x86, 0xa2, 0xd5, 0xb3, 0x7a,
	0xbb, 0x9e, 0xab, 0x13, 0x8d, 0xba, 0x27, 0xe7, 0x49, 0xea, 0xf1, 0x5f, 0xa8, 0x55, 0xff, 0x60,
	0x65, 0x84, 0x52, 0x2e, 0xff, 0x37, 0x00, 0x00, 0xff, 0xff, 0x35, 0xda, 0xd3, 0x94, 0x61, 0x37,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataLabelingServiceClient is the client API for DataLabelingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataLabelingServiceClient interface {
	// Creates dataset. If success return a Dataset resource.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Gets dataset by resource name.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets under a project. Pagination is supported.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a dataset by resource name.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Imports data into dataset based on source locations defined in request.
	// It can be called multiple times for the same dataset. Each dataset can
	// only have one long running operation running on it. For example, no
	// labeling task (also long running operation) can be started while
	// importing is still ongoing. Vice versa.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports data and annotations from dataset.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a data item in a dataset by resource name. This API can be
	// called after data are imported into dataset.
	GetDataItem(ctx context.Context, in *GetDataItemRequest, opts ...grpc.CallOption) (*DataItem, error)
	// Lists data items in a dataset. This API can be called after data
	// are imported into dataset. Pagination is supported.
	ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error)
	// Gets an annotated dataset by resource name.
	GetAnnotatedDataset(ctx context.Context, in *GetAnnotatedDatasetRequest, opts ...grpc.CallOption) (*AnnotatedDataset, error)
	// Lists annotated datasets for a dataset. Pagination is supported.
	ListAnnotatedDatasets(ctx context.Context, in *ListAnnotatedDatasetsRequest, opts ...grpc.CallOption) (*ListAnnotatedDatasetsResponse, error)
	// Deletes an annotated dataset by resource name.
	DeleteAnnotatedDataset(ctx context.Context, in *DeleteAnnotatedDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Starts a labeling task for image. The type of image labeling task is
	// configured by feature in the request.
	LabelImage(ctx context.Context, in *LabelImageRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts a labeling task for video. The type of video labeling task is
	// configured by feature in the request.
	LabelVideo(ctx context.Context, in *LabelVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts a labeling task for text. The type of text labeling task is
	// configured by feature in the request.
	LabelText(ctx context.Context, in *LabelTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an example by resource name, including both data and annotation.
	GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error)
	// Lists examples in an annotated dataset. Pagination is supported.
	ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error)
	// Creates an annotation spec set by providing a set of labels.
	CreateAnnotationSpecSet(ctx context.Context, in *CreateAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error)
	// Gets an annotation spec set by resource name.
	GetAnnotationSpecSet(ctx context.Context, in *GetAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error)
	// Lists annotation spec sets for a project. Pagination is supported.
	ListAnnotationSpecSets(ctx context.Context, in *ListAnnotationSpecSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecSetsResponse, error)
	// Deletes an annotation spec set by resource name.
	DeleteAnnotationSpecSet(ctx context.Context, in *DeleteAnnotationSpecSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates an instruction for how data should be labeled.
	CreateInstruction(ctx context.Context, in *CreateInstructionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an instruction by resource name.
	GetInstruction(ctx context.Context, in *GetInstructionRequest, opts ...grpc.CallOption) (*Instruction, error)
	// Lists instructions for a project. Pagination is supported.
	ListInstructions(ctx context.Context, in *ListInstructionsRequest, opts ...grpc.CallOption) (*ListInstructionsResponse, error)
	// Deletes an instruction object by resource name.
	DeleteInstruction(ctx context.Context, in *DeleteInstructionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets an evaluation by resource name.
	GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error)
	// Searchs evaluations within a project. Supported filter: evaluation_job,
	// evaluation_time.
	SearchEvaluations(ctx context.Context, in *SearchEvaluationsRequest, opts ...grpc.CallOption) (*SearchEvaluationsResponse, error)
	// Searchs example comparisons in evaluation, in format of examples
	// of both ground truth and prediction(s). It is represented as a search with
	// evaluation id.
	SearchExampleComparisons(ctx context.Context, in *SearchExampleComparisonsRequest, opts ...grpc.CallOption) (*SearchExampleComparisonsResponse, error)
	// Creates an evaluation job.
	CreateEvaluationJob(ctx context.Context, in *CreateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error)
	// Updates an evaluation job.
	UpdateEvaluationJob(ctx context.Context, in *UpdateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error)
	// Gets an evaluation job by resource name.
	GetEvaluationJob(ctx context.Context, in *GetEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error)
	// Pauses an evaluation job. Pausing a evaluation job that is already in
	// PAUSED state will be a no-op.
	PauseEvaluationJob(ctx context.Context, in *PauseEvaluationJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Resumes a paused evaluation job. Deleted evaluation job can't be resumed.
	// Resuming a running evaluation job will be a no-op.
	ResumeEvaluationJob(ctx context.Context, in *ResumeEvaluationJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Stops and deletes an evaluation job.
	DeleteEvaluationJob(ctx context.Context, in *DeleteEvaluationJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists all evaluation jobs within a project with possible filters.
	// Pagination is supported.
	ListEvaluationJobs(ctx context.Context, in *ListEvaluationJobsRequest, opts ...grpc.CallOption) (*ListEvaluationJobsResponse, error)
}

type dataLabelingServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataLabelingServiceClient(cc *grpc.ClientConn) DataLabelingServiceClient {
	return &dataLabelingServiceClient{cc}
}

func (c *dataLabelingServiceClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetDataItem(ctx context.Context, in *GetDataItemRequest, opts ...grpc.CallOption) (*DataItem, error) {
	out := new(DataItem)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataItem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error) {
	out := new(ListDataItemsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDataItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetAnnotatedDataset(ctx context.Context, in *GetAnnotatedDatasetRequest, opts ...grpc.CallOption) (*AnnotatedDataset, error) {
	out := new(AnnotatedDataset)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotatedDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListAnnotatedDatasets(ctx context.Context, in *ListAnnotatedDatasetsRequest, opts ...grpc.CallOption) (*ListAnnotatedDatasetsResponse, error) {
	out := new(ListAnnotatedDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotatedDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteAnnotatedDataset(ctx context.Context, in *DeleteAnnotatedDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotatedDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelImage(ctx context.Context, in *LabelImageRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelVideo(ctx context.Context, in *LabelVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelText(ctx context.Context, in *LabelTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error) {
	out := new(Example)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetExample", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error) {
	out := new(ListExamplesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListExamples", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateAnnotationSpecSet(ctx context.Context, in *CreateAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error) {
	out := new(AnnotationSpecSet)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateAnnotationSpecSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetAnnotationSpecSet(ctx context.Context, in *GetAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error) {
	out := new(AnnotationSpecSet)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotationSpecSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListAnnotationSpecSets(ctx context.Context, in *ListAnnotationSpecSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecSetsResponse, error) {
	out := new(ListAnnotationSpecSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotationSpecSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteAnnotationSpecSet(ctx context.Context, in *DeleteAnnotationSpecSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotationSpecSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateInstruction(ctx context.Context, in *CreateInstructionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateInstruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetInstruction(ctx context.Context, in *GetInstructionRequest, opts ...grpc.CallOption) (*Instruction, error) {
	out := new(Instruction)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetInstruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListInstructions(ctx context.Context, in *ListInstructionsRequest, opts ...grpc.CallOption) (*ListInstructionsResponse, error) {
	out := new(ListInstructionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListInstructions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteInstruction(ctx context.Context, in *DeleteInstructionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteInstruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error) {
	out := new(Evaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) SearchEvaluations(ctx context.Context, in *SearchEvaluationsRequest, opts ...grpc.CallOption) (*SearchEvaluationsResponse, error) {
	out := new(SearchEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/SearchEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) SearchExampleComparisons(ctx context.Context, in *SearchExampleComparisonsRequest, opts ...grpc.CallOption) (*SearchExampleComparisonsResponse, error) {
	out := new(SearchExampleComparisonsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/SearchExampleComparisons", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateEvaluationJob(ctx context.Context, in *CreateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error) {
	out := new(EvaluationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateEvaluationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) UpdateEvaluationJob(ctx context.Context, in *UpdateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error) {
	out := new(EvaluationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/UpdateEvaluationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetEvaluationJob(ctx context.Context, in *GetEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error) {
	out := new(EvaluationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetEvaluationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) PauseEvaluationJob(ctx context.Context, in *PauseEvaluationJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/PauseEvaluationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ResumeEvaluationJob(ctx context.Context, in *ResumeEvaluationJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ResumeEvaluationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteEvaluationJob(ctx context.Context, in *DeleteEvaluationJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteEvaluationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListEvaluationJobs(ctx context.Context, in *ListEvaluationJobsRequest, opts ...grpc.CallOption) (*ListEvaluationJobsResponse, error) {
	out := new(ListEvaluationJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListEvaluationJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataLabelingServiceServer is the server API for DataLabelingService service.
type DataLabelingServiceServer interface {
	// Creates dataset. If success return a Dataset resource.
	CreateDataset(context.Context, *CreateDatasetRequest) (*Dataset, error)
	// Gets dataset by resource name.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets under a project. Pagination is supported.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a dataset by resource name.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*empty.Empty, error)
	// Imports data into dataset based on source locations defined in request.
	// It can be called multiple times for the same dataset. Each dataset can
	// only have one long running operation running on it. For example, no
	// labeling task (also long running operation) can be started while
	// importing is still ongoing. Vice versa.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports data and annotations from dataset.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Gets a data item in a dataset by resource name. This API can be
	// called after data are imported into dataset.
	GetDataItem(context.Context, *GetDataItemRequest) (*DataItem, error)
	// Lists data items in a dataset. This API can be called after data
	// are imported into dataset. Pagination is supported.
	ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error)
	// Gets an annotated dataset by resource name.
	GetAnnotatedDataset(context.Context, *GetAnnotatedDatasetRequest) (*AnnotatedDataset, error)
	// Lists annotated datasets for a dataset. Pagination is supported.
	ListAnnotatedDatasets(context.Context, *ListAnnotatedDatasetsRequest) (*ListAnnotatedDatasetsResponse, error)
	// Deletes an annotated dataset by resource name.
	DeleteAnnotatedDataset(context.Context, *DeleteAnnotatedDatasetRequest) (*empty.Empty, error)
	// Starts a labeling task for image. The type of image labeling task is
	// configured by feature in the request.
	LabelImage(context.Context, *LabelImageRequest) (*longrunning.Operation, error)
	// Starts a labeling task for video. The type of video labeling task is
	// configured by feature in the request.
	LabelVideo(context.Context, *LabelVideoRequest) (*longrunning.Operation, error)
	// Starts a labeling task for text. The type of text labeling task is
	// configured by feature in the request.
	LabelText(context.Context, *LabelTextRequest) (*longrunning.Operation, error)
	// Gets an example by resource name, including both data and annotation.
	GetExample(context.Context, *GetExampleRequest) (*Example, error)
	// Lists examples in an annotated dataset. Pagination is supported.
	ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error)
	// Creates an annotation spec set by providing a set of labels.
	CreateAnnotationSpecSet(context.Context, *CreateAnnotationSpecSetRequest) (*AnnotationSpecSet, error)
	// Gets an annotation spec set by resource name.
	GetAnnotationSpecSet(context.Context, *GetAnnotationSpecSetRequest) (*AnnotationSpecSet, error)
	// Lists annotation spec sets for a project. Pagination is supported.
	ListAnnotationSpecSets(context.Context, *ListAnnotationSpecSetsRequest) (*ListAnnotationSpecSetsResponse, error)
	// Deletes an annotation spec set by resource name.
	DeleteAnnotationSpecSet(context.Context, *DeleteAnnotationSpecSetRequest) (*empty.Empty, error)
	// Creates an instruction for how data should be labeled.
	CreateInstruction(context.Context, *CreateInstructionRequest) (*longrunning.Operation, error)
	// Gets an instruction by resource name.
	GetInstruction(context.Context, *GetInstructionRequest) (*Instruction, error)
	// Lists instructions for a project. Pagination is supported.
	ListInstructions(context.Context, *ListInstructionsRequest) (*ListInstructionsResponse, error)
	// Deletes an instruction object by resource name.
	DeleteInstruction(context.Context, *DeleteInstructionRequest) (*empty.Empty, error)
	// Gets an evaluation by resource name.
	GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error)
	// Searchs evaluations within a project. Supported filter: evaluation_job,
	// evaluation_time.
	SearchEvaluations(context.Context, *SearchEvaluationsRequest) (*SearchEvaluationsResponse, error)
	// Searchs example comparisons in evaluation, in format of examples
	// of both ground truth and prediction(s). It is represented as a search with
	// evaluation id.
	SearchExampleComparisons(context.Context, *SearchExampleComparisonsRequest) (*SearchExampleComparisonsResponse, error)
	// Creates an evaluation job.
	CreateEvaluationJob(context.Context, *CreateEvaluationJobRequest) (*EvaluationJob, error)
	// Updates an evaluation job.
	UpdateEvaluationJob(context.Context, *UpdateEvaluationJobRequest) (*EvaluationJob, error)
	// Gets an evaluation job by resource name.
	GetEvaluationJob(context.Context, *GetEvaluationJobRequest) (*EvaluationJob, error)
	// Pauses an evaluation job. Pausing a evaluation job that is already in
	// PAUSED state will be a no-op.
	PauseEvaluationJob(context.Context, *PauseEvaluationJobRequest) (*empty.Empty, error)
	// Resumes a paused evaluation job. Deleted evaluation job can't be resumed.
	// Resuming a running evaluation job will be a no-op.
	ResumeEvaluationJob(context.Context, *ResumeEvaluationJobRequest) (*empty.Empty, error)
	// Stops and deletes an evaluation job.
	DeleteEvaluationJob(context.Context, *DeleteEvaluationJobRequest) (*empty.Empty, error)
	// Lists all evaluation jobs within a project with possible filters.
	// Pagination is supported.
	ListEvaluationJobs(context.Context, *ListEvaluationJobsRequest) (*ListEvaluationJobsResponse, error)
}

func RegisterDataLabelingServiceServer(s *grpc.Server, srv DataLabelingServiceServer) {
	s.RegisterService(&_DataLabelingService_serviceDesc, srv)
}

func _DataLabelingService_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetDataItem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetDataItem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataItem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetDataItem(ctx, req.(*GetDataItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDataItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListDataItems(ctx, req.(*ListDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetAnnotatedDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotatedDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetAnnotatedDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotatedDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetAnnotatedDataset(ctx, req.(*GetAnnotatedDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListAnnotatedDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotatedDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListAnnotatedDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotatedDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListAnnotatedDatasets(ctx, req.(*ListAnnotatedDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteAnnotatedDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotatedDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteAnnotatedDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotatedDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteAnnotatedDataset(ctx, req.(*DeleteAnnotatedDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelImage(ctx, req.(*LabelImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelVideo(ctx, req.(*LabelVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelText(ctx, req.(*LabelTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetExample",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetExample(ctx, req.(*GetExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListExamples",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListExamples(ctx, req.(*ListExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateAnnotationSpecSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateAnnotationSpecSet(ctx, req.(*CreateAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotationSpecSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetAnnotationSpecSet(ctx, req.(*GetAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListAnnotationSpecSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationSpecSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListAnnotationSpecSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotationSpecSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListAnnotationSpecSets(ctx, req.(*ListAnnotationSpecSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotationSpecSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteAnnotationSpecSet(ctx, req.(*DeleteAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateInstruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateInstruction(ctx, req.(*CreateInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetInstruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetInstruction(ctx, req.(*GetInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstructionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListInstructions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListInstructions(ctx, req.(*ListInstructionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteInstruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteInstruction(ctx, req.(*DeleteInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetEvaluation(ctx, req.(*GetEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_SearchEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).SearchEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/SearchEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).SearchEvaluations(ctx, req.(*SearchEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_SearchExampleComparisons_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchExampleComparisonsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).SearchExampleComparisons(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/SearchExampleComparisons",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).SearchExampleComparisons(ctx, req.(*SearchExampleComparisonsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateEvaluationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateEvaluationJob(ctx, req.(*CreateEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_UpdateEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).UpdateEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/UpdateEvaluationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).UpdateEvaluationJob(ctx, req.(*UpdateEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetEvaluationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetEvaluationJob(ctx, req.(*GetEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_PauseEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).PauseEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/PauseEvaluationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).PauseEvaluationJob(ctx, req.(*PauseEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ResumeEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ResumeEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ResumeEvaluationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ResumeEvaluationJob(ctx, req.(*ResumeEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteEvaluationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteEvaluationJob(ctx, req.(*DeleteEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListEvaluationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEvaluationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListEvaluationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListEvaluationJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListEvaluationJobs(ctx, req.(*ListEvaluationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataLabelingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datalabeling.v1beta1.DataLabelingService",
	HandlerType: (*DataLabelingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _DataLabelingService_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _DataLabelingService_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _DataLabelingService_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _DataLabelingService_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _DataLabelingService_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _DataLabelingService_ExportData_Handler,
		},
		{
			MethodName: "GetDataItem",
			Handler:    _DataLabelingService_GetDataItem_Handler,
		},
		{
			MethodName: "ListDataItems",
			Handler:    _DataLabelingService_ListDataItems_Handler,
		},
		{
			MethodName: "GetAnnotatedDataset",
			Handler:    _DataLabelingService_GetAnnotatedDataset_Handler,
		},
		{
			MethodName: "ListAnnotatedDatasets",
			Handler:    _DataLabelingService_ListAnnotatedDatasets_Handler,
		},
		{
			MethodName: "DeleteAnnotatedDataset",
			Handler:    _DataLabelingService_DeleteAnnotatedDataset_Handler,
		},
		{
			MethodName: "LabelImage",
			Handler:    _DataLabelingService_LabelImage_Handler,
		},
		{
			MethodName: "LabelVideo",
			Handler:    _DataLabelingService_LabelVideo_Handler,
		},
		{
			MethodName: "LabelText",
			Handler:    _DataLabelingService_LabelText_Handler,
		},
		{
			MethodName: "GetExample",
			Handler:    _DataLabelingService_GetExample_Handler,
		},
		{
			MethodName: "ListExamples",
			Handler:    _DataLabelingService_ListExamples_Handler,
		},
		{
			MethodName: "CreateAnnotationSpecSet",
			Handler:    _DataLabelingService_CreateAnnotationSpecSet_Handler,
		},
		{
			MethodName: "GetAnnotationSpecSet",
			Handler:    _DataLabelingService_GetAnnotationSpecSet_Handler,
		},
		{
			MethodName: "ListAnnotationSpecSets",
			Handler:    _DataLabelingService_ListAnnotationSpecSets_Handler,
		},
		{
			MethodName: "DeleteAnnotationSpecSet",
			Handler:    _DataLabelingService_DeleteAnnotationSpecSet_Handler,
		},
		{
			MethodName: "CreateInstruction",
			Handler:    _DataLabelingService_CreateInstruction_Handler,
		},
		{
			MethodName: "GetInstruction",
			Handler:    _DataLabelingService_GetInstruction_Handler,
		},
		{
			MethodName: "ListInstructions",
			Handler:    _DataLabelingService_ListInstructions_Handler,
		},
		{
			MethodName: "DeleteInstruction",
			Handler:    _DataLabelingService_DeleteInstruction_Handler,
		},
		{
			MethodName: "GetEvaluation",
			Handler:    _DataLabelingService_GetEvaluation_Handler,
		},
		{
			MethodName: "SearchEvaluations",
			Handler:    _DataLabelingService_SearchEvaluations_Handler,
		},
		{
			MethodName: "SearchExampleComparisons",
			Handler:    _DataLabelingService_SearchExampleComparisons_Handler,
		},
		{
			MethodName: "CreateEvaluationJob",
			Handler:    _DataLabelingService_CreateEvaluationJob_Handler,
		},
		{
			MethodName: "UpdateEvaluationJob",
			Handler:    _DataLabelingService_UpdateEvaluationJob_Handler,
		},
		{
			MethodName: "GetEvaluationJob",
			Handler:    _DataLabelingService_GetEvaluationJob_Handler,
		},
		{
			MethodName: "PauseEvaluationJob",
			Handler:    _DataLabelingService_PauseEvaluationJob_Handler,
		},
		{
			MethodName: "ResumeEvaluationJob",
			Handler:    _DataLabelingService_ResumeEvaluationJob_Handler,
		},
		{
			MethodName: "DeleteEvaluationJob",
			Handler:    _DataLabelingService_DeleteEvaluationJob_Handler,
		},
		{
			MethodName: "ListEvaluationJobs",
			Handler:    _DataLabelingService_ListEvaluationJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datalabeling/v1beta1/data_labeling_service.proto",
}
