// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A chat message.
type ChatMessage struct {
	_ struct{} `type:"structure"`

	// The content of the chat message.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The type of the content. Supported types are text/plain.
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ChatMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChatMessage"}

	if s.Content == nil {
		invalidParams.Add(aws.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if s.ContentType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChatMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Content != nil {
		v := *s.Content

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Content", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains summary information about a contact flow.
type ContactFlowSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact flow.
	Arn *string `type:"string"`

	// The type of contact flow.
	ContactFlowType ContactFlowType `type:"string" enum:"true"`

	// The identifier of the contact flow.
	Id *string `type:"string"`

	// The name of the contact flow.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContactFlowSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContactFlowSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ContactFlowType) > 0 {
		v := s.ContactFlowType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactFlowType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains credentials to use for federation.
type Credentials struct {
	_ struct{} `type:"structure"`

	// An access token generated for a federated user to access Amazon Connect.
	AccessToken *string `type:"string" sensitive:"true"`

	// A token generated with an expiration time for the session a user is logged
	// in to Amazon Connect.
	AccessTokenExpiration *time.Time `type:"timestamp"`

	// Renews a token generated for a user to access the Amazon Connect instance.
	RefreshToken *string `type:"string" sensitive:"true"`

	// Renews the expiration timer for a generated token.
	RefreshTokenExpiration *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Credentials) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessToken != nil {
		v := *s.AccessToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessTokenExpiration != nil {
		v := *s.AccessTokenExpiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessTokenExpiration",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.RefreshToken != nil {
		v := *s.RefreshToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RefreshToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RefreshTokenExpiration != nil {
		v := *s.RefreshTokenExpiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RefreshTokenExpiration",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Contains information about a real-time metric.
type CurrentMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	Name CurrentMetricName `type:"string" enum:"true"`

	// The unit for the metric.
	Unit Unit `type:"string" enum:"true"`
}

// String returns the string representation
func (s CurrentMetric) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CurrentMetric) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains the data for a real-time metric.
type CurrentMetricData struct {
	_ struct{} `type:"structure"`

	// Information about the metric.
	Metric *CurrentMetric `type:"structure"`

	// The value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s CurrentMetricData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CurrentMetricData) MarshalFields(e protocol.FieldEncoder) error {
	if s.Metric != nil {
		v := s.Metric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metric", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Contains information about a set of real-time metrics.
type CurrentMetricResult struct {
	_ struct{} `type:"structure"`

	// The set of metrics.
	Collections []CurrentMetricData `type:"list"`

	// The dimensions for the metrics.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s CurrentMetricResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CurrentMetricResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.Collections != nil {
		v := s.Collections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Collections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	return nil
}

// Contains information about the dimensions for a set of metrics.
type Dimensions struct {
	_ struct{} `type:"structure"`

	// The channel used for grouping and filters.
	Channel Channel `type:"string" enum:"true"`

	// Information about the queue for which metrics are returned.
	Queue *QueueReference `type:"structure"`
}

// String returns the string representation
func (s Dimensions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Dimensions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Channel) > 0 {
		v := s.Channel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Channel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Queue != nil {
		v := s.Queue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Queue", v, metadata)
	}
	return nil
}

// Contains the filter to apply when retrieving metrics.
type Filters struct {
	_ struct{} `type:"structure"`

	// The channel to use to filter the metrics.
	Channels []Channel `type:"list"`

	// The queues to use to filter the metrics. You can specify up to 100 queues
	// per request.
	Queues []string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filters"}
	if s.Queues != nil && len(s.Queues) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Queues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Filters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Channels != nil {
		v := s.Channels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Channels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Queues != nil {
		v := s.Queues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Queues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Contains information about a hierarchy group.
type HierarchyGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string `type:"string"`

	// Information about the levels in the hierarchy group.
	HierarchyPath *HierarchyPath `type:"structure"`

	// The identifier of the hierarchy group.
	Id *string `type:"string"`

	// The identifier of the level in the hierarchy group.
	LevelId *string `type:"string"`

	// The name of the hierarchy group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HierarchyPath != nil {
		v := s.HierarchyPath

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HierarchyPath", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LevelId != nil {
		v := *s.LevelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LevelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains summary information about a hierarchy group.
type HierarchyGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string `type:"string"`

	// The identifier of the hierarchy group.
	Id *string `type:"string"`

	// The name of the hierarchy group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyGroupSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a hierarchy level.
type HierarchyLevel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy level.
	Arn *string `type:"string"`

	// The identifier of the hierarchy level.
	Id *string `type:"string"`

	// The name of the hierarchy level.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyLevel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyLevel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the levels of a hierarchy group.
type HierarchyPath struct {
	_ struct{} `type:"structure"`

	// Information about level five.
	LevelFive *HierarchyGroupSummary `type:"structure"`

	// Information about level four.
	LevelFour *HierarchyGroupSummary `type:"structure"`

	// Information about level one.
	LevelOne *HierarchyGroupSummary `type:"structure"`

	// Information about level three.
	LevelThree *HierarchyGroupSummary `type:"structure"`

	// Information about level two.
	LevelTwo *HierarchyGroupSummary `type:"structure"`
}

// String returns the string representation
func (s HierarchyPath) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyPath) MarshalFields(e protocol.FieldEncoder) error {
	if s.LevelFive != nil {
		v := s.LevelFive

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFive", v, metadata)
	}
	if s.LevelFour != nil {
		v := s.LevelFour

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFour", v, metadata)
	}
	if s.LevelOne != nil {
		v := s.LevelOne

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelOne", v, metadata)
	}
	if s.LevelThree != nil {
		v := s.LevelThree

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelThree", v, metadata)
	}
	if s.LevelTwo != nil {
		v := s.LevelTwo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelTwo", v, metadata)
	}
	return nil
}

// Contains information about a hierarchy structure.
type HierarchyStructure struct {
	_ struct{} `type:"structure"`

	// Information about level five.
	LevelFive *HierarchyLevel `type:"structure"`

	// Information about level four.
	LevelFour *HierarchyLevel `type:"structure"`

	// Information about level one.
	LevelOne *HierarchyLevel `type:"structure"`

	// Information about level three.
	LevelThree *HierarchyLevel `type:"structure"`

	// Information about level two.
	LevelTwo *HierarchyLevel `type:"structure"`
}

// String returns the string representation
func (s HierarchyStructure) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyStructure) MarshalFields(e protocol.FieldEncoder) error {
	if s.LevelFive != nil {
		v := s.LevelFive

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFive", v, metadata)
	}
	if s.LevelFour != nil {
		v := s.LevelFour

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFour", v, metadata)
	}
	if s.LevelOne != nil {
		v := s.LevelOne

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelOne", v, metadata)
	}
	if s.LevelThree != nil {
		v := s.LevelThree

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelThree", v, metadata)
	}
	if s.LevelTwo != nil {
		v := s.LevelTwo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelTwo", v, metadata)
	}
	return nil
}

// Contains information about a historical metric.
type HistoricalMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	Name HistoricalMetricName `type:"string" enum:"true"`

	// The statistic for the metric.
	Statistic Statistic `type:"string" enum:"true"`

	// The threshold for the metric, used with service level metrics.
	Threshold *Threshold `type:"structure"`

	// The unit for the metric.
	Unit Unit `type:"string" enum:"true"`
}

// String returns the string representation
func (s HistoricalMetric) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistoricalMetric) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Statistic) > 0 {
		v := s.Statistic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Statistic", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Threshold != nil {
		v := s.Threshold

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Threshold", v, metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains the data for a historical metric.
type HistoricalMetricData struct {
	_ struct{} `type:"structure"`

	// Information about the metric.
	Metric *HistoricalMetric `type:"structure"`

	// The value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistoricalMetricData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistoricalMetricData) MarshalFields(e protocol.FieldEncoder) error {
	if s.Metric != nil {
		v := s.Metric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metric", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Contains information about the historical metrics retrieved.
type HistoricalMetricResult struct {
	_ struct{} `type:"structure"`

	// The set of metrics.
	Collections []HistoricalMetricData `type:"list"`

	// The dimension for the metrics.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s HistoricalMetricResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistoricalMetricResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.Collections != nil {
		v := s.Collections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Collections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	return nil
}

// Contains summary information about hours of operation for a contact center.
type HoursOfOperationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hours of operation.
	Arn *string `type:"string"`

	// The identifier of the hours of operation.
	Id *string `type:"string"`

	// The name of the hours of operation.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HoursOfOperationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HoursOfOperationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The customer's details.
type ParticipantDetails struct {
	_ struct{} `type:"structure"`

	// Display name of the participant.
	//
	// DisplayName is a required field
	DisplayName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ParticipantDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParticipantDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParticipantDetails"}

	if s.DisplayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParticipantDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains summary information about a phone number for a contact center.
type PhoneNumberSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the phone number.
	Arn *string `type:"string"`

	// The identifier of the phone number.
	Id *string `type:"string"`

	// The phone number.
	PhoneNumber *string `type:"string"`

	// The ISO country code.
	PhoneNumberCountryCode PhoneNumberCountryCode `type:"string" enum:"true"`

	// The type of phone number.
	PhoneNumberType PhoneNumberType `type:"string" enum:"true"`
}

// String returns the string representation
func (s PhoneNumberSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumber != nil {
		v := *s.PhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PhoneNumberCountryCode) > 0 {
		v := s.PhoneNumberCountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumberCountryCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.PhoneNumberType) > 0 {
		v := s.PhoneNumberType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumberType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about a queue resource for which metrics are returned.
type QueueReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string `type:"string"`

	// The identifier of the queue.
	Id *string `type:"string"`
}

// String returns the string representation
func (s QueueReference) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains summary information about a queue.
type QueueSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string `type:"string"`

	// The identifier of the queue.
	Id *string `type:"string"`

	// The name of the queue.
	Name *string `min:"1" type:"string"`

	// The type of queue.
	QueueType QueueType `type:"string" enum:"true"`
}

// String returns the string representation
func (s QueueSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.QueueType) > 0 {
		v := s.QueueType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QueueType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains summary information about a routing profile.
type RoutingProfileSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the routing profile.
	Arn *string `type:"string"`

	// The identifier of the routing profile.
	Id *string `type:"string"`

	// The name of the routing profile.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RoutingProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoutingProfileSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a security profile.
type SecurityProfileSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the security profile.
	Arn *string `type:"string"`

	// The identifier of the security profile.
	Id *string `type:"string"`

	// The name of the security profile.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityProfileSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the threshold for service level metrics.
type Threshold struct {
	_ struct{} `type:"structure"`

	// The type of comparison. Only "less than" (LT) comparisons are supported.
	Comparison Comparison `type:"string" enum:"true"`

	// The threshold value to compare.
	ThresholdValue *float64 `type:"double"`
}

// String returns the string representation
func (s Threshold) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Threshold) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparison) > 0 {
		v := s.Comparison

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comparison", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ThresholdValue != nil {
		v := *s.ThresholdValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThresholdValue", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Contains information about a user account for a Amazon Connect instance.
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string `type:"string"`

	// The identifier of the user account in the directory used for identity management.
	DirectoryUserId *string `type:"string"`

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string `type:"string"`

	// The identifier of the user account.
	Id *string `type:"string"`

	// Information about the user identity.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// Information about the phone configuration for the user.
	PhoneConfig *UserPhoneConfig `type:"structure"`

	// The identifier of the routing profile for the user.
	RoutingProfileId *string `type:"string"`

	// The identifiers of the security profiles for the user.
	SecurityProfileIds []string `min:"1" type:"list"`

	// The tags.
	Tags map[string]string `min:"1" type:"map"`

	// The user name assigned to the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s User) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DirectoryUserId != nil {
		v := *s.DirectoryUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DirectoryUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HierarchyGroupId != nil {
		v := *s.HierarchyGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HierarchyGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityInfo != nil {
		v := s.IdentityInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IdentityInfo", v, metadata)
	}
	if s.PhoneConfig != nil {
		v := s.PhoneConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PhoneConfig", v, metadata)
	}
	if s.RoutingProfileId != nil {
		v := *s.RoutingProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoutingProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityProfileIds != nil {
		v := s.SecurityProfileIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityProfileIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the identity of a user.
type UserIdentityInfo struct {
	_ struct{} `type:"structure"`

	// The email address. If you are using SAML for identity management and include
	// this parameter, an error is returned.
	Email *string `type:"string"`

	// The first name. This is required if you are using Amazon Connect or SAML
	// for identity management.
	FirstName *string `min:"1" type:"string"`

	// The last name. This is required if you are using Amazon Connect or SAML for
	// identity management.
	LastName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserIdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentityInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserIdentityInfo"}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LastName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserIdentityInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FirstName != nil {
		v := *s.FirstName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FirstName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastName != nil {
		v := *s.LastName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the phone configuration settings for a user.
type UserPhoneConfig struct {
	_ struct{} `type:"structure"`

	// The After Call Work (ACW) timeout setting, in seconds.
	AfterContactWorkTimeLimit *int64 `type:"integer"`

	// The Auto accept setting.
	AutoAccept *bool `type:"boolean"`

	// The phone number for the user's desk phone.
	DeskPhoneNumber *string `type:"string"`

	// The phone type.
	//
	// PhoneType is a required field
	PhoneType PhoneType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UserPhoneConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPhoneConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserPhoneConfig"}
	if len(s.PhoneType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PhoneType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserPhoneConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AfterContactWorkTimeLimit != nil {
		v := *s.AfterContactWorkTimeLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AfterContactWorkTimeLimit", protocol.Int64Value(v), metadata)
	}
	if s.AutoAccept != nil {
		v := *s.AutoAccept

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AutoAccept", protocol.BoolValue(v), metadata)
	}
	if s.DeskPhoneNumber != nil {
		v := *s.DeskPhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeskPhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PhoneType) > 0 {
		v := s.PhoneType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains summary information about a user.
type UserSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string `type:"string"`

	// The identifier of the user account.
	Id *string `type:"string"`

	// The Amazon Connect user name of the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
