// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ecriface provides an interface to enable mocking the Amazon EC2 Container Registry service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ecriface

import (
	"github.com/aws/aws-sdk-go-v2/service/ecr"
)

// ClientAPI provides an interface to enable mocking the
// ecr.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon ECR.
//    func myFunc(svc ecriface.ClientAPI) bool {
//        // Make svc.BatchCheckLayerAvailability request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := ecr.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ecriface.ClientPI
//    }
//    func (m *mockClientClient) BatchCheckLayerAvailability(input *ecr.BatchCheckLayerAvailabilityInput) (*ecr.BatchCheckLayerAvailabilityOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchCheckLayerAvailabilityRequest(*ecr.BatchCheckLayerAvailabilityInput) ecr.BatchCheckLayerAvailabilityRequest

	BatchDeleteImageRequest(*ecr.BatchDeleteImageInput) ecr.BatchDeleteImageRequest

	BatchGetImageRequest(*ecr.BatchGetImageInput) ecr.BatchGetImageRequest

	CompleteLayerUploadRequest(*ecr.CompleteLayerUploadInput) ecr.CompleteLayerUploadRequest

	CreateRepositoryRequest(*ecr.CreateRepositoryInput) ecr.CreateRepositoryRequest

	DeleteLifecyclePolicyRequest(*ecr.DeleteLifecyclePolicyInput) ecr.DeleteLifecyclePolicyRequest

	DeleteRepositoryRequest(*ecr.DeleteRepositoryInput) ecr.DeleteRepositoryRequest

	DeleteRepositoryPolicyRequest(*ecr.DeleteRepositoryPolicyInput) ecr.DeleteRepositoryPolicyRequest

	DescribeImageScanFindingsRequest(*ecr.DescribeImageScanFindingsInput) ecr.DescribeImageScanFindingsRequest

	DescribeImagesRequest(*ecr.DescribeImagesInput) ecr.DescribeImagesRequest

	DescribeRepositoriesRequest(*ecr.DescribeRepositoriesInput) ecr.DescribeRepositoriesRequest

	GetAuthorizationTokenRequest(*ecr.GetAuthorizationTokenInput) ecr.GetAuthorizationTokenRequest

	GetDownloadUrlForLayerRequest(*ecr.GetDownloadUrlForLayerInput) ecr.GetDownloadUrlForLayerRequest

	GetLifecyclePolicyRequest(*ecr.GetLifecyclePolicyInput) ecr.GetLifecyclePolicyRequest

	GetLifecyclePolicyPreviewRequest(*ecr.GetLifecyclePolicyPreviewInput) ecr.GetLifecyclePolicyPreviewRequest

	GetRepositoryPolicyRequest(*ecr.GetRepositoryPolicyInput) ecr.GetRepositoryPolicyRequest

	InitiateLayerUploadRequest(*ecr.InitiateLayerUploadInput) ecr.InitiateLayerUploadRequest

	ListImagesRequest(*ecr.ListImagesInput) ecr.ListImagesRequest

	ListTagsForResourceRequest(*ecr.ListTagsForResourceInput) ecr.ListTagsForResourceRequest

	PutImageRequest(*ecr.PutImageInput) ecr.PutImageRequest

	PutImageScanningConfigurationRequest(*ecr.PutImageScanningConfigurationInput) ecr.PutImageScanningConfigurationRequest

	PutImageTagMutabilityRequest(*ecr.PutImageTagMutabilityInput) ecr.PutImageTagMutabilityRequest

	PutLifecyclePolicyRequest(*ecr.PutLifecyclePolicyInput) ecr.PutLifecyclePolicyRequest

	SetRepositoryPolicyRequest(*ecr.SetRepositoryPolicyInput) ecr.SetRepositoryPolicyRequest

	StartImageScanRequest(*ecr.StartImageScanInput) ecr.StartImageScanRequest

	StartLifecyclePolicyPreviewRequest(*ecr.StartLifecyclePolicyPreviewInput) ecr.StartLifecyclePolicyPreviewRequest

	TagResourceRequest(*ecr.TagResourceInput) ecr.TagResourceRequest

	UntagResourceRequest(*ecr.UntagResourceInput) ecr.UntagResourceRequest

	UploadLayerPartRequest(*ecr.UploadLayerPartInput) ecr.UploadLayerPartRequest
}

var _ ClientAPI = (*ecr.Client)(nil)
