// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeHsmConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific Amazon Redshift HSM configuration to be described.
	// If no identifier is specified, information is returned for all HSM configurations
	// owned by your AWS customer account.
	HsmConfigurationIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmConfigurations request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM configurations
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM configurations that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag keys associated with them.
	TagKeys []string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM configurations
	// that are associated with the specified tag value or values. For example,
	// suppose that you have HSM configurations that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag values associated with them.
	TagValues []string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeHsmConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of HsmConfiguration objects.
	HsmConfigurations []HsmConfiguration `locationNameList:"HsmConfiguration" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeHsmConfigurations = "DescribeHsmConfigurations"

// DescribeHsmConfigurationsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns information about the specified Amazon Redshift HSM configuration.
// If no configuration ID is specified, returns information about all the HSM
// configurations owned by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all HSM connections that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all HSM connections that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM connections
// are returned regardless of whether they have tag keys or values associated
// with them.
//
//    // Example sending a request using DescribeHsmConfigurationsRequest.
//    req := client.DescribeHsmConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations
func (c *Client) DescribeHsmConfigurationsRequest(input *DescribeHsmConfigurationsInput) DescribeHsmConfigurationsRequest {
	op := &aws.Operation{
		Name:       opDescribeHsmConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmConfigurationsInput{}
	}

	req := c.newRequest(op, input, &DescribeHsmConfigurationsOutput{})
	return DescribeHsmConfigurationsRequest{Request: req, Input: input, Copy: c.DescribeHsmConfigurationsRequest}
}

// DescribeHsmConfigurationsRequest is the request type for the
// DescribeHsmConfigurations API operation.
type DescribeHsmConfigurationsRequest struct {
	*aws.Request
	Input *DescribeHsmConfigurationsInput
	Copy  func(*DescribeHsmConfigurationsInput) DescribeHsmConfigurationsRequest
}

// Send marshals and sends the DescribeHsmConfigurations API request.
func (r DescribeHsmConfigurationsRequest) Send(ctx context.Context) (*DescribeHsmConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeHsmConfigurationsResponse{
		DescribeHsmConfigurationsOutput: r.Request.Data.(*DescribeHsmConfigurationsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeHsmConfigurationsRequestPaginator returns a paginator for DescribeHsmConfigurations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeHsmConfigurationsRequest(input)
//   p := redshift.NewDescribeHsmConfigurationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeHsmConfigurationsPaginator(req DescribeHsmConfigurationsRequest) DescribeHsmConfigurationsPaginator {
	return DescribeHsmConfigurationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeHsmConfigurationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeHsmConfigurationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeHsmConfigurationsPaginator struct {
	aws.Pager
}

func (p *DescribeHsmConfigurationsPaginator) CurrentPage() *DescribeHsmConfigurationsOutput {
	return p.Pager.CurrentPage().(*DescribeHsmConfigurationsOutput)
}

// DescribeHsmConfigurationsResponse is the response type for the
// DescribeHsmConfigurations API operation.
type DescribeHsmConfigurationsResponse struct {
	*DescribeHsmConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeHsmConfigurations request.
func (r *DescribeHsmConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
