// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// The input for the ReplaceTopicRule operation.
type ReplaceTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The rule payload.
	//
	// TopicRulePayload is a required field
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s ReplaceTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceTopicRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplaceTopicRuleInput"}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}

	if s.TopicRulePayload == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicRulePayload"))
	}
	if s.TopicRulePayload != nil {
		if err := s.TopicRulePayload.Validate(); err != nil {
			invalidParams.AddNested("TopicRulePayload", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplaceTopicRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TopicRulePayload != nil {
		v := s.TopicRulePayload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "topicRulePayload", v, metadata)
	}
	return nil
}

type ReplaceTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReplaceTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplaceTopicRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opReplaceTopicRule = "ReplaceTopicRule"

// ReplaceTopicRuleRequest returns a request value for making API operation for
// AWS IoT.
//
// Replaces the rule. You must specify all parameters for the new rule. Creating
// rules is an administrator-level action. Any user who has permission to create
// rules will be able to access data processed by the rule.
//
//    // Example sending a request using ReplaceTopicRuleRequest.
//    req := client.ReplaceTopicRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ReplaceTopicRuleRequest(input *ReplaceTopicRuleInput) ReplaceTopicRuleRequest {
	op := &aws.Operation{
		Name:       opReplaceTopicRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &ReplaceTopicRuleInput{}
	}

	req := c.newRequest(op, input, &ReplaceTopicRuleOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ReplaceTopicRuleRequest{Request: req, Input: input, Copy: c.ReplaceTopicRuleRequest}
}

// ReplaceTopicRuleRequest is the request type for the
// ReplaceTopicRule API operation.
type ReplaceTopicRuleRequest struct {
	*aws.Request
	Input *ReplaceTopicRuleInput
	Copy  func(*ReplaceTopicRuleInput) ReplaceTopicRuleRequest
}

// Send marshals and sends the ReplaceTopicRule API request.
func (r ReplaceTopicRuleRequest) Send(ctx context.Context) (*ReplaceTopicRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReplaceTopicRuleResponse{
		ReplaceTopicRuleOutput: r.Request.Data.(*ReplaceTopicRuleOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReplaceTopicRuleResponse is the response type for the
// ReplaceTopicRule API operation.
type ReplaceTopicRuleResponse struct {
	*ReplaceTopicRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReplaceTopicRule request.
func (r *ReplaceTopicRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
