// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscalingplans

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeScalingPlansInput struct {
	_ struct{} `type:"structure"`

	// The sources for the applications (up to 10). If you specify scaling plan
	// names, you cannot specify application sources.
	ApplicationSources []ApplicationSource `type:"list"`

	// The maximum number of scalable resources to return. This value can be between
	// 1 and 50. The default value is 50.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The names of the scaling plans (up to 10). If you specify application sources,
	// you cannot specify scaling plan names.
	ScalingPlanNames []string `type:"list"`

	// The version number of the scaling plan. If you specify a scaling plan version,
	// you must also specify a scaling plan name.
	ScalingPlanVersion *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeScalingPlansInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPlansInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeScalingPlansInput"}
	if s.ApplicationSources != nil {
		for i, v := range s.ApplicationSources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ApplicationSources", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeScalingPlansOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scaling plans.
	ScalingPlans []ScalingPlan `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPlansOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeScalingPlans = "DescribeScalingPlans"

// DescribeScalingPlansRequest returns a request value for making API operation for
// AWS Auto Scaling Plans.
//
// Describes one or more of your scaling plans.
//
//    // Example sending a request using DescribeScalingPlansRequest.
//    req := client.DescribeScalingPlansRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans
func (c *Client) DescribeScalingPlansRequest(input *DescribeScalingPlansInput) DescribeScalingPlansRequest {
	op := &aws.Operation{
		Name:       opDescribeScalingPlans,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPlansInput{}
	}

	req := c.newRequest(op, input, &DescribeScalingPlansOutput{})
	return DescribeScalingPlansRequest{Request: req, Input: input, Copy: c.DescribeScalingPlansRequest}
}

// DescribeScalingPlansRequest is the request type for the
// DescribeScalingPlans API operation.
type DescribeScalingPlansRequest struct {
	*aws.Request
	Input *DescribeScalingPlansInput
	Copy  func(*DescribeScalingPlansInput) DescribeScalingPlansRequest
}

// Send marshals and sends the DescribeScalingPlans API request.
func (r DescribeScalingPlansRequest) Send(ctx context.Context) (*DescribeScalingPlansResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeScalingPlansResponse{
		DescribeScalingPlansOutput: r.Request.Data.(*DescribeScalingPlansOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeScalingPlansResponse is the response type for the
// DescribeScalingPlans API operation.
type DescribeScalingPlansResponse struct {
	*DescribeScalingPlansOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeScalingPlans request.
func (r *DescribeScalingPlansResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
