package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AppServiceCertificateOrdersClient is the webSite Management Client
type AppServiceCertificateOrdersClient struct {
	BaseClient
}

// NewAppServiceCertificateOrdersClient creates an instance of the AppServiceCertificateOrdersClient client.
func NewAppServiceCertificateOrdersClient(subscriptionID string) AppServiceCertificateOrdersClient {
	return NewAppServiceCertificateOrdersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppServiceCertificateOrdersClientWithBaseURI creates an instance of the AppServiceCertificateOrdersClient client
// using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewAppServiceCertificateOrdersClientWithBaseURI(baseURI string, subscriptionID string) AppServiceCertificateOrdersClient {
	return AppServiceCertificateOrdersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or update a certificate purchase order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// certificateDistinguishedName - distinguished name to use for the certificate order.
func (client AppServiceCertificateOrdersClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName AppServiceCertificateOrder) (result AppServiceCertificateOrdersCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: certificateDistinguishedName,
			Constraints: []validation.Constraint{{Target: "certificateDistinguishedName.AppServiceCertificateOrderProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "certificateDistinguishedName.AppServiceCertificateOrderProperties.ValidityInYears", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "certificateDistinguishedName.AppServiceCertificateOrderProperties.ValidityInYears", Name: validation.InclusiveMaximum, Rule: int64(3), Chain: nil},
						{Target: "certificateDistinguishedName.AppServiceCertificateOrderProperties.ValidityInYears", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, certificateOrderName, certificateDistinguishedName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppServiceCertificateOrdersClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName AppServiceCertificateOrder) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}", pathParameters),
		autorest.WithJSON(certificateDistinguishedName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) CreateOrUpdateSender(req *http.Request) (future AppServiceCertificateOrdersCreateOrUpdateFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) CreateOrUpdateResponder(resp *http.Response) (result AppServiceCertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateCertificate creates or updates a certificate and associates with key vault secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// name - name of the certificate.
// keyVaultCertificate - key vault certificate resource Id.
func (client AppServiceCertificateOrdersClient) CreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate AppServiceCertificateResource) (result AppServiceCertificateOrdersCreateOrUpdateCertificateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.CreateOrUpdateCertificate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "CreateOrUpdateCertificate", err.Error())
	}

	req, err := client.CreateOrUpdateCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "CreateOrUpdateCertificate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateCertificateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "CreateOrUpdateCertificate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateCertificatePreparer prepares the CreateOrUpdateCertificate request.
func (client AppServiceCertificateOrdersClient) CreateOrUpdateCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate AppServiceCertificateResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithJSON(keyVaultCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateCertificateSender sends the CreateOrUpdateCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) CreateOrUpdateCertificateSender(req *http.Request) (future AppServiceCertificateOrdersCreateOrUpdateCertificateFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateCertificateResponder handles the response to the CreateOrUpdateCertificate request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) CreateOrUpdateCertificateResponder(resp *http.Response) (result AppServiceCertificateResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an existing certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
func (client AppServiceCertificateOrdersClient) Delete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, certificateOrderName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppServiceCertificateOrdersClient) DeletePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) DeleteSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteCertificate delete the certificate associated with a certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// name - name of the certificate.
func (client AppServiceCertificateOrdersClient) DeleteCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.DeleteCertificate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "DeleteCertificate", err.Error())
	}

	req, err := client.DeleteCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "DeleteCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCertificateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "DeleteCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "DeleteCertificate", resp, "Failure responding to request")
	}

	return
}

// DeleteCertificatePreparer prepares the DeleteCertificate request.
func (client AppServiceCertificateOrdersClient) DeleteCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCertificateSender sends the DeleteCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) DeleteCertificateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteCertificateResponder handles the response to the DeleteCertificate request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) DeleteCertificateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get a certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order..
func (client AppServiceCertificateOrdersClient) Get(ctx context.Context, resourceGroupName string, certificateOrderName string) (result AppServiceCertificateOrder, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, certificateOrderName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppServiceCertificateOrdersClient) GetPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) GetResponder(resp *http.Response) (result AppServiceCertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificate get the certificate associated with a certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// name - name of the certificate.
func (client AppServiceCertificateOrdersClient) GetCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result AppServiceCertificateResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.GetCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "GetCertificate", err.Error())
	}

	req, err := client.GetCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "GetCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "GetCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.GetCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "GetCertificate", resp, "Failure responding to request")
	}

	return
}

// GetCertificatePreparer prepares the GetCertificate request.
func (client AppServiceCertificateOrdersClient) GetCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCertificateSender sends the GetCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) GetCertificateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetCertificateResponder handles the response to the GetCertificate request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) GetCertificateResponder(resp *http.Response) (result AppServiceCertificateResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all certificate orders in a subscription.
func (client AppServiceCertificateOrdersClient) List(ctx context.Context) (result AppServiceCertificateOrderCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.List")
		defer func() {
			sc := -1
			if result.ascoc.Response.Response != nil {
				sc = result.ascoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ascoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "List", resp, "Failure sending request")
		return
	}

	result.ascoc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppServiceCertificateOrdersClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ListResponder(resp *http.Response) (result AppServiceCertificateOrderCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AppServiceCertificateOrdersClient) listNextResults(ctx context.Context, lastResults AppServiceCertificateOrderCollection) (result AppServiceCertificateOrderCollection, err error) {
	req, err := lastResults.appServiceCertificateOrderCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceCertificateOrdersClient) ListComplete(ctx context.Context) (result AppServiceCertificateOrderCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByResourceGroup get certificate orders in a resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client AppServiceCertificateOrdersClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result AppServiceCertificateOrderCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.ascoc.Response.Response != nil {
				sc = result.ascoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.ascoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.ascoc, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppServiceCertificateOrdersClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ListByResourceGroupResponder(resp *http.Response) (result AppServiceCertificateOrderCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppServiceCertificateOrdersClient) listByResourceGroupNextResults(ctx context.Context, lastResults AppServiceCertificateOrderCollection) (result AppServiceCertificateOrderCollection, err error) {
	req, err := lastResults.appServiceCertificateOrderCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceCertificateOrdersClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result AppServiceCertificateOrderCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListCertificates list all certificates associated with a certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
func (client AppServiceCertificateOrdersClient) ListCertificates(ctx context.Context, resourceGroupName string, certificateOrderName string) (result AppServiceCertificateCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ListCertificates")
		defer func() {
			sc := -1
			if result.ascc.Response.Response != nil {
				sc = result.ascc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "ListCertificates", err.Error())
	}

	result.fn = client.listCertificatesNextResults
	req, err := client.ListCertificatesPreparer(ctx, resourceGroupName, certificateOrderName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ListCertificates", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCertificatesSender(req)
	if err != nil {
		result.ascc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ListCertificates", resp, "Failure sending request")
		return
	}

	result.ascc, err = client.ListCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ListCertificates", resp, "Failure responding to request")
	}

	return
}

// ListCertificatesPreparer prepares the ListCertificates request.
func (client AppServiceCertificateOrdersClient) ListCertificatesPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCertificatesSender sends the ListCertificates request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ListCertificatesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCertificatesResponder handles the response to the ListCertificates request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ListCertificatesResponder(resp *http.Response) (result AppServiceCertificateCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listCertificatesNextResults retrieves the next set of results, if any.
func (client AppServiceCertificateOrdersClient) listCertificatesNextResults(ctx context.Context, lastResults AppServiceCertificateCollection) (result AppServiceCertificateCollection, err error) {
	req, err := lastResults.appServiceCertificateCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listCertificatesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListCertificatesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listCertificatesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "listCertificatesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListCertificatesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceCertificateOrdersClient) ListCertificatesComplete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result AppServiceCertificateCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ListCertificates")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListCertificates(ctx, resourceGroupName, certificateOrderName)
	return
}

// Reissue reissue an existing certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// reissueCertificateOrderRequest - parameters for the reissue.
func (client AppServiceCertificateOrdersClient) Reissue(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest ReissueCertificateOrderRequest) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.Reissue")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "Reissue", err.Error())
	}

	req, err := client.ReissuePreparer(ctx, resourceGroupName, certificateOrderName, reissueCertificateOrderRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Reissue", nil, "Failure preparing request")
		return
	}

	resp, err := client.ReissueSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Reissue", resp, "Failure sending request")
		return
	}

	result, err = client.ReissueResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Reissue", resp, "Failure responding to request")
	}

	return
}

// ReissuePreparer prepares the Reissue request.
func (client AppServiceCertificateOrdersClient) ReissuePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest ReissueCertificateOrderRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/reissue", pathParameters),
		autorest.WithJSON(reissueCertificateOrderRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReissueSender sends the Reissue request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ReissueSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ReissueResponder handles the response to the Reissue request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ReissueResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Renew renew an existing certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// renewCertificateOrderRequest - renew parameters
func (client AppServiceCertificateOrdersClient) Renew(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest RenewCertificateOrderRequest) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.Renew")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "Renew", err.Error())
	}

	req, err := client.RenewPreparer(ctx, resourceGroupName, certificateOrderName, renewCertificateOrderRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Renew", nil, "Failure preparing request")
		return
	}

	resp, err := client.RenewSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Renew", resp, "Failure sending request")
		return
	}

	result, err = client.RenewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Renew", resp, "Failure responding to request")
	}

	return
}

// RenewPreparer prepares the Renew request.
func (client AppServiceCertificateOrdersClient) RenewPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest RenewCertificateOrderRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/renew", pathParameters),
		autorest.WithJSON(renewCertificateOrderRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RenewSender sends the Renew request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) RenewSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// RenewResponder handles the response to the Renew request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) RenewResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResendEmail resend certificate email.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
func (client AppServiceCertificateOrdersClient) ResendEmail(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ResendEmail")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "ResendEmail", err.Error())
	}

	req, err := client.ResendEmailPreparer(ctx, resourceGroupName, certificateOrderName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ResendEmail", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResendEmailSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ResendEmail", resp, "Failure sending request")
		return
	}

	result, err = client.ResendEmailResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ResendEmail", resp, "Failure responding to request")
	}

	return
}

// ResendEmailPreparer prepares the ResendEmail request.
func (client AppServiceCertificateOrdersClient) ResendEmailPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendEmail", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResendEmailSender sends the ResendEmail request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ResendEmailSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ResendEmailResponder handles the response to the ResendEmail request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ResendEmailResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResendRequestEmails verify domain ownership for this certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// nameIdentifier - email address
func (client AppServiceCertificateOrdersClient) ResendRequestEmails(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier NameIdentifier) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ResendRequestEmails")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "ResendRequestEmails", err.Error())
	}

	req, err := client.ResendRequestEmailsPreparer(ctx, resourceGroupName, certificateOrderName, nameIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ResendRequestEmails", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResendRequestEmailsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ResendRequestEmails", resp, "Failure sending request")
		return
	}

	result, err = client.ResendRequestEmailsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ResendRequestEmails", resp, "Failure responding to request")
	}

	return
}

// ResendRequestEmailsPreparer prepares the ResendRequestEmails request.
func (client AppServiceCertificateOrdersClient) ResendRequestEmailsPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier NameIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails", pathParameters),
		autorest.WithJSON(nameIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResendRequestEmailsSender sends the ResendRequestEmails request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ResendRequestEmailsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ResendRequestEmailsResponder handles the response to the ResendRequestEmails request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ResendRequestEmailsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RetrieveCertificateActions retrieve the list of certificate actions.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the certificate order.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateActions(ctx context.Context, resourceGroupName string, name string) (result ListCertificateOrderAction, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.RetrieveCertificateActions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "RetrieveCertificateActions", err.Error())
	}

	req, err := client.RetrieveCertificateActionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveCertificateActions", nil, "Failure preparing request")
		return
	}

	resp, err := client.RetrieveCertificateActionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveCertificateActions", resp, "Failure sending request")
		return
	}

	result, err = client.RetrieveCertificateActionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveCertificateActions", resp, "Failure responding to request")
	}

	return
}

// RetrieveCertificateActionsPreparer prepares the RetrieveCertificateActions request.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateActionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RetrieveCertificateActionsSender sends the RetrieveCertificateActions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateActionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// RetrieveCertificateActionsResponder handles the response to the RetrieveCertificateActions request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateActionsResponder(resp *http.Response) (result ListCertificateOrderAction, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RetrieveCertificateEmailHistory retrieve email history.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the certificate order.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateEmailHistory(ctx context.Context, resourceGroupName string, name string) (result ListCertificateEmail, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.RetrieveCertificateEmailHistory")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "RetrieveCertificateEmailHistory", err.Error())
	}

	req, err := client.RetrieveCertificateEmailHistoryPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveCertificateEmailHistory", nil, "Failure preparing request")
		return
	}

	resp, err := client.RetrieveCertificateEmailHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveCertificateEmailHistory", resp, "Failure sending request")
		return
	}

	result, err = client.RetrieveCertificateEmailHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveCertificateEmailHistory", resp, "Failure responding to request")
	}

	return
}

// RetrieveCertificateEmailHistoryPreparer prepares the RetrieveCertificateEmailHistory request.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateEmailHistoryPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RetrieveCertificateEmailHistorySender sends the RetrieveCertificateEmailHistory request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateEmailHistorySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// RetrieveCertificateEmailHistoryResponder handles the response to the RetrieveCertificateEmailHistory request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) RetrieveCertificateEmailHistoryResponder(resp *http.Response) (result ListCertificateEmail, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RetrieveSiteSeal verify domain ownership for this certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// siteSealRequest - site seal request.
func (client AppServiceCertificateOrdersClient) RetrieveSiteSeal(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest SiteSealRequest) (result SiteSeal, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.RetrieveSiteSeal")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "RetrieveSiteSeal", err.Error())
	}

	req, err := client.RetrieveSiteSealPreparer(ctx, resourceGroupName, certificateOrderName, siteSealRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveSiteSeal", nil, "Failure preparing request")
		return
	}

	resp, err := client.RetrieveSiteSealSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveSiteSeal", resp, "Failure sending request")
		return
	}

	result, err = client.RetrieveSiteSealResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "RetrieveSiteSeal", resp, "Failure responding to request")
	}

	return
}

// RetrieveSiteSealPreparer prepares the RetrieveSiteSeal request.
func (client AppServiceCertificateOrdersClient) RetrieveSiteSealPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest SiteSealRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal", pathParameters),
		autorest.WithJSON(siteSealRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RetrieveSiteSealSender sends the RetrieveSiteSeal request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) RetrieveSiteSealSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// RetrieveSiteSealResponder handles the response to the RetrieveSiteSeal request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) RetrieveSiteSealResponder(resp *http.Response) (result SiteSeal, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update create or update a certificate purchase order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// certificateDistinguishedName - distinguished name to use for the certificate order.
func (client AppServiceCertificateOrdersClient) Update(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName AppServiceCertificateOrderPatchResource) (result AppServiceCertificateOrder, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, certificateOrderName, certificateDistinguishedName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AppServiceCertificateOrdersClient) UpdatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName AppServiceCertificateOrderPatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}", pathParameters),
		autorest.WithJSON(certificateDistinguishedName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) UpdateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) UpdateResponder(resp *http.Response) (result AppServiceCertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCertificate creates or updates a certificate and associates with key vault secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
// name - name of the certificate.
// keyVaultCertificate - key vault certificate resource Id.
func (client AppServiceCertificateOrdersClient) UpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate AppServiceCertificatePatchResource) (result AppServiceCertificateResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.UpdateCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "UpdateCertificate", err.Error())
	}

	req, err := client.UpdateCertificatePreparer(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "UpdateCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "UpdateCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "UpdateCertificate", resp, "Failure responding to request")
	}

	return
}

// UpdateCertificatePreparer prepares the UpdateCertificate request.
func (client AppServiceCertificateOrdersClient) UpdateCertificatePreparer(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate AppServiceCertificatePatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithJSON(keyVaultCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCertificateSender sends the UpdateCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) UpdateCertificateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateCertificateResponder handles the response to the UpdateCertificate request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) UpdateCertificateResponder(resp *http.Response) (result AppServiceCertificateResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ValidatePurchaseInformation validate information for a certificate order.
// Parameters:
// appServiceCertificateOrder - information for a certificate order.
func (client AppServiceCertificateOrdersClient) ValidatePurchaseInformation(ctx context.Context, appServiceCertificateOrder AppServiceCertificateOrder) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.ValidatePurchaseInformation")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: appServiceCertificateOrder,
			Constraints: []validation.Constraint{{Target: "appServiceCertificateOrder.AppServiceCertificateOrderProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "appServiceCertificateOrder.AppServiceCertificateOrderProperties.ValidityInYears", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "appServiceCertificateOrder.AppServiceCertificateOrderProperties.ValidityInYears", Name: validation.InclusiveMaximum, Rule: int64(3), Chain: nil},
						{Target: "appServiceCertificateOrder.AppServiceCertificateOrderProperties.ValidityInYears", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "ValidatePurchaseInformation", err.Error())
	}

	req, err := client.ValidatePurchaseInformationPreparer(ctx, appServiceCertificateOrder)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ValidatePurchaseInformation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidatePurchaseInformationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ValidatePurchaseInformation", resp, "Failure sending request")
		return
	}

	result, err = client.ValidatePurchaseInformationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "ValidatePurchaseInformation", resp, "Failure responding to request")
	}

	return
}

// ValidatePurchaseInformationPreparer prepares the ValidatePurchaseInformation request.
func (client AppServiceCertificateOrdersClient) ValidatePurchaseInformationPreparer(ctx context.Context, appServiceCertificateOrder AppServiceCertificateOrder) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation", pathParameters),
		autorest.WithJSON(appServiceCertificateOrder),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidatePurchaseInformationSender sends the ValidatePurchaseInformation request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) ValidatePurchaseInformationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ValidatePurchaseInformationResponder handles the response to the ValidatePurchaseInformation request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) ValidatePurchaseInformationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// VerifyDomainOwnership verify domain ownership for this certificate order.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// certificateOrderName - name of the certificate order.
func (client AppServiceCertificateOrdersClient) VerifyDomainOwnership(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrdersClient.VerifyDomainOwnership")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceCertificateOrdersClient", "VerifyDomainOwnership", err.Error())
	}

	req, err := client.VerifyDomainOwnershipPreparer(ctx, resourceGroupName, certificateOrderName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "VerifyDomainOwnership", nil, "Failure preparing request")
		return
	}

	resp, err := client.VerifyDomainOwnershipSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "VerifyDomainOwnership", resp, "Failure sending request")
		return
	}

	result, err = client.VerifyDomainOwnershipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersClient", "VerifyDomainOwnership", resp, "Failure responding to request")
	}

	return
}

// VerifyDomainOwnershipPreparer prepares the VerifyDomainOwnership request.
func (client AppServiceCertificateOrdersClient) VerifyDomainOwnershipPreparer(ctx context.Context, resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/verifyDomainOwnership", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// VerifyDomainOwnershipSender sends the VerifyDomainOwnership request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceCertificateOrdersClient) VerifyDomainOwnershipSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// VerifyDomainOwnershipResponder handles the response to the VerifyDomainOwnership request. The method always
// closes the http.Response Body.
func (client AppServiceCertificateOrdersClient) VerifyDomainOwnershipResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
