// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package neptune

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Specifies a character set.
type CharacterSet struct {
	_ struct{} `type:"structure"`

	// The description of the character set.
	CharacterSetDescription *string `type:"string"`

	// The name of the character set.
	CharacterSetName *string `type:"string"`
}

// String returns the string representation
func (s CharacterSet) String() string {
	return awsutil.Prettify(s)
}

// The configuration setting for the log types to be enabled for export to CloudWatch
// Logs for a specific DB instance or DB cluster.
//
// The EnableLogTypes and DisableLogTypes arrays determine which logs will be
// exported (or not exported) to CloudWatch Logs.
type CloudwatchLogsExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of log types to disable.
	DisableLogTypes []string `type:"list"`

	// The list of log types to enable.
	EnableLogTypes []string `type:"list"`
}

// String returns the string representation
func (s CloudwatchLogsExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon Neptune DB cluster.
//
// This data type is used as a response element in the DescribeDBClusters action.
type DBCluster struct {
	_ struct{} `type:"structure"`

	// AllocatedStorage always returns 1, because Neptune DB cluster storage size
	// is not fixed, but instead automatically adjusts as needed.
	AllocatedStorage *int64 `type:"integer"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a
	// DB cluster grant permission for the DB cluster to access other AWS services
	// on your behalf.
	AssociatedRoles []DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// can be created in.
	AvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string `type:"string"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []DBClusterOptionGroupStatus `locationNameList:"DBClusterOptionGroup" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This
	// same name is returned for the life of the DB cluster.
	DatabaseName *string `type:"string"`

	// The AWS Region-unique, immutable identifier for the DB cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// cluster is accessed.
	DbClusterResourceId *string `type:"string"`

	// Specifies the earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp"`

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	EnabledCloudwatchLogsExports []string `type:"list"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// Contains the master username for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB cluster.
	ReadReplicaIdentifiers []string `locationNameList:"ReadReplicaIdentifier" type:"list"`

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Read Replicas that are available in
	// a DB cluster. As clients request new connections to the reader endpoint,
	// Neptune distributes the connection requests among the Read Replicas in the
	// DB cluster. This functionality can help balance your read workload across
	// multiple Read Replicas in your DB cluster.
	//
	// If a failover occurs, and the Read Replica that you are connected to is promoted
	// to be the primary instance, your connection is dropped. To continue sending
	// your read workload to other Read Replicas in the cluster, you can then reconnect
	// to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Not supported by Neptune.
	ReplicationSourceIdentifier *string `type:"string"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// Value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// Contains status information for a DB cluster option group.
type DBClusterOptionGroupStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string `type:"string"`

	// Specifies the status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterOptionGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon Neptune DB cluster parameter group.
//
// This data type is used as a response element in the DescribeDBClusterParameterGroups
// action.
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB cluster.
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB cluster and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - the IAM role ARN is associated with the DB cluster, but the
	//    DB cluster is unable to assume the IAM role in order to access other AWS
	//    services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// Contains the details for an Amazon Neptune DB cluster snapshot
//
// This data type is used as a response element in the DescribeDBClusterSnapshots
// action.
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// snapshot can be restored in.
	AvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the DB cluster snapshot was copied from a source DB cluster snapshot,
	// the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise,
	// a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual DB cluster snapshot. For more information, see the ModifyDBClusterSnapshotAttribute
// API action.
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBClusterSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value(s) for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB cluster snapshot. If a value of all is in the list, then the manual
	// DB cluster snapshot is public and available for any AWS account to copy or
	// restore.
	AttributeValues []string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
// API action.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to copy or restore a manual DB cluster snapshot. For more information, see
// the ModifyDBClusterSnapshotAttribute API action.
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the manual DB cluster snapshot that the attributes apply
	// to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API is not specified.
	DefaultCharacterSet *CharacterSet `type:"structure"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// The types of logs that the database engine has available for export to CloudWatch
	// Logs.
	ExportableLogTypes []string `type:"list"`

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance action.
	SupportedCharacterSets []CharacterSet `locationNameList:"CharacterSet" type:"list"`

	// A list of the time zones supported by this engine for the Timezone parameter
	// of the CreateDBInstance action.
	SupportedTimezones []Timezone `locationNameList:"Timezone" type:"list"`

	// A value that indicates whether the engine version supports exporting the
	// log types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool `type:"boolean"`

	// Indicates whether the database engine version supports read replicas.
	SupportsReadReplica *bool `type:"boolean"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon Neptune DB instance.
//
// This data type is used as a response element in the DescribeDBInstances action.
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size specified in gibibytes.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Specifies whether tags are copied from the DB instance to snapshots of the
	// DB instance.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// The database name.
	DBName *string `type:"string"`

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []DBParameterGroupStatus `locationNameList:"DBParameterGroup" type:"list"`

	// Provides List of DB security group elements containing only DBSecurityGroup.Name
	// and DBSecurityGroup.Status subelements.
	DBSecurityGroups []DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Not supported
	DomainMemberships []DomainMembership `locationNameList:"DomainMembership" type:"list"`

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudwatchLogsExports []string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if AWS Identity and Access Management (IAM) authentication is enabled,
	// and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int64 `type:"integer"`

	// Not supported: The encryption for DB instances is managed by the DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Contains the master username for the DB instance.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits Neptune to send Enhanced Monitoring
	// metrics to Amazon CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []OptionGroupMembership `locationNameList:"OptionGroupMembership" type:"list"`

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// True if Performance Insights is enabled for the DB instance, and otherwise
	// false.
	PerformanceInsightsEnabled *bool `type:"boolean"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	PromotionTier *int64 `type:"integer"`

	// This flag should no longer be used.
	PubliclyAccessible *bool `deprecated:"true" type:"boolean"`

	// Contains one or more identifiers of DB clusters that are Read Replicas of
	// this DB instance.
	ReadReplicaDBClusterIdentifiers []string `locationNameList:"ReadReplicaDBClusterIdentifier" type:"list"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB instance.
	ReadReplicaDBInstanceIdentifiers []string `locationNameList:"ReadReplicaDBInstanceIdentifier" type:"list"`

	// Contains the identifier of the source DB instance if this DB instance is
	// a Read Replica.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a Read Replica. If the instance is not a Read Replica, this
	// is blank.
	StatusInfos []DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Not supported: The encryption for DB instances is managed by the DB cluster.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type associated with DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// Not supported.
	Timezone *string `type:"string"`

	// Provides a list of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// is not in an error state, this value is blank.
	Message *string `type:"string"`

	// Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of read replica, the values can
	// be replicating, error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon Neptune DB parameter group.
//
// This data type is used as a response element in the DescribeDBParameterGroups
// action.
type DBParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// Provides the customer-specified description for this DB parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
//    * CreateDBInstance
//
//    * DeleteDBInstance
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
type DBParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The name of the DP parameter group.
	DBParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// Specifies membership in a designated DB security group.
type DBSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// The status of the DB security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon Neptune DB subnet group.
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Contains a list of Subnet elements.
	Subnets []Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the VpcId of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// An Active Directory Domain membership record associated with a DB instance.
type DomainMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the Active Directory Domain.
	Domain *string `type:"string"`

	// The fully qualified domain name of the Active Directory Domain.
	FQDN *string `type:"string"`

	// The name of the IAM role to be used when making API calls to the Directory
	// Service.
	IAMRoleName *string `type:"string"`

	// The status of the DB instance's Active Directory Domain membership, such
	// as joined, pending-join, failed etc).
	Status *string `type:"string"`
}

// String returns the string representation
func (s DomainMembership) String() string {
	return awsutil.Prettify(s)
}

// A range of double values.
type DoubleRange struct {
	_ struct{} `type:"structure"`

	// The minimum value in the range.
	From *float64 `type:"double"`

	// The maximum value in the range.
	To *float64 `type:"double"`
}

// String returns the string representation
func (s DoubleRange) String() string {
	return awsutil.Prettify(s)
}

// Specifies a connection endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
// action.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous EngineDefaults request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeEvents action.
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp"`

	// Specifies the category for the event.
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType SourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful invocation of the DescribeEventCategories
// action.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful invocation of the DescribeEventSubscriptions
// action.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the event notification subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating if the subscription is enabled. True indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A list of event categories for the event notification subscription.
	EventCategoriesList []string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) for the event subscription.
	EventSubscriptionArn *string `type:"string"`

	// The topic ARN of the event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source IDs for the event notification subscription.
	SourceIdsList []string `locationNameList:"SourceId" type:"list"`

	// The source type for the event notification subscription.
	SourceType *string `type:"string"`

	// The status of the event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that Neptune no longer has permission
	// to post to the SNS topic. The status "topic-not-exist" indicates that the
	// topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// This type is not currently supported.
type Filter struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	//
	// Values is a required field
	Values []string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information on the option groups the DB instance is a member of.
type OptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the option group that the instance belongs to.
	OptionGroupName *string `type:"string"`

	// The status of the DB instance's option group membership. Valid values are:
	// in-sync, pending-apply, pending-removal, pending-maintenance-apply, pending-maintenance-removal,
	// applying, removing, and failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Contains a list of available options for a DB instance.
//
// This data type is used as a response element in the DescribeOrderableDBInstanceOptions
// action.
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for a DB instance.
	AvailabilityZones []AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The DB instance class for a DB instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of a DB instance.
	Engine *string `type:"string"`

	// The engine version of a DB instance.
	EngineVersion *string `type:"string"`

	// The license model for a DB instance.
	LicenseModel *string `type:"string"`

	// Maximum total provisioned IOPS for a DB instance.
	MaxIopsPerDbInstance *int64 `type:"integer"`

	// Maximum provisioned IOPS per GiB for a DB instance.
	MaxIopsPerGib *float64 `type:"double"`

	// Maximum storage size for a DB instance.
	MaxStorageSize *int64 `type:"integer"`

	// Minimum total provisioned IOPS for a DB instance.
	MinIopsPerDbInstance *int64 `type:"integer"`

	// Minimum provisioned IOPS per GiB for a DB instance.
	MinIopsPerGib *float64 `type:"double"`

	// Minimum storage size for a DB instance.
	MinStorageSize *int64 `type:"integer"`

	// Indicates whether a DB instance is Multi-AZ capable.
	MultiAZCapable *bool `type:"boolean"`

	// Indicates whether a DB instance can have a Read Replica.
	ReadReplicaCapable *bool `type:"boolean"`

	// Indicates the storage type for a DB instance.
	StorageType *string `type:"string"`

	// Indicates whether a DB instance supports Enhanced Monitoring at intervals
	// from 1 to 60 seconds.
	SupportsEnhancedMonitoring *bool `type:"boolean"`

	// Indicates whether a DB instance supports IAM database authentication.
	SupportsIAMDatabaseAuthentication *bool `type:"boolean"`

	// Indicates whether a DB instance supports provisioned IOPS.
	SupportsIops *bool `type:"boolean"`

	// True if a DB instance supports Performance Insights, otherwise false.
	SupportsPerformanceInsights *bool `type:"boolean"`

	// Indicates whether a DB instance supports encrypted storage.
	SupportsStorageEncryption *bool `type:"boolean"`

	// Indicates whether a DB instance is in a VPC.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// Specifies a parameter.
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod ApplyMethod `type:"string" enum:"true"`

	// Specifies the engine specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// A list of the log types whose configuration is still pending. In other words,
// these log types are in the process of being activated or deactivated.
type PendingCloudwatchLogsExports struct {
	_ struct{} `type:"structure"`

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to CloudWatch Logs.
	LogTypesToDisable []string `type:"list"`

	// Log types that are in the process of being deactivated. After they are deactivated,
	// these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []string `type:"list"`
}

// String returns the string representation
func (s PendingCloudwatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after
	// this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp"`

	// The effective date when the pending maintenance action is applied to the
	// resource. This date takes into account opt-in requests received from the
	// ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the ForcedApplyDate.
	// This value is blank if an opt-in request has not been received and nothing
	// has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action is automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the ModifyDBInstance action.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for the DB instance that will be applied
	// or is currently being applied.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceIdentifier *string `type:"string"`

	// The new DB subnet group for the DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is currently being applied.
	Iops *int64 `type:"integer"`

	// The license model for the DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Contains the pending or currently-in-progress change of the master credentials
	// for the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Specifies the CloudWatch logs to be exported.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports `type:"structure"`

	// Specifies the pending port for the DB instance.
	Port *int64 `type:"integer"`

	// Specifies the storage type to be associated with the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// A range of integer values.
type Range struct {
	_ struct{} `type:"structure"`

	// The minimum value in the range.
	From *int64 `type:"integer"`

	// The step value for the range. For example, if you have a range of 5,000 to
	// 10,000, with a step value of 1,000, the valid values start at 5,000 and step
	// up by 1,000. Even though 7,500 is within the range, it isn't a valid value
	// for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
	Step *int64 `type:"integer"`

	// The maximum value in the range.
	To *int64 `type:"integer"`
}

// String returns the string representation
func (s Range) String() string {
	return awsutil.Prettify(s)
}

// Describes the pending maintenance actions for a resource.
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// Specifies a subnet.
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Specifies the EC2 Availability Zone that the subnet is in.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// Specifies the status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// Metadata assigned to an Amazon Neptune resource consisting of a key-value
// pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and can't be prefixed with "aws:" or
	// "rds:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// A time zone associated with a DBInstance.
type Timezone struct {
	_ struct{} `type:"structure"`

	// The name of the time zone.
	TimezoneName *string `type:"string"`
}

// String returns the string representation
func (s Timezone) String() string {
	return awsutil.Prettify(s)
}

// The version of the database engine that a DB instance can be upgraded to.
type UpgradeTarget struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the target version is applied to any source
	// DB instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool `type:"boolean"`

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string `type:"string"`

	// The name of the upgrade target database engine.
	Engine *string `type:"string"`

	// The version number of the upgrade target database engine.
	EngineVersion *string `type:"string"`

	// A value that indicates whether a database engine is upgraded to a major version.
	IsMajorVersionUpgrade *bool `type:"boolean"`
}

// String returns the string representation
func (s UpgradeTarget) String() string {
	return awsutil.Prettify(s)
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the DescribeValidDBInstanceModifications
// action. You can use this information when you call ModifyDBInstance.
type ValidDBInstanceModificationsMessage struct {
	_ struct{} `type:"structure"`

	// Valid storage options for your DB instance.
	Storage []ValidStorageOptions `locationNameList:"ValidStorageOptions" type:"list"`
}

// String returns the string representation
func (s ValidDBInstanceModificationsMessage) String() string {
	return awsutil.Prettify(s)
}

// Information about valid modifications that you can make to your DB instance.
//
// Contains the result of a successful call to the DescribeValidDBInstanceModifications
// action.
type ValidStorageOptions struct {
	_ struct{} `type:"structure"`

	// The valid range of Provisioned IOPS to gibibytes of storage multiplier. For
	// example, 3-10, which means that provisioned IOPS can be between 3 and 10
	// times storage.
	IopsToStorageRatio []DoubleRange `locationNameList:"DoubleRange" type:"list"`

	// The valid range of provisioned IOPS. For example, 1000-20000.
	ProvisionedIops []Range `locationNameList:"Range" type:"list"`

	// The valid range of storage in gibibytes. For example, 100 to 16384.
	StorageSize []Range `locationNameList:"Range" type:"list"`

	// The valid storage types for your DB instance. For example, gp2, io1.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s ValidStorageOptions) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element for queries on VPC security
// group membership.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}
