// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/invoice_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for fetching the invoices of a given billing setup that were
// issued during a given month.
type ListInvoicesRequest struct {
	// Required. The ID of the customer to fetch invoices for.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The billing setup resource name of the requested invoices.
	//
	// `customers/{customer_id}/billingSetups/{billing_setup_id}`
	BillingSetup string `protobuf:"bytes,2,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// Required. The issue year to retrieve invoices, in yyyy format. Only
	// invoices issued in 2019 or later can be retrieved.
	IssueYear string `protobuf:"bytes,3,opt,name=issue_year,json=issueYear,proto3" json:"issue_year,omitempty"`
	// Required. The issue month to retrieve invoices.
	IssueMonth           enums.MonthOfYearEnum_MonthOfYear `protobuf:"varint,4,opt,name=issue_month,json=issueMonth,proto3,enum=google.ads.googleads.v2.enums.MonthOfYearEnum_MonthOfYear" json:"issue_month,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ListInvoicesRequest) Reset()         { *m = ListInvoicesRequest{} }
func (m *ListInvoicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInvoicesRequest) ProtoMessage()    {}
func (*ListInvoicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_75f8d00dc161add1, []int{0}
}

func (m *ListInvoicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInvoicesRequest.Unmarshal(m, b)
}
func (m *ListInvoicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInvoicesRequest.Marshal(b, m, deterministic)
}
func (m *ListInvoicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInvoicesRequest.Merge(m, src)
}
func (m *ListInvoicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInvoicesRequest.Size(m)
}
func (m *ListInvoicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInvoicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInvoicesRequest proto.InternalMessageInfo

func (m *ListInvoicesRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ListInvoicesRequest) GetBillingSetup() string {
	if m != nil {
		return m.BillingSetup
	}
	return ""
}

func (m *ListInvoicesRequest) GetIssueYear() string {
	if m != nil {
		return m.IssueYear
	}
	return ""
}

func (m *ListInvoicesRequest) GetIssueMonth() enums.MonthOfYearEnum_MonthOfYear {
	if m != nil {
		return m.IssueMonth
	}
	return enums.MonthOfYearEnum_UNSPECIFIED
}

// Response message for [InvoiceService.ListInvoices][google.ads.googleads.v2.services.InvoiceService.ListInvoices].
type ListInvoicesResponse struct {
	// The list of invoices that match the billing setup and time period.
	Invoices             []*resources.Invoice `protobuf:"bytes,1,rep,name=invoices,proto3" json:"invoices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListInvoicesResponse) Reset()         { *m = ListInvoicesResponse{} }
func (m *ListInvoicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInvoicesResponse) ProtoMessage()    {}
func (*ListInvoicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_75f8d00dc161add1, []int{1}
}

func (m *ListInvoicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInvoicesResponse.Unmarshal(m, b)
}
func (m *ListInvoicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInvoicesResponse.Marshal(b, m, deterministic)
}
func (m *ListInvoicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInvoicesResponse.Merge(m, src)
}
func (m *ListInvoicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInvoicesResponse.Size(m)
}
func (m *ListInvoicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInvoicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInvoicesResponse proto.InternalMessageInfo

func (m *ListInvoicesResponse) GetInvoices() []*resources.Invoice {
	if m != nil {
		return m.Invoices
	}
	return nil
}

func init() {
	proto.RegisterType((*ListInvoicesRequest)(nil), "google.ads.googleads.v2.services.ListInvoicesRequest")
	proto.RegisterType((*ListInvoicesResponse)(nil), "google.ads.googleads.v2.services.ListInvoicesResponse")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/invoice_service.proto", fileDescriptor_75f8d00dc161add1)
}

var fileDescriptor_75f8d00dc161add1 = []byte{
	// 541 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xcd, 0x8a, 0xd4, 0x40,
	0x10, 0x26, 0x19, 0x11, 0xb7, 0x67, 0xdd, 0x43, 0x56, 0x30, 0x8c, 0x82, 0xc3, 0x30, 0xc8, 0xb0,
	0x0c, 0xdd, 0x1a, 0x71, 0x0f, 0x11, 0x0f, 0x19, 0xd0, 0x75, 0x41, 0x71, 0x99, 0x85, 0x01, 0x65,
	0x30, 0x66, 0x92, 0x9e, 0x6c, 0x43, 0xd2, 0x3d, 0xa6, 0x92, 0x80, 0x88, 0x17, 0x9f, 0x40, 0xf0,
	0x0d, 0x3c, 0xfa, 0x28, 0x7b, 0xf5, 0xe6, 0x69, 0x0f, 0x9e, 0xf4, 0x0d, 0x3c, 0x49, 0xd2, 0x9d,
	0x9f, 0x01, 0xc3, 0xe2, 0xad, 0x52, 0xf5, 0x7d, 0x5f, 0x55, 0x7f, 0x55, 0x41, 0x87, 0xa1, 0x10,
	0x61, 0x44, 0x89, 0x17, 0x00, 0x91, 0x61, 0x11, 0xe5, 0x16, 0x01, 0x9a, 0xe4, 0xcc, 0xa7, 0x40,
	0x18, 0xcf, 0x05, 0xf3, 0xa9, 0xab, 0x12, 0x78, 0x93, 0x88, 0x54, 0x18, 0x43, 0x09, 0xc6, 0x5e,
	0x00, 0xb8, 0xe6, 0xe1, 0xdc, 0xc2, 0x15, 0x6f, 0x70, 0xbf, 0x4b, 0x99, 0xf2, 0x2c, 0x06, 0x12,
	0x0b, 0x9e, 0x9e, 0xb9, 0x62, 0xed, 0xbe, 0xa7, 0x5e, 0x22, 0x45, 0x07, 0xa4, 0x8b, 0x92, 0x50,
	0x10, 0x59, 0xd2, 0x9a, 0x46, 0x11, 0x6e, 0x57, 0x84, 0x0d, 0x23, 0x1e, 0xe7, 0x22, 0xf5, 0x52,
	0x26, 0x38, 0xa8, 0xea, 0xcd, 0x56, 0xd5, 0x8f, 0x18, 0xe5, 0xa9, 0x2a, 0xdc, 0x69, 0x15, 0xd6,
	0x8c, 0x46, 0x81, 0xbb, 0xa2, 0x67, 0x5e, 0xce, 0x84, 0x1a, 0x64, 0xf4, 0x5b, 0x43, 0xfb, 0xcf,
	0x19, 0xa4, 0xc7, 0xb2, 0x1b, 0xcc, 0xe9, 0xbb, 0x8c, 0x42, 0x6a, 0x8c, 0x51, 0xdf, 0xcf, 0x20,
	0x15, 0x31, 0x4d, 0x5c, 0x16, 0x98, 0xda, 0x50, 0x9b, 0xec, 0xcc, 0x7a, 0x17, 0x8e, 0x3e, 0x47,
	0x55, 0xfe, 0x38, 0x30, 0x26, 0xe8, 0xfa, 0x8a, 0x45, 0x11, 0xe3, 0xa1, 0x0b, 0x34, 0xcd, 0x36,
	0xa6, 0xde, 0xe0, 0x76, 0x55, 0xe5, 0xb4, 0x28, 0x18, 0x23, 0x84, 0x18, 0x40, 0x46, 0x4b, 0x13,
	0xcc, 0x5e, 0x03, 0xdb, 0x29, 0xd3, 0xaf, 0xa8, 0x97, 0x18, 0x6f, 0x51, 0x5f, 0x62, 0x4a, 0xc7,
	0xcc, 0x2b, 0x43, 0x6d, 0xb2, 0x67, 0xd9, 0xb8, 0xcb, 0xff, 0xd2, 0x5d, 0xfc, 0xa2, 0xc0, 0xbe,
	0x5c, 0x17, 0x02, 0x4f, 0x78, 0x16, 0xb7, 0xbf, 0xd5, 0xbc, 0xa5, 0x66, 0x99, 0x1e, 0xbd, 0x41,
	0x37, 0xb6, 0x1f, 0x0b, 0x1b, 0xc1, 0x81, 0x1a, 0x4f, 0xd1, 0x35, 0x65, 0x37, 0x98, 0xda, 0xb0,
	0x37, 0xe9, 0x5b, 0x07, 0x9d, 0x6d, 0xeb, 0x0d, 0x61, 0x25, 0x33, 0xaf, 0xb9, 0xd6, 0x67, 0x1d,
	0xed, 0xa9, 0xec, 0xa9, 0xbc, 0x0e, 0xe3, 0x42, 0x43, 0xbb, 0xed, 0x9e, 0xc6, 0x43, 0x7c, 0xd9,
	0x41, 0xe1, 0x7f, 0x2c, 0x64, 0x70, 0xf8, 0xbf, 0x34, 0xf9, 0xb4, 0x91, 0xf7, 0xc3, 0xb9, 0xd7,
	0xda, 0xe4, 0x74, 0x6b, 0x5f, 0xd3, 0x66, 0x27, 0xd3, 0x96, 0xf5, 0x9f, 0xbe, 0xff, 0xfc, 0xa2,
	0x4f, 0x8c, 0xbb, 0xc5, 0x41, 0x56, 0x5c, 0x20, 0x1f, 0x5a, 0x32, 0x8f, 0x0f, 0x3e, 0x56, 0x07,
	0x0a, 0x83, 0x5b, 0xe7, 0x8e, 0xd9, 0x4c, 0xa4, 0xa2, 0x0d, 0x03, 0xec, 0x8b, 0x78, 0xf6, 0x47,
	0x43, 0x63, 0x5f, 0xc4, 0x97, 0x4e, 0x3f, 0xdb, 0xdf, 0x36, 0xee, 0xa4, 0x38, 0xcf, 0x13, 0xed,
	0xf5, 0x33, 0x45, 0x0c, 0x45, 0xe4, 0xf1, 0x10, 0x8b, 0x24, 0x24, 0x21, 0xe5, 0xe5, 0xf1, 0x92,
	0xa6, 0x55, 0xf7, 0x5f, 0xfd, 0xa8, 0x0a, 0xbe, 0xea, 0xbd, 0x23, 0xc7, 0xf9, 0xa6, 0x0f, 0x8f,
	0xa4, 0xa0, 0x13, 0x00, 0x96, 0x61, 0x11, 0x2d, 0x2c, 0xac, 0x1a, 0xc3, 0x79, 0x05, 0x59, 0x3a,
	0x01, 0x2c, 0x6b, 0xc8, 0x72, 0x61, 0x2d, 0x2b, 0xc8, 0x2f, 0x7d, 0x2c, 0xf3, 0xb6, 0xed, 0x04,
	0x60, 0xdb, 0x35, 0xc8, 0xb6, 0x17, 0x96, 0x6d, 0x57, 0xb0, 0xd5, 0xd5, 0x72, 0xce, 0x07, 0x7f,
	0x03, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x0d, 0x78, 0x91, 0x7c, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// InvoiceServiceClient is the client API for InvoiceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InvoiceServiceClient interface {
	// Returns all invoices associated with a billing setup, for a given month.
	ListInvoices(ctx context.Context, in *ListInvoicesRequest, opts ...grpc.CallOption) (*ListInvoicesResponse, error)
}

type invoiceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewInvoiceServiceClient(cc grpc.ClientConnInterface) InvoiceServiceClient {
	return &invoiceServiceClient{cc}
}

func (c *invoiceServiceClient) ListInvoices(ctx context.Context, in *ListInvoicesRequest, opts ...grpc.CallOption) (*ListInvoicesResponse, error) {
	out := new(ListInvoicesResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.InvoiceService/ListInvoices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InvoiceServiceServer is the server API for InvoiceService service.
type InvoiceServiceServer interface {
	// Returns all invoices associated with a billing setup, for a given month.
	ListInvoices(context.Context, *ListInvoicesRequest) (*ListInvoicesResponse, error)
}

// UnimplementedInvoiceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedInvoiceServiceServer struct {
}

func (*UnimplementedInvoiceServiceServer) ListInvoices(ctx context.Context, req *ListInvoicesRequest) (*ListInvoicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInvoices not implemented")
}

func RegisterInvoiceServiceServer(s *grpc.Server, srv InvoiceServiceServer) {
	s.RegisterService(&_InvoiceService_serviceDesc, srv)
}

func _InvoiceService_ListInvoices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInvoicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InvoiceServiceServer).ListInvoices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.InvoiceService/ListInvoices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InvoiceServiceServer).ListInvoices(ctx, req.(*ListInvoicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InvoiceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.InvoiceService",
	HandlerType: (*InvoiceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInvoices",
			Handler:    _InvoiceService_ListInvoices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/invoice_service.proto",
}
