// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AssociateAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall
	// Manager administrator account. This can be an AWS Organizations master account
	// or a member account. For more information about AWS Organizations and master
	// accounts, see Managing the AWS Accounts in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
	//
	// AdminAccount is a required field
	AdminAccount *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAdminAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateAdminAccountInput"}

	if s.AdminAccount == nil {
		invalidParams.Add(aws.NewErrParamRequired("AdminAccount"))
	}
	if s.AdminAccount != nil && len(*s.AdminAccount) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AdminAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateAdminAccount = "AssociateAdminAccount"

// AssociateAdminAccountRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Sets the AWS Firewall Manager administrator account. AWS Firewall Manager
// must be associated with the master account of your AWS organization or associated
// with a member account that has the appropriate permissions. If the account
// ID that you submit is not an AWS Organizations master account, AWS Firewall
// Manager will set the appropriate permissions for the given member account.
//
// The account that you associate with AWS Firewall Manager is called the AWS
// Firewall Manager administrator account.
//
//    // Example sending a request using AssociateAdminAccountRequest.
//    req := client.AssociateAdminAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount
func (c *Client) AssociateAdminAccountRequest(input *AssociateAdminAccountInput) AssociateAdminAccountRequest {
	op := &aws.Operation{
		Name:       opAssociateAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAdminAccountInput{}
	}

	req := c.newRequest(op, input, &AssociateAdminAccountOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AssociateAdminAccountRequest{Request: req, Input: input, Copy: c.AssociateAdminAccountRequest}
}

// AssociateAdminAccountRequest is the request type for the
// AssociateAdminAccount API operation.
type AssociateAdminAccountRequest struct {
	*aws.Request
	Input *AssociateAdminAccountInput
	Copy  func(*AssociateAdminAccountInput) AssociateAdminAccountRequest
}

// Send marshals and sends the AssociateAdminAccount API request.
func (r AssociateAdminAccountRequest) Send(ctx context.Context) (*AssociateAdminAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateAdminAccountResponse{
		AssociateAdminAccountOutput: r.Request.Data.(*AssociateAdminAccountOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateAdminAccountResponse is the response type for the
// AssociateAdminAccount API operation.
type AssociateAdminAccountResponse struct {
	*AssociateAdminAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateAdminAccount request.
func (r *AssociateAdminAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
