package reservations

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// QuotaRequestsClient is the client for the QuotaRequests methods of the Reservations service.
type QuotaRequestsClient struct {
	BaseClient
}

// NewQuotaRequestsClient creates an instance of the QuotaRequestsClient client.
func NewQuotaRequestsClient() QuotaRequestsClient {
	return NewQuotaRequestsClientWithBaseURI(DefaultBaseURI)
}

// NewQuotaRequestsClientWithBaseURI creates an instance of the QuotaRequestsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewQuotaRequestsClientWithBaseURI(baseURI string) QuotaRequestsClient {
	return QuotaRequestsClient{NewWithBaseURI(baseURI)}
}

// GetStatus gets the QuotaRequest details and status by the quota requestId for the resources for the resource
// provider at a specific location. The requestId is returned as response to the Put requests for serviceLimits.
// Parameters:
// subscriptionID - azure subscription id.
// providerID - azure resource Provider id.
// location - azure region.
// ID - quota Request id.
func (client QuotaRequestsClient) GetStatus(ctx context.Context, subscriptionID string, providerID string, location string, ID string) (result QuotaRequestDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaRequestsClient.GetStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetStatusPreparer(ctx, subscriptionID, providerID, location, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "GetStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "GetStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "GetStatus", resp, "Failure responding to request")
	}

	return
}

// GetStatusPreparer prepares the GetStatus request.
func (client QuotaRequestsClient) GetStatusPreparer(ctx context.Context, subscriptionID string, providerID string, location string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":             autorest.Encode("path", ID),
		"location":       autorest.Encode("path", location),
		"providerId":     autorest.Encode("path", providerID),
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-07-19-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimitsRequests/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStatusSender sends the GetStatus request. The method will close the
// http.Response Body if it receives an error.
func (client QuotaRequestsClient) GetStatusSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetStatusResponder handles the response to the GetStatus request. The method always
// closes the http.Response Body.
func (client QuotaRequestsClient) GetStatusResponder(resp *http.Response) (result QuotaRequestDetails, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStatus for the specified location and Resource provider gets the current quota requests under the subscription
// over the time period of one year ago from now to one year back. oData filter can be used to select quota requests.
// Parameters:
// subscriptionID - azure subscription id.
// providerID - azure resource Provider id.
// location - azure region.
// filter - | Field                    | Supported operators
// |---------------------|------------------------
//
// |requestSubmitTime | ge, le, eq, gt, lt
// top - number of records to return.
// skiptoken - skiptoken is only used if a previous operation returned a partial result. If a previous response
// contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
// specifies a starting point to use for subsequent calls
func (client QuotaRequestsClient) ListStatus(ctx context.Context, subscriptionID string, providerID string, location string, filter string, top *int32, skiptoken string) (result QuotaRequestDetailsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaRequestsClient.ListStatus")
		defer func() {
			sc := -1
			if result.qrdl.Response.Response != nil {
				sc = result.qrdl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("reservations.QuotaRequestsClient", "ListStatus", err.Error())
	}

	result.fn = client.listStatusNextResults
	req, err := client.ListStatusPreparer(ctx, subscriptionID, providerID, location, filter, top, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "ListStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStatusSender(req)
	if err != nil {
		result.qrdl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "ListStatus", resp, "Failure sending request")
		return
	}

	result.qrdl, err = client.ListStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "ListStatus", resp, "Failure responding to request")
	}

	return
}

// ListStatusPreparer prepares the ListStatus request.
func (client QuotaRequestsClient) ListStatusPreparer(ctx context.Context, subscriptionID string, providerID string, location string, filter string, top *int32, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"providerId":     autorest.Encode("path", providerID),
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-07-19-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimitsRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStatusSender sends the ListStatus request. The method will close the
// http.Response Body if it receives an error.
func (client QuotaRequestsClient) ListStatusSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListStatusResponder handles the response to the ListStatus request. The method always
// closes the http.Response Body.
func (client QuotaRequestsClient) ListStatusResponder(resp *http.Response) (result QuotaRequestDetailsList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStatusNextResults retrieves the next set of results, if any.
func (client QuotaRequestsClient) listStatusNextResults(ctx context.Context, lastResults QuotaRequestDetailsList) (result QuotaRequestDetailsList, err error) {
	req, err := lastResults.quotaRequestDetailsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "listStatusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "listStatusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaRequestsClient", "listStatusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStatusComplete enumerates all values, automatically crossing page boundaries as required.
func (client QuotaRequestsClient) ListStatusComplete(ctx context.Context, subscriptionID string, providerID string, location string, filter string, top *int32, skiptoken string) (result QuotaRequestDetailsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaRequestsClient.ListStatus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStatus(ctx, subscriptionID, providerID, location, filter, top, skiptoken)
	return
}
