// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeContributorInsightsInput struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to describe, if applicable.
	IndexName *string `min:"3" type:"string"`

	// The name of the table to describe.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeContributorInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContributorInsightsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeContributorInsightsInput"}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeContributorInsightsOutput struct {
	_ struct{} `type:"structure"`

	// List of names of the associated Alpine rules.
	ContributorInsightsRuleList []string `type:"list"`

	// Current Status contributor insights.
	ContributorInsightsStatus ContributorInsightsStatus `type:"string" enum:"true"`

	// Returns information about the last failure that encountered.
	//
	// The most common exceptions for a FAILED status are:
	//
	//    * LimitExceededException - Per-account Amazon CloudWatch Contributor Insights
	//    rule limit reached. Please disable Contributor Insights for other tables/indexes
	//    OR disable Contributor Insights rules before retrying.
	//
	//    * AccessDeniedException - Amazon CloudWatch Contributor Insights rules
	//    cannot be modified due to insufficient permissions.
	//
	//    * AccessDeniedException - Failed to create service-linked role for Contributor
	//    Insights due to insufficient permissions.
	//
	//    * InternalServerError - Failed to create Amazon CloudWatch Contributor
	//    Insights rules. Please retry request.
	FailureException *FailureException `type:"structure"`

	// The name of the global secondary index being described.
	IndexName *string `min:"3" type:"string"`

	// Timestamp of the last time the status was changed.
	LastUpdateDateTime *time.Time `type:"timestamp"`

	// The name of the table being described.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribeContributorInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeContributorInsights = "DescribeContributorInsights"

// DescribeContributorInsightsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Returns information about contributor insights, for a given table or global
// secondary index.
//
//    // Example sending a request using DescribeContributorInsightsRequest.
//    req := client.DescribeContributorInsightsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContributorInsights
func (c *Client) DescribeContributorInsightsRequest(input *DescribeContributorInsightsInput) DescribeContributorInsightsRequest {
	op := &aws.Operation{
		Name:       opDescribeContributorInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContributorInsightsInput{}
	}

	req := c.newRequest(op, input, &DescribeContributorInsightsOutput{})
	return DescribeContributorInsightsRequest{Request: req, Input: input, Copy: c.DescribeContributorInsightsRequest}
}

// DescribeContributorInsightsRequest is the request type for the
// DescribeContributorInsights API operation.
type DescribeContributorInsightsRequest struct {
	*aws.Request
	Input *DescribeContributorInsightsInput
	Copy  func(*DescribeContributorInsightsInput) DescribeContributorInsightsRequest
}

// Send marshals and sends the DescribeContributorInsights API request.
func (r DescribeContributorInsightsRequest) Send(ctx context.Context) (*DescribeContributorInsightsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeContributorInsightsResponse{
		DescribeContributorInsightsOutput: r.Request.Data.(*DescribeContributorInsightsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeContributorInsightsResponse is the response type for the
// DescribeContributorInsights API operation.
type DescribeContributorInsightsResponse struct {
	*DescribeContributorInsightsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeContributorInsights request.
func (r *DescribeContributorInsightsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
