// Copyright 2012 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package salsa

import "testing"

func TestCore208(t *testing.T) {
	in := [64]byte{
		0x7e, 0x87, 0x9a, 0x21, 0x4f, 0x3e, 0xc9, 0x86,
		0x7c, 0xa9, 0x40, 0xe6, 0x41, 0x71, 0x8f, 0x26,
		0xba, 0xee, 0x55, 0x5b, 0x8c, 0x61, 0xc1, 0xb5,
		0x0d, 0xf8, 0x46, 0x11, 0x6d, 0xcd, 0x3b, 0x1d,
		0xee, 0x24, 0xf3, 0x19, 0xdf, 0x9b, 0x3d, 0x85,
		0x14, 0x12, 0x1e, 0x4b, 0x5a, 0xc5, 0xaa, 0x32,
		0x76, 0x02, 0x1d, 0x29, 0x09, 0xc7, 0x48, 0x29,
		0xed, 0xeb, 0xc6, 0x8d, 0xb8, 0xb8, 0xc2, 0x5e}

	out := [64]byte{
		0xa4, 0x1f, 0x85, 0x9c, 0x66, 0x08, 0xcc, 0x99,
		0x3b, 0x81, 0xca, 0xcb, 0x02, 0x0c, 0xef, 0x05,
		0x04, 0x4b, 0x21, 0x81, 0xa2, 0xfd, 0x33, 0x7d,
		0xfd, 0x7b, 0x1c, 0x63, 0x96, 0x68, 0x2f, 0x29,
		0xb4, 0x39, 0x31, 0x68, 0xe3, 0xc9, 0xe6, 0xbc,
		0xfe, 0x6b, 0xc5, 0xb7, 0xa0, 0x6d, 0x96, 0xba,
		0xe4, 0x24, 0xcc, 0x10, 0x2c, 0x91, 0x74, 0x5c,
		0x24, 0xad, 0x67, 0x3d, 0xc7, 0x61, 0x8f, 0x81,
	}

	Core208(&in, &in)
	if in != out {
		t.Errorf("expected %x, got %x", out, in)
	}
}

func TestOutOfBoundsWrite(t *testing.T) {
	// encrypted "0123456789"
	cipherText := []byte{170, 166, 196, 104, 175, 121, 68, 44, 174, 51}
	var counter [16]byte
	var key [32]byte
	want := "abcdefghij"
	plainText := []byte(want)
	defer func() {
		err := recover()
		if err == nil {
			t.Error("XORKeyStream expected to panic on len(dst) < len(src), but didn't")
		}
		if plainText[3] == '3' {
			t.Errorf("XORKeyStream did out of bounds write, want %v, got %v", want, string(plainText))
		}
	}()
	XORKeyStream(plainText[:3], cipherText, &counter, &key)
}
