package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the creates an Azure Data Lake Analytics account management client.
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient(subscriptionID string) Client {
	return NewClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewClientWithBaseURI creates an instance of the Client client using a custom endpoint.  Use this when interacting
// with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewClientWithBaseURI(baseURI string, subscriptionID string) Client {
	return Client{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddDataLakeStoreAccount updates the specified Data Lake Analytics account to include the additional Data Lake Store
// account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account to which to add the Data Lake Store account.
// dataLakeStoreAccountName - the name of the Data Lake Store account to add.
// parameters - the details of the Data Lake Store account.
func (client Client) AddDataLakeStoreAccount(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string, parameters AddDataLakeStoreParameters) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.AddDataLakeStoreAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Properties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("account.Client", "AddDataLakeStoreAccount", err.Error())
	}

	req, err := client.AddDataLakeStoreAccountPreparer(ctx, resourceGroupName, accountName, dataLakeStoreAccountName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "AddDataLakeStoreAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddDataLakeStoreAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "account.Client", "AddDataLakeStoreAccount", resp, "Failure sending request")
		return
	}

	result, err = client.AddDataLakeStoreAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "AddDataLakeStoreAccount", resp, "Failure responding to request")
	}

	return
}

// AddDataLakeStoreAccountPreparer prepares the AddDataLakeStoreAccount request.
func (client Client) AddDataLakeStoreAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string, parameters AddDataLakeStoreParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":              autorest.Encode("path", accountName),
		"dataLakeStoreAccountName": autorest.Encode("path", dataLakeStoreAccountName),
		"resourceGroupName":        autorest.Encode("path", resourceGroupName),
		"subscriptionId":           autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/{dataLakeStoreAccountName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddDataLakeStoreAccountSender sends the AddDataLakeStoreAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) AddDataLakeStoreAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// AddDataLakeStoreAccountResponder handles the response to the AddDataLakeStoreAccount request. The method always
// closes the http.Response Body.
func (client Client) AddDataLakeStoreAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// AddStorageAccount updates the specified Data Lake Analytics account to add an Azure Storage account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account to which to add the Azure Storage account.
// storageAccountName - the name of the Azure Storage account to add
// parameters - the parameters containing the access key and optional suffix for the Azure Storage Account.
func (client Client) AddStorageAccount(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, parameters AddStorageAccountParameters) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.AddStorageAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.Properties.AccessKey", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("account.Client", "AddStorageAccount", err.Error())
	}

	req, err := client.AddStorageAccountPreparer(ctx, resourceGroupName, accountName, storageAccountName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "AddStorageAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddStorageAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "account.Client", "AddStorageAccount", resp, "Failure sending request")
		return
	}

	result, err = client.AddStorageAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "AddStorageAccount", resp, "Failure responding to request")
	}

	return
}

// AddStorageAccountPreparer prepares the AddStorageAccount request.
func (client Client) AddStorageAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, parameters AddStorageAccountParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddStorageAccountSender sends the AddStorageAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) AddStorageAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// AddStorageAccountResponder handles the response to the AddStorageAccount request. The method always
// closes the http.Response Body.
func (client Client) AddStorageAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Create creates the specified Data Lake Analytics account. This supplies the user with computation services for Data
// Lake Analytics workloads
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.the
// account will be associated with.
// name - the name of the Data Lake Analytics account to create.
// parameters - parameters supplied to the create Data Lake Analytics account operation.
func (client Client) Create(ctx context.Context, resourceGroupName string, name string, parameters DataLakeAnalyticsAccount) (result CreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Create")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreatePreparer(ctx, resourceGroupName, name, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client Client) CreatePreparer(ctx context.Context, resourceGroupName string, name string, parameters DataLakeAnalyticsAccount) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.Type = nil
	parameters.ID = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client Client) CreateSender(req *http.Request) (future CreateFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client Client) CreateResponder(resp *http.Response) (result DataLakeAnalyticsAccount, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete begins the delete process for the Data Lake Analytics account object specified by the account name.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account to delete
func (client Client) Delete(ctx context.Context, resourceGroupName string, accountName string) (result DeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client Client) DeletePreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteSender(req *http.Request) (future DeleteFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client Client) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDataLakeStoreAccount updates the Data Lake Analytics account specified to remove the specified Data Lake Store
// account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account from which to remove the Data Lake Store account.
// dataLakeStoreAccountName - the name of the Data Lake Store account to remove
func (client Client) DeleteDataLakeStoreAccount(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.DeleteDataLakeStoreAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteDataLakeStoreAccountPreparer(ctx, resourceGroupName, accountName, dataLakeStoreAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "DeleteDataLakeStoreAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDataLakeStoreAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "account.Client", "DeleteDataLakeStoreAccount", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDataLakeStoreAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "DeleteDataLakeStoreAccount", resp, "Failure responding to request")
	}

	return
}

// DeleteDataLakeStoreAccountPreparer prepares the DeleteDataLakeStoreAccount request.
func (client Client) DeleteDataLakeStoreAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":              autorest.Encode("path", accountName),
		"dataLakeStoreAccountName": autorest.Encode("path", dataLakeStoreAccountName),
		"resourceGroupName":        autorest.Encode("path", resourceGroupName),
		"subscriptionId":           autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/{dataLakeStoreAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDataLakeStoreAccountSender sends the DeleteDataLakeStoreAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteDataLakeStoreAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteDataLakeStoreAccountResponder handles the response to the DeleteDataLakeStoreAccount request. The method always
// closes the http.Response Body.
func (client Client) DeleteDataLakeStoreAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStorageAccount updates the specified Data Lake Analytics account to remove an Azure Storage account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account from which to remove the Azure Storage account.
// storageAccountName - the name of the Azure Storage account to remove
func (client Client) DeleteStorageAccount(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.DeleteStorageAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteStorageAccountPreparer(ctx, resourceGroupName, accountName, storageAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "DeleteStorageAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteStorageAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "account.Client", "DeleteStorageAccount", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteStorageAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "DeleteStorageAccount", resp, "Failure responding to request")
	}

	return
}

// DeleteStorageAccountPreparer prepares the DeleteStorageAccount request.
func (client Client) DeleteStorageAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStorageAccountSender sends the DeleteStorageAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteStorageAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteStorageAccountResponder handles the response to the DeleteStorageAccount request. The method always
// closes the http.Response Body.
func (client Client) DeleteStorageAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets details of the specified Data Lake Analytics account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account to retrieve.
func (client Client) Get(ctx context.Context, resourceGroupName string, accountName string) (result DataLakeAnalyticsAccount, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client Client) GetPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client Client) GetResponder(resp *http.Response) (result DataLakeAnalyticsAccount, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDataLakeStoreAccount gets the specified Data Lake Store account details in the specified Data Lake Analytics
// account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account from which to retrieve the Data Lake Store account
// details.
// dataLakeStoreAccountName - the name of the Data Lake Store account to retrieve
func (client Client) GetDataLakeStoreAccount(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string) (result DataLakeStoreAccountInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetDataLakeStoreAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDataLakeStoreAccountPreparer(ctx, resourceGroupName, accountName, dataLakeStoreAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "GetDataLakeStoreAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDataLakeStoreAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "GetDataLakeStoreAccount", resp, "Failure sending request")
		return
	}

	result, err = client.GetDataLakeStoreAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "GetDataLakeStoreAccount", resp, "Failure responding to request")
	}

	return
}

// GetDataLakeStoreAccountPreparer prepares the GetDataLakeStoreAccount request.
func (client Client) GetDataLakeStoreAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":              autorest.Encode("path", accountName),
		"dataLakeStoreAccountName": autorest.Encode("path", dataLakeStoreAccountName),
		"resourceGroupName":        autorest.Encode("path", resourceGroupName),
		"subscriptionId":           autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/{dataLakeStoreAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDataLakeStoreAccountSender sends the GetDataLakeStoreAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetDataLakeStoreAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetDataLakeStoreAccountResponder handles the response to the GetDataLakeStoreAccount request. The method always
// closes the http.Response Body.
func (client Client) GetDataLakeStoreAccountResponder(resp *http.Response) (result DataLakeStoreAccountInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStorageAccount gets the specified Azure Storage account linked to the given Data Lake Analytics account.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account from which to retrieve Azure storage account
// details.
// storageAccountName - the name of the Azure Storage account for which to retrieve the details.
func (client Client) GetStorageAccount(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (result StorageAccountInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetStorageAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetStorageAccountPreparer(ctx, resourceGroupName, accountName, storageAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "GetStorageAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStorageAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "GetStorageAccount", resp, "Failure sending request")
		return
	}

	result, err = client.GetStorageAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "GetStorageAccount", resp, "Failure responding to request")
	}

	return
}

// GetStorageAccountPreparer prepares the GetStorageAccount request.
func (client Client) GetStorageAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStorageAccountSender sends the GetStorageAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetStorageAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetStorageAccountResponder handles the response to the GetStorageAccount request. The method always
// closes the http.Response Body.
func (client Client) GetStorageAccountResponder(resp *http.Response) (result StorageAccountInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStorageContainer gets the specified Azure Storage container associated with the given Data Lake Analytics and
// Azure Storage accounts.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account for which to retrieve blob container.
// storageAccountName - the name of the Azure storage account from which to retrieve the blob container.
// containerName - the name of the Azure storage container to retrieve
func (client Client) GetStorageContainer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, containerName string) (result BlobContainer, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetStorageContainer")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetStorageContainerPreparer(ctx, resourceGroupName, accountName, storageAccountName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "GetStorageContainer", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStorageContainerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "GetStorageContainer", resp, "Failure sending request")
		return
	}

	result, err = client.GetStorageContainerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "GetStorageContainer", resp, "Failure responding to request")
	}

	return
}

// GetStorageContainerPreparer prepares the GetStorageContainer request.
func (client Client) GetStorageContainerPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"containerName":      autorest.Encode("path", containerName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers/{containerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStorageContainerSender sends the GetStorageContainer request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetStorageContainerSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetStorageContainerResponder handles the response to the GetStorageContainer request. The method always
// closes the http.Response Body.
func (client Client) GetStorageContainerResponder(resp *http.Response) (result BlobContainer, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the first page of Data Lake Analytics accounts, if any, within the current subscription. This includes a
// link to the next page, if any.
// Parameters:
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories/$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
// search - a free form search. A free-text search expression to match for whether a particular entry should be
// included in the feed, e.g. Categories?$search=blue OR green. Optional.
// formatParameter - the desired return format. Return the response in particular format without access to
// request headers for standard content-type negotiation (e.g Orders?$format=json). Optional.
func (client Client) List(ctx context.Context, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.List")
		defer func() {
			sc := -1
			if result.dlaalr.Response.Response != nil {
				sc = result.dlaalr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.dlaalr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "List", resp, "Failure sending request")
		return
	}

	result.dlaalr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client Client) ListPreparer(ctx context.Context, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/accounts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client Client) ListResponder(resp *http.Response) (result DataLakeAnalyticsAccountListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client Client) listNextResults(ctx context.Context, lastResults DataLakeAnalyticsAccountListResult) (result DataLakeAnalyticsAccountListResult, err error) {
	req, err := lastResults.dataLakeAnalyticsAccountListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.Client", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.Client", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListComplete(ctx context.Context, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	return
}

// ListByResourceGroup gets the first page of Data Lake Analytics accounts, if any, within a specific resource group.
// This includes a link to the next page, if any.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories/$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
// search - a free form search. A free-text search expression to match for whether a particular entry should be
// included in the feed, e.g. Categories?$search=blue OR green. Optional.
// formatParameter - the return format. Return the response in particular format without access to request
// headers for standard content-type negotiation (e.g Orders?$format=json). Optional.
func (client Client) ListByResourceGroup(ctx context.Context, resourceGroupName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.dlaalr.Response.Response != nil {
				sc = result.dlaalr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.dlaalr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.dlaalr, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client Client) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client Client) ListByResourceGroupResponder(resp *http.Response) (result DataLakeAnalyticsAccountListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client Client) listByResourceGroupNextResults(ctx context.Context, lastResults DataLakeAnalyticsAccountListResult) (result DataLakeAnalyticsAccountListResult, err error) {
	req, err := lastResults.dataLakeAnalyticsAccountListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.Client", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.Client", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	return
}

// ListDataLakeStoreAccounts gets the first page of Data Lake Store accounts linked to the specified Data Lake
// Analytics account. The response includes a link to the next page, if any.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account for which to list Data Lake Store accounts.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories/$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
// search - a free form search. A free-text search expression to match for whether a particular entry should be
// included in the feed, e.g. Categories?$search=blue OR green. Optional.
// formatParameter - the desired return format. Return the response in particular format without access to
// request headers for standard content-type negotiation (e.g Orders?$format=json). Optional.
func (client Client) ListDataLakeStoreAccounts(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListDataLakeStoreResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListDataLakeStoreAccounts")
		defer func() {
			sc := -1
			if result.dlaaldlsr.Response.Response != nil {
				sc = result.dlaaldlsr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listDataLakeStoreAccountsNextResults
	req, err := client.ListDataLakeStoreAccountsPreparer(ctx, resourceGroupName, accountName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListDataLakeStoreAccounts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDataLakeStoreAccountsSender(req)
	if err != nil {
		result.dlaaldlsr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "ListDataLakeStoreAccounts", resp, "Failure sending request")
		return
	}

	result.dlaaldlsr, err = client.ListDataLakeStoreAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListDataLakeStoreAccounts", resp, "Failure responding to request")
	}

	return
}

// ListDataLakeStoreAccountsPreparer prepares the ListDataLakeStoreAccounts request.
func (client Client) ListDataLakeStoreAccountsPreparer(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDataLakeStoreAccountsSender sends the ListDataLakeStoreAccounts request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListDataLakeStoreAccountsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListDataLakeStoreAccountsResponder handles the response to the ListDataLakeStoreAccounts request. The method always
// closes the http.Response Body.
func (client Client) ListDataLakeStoreAccountsResponder(resp *http.Response) (result DataLakeAnalyticsAccountListDataLakeStoreResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDataLakeStoreAccountsNextResults retrieves the next set of results, if any.
func (client Client) listDataLakeStoreAccountsNextResults(ctx context.Context, lastResults DataLakeAnalyticsAccountListDataLakeStoreResult) (result DataLakeAnalyticsAccountListDataLakeStoreResult, err error) {
	req, err := lastResults.dataLakeAnalyticsAccountListDataLakeStoreResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.Client", "listDataLakeStoreAccountsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDataLakeStoreAccountsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.Client", "listDataLakeStoreAccountsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDataLakeStoreAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "listDataLakeStoreAccountsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDataLakeStoreAccountsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListDataLakeStoreAccountsComplete(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListDataLakeStoreResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListDataLakeStoreAccounts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDataLakeStoreAccounts(ctx, resourceGroupName, accountName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	return
}

// ListSasTokens gets the SAS token associated with the specified Data Lake Analytics and Azure Storage account and
// container combination.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account from which an Azure Storage account's SAS token is
// being requested.
// storageAccountName - the name of the Azure storage account for which the SAS token is being requested.
// containerName - the name of the Azure storage container for which the SAS token is being requested.
func (client Client) ListSasTokens(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, containerName string) (result ListSasTokensResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListSasTokens")
		defer func() {
			sc := -1
			if result.lstr.Response.Response != nil {
				sc = result.lstr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSasTokensNextResults
	req, err := client.ListSasTokensPreparer(ctx, resourceGroupName, accountName, storageAccountName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListSasTokens", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSasTokensSender(req)
	if err != nil {
		result.lstr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "ListSasTokens", resp, "Failure sending request")
		return
	}

	result.lstr, err = client.ListSasTokensResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListSasTokens", resp, "Failure responding to request")
	}

	return
}

// ListSasTokensPreparer prepares the ListSasTokens request.
func (client Client) ListSasTokensPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"containerName":      autorest.Encode("path", containerName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers/{containerName}/listSasTokens", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSasTokensSender sends the ListSasTokens request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListSasTokensSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListSasTokensResponder handles the response to the ListSasTokens request. The method always
// closes the http.Response Body.
func (client Client) ListSasTokensResponder(resp *http.Response) (result ListSasTokensResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSasTokensNextResults retrieves the next set of results, if any.
func (client Client) listSasTokensNextResults(ctx context.Context, lastResults ListSasTokensResult) (result ListSasTokensResult, err error) {
	req, err := lastResults.listSasTokensResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.Client", "listSasTokensNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSasTokensSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.Client", "listSasTokensNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSasTokensResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "listSasTokensNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSasTokensComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListSasTokensComplete(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, containerName string) (result ListSasTokensResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListSasTokens")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSasTokens(ctx, resourceGroupName, accountName, storageAccountName, containerName)
	return
}

// ListStorageAccounts gets the first page of Azure Storage accounts, if any, linked to the specified Data Lake
// Analytics account. The response includes a link to the next page, if any.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account for which to list Azure Storage accounts.
// filter - the OData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories/$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
// search - a free form search. A free-text search expression to match for whether a particular entry should be
// included in the feed, e.g. Categories?$search=blue OR green. Optional.
// formatParameter - the desired return format. Return the response in particular format without access to
// request headers for standard content-type negotiation (e.g Orders?$format=json). Optional.
func (client Client) ListStorageAccounts(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListStorageAccountsResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListStorageAccounts")
		defer func() {
			sc := -1
			if result.dlaalsar.Response.Response != nil {
				sc = result.dlaalsar.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listStorageAccountsNextResults
	req, err := client.ListStorageAccountsPreparer(ctx, resourceGroupName, accountName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListStorageAccounts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStorageAccountsSender(req)
	if err != nil {
		result.dlaalsar.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "ListStorageAccounts", resp, "Failure sending request")
		return
	}

	result.dlaalsar, err = client.ListStorageAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListStorageAccounts", resp, "Failure responding to request")
	}

	return
}

// ListStorageAccountsPreparer prepares the ListStorageAccounts request.
func (client Client) ListStorageAccountsPreparer(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStorageAccountsSender sends the ListStorageAccounts request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListStorageAccountsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListStorageAccountsResponder handles the response to the ListStorageAccounts request. The method always
// closes the http.Response Body.
func (client Client) ListStorageAccountsResponder(resp *http.Response) (result DataLakeAnalyticsAccountListStorageAccountsResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStorageAccountsNextResults retrieves the next set of results, if any.
func (client Client) listStorageAccountsNextResults(ctx context.Context, lastResults DataLakeAnalyticsAccountListStorageAccountsResult) (result DataLakeAnalyticsAccountListStorageAccountsResult, err error) {
	req, err := lastResults.dataLakeAnalyticsAccountListStorageAccountsResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.Client", "listStorageAccountsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStorageAccountsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.Client", "listStorageAccountsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStorageAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "listStorageAccountsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStorageAccountsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListStorageAccountsComplete(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeAnalyticsAccountListStorageAccountsResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListStorageAccounts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStorageAccounts(ctx, resourceGroupName, accountName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	return
}

// ListStorageContainers lists the Azure Storage containers, if any, associated with the specified Data Lake Analytics
// and Azure Storage account combination. The response includes a link to the next page of results, if any.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account for which to list Azure Storage blob containers.
// storageAccountName - the name of the Azure storage account from which to list blob containers.
func (client Client) ListStorageContainers(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (result ListBlobContainersResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListStorageContainers")
		defer func() {
			sc := -1
			if result.lbcr.Response.Response != nil {
				sc = result.lbcr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listStorageContainersNextResults
	req, err := client.ListStorageContainersPreparer(ctx, resourceGroupName, accountName, storageAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListStorageContainers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStorageContainersSender(req)
	if err != nil {
		result.lbcr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "account.Client", "ListStorageContainers", resp, "Failure sending request")
		return
	}

	result.lbcr, err = client.ListStorageContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "ListStorageContainers", resp, "Failure responding to request")
	}

	return
}

// ListStorageContainersPreparer prepares the ListStorageContainers request.
func (client Client) ListStorageContainersPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStorageContainersSender sends the ListStorageContainers request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListStorageContainersSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListStorageContainersResponder handles the response to the ListStorageContainers request. The method always
// closes the http.Response Body.
func (client Client) ListStorageContainersResponder(resp *http.Response) (result ListBlobContainersResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStorageContainersNextResults retrieves the next set of results, if any.
func (client Client) listStorageContainersNextResults(ctx context.Context, lastResults ListBlobContainersResult) (result ListBlobContainersResult, err error) {
	req, err := lastResults.listBlobContainersResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.Client", "listStorageContainersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStorageContainersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.Client", "listStorageContainersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStorageContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "listStorageContainersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStorageContainersComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListStorageContainersComplete(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string) (result ListBlobContainersResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListStorageContainers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStorageContainers(ctx, resourceGroupName, accountName, storageAccountName)
	return
}

// Update updates the Data Lake Analytics account object specified by the accountName with the contents of the account
// object.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// name - the name of the Data Lake Analytics account to update.
// parameters - parameters supplied to the update Data Lake Analytics account operation.
func (client Client) Update(ctx context.Context, resourceGroupName string, name string, parameters DataLakeAnalyticsAccount) (result UpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Update")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, resourceGroupName, name, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client Client) UpdatePreparer(ctx context.Context, resourceGroupName string, name string, parameters DataLakeAnalyticsAccount) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.Type = nil
	parameters.ID = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client Client) UpdateSender(req *http.Request) (future UpdateFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client Client) UpdateResponder(resp *http.Response) (result DataLakeAnalyticsAccount, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateStorageAccount updates the Data Lake Analytics account to replace Azure Storage blob account details, such as
// the access key and/or suffix.
// Parameters:
// resourceGroupName - the name of the Azure resource group that contains the Data Lake Analytics account.
// accountName - the name of the Data Lake Analytics account to modify storage accounts in
// storageAccountName - the Azure Storage account to modify
// parameters - the parameters containing the access key and suffix to update the storage account with.
func (client Client) UpdateStorageAccount(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, parameters AddStorageAccountParameters) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.UpdateStorageAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateStorageAccountPreparer(ctx, resourceGroupName, accountName, storageAccountName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "UpdateStorageAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateStorageAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "account.Client", "UpdateStorageAccount", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateStorageAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.Client", "UpdateStorageAccount", resp, "Failure responding to request")
	}

	return
}

// UpdateStorageAccountPreparer prepares the UpdateStorageAccount request.
func (client Client) UpdateStorageAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, parameters AddStorageAccountParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":        autorest.Encode("path", accountName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"storageAccountName": autorest.Encode("path", storageAccountName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateStorageAccountSender sends the UpdateStorageAccount request. The method will close the
// http.Response Body if it receives an error.
func (client Client) UpdateStorageAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateStorageAccountResponder handles the response to the UpdateStorageAccount request. The method always
// closes the http.Response Body.
func (client Client) UpdateStorageAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
