// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeregisterRdsDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS instance's ARN.
	//
	// RdsDbInstanceArn is a required field
	RdsDbInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterRdsDbInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterRdsDbInstanceInput"}

	if s.RdsDbInstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RdsDbInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterRdsDbInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterRdsDbInstance = "DeregisterRdsDbInstance"

// DeregisterRdsDbInstanceRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Deregisters an Amazon RDS instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DeregisterRdsDbInstanceRequest.
//    req := client.DeregisterRdsDbInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterRdsDbInstance
func (c *Client) DeregisterRdsDbInstanceRequest(input *DeregisterRdsDbInstanceInput) DeregisterRdsDbInstanceRequest {
	op := &aws.Operation{
		Name:       opDeregisterRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterRdsDbInstanceInput{}
	}

	req := c.newRequest(op, input, &DeregisterRdsDbInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeregisterRdsDbInstanceRequest{Request: req, Input: input, Copy: c.DeregisterRdsDbInstanceRequest}
}

// DeregisterRdsDbInstanceRequest is the request type for the
// DeregisterRdsDbInstance API operation.
type DeregisterRdsDbInstanceRequest struct {
	*aws.Request
	Input *DeregisterRdsDbInstanceInput
	Copy  func(*DeregisterRdsDbInstanceInput) DeregisterRdsDbInstanceRequest
}

// Send marshals and sends the DeregisterRdsDbInstance API request.
func (r DeregisterRdsDbInstanceRequest) Send(ctx context.Context) (*DeregisterRdsDbInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterRdsDbInstanceResponse{
		DeregisterRdsDbInstanceOutput: r.Request.Data.(*DeregisterRdsDbInstanceOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterRdsDbInstanceResponse is the response type for the
// DeregisterRdsDbInstance API operation.
type DeregisterRdsDbInstanceResponse struct {
	*DeregisterRdsDbInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterRdsDbInstance request.
func (r *DeregisterRdsDbInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
