// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for a GetChange request.
type GetChangeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the change batch request. The value that you specify here is the
	// value that ChangeResourceRecordSets returned in the Id element when you submitted
	// the request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChangeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetChangeInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetChangeInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the ChangeInfo element.
type GetChangeOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the specified change batch.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetChangeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeInfo != nil {
		v := s.ChangeInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ChangeInfo", v, metadata)
	}
	return nil
}

const opGetChange = "GetChange"

// GetChangeRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Returns the current status of a change batch request. The status is one of
// the following values:
//
//    * PENDING indicates that the changes in this request have not propagated
//    to all Amazon Route 53 DNS servers. This is the initial status of all
//    change batch requests.
//
//    * INSYNC indicates that the changes have propagated to all Route 53 DNS
//    servers.
//
//    // Example sending a request using GetChangeRequest.
//    req := client.GetChangeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange
func (c *Client) GetChangeRequest(input *GetChangeInput) GetChangeRequest {
	op := &aws.Operation{
		Name:       opGetChange,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/change/{Id}",
	}

	if input == nil {
		input = &GetChangeInput{}
	}

	req := c.newRequest(op, input, &GetChangeOutput{})
	return GetChangeRequest{Request: req, Input: input, Copy: c.GetChangeRequest}
}

// GetChangeRequest is the request type for the
// GetChange API operation.
type GetChangeRequest struct {
	*aws.Request
	Input *GetChangeInput
	Copy  func(*GetChangeInput) GetChangeRequest
}

// Send marshals and sends the GetChange API request.
func (r GetChangeRequest) Send(ctx context.Context) (*GetChangeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetChangeResponse{
		GetChangeOutput: r.Request.Data.(*GetChangeOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetChangeResponse is the response type for the
// GetChange API operation.
type GetChangeResponse struct {
	*GetChangeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetChange request.
func (r *GetChangeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
