// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeVpcEndpoints.
type DescribeVpcEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * service-name: The name of the service.
	//
	//    * vpc-id: The ID of the VPC in which the endpoint resides.
	//
	//    * vpc-endpoint-id: The ID of the endpoint.
	//
	//    * vpc-endpoint-state - The state of the endpoint (pendingAcceptance |
	//    pending | available | deleting | deleted | rejected | failed).
	//
	//    * tag:<key> - The key/value combination of a tag assigned to the resource.
	//    Use the tag key in the filter name and the tag value as the filter value.
	//    For example, to find all resources that have a tag with the key Owner
	//    and the value TeamA, specify tag:Owner for the filter name and TeamA for
	//    the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. Use this filter
	//    to find all resources assigned a tag with a specific key, regardless of
	//    the tag value.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of items to return for this request. The request returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	//
	// Constraint: If the value is greater than 1000, we return only 1000 items.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a prior call.)
	NextToken *string `type:"string"`

	// One or more endpoint IDs.
	VpcEndpointIds []string `locationName:"VpcEndpointId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeVpcEndpoints.
type DescribeVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the endpoints.
	VpcEndpoints []VpcEndpoint `locationName:"vpcEndpointSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVpcEndpoints = "DescribeVpcEndpoints"

// DescribeVpcEndpointsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPC endpoints.
//
//    // Example sending a request using DescribeVpcEndpointsRequest.
//    req := client.DescribeVpcEndpointsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpoints
func (c *Client) DescribeVpcEndpointsRequest(input *DescribeVpcEndpointsInput) DescribeVpcEndpointsRequest {
	op := &aws.Operation{
		Name:       opDescribeVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVpcEndpointsInput{}
	}

	req := c.newRequest(op, input, &DescribeVpcEndpointsOutput{})
	return DescribeVpcEndpointsRequest{Request: req, Input: input, Copy: c.DescribeVpcEndpointsRequest}
}

// DescribeVpcEndpointsRequest is the request type for the
// DescribeVpcEndpoints API operation.
type DescribeVpcEndpointsRequest struct {
	*aws.Request
	Input *DescribeVpcEndpointsInput
	Copy  func(*DescribeVpcEndpointsInput) DescribeVpcEndpointsRequest
}

// Send marshals and sends the DescribeVpcEndpoints API request.
func (r DescribeVpcEndpointsRequest) Send(ctx context.Context) (*DescribeVpcEndpointsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVpcEndpointsResponse{
		DescribeVpcEndpointsOutput: r.Request.Data.(*DescribeVpcEndpointsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeVpcEndpointsRequestPaginator returns a paginator for DescribeVpcEndpoints.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeVpcEndpointsRequest(input)
//   p := ec2.NewDescribeVpcEndpointsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeVpcEndpointsPaginator(req DescribeVpcEndpointsRequest) DescribeVpcEndpointsPaginator {
	return DescribeVpcEndpointsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeVpcEndpointsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeVpcEndpointsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeVpcEndpointsPaginator struct {
	aws.Pager
}

func (p *DescribeVpcEndpointsPaginator) CurrentPage() *DescribeVpcEndpointsOutput {
	return p.Pager.CurrentPage().(*DescribeVpcEndpointsOutput)
}

// DescribeVpcEndpointsResponse is the response type for the
// DescribeVpcEndpoints API operation.
type DescribeVpcEndpointsResponse struct {
	*DescribeVpcEndpointsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVpcEndpoints request.
func (r *DescribeVpcEndpointsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
