package kubespec

import (
	"fmt"
	"testing"
)

var legacyNamespaces = []string{
	"io.k8s.kubernetes.pkg.api.v1.NodeAffinity",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.HorizontalPodAutoscalerStatus",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ThirdPartyResource",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.RoleRef",
	"io.k8s.kubernetes.pkg.api.v1.ConfigMapKeySelector",
	"io.k8s.kubernetes.pkg.api.v1.LimitRangeItem",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeClaimStatus",
	"io.k8s.kubernetes.pkg.api.v1.PodTemplateList",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DaemonSetSpec",
	"io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta",
	"io.k8s.kubernetes.pkg.api.v1.LocalObjectReference",
	"io.k8s.kubernetes.pkg.api.v1.FlockerVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolume",
	"io.k8s.kubernetes.pkg.api.v1.Toleration",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.HorizontalPodAutoscalerStatus",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.HorizontalPodAutoscaler",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.PodSecurityPolicy",
	"io.k8s.kubernetes.pkg.api.v1.ConfigMapProjection",
	"io.k8s.kubernetes.pkg.api.v1.ContainerStatus",
	"io.k8s.kubernetes.pkg.apis.policy.v1beta1.PodDisruptionBudget",
	"io.k8s.kubernetes.pkg.api.v1.GitRepoVolumeSource",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.DeploymentList",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.DeploymentSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DaemonSetList",
	"io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR",
	"io.k8s.kubernetes.pkg.api.v1.Binding",
	"io.k8s.kubernetes.pkg.api.v1.Pod",
	"io.k8s.kubernetes.pkg.apis.batch.v2alpha1.CronJob",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.RoleBindingList",
	"io.k8s.kubernetes.pkg.apis.storage.v1.StorageClass",
	"io.k8s.kubernetes.pkg.api.v1.LimitRange",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeClaimList",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.DeploymentRollback",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.SubjectAccessReview",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.PolicyRule",
	"io.k8s.kubernetes.pkg.api.v1.Affinity",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeClaimSpec",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.SubjectAccessReviewStatus",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.NetworkPolicySpec",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeClaimVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.ResourceQuotaSpec",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.Deployment",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.Role",
	"io.k8s.kubernetes.pkg.apis.storage.v1beta1.StorageClassList",
	"io.k8s.kubernetes.pkg.api.v1.LoadBalancerStatus",
	"io.k8s.kubernetes.pkg.api.v1.Probe",
	"io.k8s.kubernetes.pkg.api.v1.GlusterfsVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeList",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.SubjectAccessReviewSpec",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.CrossVersionObjectReference",
	"io.k8s.kubernetes.pkg.apis.certificates.v1beta1.CertificateSigningRequest",
	"io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions",
	"io.k8s.kubernetes.pkg.api.v1.ConfigMap",
	"io.k8s.kubernetes.pkg.api.v1.NodeList",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.ClusterRoleBinding",
	"io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery",
	"io.k8s.kubernetes.pkg.api.v1.NodeAddress",
	"io.k8s.kubernetes.pkg.apis.storage.v1.StorageClassList",
	"io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent",
	"io.k8s.kubernetes.pkg.api.v1.ReplicationControllerStatus",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.DeploymentCondition",
	"io.k8s.kubernetes.pkg.apis.authentication.v1.TokenReviewSpec",
	"io.k8s.kubernetes.pkg.api.v1.AzureFileVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.EnvFromSource",
	"io.k8s.kubernetes.pkg.api.v1.Node",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.StatefulSetSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.NetworkPolicyPort",
	"io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause",
	"io.k8s.kubernetes.pkg.api.v1.ContainerState",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IngressStatus",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.ClusterRole",
	"io.k8s.kubernetes.pkg.api.v1.ResourceQuota",
	"io.k8s.kubernetes.pkg.apis.settings.v1alpha1.PodPresetSpec",
	"io.k8s.kubernetes.pkg.api.v1.Service",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.ResourceAttributes",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.RollingUpdateDaemonSet",
	"io.k8s.kubernetes.pkg.apis.policy.v1beta1.PodDisruptionBudgetSpec",
	"io.k8s.kubernetes.pkg.api.v1.PodAntiAffinity",
	"io.k8s.kubernetes.pkg.api.v1.PortworxVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.RBDVolumeSource",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.DeploymentStatus",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.LocalSubjectAccessReview",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.LocalSubjectAccessReview",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.NonResourceAttributes",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.MetricStatus",
	"io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta",
	"io.k8s.kubernetes.pkg.api.v1.FlexVolumeSource",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IngressBackend",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IngressList",
	"io.k8s.kubernetes.pkg.api.v1.ComponentCondition",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeClaim",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.SELinuxStrategyOptions",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.Role",
	"io.k8s.kubernetes.pkg.api.v1.Container",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.ResourceMetricSource",
	"io.k8s.kubernetes.pkg.api.v1.HostAlias",
	"io.k8s.kubernetes.pkg.api.v1.NodeSystemInfo",
	"io.k8s.kubernetes.pkg.api.v1.ResourceRequirements",
	"io.k8s.kubernetes.pkg.api.v1.ScaleIOVolumeSource",
	"io.k8s.kubernetes.pkg.apis.authentication.v1.UserInfo",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.HorizontalPodAutoscalerSpec",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions",
	"io.k8s.apimachinery.pkg.version.Info",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.HTTPIngressPath",
	"io.k8s.kubernetes.pkg.apis.certificates.v1beta1.CertificateSigningRequestList",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.HostPortRange",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ReplicaSetStatus",
	"io.k8s.kubernetes.pkg.api.v1.Lifecycle",
	"io.k8s.kubernetes.pkg.api.v1.VolumeMount",
	"io.k8s.kubernetes.pkg.api.v1.SecretEnvSource",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ReplicaSetCondition",
	"io.k8s.kubernetes.pkg.api.v1.ComponentStatusList",
	"io.k8s.kubernetes.pkg.api.v1.Secret",
	"io.k8s.kubernetes.pkg.api.v1.ObjectFieldSelector",
	"io.k8s.kubernetes.pkg.api.v1.PodTemplate",
	"io.k8s.kubernetes.pkg.api.v1.SecretProjection",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.SubjectAccessReview",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.HorizontalPodAutoscalerList",
	"io.k8s.kubernetes.pkg.api.v1.EndpointsList",
	"io.k8s.kubernetes.pkg.api.v1.ExecAction",
	"io.k8s.kubernetes.pkg.apis.authentication.v1beta1.TokenReview",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.NetworkPolicyIngressRule",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.ClusterRoleList",
	"io.k8s.kubernetes.pkg.api.v1.ObjectReference",
	"io.k8s.kubernetes.pkg.api.v1.SecurityContext",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.MetricSpec",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Status",
	"io.k8s.kubernetes.pkg.api.v1.NodeCondition",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.SelfSubjectAccessReview",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.ScaleSpec",
	"io.k8s.kubernetes.pkg.api.v1.Namespace",
	"io.k8s.kubernetes.pkg.api.v1.ServiceStatus",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.RollingUpdateDeployment",
	"io.k8s.kubernetes.pkg.api.v1.FCVolumeSource",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.ResourceAttributes",
	"io.k8s.kubernetes.pkg.api.v1.ProjectedVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.VsphereVirtualDiskVolumeSource",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.RoleBindingList",
	"io.k8s.kubernetes.pkg.apis.storage.v1beta1.StorageClass",
	"io.k8s.kubernetes.pkg.api.v1.EnvVarSource",
	"io.k8s.kubernetes.pkg.api.v1.PhotonPersistentDiskVolumeSource",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.ObjectMetricSource",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.RoleRef",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Initializer",
	"io.k8s.kubernetes.pkg.api.v1.Event",
	"io.k8s.kubernetes.pkg.api.v1.ResourceQuotaStatus",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.SelfSubjectAccessReviewSpec",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.ScaleSpec",
	"io.k8s.kubernetes.pkg.apis.policy.v1beta1.PodDisruptionBudgetStatus",
	"io.k8s.kubernetes.pkg.apis.settings.v1alpha1.PodPresetList",
	"io.k8s.kubernetes.pkg.api.v1.ConfigMapEnvSource",
	"io.k8s.kubernetes.pkg.api.v1.NodeSelectorRequirement",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.HorizontalPodAutoscalerSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DeploymentList",
	"io.k8s.kubernetes.pkg.api.v1.Endpoints",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.HorizontalPodAutoscaler",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.SelfSubjectAccessReview",
	"io.k8s.kubernetes.pkg.apis.batch.v2alpha1.JobTemplateSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.APIVersion",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.PodSecurityPolicyList",
	"io.k8s.kubernetes.pkg.api.v1.DaemonEndpoint",
	"io.k8s.kubernetes.pkg.api.v1.ISCSIVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.GCEPersistentDiskVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.NodeSelector",
	"io.k8s.kubernetes.pkg.apis.authentication.v1.TokenReviewStatus",
	"io.k8s.kubernetes.pkg.apis.batch.v2alpha1.CronJobStatus",
	"io.k8s.apimachinery.pkg.runtime.RawExtension",
	"io.k8s.kubernetes.pkg.api.v1.ContainerImage",
	"io.k8s.kubernetes.pkg.api.v1.SecretKeySelector",
	"io.k8s.kubernetes.pkg.apis.batch.v2alpha1.CronJobList",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.NetworkPolicyPeer",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.PodSecurityPolicySpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ScaleSpec",
	"io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList",
	"io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions",
	"io.k8s.kubernetes.pkg.api.v1.ReplicationController",
	"io.k8s.kubernetes.pkg.api.v1.TCPSocketAction",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.StatefulSetList",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.SelfSubjectAccessReviewSpec",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.SubjectAccessReviewStatus",
	"io.k8s.kubernetes.pkg.api.v1.AttachedVolume",
	"io.k8s.kubernetes.pkg.api.v1.KeyToPath",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.ObjectMetricStatus",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Patch",
	"io.k8s.kubernetes.pkg.api.v1.SecretList",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.ScaleStatus",
	"io.k8s.kubernetes.pkg.apis.authentication.v1.TokenReview",
	"io.k8s.kubernetes.pkg.apis.batch.v1.JobStatus",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.Subject",
	"io.k8s.apimachinery.pkg.api.resource.Quantity",
	"io.k8s.kubernetes.pkg.api.v1.ReplicationControllerList",
	"io.k8s.kubernetes.pkg.apis.batch.v2alpha1.CronJobSpec",
	"io.k8s.kubernetes.pkg.api.v1.EnvVar",
	"io.k8s.kubernetes.pkg.api.v1.PodStatus",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ReplicaSetList",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.RoleBinding",
	"io.k8s.kubernetes.pkg.api.v1.EndpointAddress",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.ScaleStatus",
	"io.k8s.kubernetes.pkg.apis.batch.v1.JobCondition",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.FSGroupStrategyOptions",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.Ingress",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.ClusterRole",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.ClusterRoleBinding",
	"io.k8s.kubernetes.pkg.api.v1.NodeDaemonEndpoints",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.CrossVersionObjectReference",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.ResourceMetricStatus",
	"io.k8s.kubernetes.pkg.api.v1.AzureDiskVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.ResourceQuotaList",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.RoleList",
	"io.k8s.kubernetes.pkg.api.v1.PodCondition",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ThirdPartyResourceList",
	"io.k8s.apimachinery.pkg.util.intstr.IntOrString",
	"io.k8s.kubernetes.pkg.api.v1.LoadBalancerIngress",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.RollbackConfig",
	"io.k8s.kubernetes.pkg.apis.settings.v1alpha1.PodPreset",
	"io.k8s.kubernetes.pkg.api.v1.Taint",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IngressSpec",
	"io.k8s.kubernetes.pkg.api.v1.ContainerStateRunning",
	"io.k8s.kubernetes.pkg.api.v1.VolumeProjection",
	"io.k8s.kubernetes.pkg.api.v1.PreferredSchedulingTerm",
	"io.k8s.kubernetes.pkg.api.v1.SecretVolumeSource",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DeploymentCondition",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DeploymentSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DeploymentStatus",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.ClusterRoleBindingList",
	"io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup",
	"io.k8s.kubernetes.pkg.api.v1.ConfigMapList",
	"io.k8s.kubernetes.pkg.api.v1.ServicePort",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DaemonSet",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DeploymentStrategy",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IngressTLS",
	"io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference",
	"io.k8s.kubernetes.pkg.api.v1.ContainerStateTerminated",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DaemonSetUpdateStrategy",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.NetworkPolicyList",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.Scale",
	"io.k8s.kubernetes.pkg.api.v1.ReplicationControllerSpec",
	"io.k8s.kubernetes.pkg.apis.authentication.v1beta1.UserInfo",
	"io.k8s.kubernetes.pkg.api.v1.NodeStatus",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeSpec",
	"io.k8s.kubernetes.pkg.apis.certificates.v1beta1.CertificateSigningRequestStatus",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.HTTPIngressRuleValue",
	"io.k8s.kubernetes.pkg.apis.policy.v1beta1.Eviction",
	"io.k8s.kubernetes.pkg.api.v1.DownwardAPIVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.NamespaceSpec",
	"io.k8s.kubernetes.pkg.api.v1.ComponentStatus",
	"io.k8s.kubernetes.pkg.api.v1.PersistentVolumeStatus",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.SupplementalGroupsStrategyOptions",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.ClusterRoleList",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.PolicyRule",
	"io.k8s.kubernetes.pkg.api.v1.NamespaceStatus",
	"io.k8s.kubernetes.pkg.api.v1.NodeSpec",
	"io.k8s.kubernetes.pkg.api.v1.DownwardAPIVolumeFile",
	"io.k8s.kubernetes.pkg.api.v1.EndpointSubset",
	"io.k8s.kubernetes.pkg.api.v1.Handler",
	"io.k8s.kubernetes.pkg.api.v1.WeightedPodAffinityTerm",
	"io.k8s.kubernetes.pkg.apis.batch.v1.JobList",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.ClusterRoleBindingList",
	"io.k8s.apimachinery.pkg.apis.meta.v1.APIResource",
	"io.k8s.kubernetes.pkg.api.v1.AWSElasticBlockStoreVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.NFSVolumeSource",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.DeploymentStrategy",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.StatefulSetStatus",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.HorizontalPodAutoscalerList",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DeploymentRollback",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ReplicaSetSpec",
	"io.k8s.kubernetes.pkg.api.v1.CinderVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.EmptyDirVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.PodTemplateSpec",
	"io.k8s.kubernetes.pkg.api.v1.SELinuxOptions",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.RollingUpdateDeployment",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.PodsMetricStatus",
	"io.k8s.kubernetes.pkg.api.v1.Capabilities",
	"io.k8s.kubernetes.pkg.api.v1.PodSecurityContext",
	"io.k8s.kubernetes.pkg.api.v1.ContainerPort",
	"io.k8s.kubernetes.pkg.api.v1.EventSource",
	"io.k8s.kubernetes.pkg.api.v1.HostPathVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.PodAffinity",
	"io.k8s.kubernetes.pkg.api.v1.PodSpec",
	"io.k8s.kubernetes.pkg.api.v1.ReplicationControllerCondition",
	"io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails",
	"io.k8s.kubernetes.pkg.api.v1.CephFSVolumeSource",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.Scale",
	"io.k8s.kubernetes.pkg.apis.batch.v1.Job",
	"io.k8s.kubernetes.pkg.apis.rbac.v1beta1.RoleBinding",
	"io.k8s.kubernetes.pkg.api.v1.ServiceList",
	"io.k8s.kubernetes.pkg.api.v1.ServiceSpec",
	"io.k8s.kubernetes.pkg.apis.authentication.v1beta1.TokenReviewSpec",
	"io.k8s.kubernetes.pkg.apis.batch.v1.JobSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.DaemonSetStatus",
	"io.k8s.kubernetes.pkg.api.v1.NamespaceList",
	"io.k8s.kubernetes.pkg.api.v1.ServiceAccountList",
	"io.k8s.kubernetes.pkg.apis.authorization.v1.NonResourceAttributes",
	"io.k8s.kubernetes.pkg.apis.authorization.v1beta1.SubjectAccessReviewSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ReplicaSet",
	"io.k8s.kubernetes.pkg.api.v1.HTTPGetAction",
	"io.k8s.kubernetes.pkg.api.v1.LimitRangeList",
	"io.k8s.kubernetes.pkg.api.v1.ContainerStateWaiting",
	"io.k8s.kubernetes.pkg.api.v1.HTTPHeader",
	"io.k8s.kubernetes.pkg.api.v1.QuobyteVolumeSource",
	"io.k8s.kubernetes.pkg.api.v1.ResourceFieldSelector",
	"io.k8s.kubernetes.pkg.api.v1.Volume",
	"io.k8s.kubernetes.pkg.apis.certificates.v1beta1.CertificateSigningRequestCondition",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Initializers",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Time",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.RunAsUserStrategyOptions",
	"io.k8s.kubernetes.pkg.apis.policy.v1beta1.PodDisruptionBudgetList",
	"io.k8s.kubernetes.pkg.api.v1.LimitRangeSpec",
	"io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector",
	"io.k8s.kubernetes.pkg.api.v1.DownwardAPIProjection",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.RollbackConfig",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IDRange",
	"io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement",
	"io.k8s.kubernetes.pkg.api.v1.NodeSelectorTerm",
	"io.k8s.kubernetes.pkg.api.v1.EventList",
	"io.k8s.kubernetes.pkg.api.v1.PodAffinityTerm",
	"io.k8s.kubernetes.pkg.api.v1.ServiceAccount",
	"io.k8s.kubernetes.pkg.apis.apps.v1beta1.StatefulSet",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.ScaleStatus",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.Subject",
	"io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList",
	"io.k8s.kubernetes.pkg.api.v1.ConfigMapVolumeSource",
	"io.k8s.kubernetes.pkg.apis.certificates.v1beta1.CertificateSigningRequestSpec",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.Deployment",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.IngressRule",
	"io.k8s.kubernetes.pkg.apis.extensions.v1beta1.NetworkPolicy",
	"io.k8s.kubernetes.pkg.api.v1.PodList",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v1.Scale",
	"io.k8s.kubernetes.pkg.apis.autoscaling.v2alpha1.PodsMetricSource",
	"io.k8s.kubernetes.pkg.apis.rbac.v1alpha1.RoleList",
	"io.k8s.kubernetes.pkg.api.v1.EndpointPort",
	"io.k8s.kubernetes.pkg.apis.authentication.v1beta1.TokenReviewStatus",
}

// Definition naming schema for Kubernetes 1.8.x+
var newSchemaNamespaces = []string{
	"io.k8s.api.core.v1.ConfigMapList",
	"io.k8s.api.policy.v1beta1.Eviction",
	"io.k8s.api.apps.v1beta2.ControllerRevision",
	"io.k8s.api.batch.v2alpha1.CronJobList",
	"io.k8s.apimachinery.pkg.apis.meta.v1.Status",
}

func testDefinitionName(namespace string, withNewSchema bool, t *testing.T) {
	dn := DefinitionName(namespace)
	parsed, err := dn.Parse()
	if err != nil {
		t.Fatalf("Unexpected error while parsing: %v", err)
	}

	unparsed, err := parsed.Unparse(withNewSchema)
	if err != nil {
		t.Fatalf("Unexpected error while unparsing: %v", err)
	}

	if dn != unparsed {
		t.Errorf("Expected '%s' got '%s'", string(dn), unparsed)
	}
}

func TestNamespaceParser(t *testing.T) {
	for _, namespace := range legacyNamespaces {
		t.Run(fmt.Sprintf("legacy namespace: %s", namespace), func(t *testing.T) {
			testDefinitionName(namespace, true, t)
		})
	}

	for _, namespace := range newSchemaNamespaces {
		t.Run(fmt.Sprintf("namespace: %s", namespace), func(t *testing.T) {
			testDefinitionName(namespace, false, t)
		})
	}

}
