// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Access Control List files for the documents in a data source.
type AccessControlListConfiguration struct {
	_ struct{} `type:"structure"`

	// Path to the AWS S3 bucket that contains the ACL files.
	KeyPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessControlListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlListConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlListConfiguration"}
	if s.KeyPath != nil && len(*s.KeyPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about the column that should be used for filtering the
// query response by groups.
type AclConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of groups, separated by semi-colons, that filters a query response
	// based on user context. The document is only returned to users that are in
	// one of the groups specified in the UserContext field of the Query operation.
	//
	// AllowedGroupsColumnName is a required field
	AllowedGroupsColumnName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AclConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AclConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AclConfiguration"}

	if s.AllowedGroupsColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedGroupsColumnName"))
	}
	if s.AllowedGroupsColumnName != nil && len(*s.AllowedGroupsColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AllowedGroupsColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AdditionalResultAttribute struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An attribute returned with a document from a search.
	//
	// Value is a required field
	Value *AdditionalResultAttributeValue `type:"structure" required:"true"`

	// ValueType is a required field
	ValueType AdditionalResultAttributeValueType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AdditionalResultAttribute) String() string {
	return awsutil.Prettify(s)
}

// An attribute returned with a document from a search.
type AdditionalResultAttributeValue struct {
	_ struct{} `type:"structure"`

	// The text associated with the attribute and information about the highlight
	// to apply to the text.
	TextWithHighlightsValue *TextWithHighlights `type:"structure"`
}

// String returns the string representation
func (s AdditionalResultAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Provides filtering the query results based on document attributes.
type AttributeFilter struct {
	_ struct{} `type:"structure"`

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []AttributeFilter `min:"1" type:"list"`

	// Returns true when a document contains all of the specified document attributes.
	ContainsAll *DocumentAttribute `type:"structure"`

	// Returns true when a document contains any of the specified document attributes.
	ContainsAny *DocumentAttribute `type:"structure"`

	// Performs an equals operation on two document attributes.
	EqualsTo *DocumentAttribute `type:"structure"`

	// Performs a greater than operation on two document attributes. Use with a
	// document attribute of type Integer or Long.
	GreaterThan *DocumentAttribute `type:"structure"`

	// Performs a greater or equals than operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	GreaterThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a less than operation on two document attributes. Use with a document
	// attribute of type Integer or Long.
	LessThan *DocumentAttribute `type:"structure"`

	// Performs a less than or equals operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	LessThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter `type:"structure"`

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []AttributeFilter `min:"1" type:"list"`
}

// String returns the string representation
func (s AttributeFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeFilter"}
	if s.AndAllFilters != nil && len(s.AndAllFilters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AndAllFilters", 1))
	}
	if s.OrAllFilters != nil && len(s.OrAllFilters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrAllFilters", 1))
	}
	if s.AndAllFilters != nil {
		for i, v := range s.AndAllFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AndAllFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ContainsAll != nil {
		if err := s.ContainsAll.Validate(); err != nil {
			invalidParams.AddNested("ContainsAll", err.(aws.ErrInvalidParams))
		}
	}
	if s.ContainsAny != nil {
		if err := s.ContainsAny.Validate(); err != nil {
			invalidParams.AddNested("ContainsAny", err.(aws.ErrInvalidParams))
		}
	}
	if s.EqualsTo != nil {
		if err := s.EqualsTo.Validate(); err != nil {
			invalidParams.AddNested("EqualsTo", err.(aws.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(aws.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEquals != nil {
		if err := s.GreaterThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEquals", err.(aws.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(aws.ErrInvalidParams))
		}
	}
	if s.LessThanOrEquals != nil {
		if err := s.LessThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEquals", err.(aws.ErrInvalidParams))
		}
	}
	if s.NotFilter != nil {
		if err := s.NotFilter.Validate(); err != nil {
			invalidParams.AddNested("NotFilter", err.(aws.ErrInvalidParams))
		}
	}
	if s.OrAllFilters != nil {
		for i, v := range s.OrAllFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAllFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about documents that could not be removed from an index
// by the BatchDeleteDocument operation.
type BatchDeleteDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The error code for why the document couldn't be removed from the index.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// An explanation for why the document couldn't be removed from the index.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the document that couldn't be removed from the index.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchDeleteDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a document that could not be indexed.
type BatchPutDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The type of error that caused the document to fail to be indexed.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// A description of the reason why the document could not be indexed.
	ErrorMessage *string `min:"1" type:"string"`

	// The unique identifier of the document.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// Gathers information about when a particular result was clicked by a user.
// Your application uses the SubmitFeedback operation to provide click information.
type ClickFeedback struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp of the data and time that the result was clicked.
	//
	// ClickTime is a required field
	ClickTime *time.Time `type:"timestamp" required:"true"`

	// The unique identifier of the search result that was clicked.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ClickFeedback) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClickFeedback) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ClickFeedback"}

	if s.ClickTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClickTime"))
	}

	if s.ResultId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how Amazon Kendra should use the columns of a
// database in an index.
type ColumnConfiguration struct {
	_ struct{} `type:"structure"`

	// One to five columns that indicate when a document in the database has changed.
	//
	// ChangeDetectingColumns is a required field
	ChangeDetectingColumns []string `min:"1" type:"list" required:"true"`

	// The column that contains the contents of the document.
	//
	// DocumentDataColumnName is a required field
	DocumentDataColumnName *string `min:"1" type:"string" required:"true"`

	// The column that provides the document's unique identifier.
	//
	// DocumentIdColumnName is a required field
	DocumentIdColumnName *string `min:"1" type:"string" required:"true"`

	// The column that contains the title of the document.
	DocumentTitleColumnName *string `min:"1" type:"string"`

	// An array of objects that map database column names to the corresponding fields
	// in an index. You must first create the fields in the index using the UpdateIndex
	// operation.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation
func (s ColumnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ColumnConfiguration"}

	if s.ChangeDetectingColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeDetectingColumns"))
	}
	if s.ChangeDetectingColumns != nil && len(s.ChangeDetectingColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeDetectingColumns", 1))
	}

	if s.DocumentDataColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataColumnName"))
	}
	if s.DocumentDataColumnName != nil && len(*s.DocumentDataColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataColumnName", 1))
	}

	if s.DocumentIdColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentIdColumnName"))
	}
	if s.DocumentIdColumnName != nil && len(*s.DocumentIdColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentIdColumnName", 1))
	}
	if s.DocumentTitleColumnName != nil && len(*s.DocumentTitleColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleColumnName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the information necessary to connect to a database.
type ConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the host for the database. Can be either a string (host.subdomain.domain.tld)
	// or an IPv4 or IPv6 address.
	//
	// DatabaseHost is a required field
	DatabaseHost *string `min:"1" type:"string" required:"true"`

	// The name of the database containing the document data.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The port that the database uses for connections.
	//
	// DatabasePort is a required field
	DatabasePort *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Database Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html).
	// For more information about AWS Secrets Manager, see What Is AWS Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the AWS Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The name of the table that contains the document data.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConnectionConfiguration"}

	if s.DatabaseHost == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseHost"))
	}
	if s.DatabaseHost != nil && len(*s.DatabaseHost) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseHost", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.DatabasePort == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabasePort"))
	}
	if s.DatabasePort != nil && *s.DatabasePort < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DatabasePort", 1))
	}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration information for a Amazon Kendra data source.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information necessary to create a connector for a database.
	DatabaseConfiguration *DatabaseConfiguration `type:"structure"`

	// Provides information to create a connector for a document repository in an
	// Amazon S3 bucket.
	S3Configuration *S3DataSourceConfiguration `type:"structure"`

	// Provides information necessary to create a connector for a Microsoft SharePoint
	// site.
	SharePointConfiguration *SharePointConfiguration `type:"structure"`
}

// String returns the string representation
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.DatabaseConfiguration != nil {
		if err := s.DatabaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DatabaseConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(aws.ErrInvalidParams))
		}
	}
	if s.SharePointConfiguration != nil {
		if err := s.SharePointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SharePointConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Summary information for a Amazon Kendra data source. Returned in a call to .
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier for the data source.
	Id *string `min:"1" type:"string"`

	// The name of the data source.
	Name *string `min:"1" type:"string"`

	// The status of the data source. When the status is ATIVE the data source is
	// ready to use.
	Status DataSourceStatus `type:"string" enum:"true"`

	// The type of the data source.
	Type DataSourceType `type:"string" enum:"true"`

	// The UNIX datetime that the data source was lasted updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a synchronization job.
type DataSourceSyncJob struct {
	_ struct{} `type:"structure"`

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string `min:"1" type:"string"`

	// The UNIX datetime that the synchronization job was completed.
	EndTime *time.Time `type:"timestamp"`

	// If the Status field is set to FAILED, the ErrorCode field contains a the
	// reason that the synchronization failed.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// If the Status field is set to ERROR, the ErrorMessage field contains a description
	// of the error that caused the synchronization to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// A unique identifier for the synchronization job.
	ExecutionId *string `min:"1" type:"string"`

	// The UNIX datetime that the synchronization job was started.
	StartTime *time.Time `type:"timestamp"`

	// The execution status of the synchronization job. When the Status field is
	// set to SUCCEEDED, the synchronization job is done. If the status code is
	// set to FAILED, the ErrorCode and ErrorMessage fields give you the reason
	// for the failure.
	Status DataSourceSyncJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DataSourceSyncJob) String() string {
	return awsutil.Prettify(s)
}

// Maps a column or attribute in the data source to an index field. You must
// first create the fields in the index using the UpdateIndex operation.
type DataSourceToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the column or attribute in the data source.
	//
	// DataSourceFieldName is a required field
	DataSourceFieldName *string `min:"1" type:"string" required:"true"`

	// The type of data stored in the column or attribute.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the field in the index.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DataSourceToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceToIndexFieldMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceToIndexFieldMapping"}

	if s.DataSourceFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceFieldName"))
	}
	if s.DataSourceFieldName != nil && len(*s.DataSourceFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSourceFieldName", 1))
	}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("DateFieldFormat", 4))
	}

	if s.IndexFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information for connecting to an Amazon VPC.
type DataSourceVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Kendra to connect to the data source.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `min:"1" type:"list" required:"true"`

	// A list of identifiers for subnets within your Amazon VPC. The subnets should
	// be able to connect to each other in the VPC, and they should have outgoing
	// access to the Internet through a NAT device.
	//
	// SubnetIds is a required field
	SubnetIds []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DataSourceVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceVpcConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceVpcConfiguration"}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the information necessary to connect a database to an index.
type DatabaseConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the database column that provides information for user
	// context filtering.
	AclConfiguration *AclConfiguration `type:"structure"`

	// Information about where the index should get the document information from
	// the database.
	//
	// ColumnConfiguration is a required field
	ColumnConfiguration *ColumnConfiguration `type:"structure" required:"true"`

	// The information necessary to connect to a database.
	//
	// ConnectionConfiguration is a required field
	ConnectionConfiguration *ConnectionConfiguration `type:"structure" required:"true"`

	// The type of database engine that runs the database.
	//
	// DatabaseEngineType is a required field
	DatabaseEngineType DatabaseEngineType `type:"string" required:"true" enum:"true"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s DatabaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatabaseConfiguration"}

	if s.ColumnConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnConfiguration"))
	}

	if s.ConnectionConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionConfiguration"))
	}
	if len(s.DatabaseEngineType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseEngineType"))
	}
	if s.AclConfiguration != nil {
		if err := s.AclConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AclConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ColumnConfiguration != nil {
		if err := s.ColumnConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ColumnConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ConnectionConfiguration != nil {
		if err := s.ConnectionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ConnectionConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A document in an index.
type Document struct {
	_ struct{} `type:"structure"`

	// Information to use for user context filtering.
	AccessControlList []Principal `min:"1" type:"list"`

	// Custom attributes to apply to the document. Use the custom attributes to
	// provide additional information for searching, to provide facets for refining
	// searches, and to provide additional information in the query response.
	Attributes []DocumentAttribute `min:"1" type:"list"`

	// The contents of the document as a base-64 encoded string.
	//
	// Blob is automatically base64 encoded/decoded by the SDK.
	Blob []byte `min:"1" type:"blob"`

	// The file type of the document in the Blob field.
	ContentType ContentType `type:"string" enum:"true"`

	// A unique identifier of the document in the index.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The title of the document.
	Title *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Document"}
	if s.AccessControlList != nil && len(s.AccessControlList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessControlList", 1))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attributes", 1))
	}
	if s.Blob != nil && len(s.Blob) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Blob", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Title", 1))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A custom attribute value assigned to a document.
type DocumentAttribute struct {
	_ struct{} `type:"structure"`

	// The identifier for the attribute.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *DocumentAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s DocumentAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentAttribute"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of a custom document attribute. You can only provide one value
// for a custom attribute.
type DocumentAttributeValue struct {
	_ struct{} `type:"structure"`

	// A date value expressed as seconds from the Unix epoch.
	DateValue *time.Time `type:"timestamp"`

	// A long integer value.
	LongValue *int64 `type:"long"`

	// A list of strings.
	StringListValue []string `min:"1" type:"list"`

	// A string, such as "department".
	StringValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DocumentAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentAttributeValue"}
	if s.StringListValue != nil && len(s.StringListValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StringListValue", 1))
	}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the count of documents that match a particular attribute when doing
// a faceted search.
type DocumentAttributeValueCountPair struct {
	_ struct{} `type:"structure"`

	// The number of documents in the response that have the attribute value for
	// the key.
	Count *int64 `type:"integer"`

	// The value of the attribute. For example, "HR."
	DocumentAttributeValue *DocumentAttributeValue `type:"structure"`
}

// String returns the string representation
func (s DocumentAttributeValueCountPair) String() string {
	return awsutil.Prettify(s)
}

// Specifies the properties of a custom index field.
type DocumentMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the index field.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Provides manual tuning parameters to determine how the field affects the
	// search results.
	Relevance *Relevance `type:"structure"`

	// Provides information about how the field is used during a search.
	Search *Search `type:"structure"`

	// The data type of the index field.
	//
	// Type is a required field
	Type DocumentAttributeValueType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DocumentMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentMetadataConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentMetadataConfiguration"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Relevance != nil {
		if err := s.Relevance.Validate(); err != nil {
			invalidParams.AddNested("Relevance", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Document metadata files that contain information such as the document access
// control information, source URI, document author, and custom attributes.
// Each metadata file contains metadata about a single document.
type DocumentsMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// A prefix used to filter metadata configuration files in the AWS S3 bucket.
	// The S3 bucket might contain multiple metadata files. Use S3Prefix to include
	// only the desired metadata files.
	S3Prefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DocumentsMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentsMetadataConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentsMetadataConfiguration"}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information a document attribute
type Facet struct {
	_ struct{} `type:"structure"`

	// The unique key for the document attribute.
	DocumentAttributeKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Facet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Facet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Facet"}
	if s.DocumentAttributeKey != nil && len(*s.DocumentAttributeKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentAttributeKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The facet values for the documents in the response.
type FacetResult struct {
	_ struct{} `type:"structure"`

	// The key for the facet values. This is the same as the DocumentAttributeKey
	// provided in the query.
	DocumentAttributeKey *string `min:"1" type:"string"`

	// An array of key/value pairs, where the key is the value of the attribute
	// and the count is the number of documents that share the key value.
	DocumentAttributeValueCountPairs []DocumentAttributeValueCountPair `type:"list"`
}

// String returns the string representation
func (s FacetResult) String() string {
	return awsutil.Prettify(s)
}

// Provides statistical information about the FAQ questions and answers contained
// in an index.
type FaqStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of FAQ questions and answers contained in the index.
	//
	// IndexedQuestionAnswersCount is a required field
	IndexedQuestionAnswersCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FaqStatistics) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a frequently asked questions and answer contained
// in an index.
type FaqSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the FAQ was added to the index.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The name that you assigned the FAQ when you created or updated the FAQ.
	Name *string `min:"1" type:"string"`

	// The current status of the FAQ. When the status is ACTIVE the FAQ is ready
	// for use.
	Status FaqStatus `type:"string" enum:"true"`

	// The UNIX datetime that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s FaqSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides information that you can use to highlight a search result so that
// your users can quickly identify terms in the response.
type Highlight struct {
	_ struct{} `type:"structure"`

	// The zero-based location in the response string where the highlight starts.
	//
	// BeginOffset is a required field
	BeginOffset *int64 `type:"integer" required:"true"`

	// The zero-based location in the response string where the highlight ends.
	//
	// EndOffset is a required field
	EndOffset *int64 `type:"integer" required:"true"`

	// Indicates whether the response is the best response. True if this is the
	// best response; otherwise, false.
	TopAnswer *bool `type:"boolean"`
}

// String returns the string representation
func (s Highlight) String() string {
	return awsutil.Prettify(s)
}

// A summary of information about an index.
type IndexConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the index was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// A unique identifier for the index. Use this to identify the index when you
	// are using operations such as Query, DescribeIndex, UpdateIndex, and DeleteIndex.
	Id *string `min:"36" type:"string"`

	// The name of the index.
	Name *string `min:"1" type:"string"`

	// The current status of the index. When the status is ACTIVE, the index is
	// ready to search.
	//
	// Status is a required field
	Status IndexStatus `type:"string" required:"true" enum:"true"`

	// The Unix timestamp when the index was last updated by the UpdateIndex operation.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s IndexConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides information about the number of documents and the number of questions
// and answers in an index.
type IndexStatistics struct {
	_ struct{} `type:"structure"`

	// The number of question and answer topics in the index.
	//
	// FaqStatistics is a required field
	FaqStatistics *FaqStatistics `type:"structure" required:"true"`

	// The number of text documents indexed.
	//
	// TextDocumentStatistics is a required field
	TextDocumentStatistics *TextDocumentStatistics `type:"structure" required:"true"`
}

// String returns the string representation
func (s IndexStatistics) String() string {
	return awsutil.Prettify(s)
}

// Provides user and group information for document access filtering.
type Principal struct {
	_ struct{} `type:"structure"`

	// Whether to allow or deny access to the principal.
	//
	// Access is a required field
	Access ReadAccessType `type:"string" required:"true" enum:"true"`

	// The name of the user or group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of principal.
	//
	// Type is a required field
	Type PrincipalType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Principal) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Principal"}
	if len(s.Access) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Access"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A single query result.
//
// A query result contains information about a document returned by the query.
// This includes the original location of the document, a list of attributes
// assigned to the document, and relevant text from the document that satisfies
// the query.
type QueryResultItem struct {
	_ struct{} `type:"structure"`

	AdditionalAttributes []AdditionalResultAttribute `type:"list"`

	// An array of document attributes for the document that the query result maps
	// to. For example, the document author (Author) or the source URI (SourceUri)
	// of the document.
	DocumentAttributes []DocumentAttribute `min:"1" type:"list"`

	// An extract of the text in the document. Contains information about highlighting
	// the relevant terms in the excerpt.
	DocumentExcerpt *TextWithHighlights `type:"structure"`

	// The unique identifier for the document.
	DocumentId *string `min:"1" type:"string"`

	// The title of the document. Contains the text of the title and information
	// for highlighting the relevant terms in the title.
	DocumentTitle *TextWithHighlights `type:"structure"`

	// The URI of the original location of the document.
	DocumentURI *string `min:"1" type:"string"`

	// The unique identifier for the query result.
	Id *string `min:"1" type:"string"`

	// The type of document.
	Type QueryResultType `type:"string" enum:"true"`
}

// String returns the string representation
func (s QueryResultItem) String() string {
	return awsutil.Prettify(s)
}

// Provides information for manually tuning the relevance of a field in a search.
// When a query includes terms that match the field, the results are given a
// boost in the response based on these tuning parameters.
type Relevance struct {
	_ struct{} `type:"structure"`

	// Specifies the time period that the boost applies to. For example, to make
	// the boost apply to documents with the field value within the last month,
	// you would use "2628000s". Once the field value is beyond the specified range,
	// the effect of the boost drops off. The higher the importance, the faster
	// the effect drops off. If you don't specify a value, the default is 3 months.
	// The value of the field is a numeric string followed by the character "s",
	// for example "86400s" for one day, or "604800s" for one week.
	//
	// Only applies to DATE fields.
	Duration *string `min:"1" type:"string"`

	// Indicates that this field determines how "fresh" a document is. For example,
	// if document 1 was created on November 5, and document 2 was created on October
	// 31, document 1 is "fresher" than document 2. You can only set the Freshness
	// field on one DATE type field. Only applies to DATE fields.
	Freshness *bool `type:"boolean"`

	// The relative importance of the field in the search. Larger numbers provide
	// more of a boost than smaller numbers.
	Importance *int64 `min:"1" type:"integer"`

	// Determines how values should be interpreted.
	//
	// When the RankOrder field is ASCENDING, higher numbers are better. For example,
	// a document with a rating score of 10 is higher ranking than a document with
	// a rating score of 1.
	//
	// When the RankOrder field is DESCENDING, lower numbers are better. For example,
	// in a task tracking application, a priority 1 task is more important than
	// a priority 5 task.
	//
	// Only applies to LONG and DOUBLE fields.
	RankOrder Order `type:"string" enum:"true"`

	// A list of values that should be given a different boost when they appear
	// in the result list. For example, if you are boosting a field called "department,"
	// query terms that match the department field are boosted in the result. However,
	// you can add entries from the department field to boost documents with those
	// values higher.
	//
	// For example, you can add entries to the map with names of departments. If
	// you add "HR",5 and "Legal",3 those departments are given special attention
	// when they appear in the metadata of a document. When those terms appear they
	// are given the specified importance instead of the regular importance for
	// the boost.
	ValueImportanceMap map[string]int64 `type:"map"`
}

// String returns the string representation
func (s Relevance) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Relevance) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Relevance"}
	if s.Duration != nil && len(*s.Duration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Duration", 1))
	}
	if s.Importance != nil && *s.Importance < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Importance", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides feedback on how relevant a document is to a search. Your application
// uses the SubmitFeedback operation to provide relevance information.
type RelevanceFeedback struct {
	_ struct{} `type:"structure"`

	// Whether to document was relevant or not relevant to the search.
	//
	// RelevanceValue is a required field
	RelevanceValue RelevanceType `type:"string" required:"true" enum:"true"`

	// The unique identifier of the search result that the user provided relevance
	// feedback for.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RelevanceFeedback) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelevanceFeedback) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RelevanceFeedback"}
	if len(s.RelevanceValue) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RelevanceValue"))
	}

	if s.ResultId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for a data source to index documents in
// an Amazon S3 bucket.
type S3DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides the path to the S3 bucket that contains the user context filtering
	// files for the data source.
	AccessControlListConfiguration *AccessControlListConfiguration `type:"structure"`

	// The name of the bucket that contains the documents.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Document metadata files that contain information such as the document access
	// control information, source URI, document author, and custom attributes.
	// Each metadata file contains metadata about a single document.
	DocumentsMetadataConfiguration *DocumentsMetadataConfiguration `type:"structure"`

	// A list of glob patterns for documents that should not be indexed. If a document
	// that matches an inclusion prefix also matches an exclusion pattern, the document
	// is not indexed.
	//
	// For more information about glob patterns, see glob (programming) (http://wikipedia.org/wiki/Glob_%28programming%29)
	// in Wikipedia.
	ExclusionPatterns []string `type:"list"`

	// A list of S3 prefixes for the documents that should be included in the index.
	InclusionPrefixes []string `type:"list"`
}

// String returns the string representation
func (s S3DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSourceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3DataSourceConfiguration"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketName", 3))
	}
	if s.AccessControlListConfiguration != nil {
		if err := s.AccessControlListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccessControlListConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.DocumentsMetadataConfiguration != nil {
		if err := s.DocumentsMetadataConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DocumentsMetadataConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information required to find a specific file in an Amazon S3 bucket.
type S3Path struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that contains the file.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of the file.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Path) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Path) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Path"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how a custom index field is used during a search.
type Search struct {
	_ struct{} `type:"structure"`

	// Determines whether the field is returned in the query response. The default
	// is true.
	Displayable *bool `type:"boolean"`

	// Indicates that the field can be used to create search facets, a count of
	// results for each value in the field. The default is false .
	Facetable *bool `type:"boolean"`

	// Determines whether the field is used in the search. If the Searchable field
	// is true, you can use relevance tuning to manually tune how Amazon Kendra
	// weights the field in the search. The default is true for string fields and
	// false for number and date fields.
	Searchable *bool `type:"boolean"`
}

// String returns the string representation
func (s Search) String() string {
	return awsutil.Prettify(s)
}

// Provides the identifier of the AWS KMS customer master key (CMK) used to
// encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric
// CMKs.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS KMS customer master key (CMK). Amazon Kendra doesn't
	// support asymmetric CMKs.
	KmsKeyId *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for connecting to a Microsoft SharePoint
// data source.
type SharePointConfiguration struct {
	_ struct{} `type:"structure"`

	// TRUE to include attachments to documents stored in your Microsoft SharePoint
	// site in the index; otherwise, FALSE.
	CrawlAttachments *bool `type:"boolean"`

	// The Microsoft SharePoint attribute field that contains the title of the document.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft SharePoint
	// attributes to custom fields in the Amazon Kendra index. You must first create
	// the index fields using the operation before you map SharePoint attributes.
	// For more information, see Mapping Data Source Fields (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Microsoft SharePoint Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html).
	// For more information about AWS Secrets Manager, see What Is AWS Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the AWS Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The version of Microsoft SharePoint that you are using as a data source.
	//
	// SharePointVersion is a required field
	SharePointVersion SharePointVersion `type:"string" required:"true" enum:"true"`

	// The URLs of the Microsoft SharePoint site that contains the documents that
	// should be indexed.
	//
	// Urls is a required field
	Urls []string `min:"1" type:"list" required:"true"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s SharePointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SharePointConfiguration"}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}
	if len(s.SharePointVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SharePointVersion"))
	}

	if s.Urls == nil {
		invalidParams.Add(aws.NewErrParamRequired("Urls"))
	}
	if s.Urls != nil && len(s.Urls) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Urls", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about text documents indexed in an index.
type TextDocumentStatistics struct {
	_ struct{} `type:"structure"`

	// The number of text documents indexed.
	//
	// IndexedTextDocumentsCount is a required field
	IndexedTextDocumentsCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TextDocumentStatistics) String() string {
	return awsutil.Prettify(s)
}

// Provides text and information about where to highlight the text.
type TextWithHighlights struct {
	_ struct{} `type:"structure"`

	// The beginning and end of the text that should be highlighted.
	Highlights []Highlight `type:"list"`

	// The text to display to the user.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TextWithHighlights) String() string {
	return awsutil.Prettify(s)
}

// Provides a range of time.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime of the end of the time range.
	EndTime *time.Time `type:"timestamp"`

	// The UNIX datetime of the beginning of the time range.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}
