// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateRuleVersionInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The rule expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The language.
	//
	// Language is a required field
	Language Language `locationName:"language" type:"string" required:"true" enum:"true"`

	// The outcomes.
	//
	// Outcomes is a required field
	Outcomes []string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuleVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRuleVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}
	if len(s.Language) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Language"))
	}

	if s.Outcomes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Outcomes", 1))
	}

	if s.Rule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateRuleVersionOutput struct {
	_ struct{} `type:"structure"`

	// The new rule version that was created.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation
func (s UpdateRuleVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRuleVersion = "UpdateRuleVersion"

// UpdateRuleVersionRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates a rule version resulting in a new rule version.
//
//    // Example sending a request using UpdateRuleVersionRequest.
//    req := client.UpdateRuleVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *Client) UpdateRuleVersionRequest(input *UpdateRuleVersionInput) UpdateRuleVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateRuleVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateRuleVersionOutput{})
	return UpdateRuleVersionRequest{Request: req, Input: input, Copy: c.UpdateRuleVersionRequest}
}

// UpdateRuleVersionRequest is the request type for the
// UpdateRuleVersion API operation.
type UpdateRuleVersionRequest struct {
	*aws.Request
	Input *UpdateRuleVersionInput
	Copy  func(*UpdateRuleVersionInput) UpdateRuleVersionRequest
}

// Send marshals and sends the UpdateRuleVersion API request.
func (r UpdateRuleVersionRequest) Send(ctx context.Context) (*UpdateRuleVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRuleVersionResponse{
		UpdateRuleVersionOutput: r.Request.Data.(*UpdateRuleVersionOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRuleVersionResponse is the response type for the
// UpdateRuleVersion API operation.
type UpdateRuleVersionResponse struct {
	*UpdateRuleVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRuleVersion request.
func (r *UpdateRuleVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
