// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

type ListSizeConstraintSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of SizeConstraintSet objects that you want AWS WAF to
	// return for this request. If you have more SizeConstraintSets objects than
	// the number you specify for Limit, the response includes a NextMarker value
	// that you can use to get another batch of SizeConstraintSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more SizeConstraintSets than
	// the value of Limit, AWS WAF returns a NextMarker value in the response that
	// allows you to list another group of SizeConstraintSets. For the second and
	// subsequent ListSizeConstraintSets requests, specify the value of NextMarker
	// from the previous response to get information about another batch of SizeConstraintSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSizeConstraintSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSizeConstraintSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSizeConstraintSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListSizeConstraintSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more SizeConstraintSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more SizeConstraintSet objects, submit another ListSizeConstraintSets request,
	// and specify the NextMarker value from the response in the NextMarker value
	// in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of SizeConstraintSetSummary objects.
	SizeConstraintSets []waf.SizeConstraintSetSummary `type:"list"`
}

// String returns the string representation
func (s ListSizeConstraintSetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSizeConstraintSets = "ListSizeConstraintSets"

// ListSizeConstraintSetsRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Returns an array of SizeConstraintSetSummary objects.
//
//    // Example sending a request using ListSizeConstraintSetsRequest.
//    req := client.ListSizeConstraintSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSizeConstraintSets
func (c *Client) ListSizeConstraintSetsRequest(input *ListSizeConstraintSetsInput) ListSizeConstraintSetsRequest {
	op := &aws.Operation{
		Name:       opListSizeConstraintSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSizeConstraintSetsInput{}
	}

	req := c.newRequest(op, input, &ListSizeConstraintSetsOutput{})
	return ListSizeConstraintSetsRequest{Request: req, Input: input, Copy: c.ListSizeConstraintSetsRequest}
}

// ListSizeConstraintSetsRequest is the request type for the
// ListSizeConstraintSets API operation.
type ListSizeConstraintSetsRequest struct {
	*aws.Request
	Input *ListSizeConstraintSetsInput
	Copy  func(*ListSizeConstraintSetsInput) ListSizeConstraintSetsRequest
}

// Send marshals and sends the ListSizeConstraintSets API request.
func (r ListSizeConstraintSetsRequest) Send(ctx context.Context) (*ListSizeConstraintSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSizeConstraintSetsResponse{
		ListSizeConstraintSetsOutput: r.Request.Data.(*ListSizeConstraintSetsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListSizeConstraintSetsResponse is the response type for the
// ListSizeConstraintSets API operation.
type ListSizeConstraintSetsResponse struct {
	*ListSizeConstraintSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSizeConstraintSets request.
func (r *ListSizeConstraintSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
