// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package accessanalyzeriface provides an interface to enable mocking the Access Analyzer service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package accessanalyzeriface

import (
	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer"
)

// ClientAPI provides an interface to enable mocking the
// accessanalyzer.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Access Analyzer.
//    func myFunc(svc accessanalyzeriface.ClientAPI) bool {
//        // Make svc.CreateAnalyzer request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := accessanalyzer.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        accessanalyzeriface.ClientPI
//    }
//    func (m *mockClientClient) CreateAnalyzer(input *accessanalyzer.CreateAnalyzerInput) (*accessanalyzer.CreateAnalyzerOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateAnalyzerRequest(*accessanalyzer.CreateAnalyzerInput) accessanalyzer.CreateAnalyzerRequest

	CreateArchiveRuleRequest(*accessanalyzer.CreateArchiveRuleInput) accessanalyzer.CreateArchiveRuleRequest

	DeleteAnalyzerRequest(*accessanalyzer.DeleteAnalyzerInput) accessanalyzer.DeleteAnalyzerRequest

	DeleteArchiveRuleRequest(*accessanalyzer.DeleteArchiveRuleInput) accessanalyzer.DeleteArchiveRuleRequest

	GetAnalyzedResourceRequest(*accessanalyzer.GetAnalyzedResourceInput) accessanalyzer.GetAnalyzedResourceRequest

	GetAnalyzerRequest(*accessanalyzer.GetAnalyzerInput) accessanalyzer.GetAnalyzerRequest

	GetArchiveRuleRequest(*accessanalyzer.GetArchiveRuleInput) accessanalyzer.GetArchiveRuleRequest

	GetFindingRequest(*accessanalyzer.GetFindingInput) accessanalyzer.GetFindingRequest

	ListAnalyzedResourcesRequest(*accessanalyzer.ListAnalyzedResourcesInput) accessanalyzer.ListAnalyzedResourcesRequest

	ListAnalyzersRequest(*accessanalyzer.ListAnalyzersInput) accessanalyzer.ListAnalyzersRequest

	ListArchiveRulesRequest(*accessanalyzer.ListArchiveRulesInput) accessanalyzer.ListArchiveRulesRequest

	ListFindingsRequest(*accessanalyzer.ListFindingsInput) accessanalyzer.ListFindingsRequest

	ListTagsForResourceRequest(*accessanalyzer.ListTagsForResourceInput) accessanalyzer.ListTagsForResourceRequest

	StartResourceScanRequest(*accessanalyzer.StartResourceScanInput) accessanalyzer.StartResourceScanRequest

	TagResourceRequest(*accessanalyzer.TagResourceInput) accessanalyzer.TagResourceRequest

	UntagResourceRequest(*accessanalyzer.UntagResourceInput) accessanalyzer.UntagResourceRequest

	UpdateArchiveRuleRequest(*accessanalyzer.UpdateArchiveRuleInput) accessanalyzer.UpdateArchiveRuleRequest

	UpdateFindingsRequest(*accessanalyzer.UpdateFindingsInput) accessanalyzer.UpdateFindingsRequest
}

var _ ClientAPI = (*accessanalyzer.Client)(nil)
