// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to set whether Amazon SES includes the original email
// headers in the Amazon SNS notifications of a specified type. For information
// about notifications, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html).
type SetIdentityHeadersInNotificationsEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SES includes the original email headers in Amazon SNS
	// notifications of the specified notification type. A value of true specifies
	// that Amazon SES will include headers in notifications, and a value of false
	// specifies that Amazon SES will not include headers in notifications.
	//
	// This value can only be set when NotificationType is already set to use a
	// particular Amazon SNS topic.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The identity for which to enable or disable headers in notifications. Examples:
	// user@example.com, example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The notification type for which to enable or disable headers in notifications.
	//
	// NotificationType is a required field
	NotificationType NotificationType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SetIdentityHeadersInNotificationsEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityHeadersInNotificationsEnabledInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetIdentityHeadersInNotificationsEnabledInput"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.Identity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identity"))
	}
	if len(s.NotificationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("NotificationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type SetIdentityHeadersInNotificationsEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityHeadersInNotificationsEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetIdentityHeadersInNotificationsEnabled = "SetIdentityHeadersInNotificationsEnabled"

// SetIdentityHeadersInNotificationsEnabledRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), sets whether Amazon SES
// includes the original email headers in the Amazon Simple Notification Service
// (Amazon SNS) notifications of a specified type.
//
// You can execute this operation no more than once per second.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
//
//    // Example sending a request using SetIdentityHeadersInNotificationsEnabledRequest.
//    req := client.SetIdentityHeadersInNotificationsEnabledRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled
func (c *Client) SetIdentityHeadersInNotificationsEnabledRequest(input *SetIdentityHeadersInNotificationsEnabledInput) SetIdentityHeadersInNotificationsEnabledRequest {
	op := &aws.Operation{
		Name:       opSetIdentityHeadersInNotificationsEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityHeadersInNotificationsEnabledInput{}
	}

	req := c.newRequest(op, input, &SetIdentityHeadersInNotificationsEnabledOutput{})
	return SetIdentityHeadersInNotificationsEnabledRequest{Request: req, Input: input, Copy: c.SetIdentityHeadersInNotificationsEnabledRequest}
}

// SetIdentityHeadersInNotificationsEnabledRequest is the request type for the
// SetIdentityHeadersInNotificationsEnabled API operation.
type SetIdentityHeadersInNotificationsEnabledRequest struct {
	*aws.Request
	Input *SetIdentityHeadersInNotificationsEnabledInput
	Copy  func(*SetIdentityHeadersInNotificationsEnabledInput) SetIdentityHeadersInNotificationsEnabledRequest
}

// Send marshals and sends the SetIdentityHeadersInNotificationsEnabled API request.
func (r SetIdentityHeadersInNotificationsEnabledRequest) Send(ctx context.Context) (*SetIdentityHeadersInNotificationsEnabledResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetIdentityHeadersInNotificationsEnabledResponse{
		SetIdentityHeadersInNotificationsEnabledOutput: r.Request.Data.(*SetIdentityHeadersInNotificationsEnabledOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetIdentityHeadersInNotificationsEnabledResponse is the response type for the
// SetIdentityHeadersInNotificationsEnabled API operation.
type SetIdentityHeadersInNotificationsEnabledResponse struct {
	*SetIdentityHeadersInNotificationsEnabledOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetIdentityHeadersInNotificationsEnabled request.
func (r *SetIdentityHeadersInNotificationsEnabledResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
