// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The streaming configuration details to add.
	//
	// StreamingConfiguration is a required field
	StreamingConfiguration *StreamingConfiguration `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutVoiceConnectorStreamingConfigurationInput"}

	if s.StreamingConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamingConfiguration"))
	}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.StreamingConfiguration != nil {
		if err := s.StreamingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StreamingConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutVoiceConnectorStreamingConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.StreamingConfiguration != nil {
		v := s.StreamingConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StreamingConfiguration", v, metadata)
	}
	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The updated streaming configuration details.
	StreamingConfiguration *StreamingConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutVoiceConnectorStreamingConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamingConfiguration != nil {
		v := s.StreamingConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StreamingConfiguration", v, metadata)
	}
	return nil
}

const opPutVoiceConnectorStreamingConfiguration = "PutVoiceConnectorStreamingConfiguration"

// PutVoiceConnectorStreamingConfigurationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Adds a streaming configuration for the specified Amazon Chime Voice Connector.
// The streaming configuration specifies whether media streaming is enabled
// for sending to Amazon Kinesis. It also sets the retention period, in hours,
// for the Amazon Kinesis data.
//
//    // Example sending a request using PutVoiceConnectorStreamingConfigurationRequest.
//    req := client.PutVoiceConnectorStreamingConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration
func (c *Client) PutVoiceConnectorStreamingConfigurationRequest(input *PutVoiceConnectorStreamingConfigurationInput) PutVoiceConnectorStreamingConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutVoiceConnectorStreamingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorStreamingConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutVoiceConnectorStreamingConfigurationOutput{})
	return PutVoiceConnectorStreamingConfigurationRequest{Request: req, Input: input, Copy: c.PutVoiceConnectorStreamingConfigurationRequest}
}

// PutVoiceConnectorStreamingConfigurationRequest is the request type for the
// PutVoiceConnectorStreamingConfiguration API operation.
type PutVoiceConnectorStreamingConfigurationRequest struct {
	*aws.Request
	Input *PutVoiceConnectorStreamingConfigurationInput
	Copy  func(*PutVoiceConnectorStreamingConfigurationInput) PutVoiceConnectorStreamingConfigurationRequest
}

// Send marshals and sends the PutVoiceConnectorStreamingConfiguration API request.
func (r PutVoiceConnectorStreamingConfigurationRequest) Send(ctx context.Context) (*PutVoiceConnectorStreamingConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutVoiceConnectorStreamingConfigurationResponse{
		PutVoiceConnectorStreamingConfigurationOutput: r.Request.Data.(*PutVoiceConnectorStreamingConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutVoiceConnectorStreamingConfigurationResponse is the response type for the
// PutVoiceConnectorStreamingConfiguration API operation.
type PutVoiceConnectorStreamingConfigurationResponse struct {
	*PutVoiceConnectorStreamingConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutVoiceConnectorStreamingConfiguration request.
func (r *PutVoiceConnectorStreamingConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
