// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request for usage information about the identity pool.
type DescribeIdentityPoolUsageInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityPoolUsageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeIdentityPoolUsageInput"}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeIdentityPoolUsageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response to a successful DescribeIdentityPoolUsage request.
type DescribeIdentityPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the usage of the identity pool.
	IdentityPoolUsage *IdentityPoolUsage `type:"structure"`
}

// String returns the string representation
func (s DescribeIdentityPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeIdentityPoolUsageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.IdentityPoolUsage != nil {
		v := s.IdentityPoolUsage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IdentityPoolUsage", v, metadata)
	}
	return nil
}

const opDescribeIdentityPoolUsage = "DescribeIdentityPoolUsage"

// DescribeIdentityPoolUsageRequest returns a request value for making API operation for
// Amazon Cognito Sync.
//
// Gets usage details (for example, data storage) about a particular identity
// pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
//    // Example sending a request using DescribeIdentityPoolUsageRequest.
//    req := client.DescribeIdentityPoolUsageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityPoolUsage
func (c *Client) DescribeIdentityPoolUsageRequest(input *DescribeIdentityPoolUsageInput) DescribeIdentityPoolUsageRequest {
	op := &aws.Operation{
		Name:       opDescribeIdentityPoolUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}",
	}

	if input == nil {
		input = &DescribeIdentityPoolUsageInput{}
	}

	req := c.newRequest(op, input, &DescribeIdentityPoolUsageOutput{})
	return DescribeIdentityPoolUsageRequest{Request: req, Input: input, Copy: c.DescribeIdentityPoolUsageRequest}
}

// DescribeIdentityPoolUsageRequest is the request type for the
// DescribeIdentityPoolUsage API operation.
type DescribeIdentityPoolUsageRequest struct {
	*aws.Request
	Input *DescribeIdentityPoolUsageInput
	Copy  func(*DescribeIdentityPoolUsageInput) DescribeIdentityPoolUsageRequest
}

// Send marshals and sends the DescribeIdentityPoolUsage API request.
func (r DescribeIdentityPoolUsageRequest) Send(ctx context.Context) (*DescribeIdentityPoolUsageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeIdentityPoolUsageResponse{
		DescribeIdentityPoolUsageOutput: r.Request.Data.(*DescribeIdentityPoolUsageOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeIdentityPoolUsageResponse is the response type for the
// DescribeIdentityPoolUsage API operation.
type DescribeIdentityPoolUsageResponse struct {
	*DescribeIdentityPoolUsageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeIdentityPoolUsage request.
func (r *DescribeIdentityPoolUsageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
