// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterDeprovisionLister helps list ClusterDeprovisions.
// All objects returned here must be treated as read-only.
type ClusterDeprovisionLister interface {
	// List lists all ClusterDeprovisions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterDeprovision, err error)
	// ClusterDeprovisions returns an object that can list and get ClusterDeprovisions.
	ClusterDeprovisions(namespace string) ClusterDeprovisionNamespaceLister
	ClusterDeprovisionListerExpansion
}

// clusterDeprovisionLister implements the ClusterDeprovisionLister interface.
type clusterDeprovisionLister struct {
	indexer cache.Indexer
}

// NewClusterDeprovisionLister returns a new ClusterDeprovisionLister.
func NewClusterDeprovisionLister(indexer cache.Indexer) ClusterDeprovisionLister {
	return &clusterDeprovisionLister{indexer: indexer}
}

// List lists all ClusterDeprovisions in the indexer.
func (s *clusterDeprovisionLister) List(selector labels.Selector) (ret []*v1.ClusterDeprovision, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterDeprovision))
	})
	return ret, err
}

// ClusterDeprovisions returns an object that can list and get ClusterDeprovisions.
func (s *clusterDeprovisionLister) ClusterDeprovisions(namespace string) ClusterDeprovisionNamespaceLister {
	return clusterDeprovisionNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterDeprovisionNamespaceLister helps list and get ClusterDeprovisions.
// All objects returned here must be treated as read-only.
type ClusterDeprovisionNamespaceLister interface {
	// List lists all ClusterDeprovisions in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterDeprovision, err error)
	// Get retrieves the ClusterDeprovision from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.ClusterDeprovision, error)
	ClusterDeprovisionNamespaceListerExpansion
}

// clusterDeprovisionNamespaceLister implements the ClusterDeprovisionNamespaceLister
// interface.
type clusterDeprovisionNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterDeprovisions in the indexer for a given namespace.
func (s clusterDeprovisionNamespaceLister) List(selector labels.Selector) (ret []*v1.ClusterDeprovision, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterDeprovision))
	})
	return ret, err
}

// Get retrieves the ClusterDeprovision from the indexer for a given namespace and name.
func (s clusterDeprovisionNamespaceLister) Get(name string) (*v1.ClusterDeprovision, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterdeprovision"), name)
	}
	return obj.(*v1.ClusterDeprovision), nil
}
