/*
Copyright the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/heptio/velero/pkg/apis/velero/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ServerStatusRequestLister helps list ServerStatusRequests.
type ServerStatusRequestLister interface {
	// List lists all ServerStatusRequests in the indexer.
	List(selector labels.Selector) (ret []*v1.ServerStatusRequest, err error)
	// ServerStatusRequests returns an object that can list and get ServerStatusRequests.
	ServerStatusRequests(namespace string) ServerStatusRequestNamespaceLister
	ServerStatusRequestListerExpansion
}

// serverStatusRequestLister implements the ServerStatusRequestLister interface.
type serverStatusRequestLister struct {
	indexer cache.Indexer
}

// NewServerStatusRequestLister returns a new ServerStatusRequestLister.
func NewServerStatusRequestLister(indexer cache.Indexer) ServerStatusRequestLister {
	return &serverStatusRequestLister{indexer: indexer}
}

// List lists all ServerStatusRequests in the indexer.
func (s *serverStatusRequestLister) List(selector labels.Selector) (ret []*v1.ServerStatusRequest, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ServerStatusRequest))
	})
	return ret, err
}

// ServerStatusRequests returns an object that can list and get ServerStatusRequests.
func (s *serverStatusRequestLister) ServerStatusRequests(namespace string) ServerStatusRequestNamespaceLister {
	return serverStatusRequestNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ServerStatusRequestNamespaceLister helps list and get ServerStatusRequests.
type ServerStatusRequestNamespaceLister interface {
	// List lists all ServerStatusRequests in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.ServerStatusRequest, err error)
	// Get retrieves the ServerStatusRequest from the indexer for a given namespace and name.
	Get(name string) (*v1.ServerStatusRequest, error)
	ServerStatusRequestNamespaceListerExpansion
}

// serverStatusRequestNamespaceLister implements the ServerStatusRequestNamespaceLister
// interface.
type serverStatusRequestNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ServerStatusRequests in the indexer for a given namespace.
func (s serverStatusRequestNamespaceLister) List(selector labels.Selector) (ret []*v1.ServerStatusRequest, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ServerStatusRequest))
	})
	return ret, err
}

// Get retrieves the ServerStatusRequest from the indexer for a given namespace and name.
func (s serverStatusRequestNamespaceLister) Get(name string) (*v1.ServerStatusRequest, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("serverstatusrequest"), name)
	}
	return obj.(*v1.ServerStatusRequest), nil
}
