package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// InvoicesClient is the billing client provides access to billing resources for Azure subscriptions.
type InvoicesClient struct {
	BaseClient
}

// NewInvoicesClient creates an instance of the InvoicesClient client.
func NewInvoicesClient(subscriptionID string) InvoicesClient {
	return NewInvoicesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewInvoicesClientWithBaseURI creates an instance of the InvoicesClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewInvoicesClientWithBaseURI(baseURI string, subscriptionID string) InvoicesClient {
	return InvoicesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// DownloadBillingSubscriptionInvoice gets a URL to download an invoice.
// Parameters:
// invoiceName - the ID that uniquely identifies an invoice.
// downloadToken - download token with document source and document ID.
func (client InvoicesClient) DownloadBillingSubscriptionInvoice(ctx context.Context, invoiceName string, downloadToken string) (result InvoicesDownloadBillingSubscriptionInvoiceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.DownloadBillingSubscriptionInvoice")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DownloadBillingSubscriptionInvoicePreparer(ctx, invoiceName, downloadToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadBillingSubscriptionInvoice", nil, "Failure preparing request")
		return
	}

	result, err = client.DownloadBillingSubscriptionInvoiceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadBillingSubscriptionInvoice", nil, "Failure sending request")
		return
	}

	return
}

// DownloadBillingSubscriptionInvoicePreparer prepares the DownloadBillingSubscriptionInvoice request.
func (client InvoicesClient) DownloadBillingSubscriptionInvoicePreparer(ctx context.Context, invoiceName string, downloadToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"invoiceName":    autorest.Encode("path", invoiceName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version":   APIVersion,
		"downloadToken": autorest.Encode("query", downloadToken),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}/download", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadBillingSubscriptionInvoiceSender sends the DownloadBillingSubscriptionInvoice request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) DownloadBillingSubscriptionInvoiceSender(req *http.Request) (future InvoicesDownloadBillingSubscriptionInvoiceFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client InvoicesClient) (du DownloadURL, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadBillingSubscriptionInvoiceFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("billing.InvoicesDownloadBillingSubscriptionInvoiceFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		du.Response.Response, err = future.GetResult(sender)
		if du.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadBillingSubscriptionInvoiceFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
			du, err = client.DownloadBillingSubscriptionInvoiceResponder(du.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadBillingSubscriptionInvoiceFuture", "Result", du.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// DownloadBillingSubscriptionInvoiceResponder handles the response to the DownloadBillingSubscriptionInvoice request. The method always
// closes the http.Response Body.
func (client InvoicesClient) DownloadBillingSubscriptionInvoiceResponder(resp *http.Response) (result DownloadURL, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DownloadInvoice gets a URL to download an invoice. The operation is supported for billing accounts with agreement
// type Microsoft Partner Agreement or Microsoft Customer Agreement.
// Parameters:
// billingAccountName - the ID that uniquely identifies a billing account.
// invoiceName - the ID that uniquely identifies an invoice.
// downloadToken - download token with document source and document ID.
func (client InvoicesClient) DownloadInvoice(ctx context.Context, billingAccountName string, invoiceName string, downloadToken string) (result InvoicesDownloadInvoiceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.DownloadInvoice")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DownloadInvoicePreparer(ctx, billingAccountName, invoiceName, downloadToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadInvoice", nil, "Failure preparing request")
		return
	}

	result, err = client.DownloadInvoiceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadInvoice", nil, "Failure sending request")
		return
	}

	return
}

// DownloadInvoicePreparer prepares the DownloadInvoice request.
func (client InvoicesClient) DownloadInvoicePreparer(ctx context.Context, billingAccountName string, invoiceName string, downloadToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"invoiceName":        autorest.Encode("path", invoiceName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version":   APIVersion,
		"downloadToken": autorest.Encode("query", downloadToken),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}/download", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadInvoiceSender sends the DownloadInvoice request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) DownloadInvoiceSender(req *http.Request) (future InvoicesDownloadInvoiceFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client InvoicesClient) (du DownloadURL, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadInvoiceFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("billing.InvoicesDownloadInvoiceFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		du.Response.Response, err = future.GetResult(sender)
		if du.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadInvoiceFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
			du, err = client.DownloadInvoiceResponder(du.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadInvoiceFuture", "Result", du.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// DownloadInvoiceResponder handles the response to the DownloadInvoice request. The method always
// closes the http.Response Body.
func (client InvoicesClient) DownloadInvoiceResponder(resp *http.Response) (result DownloadURL, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DownloadMultipleBillingProfileInvoices gets a URL to download multiple invoice documents (invoice pdf, tax receipts,
// credit notes) as a zip file. The operation is supported for billing accounts with agreement type Microsoft Partner
// Agreement or Microsoft Customer Agreement.
// Parameters:
// billingAccountName - the ID that uniquely identifies a billing account.
// downloadUrls - an array of download urls for individual documents
func (client InvoicesClient) DownloadMultipleBillingProfileInvoices(ctx context.Context, billingAccountName string, downloadUrls []string) (result InvoicesDownloadMultipleBillingProfileInvoicesFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.DownloadMultipleBillingProfileInvoices")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: downloadUrls,
			Constraints: []validation.Constraint{{Target: "downloadUrls", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("billing.InvoicesClient", "DownloadMultipleBillingProfileInvoices", err.Error())
	}

	req, err := client.DownloadMultipleBillingProfileInvoicesPreparer(ctx, billingAccountName, downloadUrls)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadMultipleBillingProfileInvoices", nil, "Failure preparing request")
		return
	}

	result, err = client.DownloadMultipleBillingProfileInvoicesSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadMultipleBillingProfileInvoices", nil, "Failure sending request")
		return
	}

	return
}

// DownloadMultipleBillingProfileInvoicesPreparer prepares the DownloadMultipleBillingProfileInvoices request.
func (client InvoicesClient) DownloadMultipleBillingProfileInvoicesPreparer(ctx context.Context, billingAccountName string, downloadUrls []string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/downloadDocuments", pathParameters),
		autorest.WithJSON(downloadUrls),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadMultipleBillingProfileInvoicesSender sends the DownloadMultipleBillingProfileInvoices request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) DownloadMultipleBillingProfileInvoicesSender(req *http.Request) (future InvoicesDownloadMultipleBillingProfileInvoicesFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client InvoicesClient) (du DownloadURL, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadMultipleBillingProfileInvoicesFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("billing.InvoicesDownloadMultipleBillingProfileInvoicesFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		du.Response.Response, err = future.GetResult(sender)
		if du.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadMultipleBillingProfileInvoicesFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
			du, err = client.DownloadMultipleBillingProfileInvoicesResponder(du.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadMultipleBillingProfileInvoicesFuture", "Result", du.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// DownloadMultipleBillingProfileInvoicesResponder handles the response to the DownloadMultipleBillingProfileInvoices request. The method always
// closes the http.Response Body.
func (client InvoicesClient) DownloadMultipleBillingProfileInvoicesResponder(resp *http.Response) (result DownloadURL, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DownloadMultipleBillingSubscriptionInvoices gets a URL to download multiple invoice documents (invoice pdf, tax
// receipts, credit notes) as a zip file.
// Parameters:
// downloadUrls - an array of download urls for individual documents
func (client InvoicesClient) DownloadMultipleBillingSubscriptionInvoices(ctx context.Context, downloadUrls []string) (result InvoicesDownloadMultipleBillingSubscriptionInvoicesFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.DownloadMultipleBillingSubscriptionInvoices")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: downloadUrls,
			Constraints: []validation.Constraint{{Target: "downloadUrls", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("billing.InvoicesClient", "DownloadMultipleBillingSubscriptionInvoices", err.Error())
	}

	req, err := client.DownloadMultipleBillingSubscriptionInvoicesPreparer(ctx, downloadUrls)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadMultipleBillingSubscriptionInvoices", nil, "Failure preparing request")
		return
	}

	result, err = client.DownloadMultipleBillingSubscriptionInvoicesSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "DownloadMultipleBillingSubscriptionInvoices", nil, "Failure sending request")
		return
	}

	return
}

// DownloadMultipleBillingSubscriptionInvoicesPreparer prepares the DownloadMultipleBillingSubscriptionInvoices request.
func (client InvoicesClient) DownloadMultipleBillingSubscriptionInvoicesPreparer(ctx context.Context, downloadUrls []string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/downloadDocuments", pathParameters),
		autorest.WithJSON(downloadUrls),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadMultipleBillingSubscriptionInvoicesSender sends the DownloadMultipleBillingSubscriptionInvoices request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) DownloadMultipleBillingSubscriptionInvoicesSender(req *http.Request) (future InvoicesDownloadMultipleBillingSubscriptionInvoicesFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client InvoicesClient) (du DownloadURL, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadMultipleBillingSubscriptionInvoicesFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("billing.InvoicesDownloadMultipleBillingSubscriptionInvoicesFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		du.Response.Response, err = future.GetResult(sender)
		if du.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadMultipleBillingSubscriptionInvoicesFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
			du, err = client.DownloadMultipleBillingSubscriptionInvoicesResponder(du.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadMultipleBillingSubscriptionInvoicesFuture", "Result", du.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// DownloadMultipleBillingSubscriptionInvoicesResponder handles the response to the DownloadMultipleBillingSubscriptionInvoices request. The method always
// closes the http.Response Body.
func (client InvoicesClient) DownloadMultipleBillingSubscriptionInvoicesResponder(resp *http.Response) (result DownloadURL, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets an invoice by billing account name and ID. The operation is supported for billing accounts with agreement
// type Microsoft Partner Agreement or Microsoft Customer Agreement.
// Parameters:
// billingAccountName - the ID that uniquely identifies a billing account.
// invoiceName - the ID that uniquely identifies an invoice.
func (client InvoicesClient) Get(ctx context.Context, billingAccountName string, invoiceName string) (result Invoice, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, billingAccountName, invoiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client InvoicesClient) GetPreparer(ctx context.Context, billingAccountName string, invoiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"invoiceName":        autorest.Encode("path", invoiceName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client InvoicesClient) GetResponder(resp *http.Response) (result Invoice, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByID gets an invoice by ID. The operation is supported for billing accounts with agreement type Microsoft Partner
// Agreement or Microsoft Customer Agreement.
// Parameters:
// invoiceName - the ID that uniquely identifies an invoice.
func (client InvoicesClient) GetByID(ctx context.Context, invoiceName string) (result Invoice, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.GetByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByIDPreparer(ctx, invoiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "GetByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "GetByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "GetByID", resp, "Failure responding to request")
		return
	}

	return
}

// GetByIDPreparer prepares the GetByID request.
func (client InvoicesClient) GetByIDPreparer(ctx context.Context, invoiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"invoiceName": autorest.Encode("path", invoiceName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/default/invoices/{invoiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByIDSender sends the GetByID request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) GetByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByIDResponder handles the response to the GetByID request. The method always
// closes the http.Response Body.
func (client InvoicesClient) GetByIDResponder(resp *http.Response) (result Invoice, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBySubscriptionAndInvoiceID gets an invoice by subscription ID and invoice ID.
// Parameters:
// invoiceName - the ID that uniquely identifies an invoice.
func (client InvoicesClient) GetBySubscriptionAndInvoiceID(ctx context.Context, invoiceName string) (result Invoice, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.GetBySubscriptionAndInvoiceID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetBySubscriptionAndInvoiceIDPreparer(ctx, invoiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "GetBySubscriptionAndInvoiceID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBySubscriptionAndInvoiceIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "GetBySubscriptionAndInvoiceID", resp, "Failure sending request")
		return
	}

	result, err = client.GetBySubscriptionAndInvoiceIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "GetBySubscriptionAndInvoiceID", resp, "Failure responding to request")
		return
	}

	return
}

// GetBySubscriptionAndInvoiceIDPreparer prepares the GetBySubscriptionAndInvoiceID request.
func (client InvoicesClient) GetBySubscriptionAndInvoiceIDPreparer(ctx context.Context, invoiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"invoiceName":    autorest.Encode("path", invoiceName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBySubscriptionAndInvoiceIDSender sends the GetBySubscriptionAndInvoiceID request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) GetBySubscriptionAndInvoiceIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetBySubscriptionAndInvoiceIDResponder handles the response to the GetBySubscriptionAndInvoiceID request. The method always
// closes the http.Response Body.
func (client InvoicesClient) GetBySubscriptionAndInvoiceIDResponder(resp *http.Response) (result Invoice, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByBillingAccount lists the invoices for a billing account for a given start date and end date. The operation is
// supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
// Parameters:
// billingAccountName - the ID that uniquely identifies a billing account.
// periodStartDate - the start date to fetch the invoices. The date should be specified in MM-DD-YYYY format.
// periodEndDate - the end date to fetch the invoices. The date should be specified in MM-DD-YYYY format.
func (client InvoicesClient) ListByBillingAccount(ctx context.Context, billingAccountName string, periodStartDate string, periodEndDate string) (result InvoiceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.ListByBillingAccount")
		defer func() {
			sc := -1
			if result.ilr.Response.Response != nil {
				sc = result.ilr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByBillingAccountNextResults
	req, err := client.ListByBillingAccountPreparer(ctx, billingAccountName, periodStartDate, periodEndDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingAccountSender(req)
	if err != nil {
		result.ilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingAccount", resp, "Failure sending request")
		return
	}

	result.ilr, err = client.ListByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingAccount", resp, "Failure responding to request")
		return
	}
	if result.ilr.hasNextLink() && result.ilr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByBillingAccountPreparer prepares the ListByBillingAccount request.
func (client InvoicesClient) ListByBillingAccountPreparer(ctx context.Context, billingAccountName string, periodStartDate string, periodEndDate string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"periodEndDate":   autorest.Encode("query", periodEndDate),
		"periodStartDate": autorest.Encode("query", periodStartDate),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingAccountSender sends the ListByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) ListByBillingAccountSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByBillingAccountResponder handles the response to the ListByBillingAccount request. The method always
// closes the http.Response Body.
func (client InvoicesClient) ListByBillingAccountResponder(resp *http.Response) (result InvoiceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByBillingAccountNextResults retrieves the next set of results, if any.
func (client InvoicesClient) listByBillingAccountNextResults(ctx context.Context, lastResults InvoiceListResult) (result InvoiceListResult, err error) {
	req, err := lastResults.invoiceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingAccountNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingAccountNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingAccountNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByBillingAccountComplete enumerates all values, automatically crossing page boundaries as required.
func (client InvoicesClient) ListByBillingAccountComplete(ctx context.Context, billingAccountName string, periodStartDate string, periodEndDate string) (result InvoiceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.ListByBillingAccount")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByBillingAccount(ctx, billingAccountName, periodStartDate, periodEndDate)
	return
}

// ListByBillingProfile lists the invoices for a billing profile for a given start date and end date. The operation is
// supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
// Parameters:
// billingAccountName - the ID that uniquely identifies a billing account.
// billingProfileName - the ID that uniquely identifies a billing profile.
// periodStartDate - the start date to fetch the invoices. The date should be specified in MM-DD-YYYY format.
// periodEndDate - the end date to fetch the invoices. The date should be specified in MM-DD-YYYY format.
func (client InvoicesClient) ListByBillingProfile(ctx context.Context, billingAccountName string, billingProfileName string, periodStartDate string, periodEndDate string) (result InvoiceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.ListByBillingProfile")
		defer func() {
			sc := -1
			if result.ilr.Response.Response != nil {
				sc = result.ilr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByBillingProfileNextResults
	req, err := client.ListByBillingProfilePreparer(ctx, billingAccountName, billingProfileName, periodStartDate, periodEndDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingProfile", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingProfileSender(req)
	if err != nil {
		result.ilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingProfile", resp, "Failure sending request")
		return
	}

	result.ilr, err = client.ListByBillingProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingProfile", resp, "Failure responding to request")
		return
	}
	if result.ilr.hasNextLink() && result.ilr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByBillingProfilePreparer prepares the ListByBillingProfile request.
func (client InvoicesClient) ListByBillingProfilePreparer(ctx context.Context, billingAccountName string, billingProfileName string, periodStartDate string, periodEndDate string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"billingProfileName": autorest.Encode("path", billingProfileName),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"periodEndDate":   autorest.Encode("query", periodEndDate),
		"periodStartDate": autorest.Encode("query", periodStartDate),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingProfileSender sends the ListByBillingProfile request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) ListByBillingProfileSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByBillingProfileResponder handles the response to the ListByBillingProfile request. The method always
// closes the http.Response Body.
func (client InvoicesClient) ListByBillingProfileResponder(resp *http.Response) (result InvoiceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByBillingProfileNextResults retrieves the next set of results, if any.
func (client InvoicesClient) listByBillingProfileNextResults(ctx context.Context, lastResults InvoiceListResult) (result InvoiceListResult, err error) {
	req, err := lastResults.invoiceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingProfileNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByBillingProfileSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingProfileNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByBillingProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingProfileNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByBillingProfileComplete enumerates all values, automatically crossing page boundaries as required.
func (client InvoicesClient) ListByBillingProfileComplete(ctx context.Context, billingAccountName string, billingProfileName string, periodStartDate string, periodEndDate string) (result InvoiceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.ListByBillingProfile")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByBillingProfile(ctx, billingAccountName, billingProfileName, periodStartDate, periodEndDate)
	return
}

// ListByBillingSubscription lists the invoices for a subscription.
// Parameters:
// periodStartDate - invoice period start date.
// periodEndDate - invoice period end date.
func (client InvoicesClient) ListByBillingSubscription(ctx context.Context, periodStartDate string, periodEndDate string) (result InvoiceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.ListByBillingSubscription")
		defer func() {
			sc := -1
			if result.ilr.Response.Response != nil {
				sc = result.ilr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByBillingSubscriptionNextResults
	req, err := client.ListByBillingSubscriptionPreparer(ctx, periodStartDate, periodEndDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingSubscriptionSender(req)
	if err != nil {
		result.ilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingSubscription", resp, "Failure sending request")
		return
	}

	result.ilr, err = client.ListByBillingSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "ListByBillingSubscription", resp, "Failure responding to request")
		return
	}
	if result.ilr.hasNextLink() && result.ilr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByBillingSubscriptionPreparer prepares the ListByBillingSubscription request.
func (client InvoicesClient) ListByBillingSubscriptionPreparer(ctx context.Context, periodStartDate string, periodEndDate string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-05-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"periodEndDate":   autorest.Encode("query", periodEndDate),
		"periodStartDate": autorest.Encode("query", periodStartDate),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingSubscriptionSender sends the ListByBillingSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client InvoicesClient) ListByBillingSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByBillingSubscriptionResponder handles the response to the ListByBillingSubscription request. The method always
// closes the http.Response Body.
func (client InvoicesClient) ListByBillingSubscriptionResponder(resp *http.Response) (result InvoiceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByBillingSubscriptionNextResults retrieves the next set of results, if any.
func (client InvoicesClient) listByBillingSubscriptionNextResults(ctx context.Context, lastResults InvoiceListResult) (result InvoiceListResult, err error) {
	req, err := lastResults.invoiceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingSubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByBillingSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingSubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByBillingSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesClient", "listByBillingSubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByBillingSubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client InvoicesClient) ListByBillingSubscriptionComplete(ctx context.Context, periodStartDate string, periodEndDate string) (result InvoiceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesClient.ListByBillingSubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByBillingSubscription(ctx, periodStartDate, periodEndDate)
	return
}
