// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package datapipelineiface provides an interface to enable mocking the AWS Data Pipeline service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package datapipelineiface

import (
	"github.com/aws/aws-sdk-go-v2/service/datapipeline"
)

// ClientAPI provides an interface to enable mocking the
// datapipeline.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Data Pipeline.
//    func myFunc(svc datapipelineiface.ClientAPI) bool {
//        // Make svc.ActivatePipeline request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := datapipeline.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        datapipelineiface.ClientPI
//    }
//    func (m *mockClientClient) ActivatePipeline(input *datapipeline.ActivatePipelineInput) (*datapipeline.ActivatePipelineOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	ActivatePipelineRequest(*datapipeline.ActivatePipelineInput) datapipeline.ActivatePipelineRequest

	AddTagsRequest(*datapipeline.AddTagsInput) datapipeline.AddTagsRequest

	CreatePipelineRequest(*datapipeline.CreatePipelineInput) datapipeline.CreatePipelineRequest

	DeactivatePipelineRequest(*datapipeline.DeactivatePipelineInput) datapipeline.DeactivatePipelineRequest

	DeletePipelineRequest(*datapipeline.DeletePipelineInput) datapipeline.DeletePipelineRequest

	DescribeObjectsRequest(*datapipeline.DescribeObjectsInput) datapipeline.DescribeObjectsRequest

	DescribePipelinesRequest(*datapipeline.DescribePipelinesInput) datapipeline.DescribePipelinesRequest

	EvaluateExpressionRequest(*datapipeline.EvaluateExpressionInput) datapipeline.EvaluateExpressionRequest

	GetPipelineDefinitionRequest(*datapipeline.GetPipelineDefinitionInput) datapipeline.GetPipelineDefinitionRequest

	ListPipelinesRequest(*datapipeline.ListPipelinesInput) datapipeline.ListPipelinesRequest

	PollForTaskRequest(*datapipeline.PollForTaskInput) datapipeline.PollForTaskRequest

	PutPipelineDefinitionRequest(*datapipeline.PutPipelineDefinitionInput) datapipeline.PutPipelineDefinitionRequest

	QueryObjectsRequest(*datapipeline.QueryObjectsInput) datapipeline.QueryObjectsRequest

	RemoveTagsRequest(*datapipeline.RemoveTagsInput) datapipeline.RemoveTagsRequest

	ReportTaskProgressRequest(*datapipeline.ReportTaskProgressInput) datapipeline.ReportTaskProgressRequest

	ReportTaskRunnerHeartbeatRequest(*datapipeline.ReportTaskRunnerHeartbeatInput) datapipeline.ReportTaskRunnerHeartbeatRequest

	SetStatusRequest(*datapipeline.SetStatusInput) datapipeline.SetStatusRequest

	SetTaskStatusRequest(*datapipeline.SetTaskStatusInput) datapipeline.SetTaskStatusRequest

	ValidatePipelineDefinitionRequest(*datapipeline.ValidatePipelineDefinitionInput) datapipeline.ValidatePipelineDefinitionRequest
}

var _ ClientAPI = (*datapipeline.Client)(nil)
