// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the security group. This is informational only.
	//
	// Constraints: Up to 255 characters in length
	//
	// Constraints for EC2-Classic: ASCII characters
	//
	// Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&;{}!$*
	//
	// Description is a required field
	Description *string `locationName:"GroupDescription" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the security group.
	//
	// Constraints: Up to 255 characters in length. Cannot start with sg-.
	//
	// Constraints for EC2-Classic: ASCII characters
	//
	// Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&;{}!$*
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSecurityGroupInput"}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSecurityGroup = "CreateSecurityGroup"

// CreateSecurityGroupRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a security group.
//
// A security group acts as a virtual firewall for your instance to control
// inbound and outbound traffic. For more information, see Amazon EC2 Security
// Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security Groups for Your
// VPC (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// When you create a security group, you specify a friendly name of your choice.
// You can have a security group for use in EC2-Classic with the same name as
// a security group for use in a VPC. However, you can't have two security groups
// for use in EC2-Classic with the same name or two security groups for use
// in a VPC with the same name.
//
// You have a default security group for use in EC2-Classic and a default security
// group for use in your VPC. If you don't specify a security group when you
// launch an instance, the instance is launched into the appropriate default
// security group. A default security group includes a default rule that grants
// instances unrestricted network access to each other.
//
// You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress,
// AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
//
// For more information about VPC security group limits, see Amazon VPC Limits
// (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
//
//    // Example sending a request using CreateSecurityGroupRequest.
//    req := client.CreateSecurityGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *Client) CreateSecurityGroupRequest(input *CreateSecurityGroupInput) CreateSecurityGroupRequest {
	op := &aws.Operation{
		Name:       opCreateSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityGroupInput{}
	}

	req := c.newRequest(op, input, &CreateSecurityGroupOutput{})
	return CreateSecurityGroupRequest{Request: req, Input: input, Copy: c.CreateSecurityGroupRequest}
}

// CreateSecurityGroupRequest is the request type for the
// CreateSecurityGroup API operation.
type CreateSecurityGroupRequest struct {
	*aws.Request
	Input *CreateSecurityGroupInput
	Copy  func(*CreateSecurityGroupInput) CreateSecurityGroupRequest
}

// Send marshals and sends the CreateSecurityGroup API request.
func (r CreateSecurityGroupRequest) Send(ctx context.Context) (*CreateSecurityGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSecurityGroupResponse{
		CreateSecurityGroupOutput: r.Request.Data.(*CreateSecurityGroupOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSecurityGroupResponse is the response type for the
// CreateSecurityGroup API operation.
type CreateSecurityGroupResponse struct {
	*CreateSecurityGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSecurityGroup request.
func (r *CreateSecurityGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
