// DO NOT EDIT: This file is autogenerated via the builtin command.

package geo

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 30,
					Line:   170,
				},
				File:   "geo.flux",
				Source: "package geo\n\nimport \"experimental\"\n\n//\n// None of the builtin functions are intended to be used by end users.\n//\n\n// Check whether lat/lon is in specified region.\nbuiltin containsLatLon\n\n// Calculates grid (set of cell ID tokens) for given region and according to options.\nbuiltin getGrid\n\n// Returns level of specified cell ID token.\nbuiltin getLevel\n\n// Returns cell ID token for given cell or lat/lon point at specified level.\nbuiltin s2CellIDToken\n\n//\n// Flux\n//\n\n// Gets level of cell ID tag `s2cellID` from the first record from the first table from the stream.\n_detectLevel = (tables=<-) => {\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}\n\n//\n// Convenience functions\n//\n\n// Collects values to row-wise sets.\ntoRows = (tables=<-, correlationKey=[\"_time\"]) =>\n  tables\n    |> pivot(\n      rowKey: correlationKey,\n      columnKey: [\"_field\"],\n      valueColumn: \"_value\"\n    )\n\n// Shapes data to meet the requirements of the geo package.\n// Renames fields containing latitude and longitude values to lat and lon.\n// Pivots values to row-wise sets.\n// Generates an s2_cell_id tag for each reach using lat and lon values.\n// Adds the s2_cell_id column to the group key.\nshapeData = (tables=<-, latField, lonField, level, correlationKey=[\"_time\"]) =>\n  tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows(correlationKey: correlationKey)\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )\n\n//\n// Filtering functions\n//\n\n// Filters records by a box, a circle or a polygon area using S2 cell ID tag.\n// It is a coarse filter, as the grid always overlays the region, the result will likely contain records\n// with lat/lon outside the specified region.\ngridFilter = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}\n\n// Filters records by specified region.\n// It is an exact filter and must be used after `toRows()` because it requires `lat` and `lon` columns in input row sets.\nstrictFilter = (tables=<-, region) =>\n  tables\n    |> filter(fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)\n    )\n\n// Two-phase filtering by speficied region.\n// Checks to see if data is already pivoted and contains a lat column.\n// Returns rows of fields correlated by `correlationKey`.\nfilterRows = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, correlationKey=[\"_time\"], strict=true) => {\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}\n\n//\n// Grouping functions\n//\n// intended to be used row-wise sets (i.e after `toRows()`)\n\n// Groups data by area of size specified by level. Result is grouped by `newColumn`.\n// Grouping levels: https://s2geometry.io/resources/s2cell_statistics.html\ngroupByArea = (tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}\n\n// Groups rows into tracks.\nasTracks = (tables=<-, groupBy=[\"id\",\"tid\"], orderBy=[\"_time\"]) =>\n  tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 23,
						Line:   11,
					},
					File:   "geo.flux",
					Source: "builtin containsLatLon",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   11,
						},
						File:   "geo.flux",
						Source: "containsLatLon",
						Start: ast.Position{
							Column: 9,
							Line:   11,
						},
					},
				},
				Name: "containsLatLon",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   14,
					},
					File:   "geo.flux",
					Source: "builtin getGrid",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   14,
						},
						File:   "geo.flux",
						Source: "getGrid",
						Start: ast.Position{
							Column: 9,
							Line:   14,
						},
					},
				},
				Name: "getGrid",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   17,
					},
					File:   "geo.flux",
					Source: "builtin getLevel",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   17,
						},
						File:   "geo.flux",
						Source: "getLevel",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "getLevel",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   20,
					},
					File:   "geo.flux",
					Source: "builtin s2CellIDToken",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   20,
						},
						File:   "geo.flux",
						Source: "s2CellIDToken",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "s2CellIDToken",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   38,
					},
					File:   "geo.flux",
					Source: "_detectLevel = (tables=<-) => {\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   27,
						},
						File:   "geo.flux",
						Source: "_detectLevel",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "_detectLevel",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   38,
						},
						File:   "geo.flux",
						Source: "(tables=<-) => {\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}",
						Start: ast.Position{
							Column: 16,
							Line:   27,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   38,
							},
							File:   "geo.flux",
							Source: "{\n  _r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)\n  _level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666\n  return _level\n}",
							Start: ast.Position{
								Column: 31,
								Line:   27,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "_r0 =\n    tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)",
								Start: ast.Position{
									Column: 3,
									Line:   28,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   28,
									},
									File:   "geo.flux",
									Source: "_r0",
									Start: ast.Position{
										Column: 3,
										Line:   28,
									},
								},
							},
							Name: "_r0",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   29,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   29,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)",
										Start: ast.Position{
											Column: 5,
											Line:   29,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   30,
												},
												File:   "geo.flux",
												Source: "fn: (key) => exists key.s2_cell_id",
												Start: ast.Position{
													Column: 20,
													Line:   30,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   30,
													},
													File:   "geo.flux",
													Source: "fn: (key) => exists key.s2_cell_id",
													Start: ast.Position{
														Column: 20,
														Line:   30,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   30,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 20,
															Line:   30,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   30,
														},
														File:   "geo.flux",
														Source: "(key) => exists key.s2_cell_id",
														Start: ast.Position{
															Column: 24,
															Line:   30,
														},
													},
												},
												Body: &ast.UnaryExpression{
													Argument: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   30,
																},
																File:   "geo.flux",
																Source: "key.s2_cell_id",
																Start: ast.Position{
																	Column: 40,
																	Line:   30,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   30,
																	},
																	File:   "geo.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 40,
																		Line:   30,
																	},
																},
															},
															Name: "key",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   30,
																	},
																	File:   "geo.flux",
																	Source: "s2_cell_id",
																	Start: ast.Position{
																		Column: 44,
																		Line:   30,
																	},
																},
															},
															Name: "s2_cell_id",
														},
													},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   30,
															},
															File:   "geo.flux",
															Source: "exists key.s2_cell_id",
															Start: ast.Position{
																Column: 33,
																Line:   30,
															},
														},
													},
													Operator: 14,
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   30,
															},
															File:   "geo.flux",
															Source: "key",
															Start: ast.Position{
																Column: 25,
																Line:   30,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   30,
																},
																File:   "geo.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 25,
																	Line:   30,
																},
															},
														},
														Name: "key",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "tableFind(fn: (key) => exists key.s2_cell_id)",
											Start: ast.Position{
												Column: 10,
												Line:   30,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   30,
												},
												File:   "geo.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 10,
													Line:   30,
												},
											},
										},
										Name: "tableFind",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   31,
									},
									File:   "geo.flux",
									Source: "tables\n      |> tableFind(fn: (key) => exists key.s2_cell_id)\n      |> getRecord(idx: 0)",
									Start: ast.Position{
										Column: 5,
										Line:   29,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 20,
												Line:   31,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   31,
												},
												File:   "geo.flux",
												Source: "idx: 0",
												Start: ast.Position{
													Column: 20,
													Line:   31,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   31,
													},
													File:   "geo.flux",
													Source: "idx",
													Start: ast.Position{
														Column: 20,
														Line:   31,
													},
												},
											},
											Name: "idx",
										},
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   31,
													},
													File:   "geo.flux",
													Source: "0",
													Start: ast.Position{
														Column: 25,
														Line:   31,
													},
												},
											},
											Value: int64(0),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   31,
										},
										File:   "geo.flux",
										Source: "getRecord(idx: 0)",
										Start: ast.Position{
											Column: 10,
											Line:   31,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "getRecord",
											Start: ast.Position{
												Column: 10,
												Line:   31,
											},
										},
									},
									Name: "getRecord",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   36,
								},
								File:   "geo.flux",
								Source: "_level =\n    if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666",
								Start: ast.Position{
									Column: 3,
									Line:   32,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   32,
									},
									File:   "geo.flux",
									Source: "_level",
									Start: ast.Position{
										Column: 3,
										Line:   32,
									},
								},
							},
							Name: "_level",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.IntegerLiteral{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   36,
										},
										File:   "geo.flux",
										Source: "666",
										Start: ast.Position{
											Column: 8,
											Line:   36,
										},
									},
								},
								Value: int64(666),
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   36,
									},
									File:   "geo.flux",
									Source: "if exists _r0 then\n      getLevel(token: _r0.s2_cell_id)\n    else\n       666",
									Start: ast.Position{
										Column: 5,
										Line:   33,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   34,
											},
											File:   "geo.flux",
											Source: "token: _r0.s2_cell_id",
											Start: ast.Position{
												Column: 16,
												Line:   34,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   34,
												},
												File:   "geo.flux",
												Source: "token: _r0.s2_cell_id",
												Start: ast.Position{
													Column: 16,
													Line:   34,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   34,
													},
													File:   "geo.flux",
													Source: "token",
													Start: ast.Position{
														Column: 16,
														Line:   34,
													},
												},
											},
											Name: "token",
										},
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   34,
													},
													File:   "geo.flux",
													Source: "_r0.s2_cell_id",
													Start: ast.Position{
														Column: 23,
														Line:   34,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   34,
														},
														File:   "geo.flux",
														Source: "_r0",
														Start: ast.Position{
															Column: 23,
															Line:   34,
														},
													},
												},
												Name: "_r0",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   34,
														},
														File:   "geo.flux",
														Source: "s2_cell_id",
														Start: ast.Position{
															Column: 27,
															Line:   34,
														},
													},
												},
												Name: "s2_cell_id",
											},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   34,
										},
										File:   "geo.flux",
										Source: "getLevel(token: _r0.s2_cell_id)",
										Start: ast.Position{
											Column: 7,
											Line:   34,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   34,
											},
											File:   "geo.flux",
											Source: "getLevel",
											Start: ast.Position{
												Column: 7,
												Line:   34,
											},
										},
									},
									Name: "getLevel",
								},
							},
							Test: &ast.UnaryExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   33,
											},
											File:   "geo.flux",
											Source: "_r0",
											Start: ast.Position{
												Column: 15,
												Line:   33,
											},
										},
									},
									Name: "_r0",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   33,
										},
										File:   "geo.flux",
										Source: "exists _r0",
										Start: ast.Position{
											Column: 8,
											Line:   33,
										},
									},
								},
								Operator: 14,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   37,
									},
									File:   "geo.flux",
									Source: "_level",
									Start: ast.Position{
										Column: 10,
										Line:   37,
									},
								},
							},
							Name: "_level",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   37,
								},
								File:   "geo.flux",
								Source: "return _level",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   27,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   27,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   27,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   27,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   27,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   27,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   51,
					},
					File:   "geo.flux",
					Source: "toRows = (tables=<-, correlationKey=[\"_time\"]) =>\n  tables\n    |> pivot(\n      rowKey: correlationKey,\n      columnKey: [\"_field\"],\n      valueColumn: \"_value\"\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   45,
						},
						File:   "geo.flux",
						Source: "toRows",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "toRows",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   51,
						},
						File:   "geo.flux",
						Source: "(tables=<-, correlationKey=[\"_time\"]) =>\n  tables\n    |> pivot(\n      rowKey: correlationKey,\n      columnKey: [\"_field\"],\n      valueColumn: \"_value\"\n    )",
						Start: ast.Position{
							Column: 10,
							Line:   45,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   46,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 3,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   51,
							},
							File:   "geo.flux",
							Source: "tables\n    |> pivot(\n      rowKey: correlationKey,\n      columnKey: [\"_field\"],\n      valueColumn: \"_value\"\n    )",
							Start: ast.Position{
								Column: 3,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   50,
									},
									File:   "geo.flux",
									Source: "rowKey: correlationKey,\n      columnKey: [\"_field\"],\n      valueColumn: \"_value\"",
									Start: ast.Position{
										Column: 7,
										Line:   48,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   48,
										},
										File:   "geo.flux",
										Source: "rowKey: correlationKey",
										Start: ast.Position{
											Column: 7,
											Line:   48,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   48,
											},
											File:   "geo.flux",
											Source: "rowKey",
											Start: ast.Position{
												Column: 7,
												Line:   48,
											},
										},
									},
									Name: "rowKey",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   48,
											},
											File:   "geo.flux",
											Source: "correlationKey",
											Start: ast.Position{
												Column: 15,
												Line:   48,
											},
										},
									},
									Name: "correlationKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   49,
										},
										File:   "geo.flux",
										Source: "columnKey: [\"_field\"]",
										Start: ast.Position{
											Column: 7,
											Line:   49,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   49,
											},
											File:   "geo.flux",
											Source: "columnKey",
											Start: ast.Position{
												Column: 7,
												Line:   49,
											},
										},
									},
									Name: "columnKey",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   49,
											},
											File:   "geo.flux",
											Source: "[\"_field\"]",
											Start: ast.Position{
												Column: 18,
												Line:   49,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   49,
												},
												File:   "geo.flux",
												Source: "\"_field\"",
												Start: ast.Position{
													Column: 19,
													Line:   49,
												},
											},
										},
										Value: "_field",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   50,
										},
										File:   "geo.flux",
										Source: "valueColumn: \"_value\"",
										Start: ast.Position{
											Column: 7,
											Line:   50,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   50,
											},
											File:   "geo.flux",
											Source: "valueColumn",
											Start: ast.Position{
												Column: 7,
												Line:   50,
											},
										},
									},
									Name: "valueColumn",
								},
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   50,
											},
											File:   "geo.flux",
											Source: "\"_value\"",
											Start: ast.Position{
												Column: 20,
												Line:   50,
											},
										},
									},
									Value: "_value",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   51,
								},
								File:   "geo.flux",
								Source: "pivot(\n      rowKey: correlationKey,\n      columnKey: [\"_field\"],\n      valueColumn: \"_value\"\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   47,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   47,
									},
									File:   "geo.flux",
									Source: "pivot",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Name: "pivot",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   45,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   45,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   45,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   45,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   45,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   45,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   45,
							},
							File:   "geo.flux",
							Source: "correlationKey=[\"_time\"]",
							Start: ast.Position{
								Column: 22,
								Line:   45,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   45,
								},
								File:   "geo.flux",
								Source: "correlationKey",
								Start: ast.Position{
									Column: 22,
									Line:   45,
								},
							},
						},
						Name: "correlationKey",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   45,
								},
								File:   "geo.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 37,
									Line:   45,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   45,
									},
									File:   "geo.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 38,
										Line:   45,
									},
								},
							},
							Value: "_time",
						}},
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   75,
					},
					File:   "geo.flux",
					Source: "shapeData = (tables=<-, latField, lonField, level, correlationKey=[\"_time\"]) =>\n  tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows(correlationKey: correlationKey)\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   58,
						},
						File:   "geo.flux",
						Source: "shapeData",
						Start: ast.Position{
							Column: 1,
							Line:   58,
						},
					},
				},
				Name: "shapeData",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   75,
						},
						File:   "geo.flux",
						Source: "(tables=<-, latField, lonField, level, correlationKey=[\"_time\"]) =>\n  tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows(correlationKey: correlationKey)\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
						Start: ast.Position{
							Column: 13,
							Line:   58,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   59,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 3,
												Line:   59,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   66,
										},
										File:   "geo.flux",
										Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )",
										Start: ast.Position{
											Column: 3,
											Line:   59,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   65,
												},
												File:   "geo.flux",
												Source: "fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
												Start: ast.Position{
													Column: 12,
													Line:   60,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   65,
													},
													File:   "geo.flux",
													Source: "fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
													Start: ast.Position{
														Column: 12,
														Line:   60,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   60,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   60,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 9,
															Line:   65,
														},
														File:   "geo.flux",
														Source: "(r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
														Start: ast.Position{
															Column: 16,
															Line:   60,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 9,
																Line:   65,
															},
															File:   "geo.flux",
															Source: "({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })",
															Start: ast.Position{
																Column: 23,
																Line:   60,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 8,
																	Line:   65,
																},
																File:   "geo.flux",
																Source: "{ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      }",
																Start: ast.Position{
																	Column: 24,
																	Line:   60,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   64,
																	},
																	File:   "geo.flux",
																	Source: "_field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field",
																	Start: ast.Position{
																		Column: 9,
																		Line:   61,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   61,
																		},
																		File:   "geo.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 9,
																			Line:   61,
																		},
																	},
																},
																Name: "_field",
															},
															Value: &ast.ConditionalExpression{
																Alternate: &ast.ConditionalExpression{
																	Alternate: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   64,
																				},
																				File:   "geo.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 16,
																					Line:   64,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 17,
																						Line:   64,
																					},
																					File:   "geo.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 16,
																						Line:   64,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   64,
																					},
																					File:   "geo.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 18,
																						Line:   64,
																					},
																				},
																			},
																			Name: "_field",
																		},
																	},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   64,
																			},
																			File:   "geo.flux",
																			Source: "if r._field == lonField then \"lon\"\n          else r._field",
																			Start: ast.Position{
																				Column: 16,
																				Line:   63,
																			},
																		},
																	},
																	Consequent: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   63,
																				},
																				File:   "geo.flux",
																				Source: "\"lon\"",
																				Start: ast.Position{
																					Column: 45,
																					Line:   63,
																				},
																			},
																		},
																		Value: "lon",
																	},
																	Test: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 39,
																					Line:   63,
																				},
																				File:   "geo.flux",
																				Source: "r._field == lonField",
																				Start: ast.Position{
																					Column: 19,
																					Line:   63,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 27,
																						Line:   63,
																					},
																					File:   "geo.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 19,
																						Line:   63,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 20,
																							Line:   63,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 19,
																							Line:   63,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 27,
																							Line:   63,
																						},
																						File:   "geo.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 21,
																							Line:   63,
																						},
																					},
																				},
																				Name: "_field",
																			},
																		},
																		Operator: 17,
																		Right: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 39,
																						Line:   63,
																					},
																					File:   "geo.flux",
																					Source: "lonField",
																					Start: ast.Position{
																						Column: 31,
																						Line:   63,
																					},
																				},
																			},
																			Name: "lonField",
																		},
																	},
																},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   64,
																		},
																		File:   "geo.flux",
																		Source: "if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field",
																		Start: ast.Position{
																			Column: 11,
																			Line:   62,
																		},
																	},
																},
																Consequent: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   62,
																			},
																			File:   "geo.flux",
																			Source: "\"lat\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   62,
																			},
																		},
																	},
																	Value: "lat",
																},
																Test: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   62,
																			},
																			File:   "geo.flux",
																			Source: "r._field == latField",
																			Start: ast.Position{
																				Column: 14,
																				Line:   62,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 22,
																					Line:   62,
																				},
																				File:   "geo.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 14,
																					Line:   62,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 15,
																						Line:   62,
																					},
																					File:   "geo.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 14,
																						Line:   62,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   62,
																					},
																					File:   "geo.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 16,
																						Line:   62,
																					},
																				},
																			},
																			Name: "_field",
																		},
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   62,
																				},
																				File:   "geo.flux",
																				Source: "latField",
																				Start: ast.Position{
																					Column: 26,
																					Line:   62,
																				},
																			},
																		},
																		Name: "latField",
																	},
																},
															},
														}},
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   60,
																	},
																	File:   "geo.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   60,
																	},
																},
															},
															Name: "r",
														},
													},
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   60,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   60,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   60,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   60,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   66,
											},
											File:   "geo.flux",
											Source: "map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )",
											Start: ast.Position{
												Column: 8,
												Line:   60,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   60,
												},
												File:   "geo.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   60,
												},
											},
										},
										Name: "map",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows(correlationKey: correlationKey)",
									Start: ast.Position{
										Column: 3,
										Line:   59,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   67,
											},
											File:   "geo.flux",
											Source: "correlationKey: correlationKey",
											Start: ast.Position{
												Column: 15,
												Line:   67,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   67,
												},
												File:   "geo.flux",
												Source: "correlationKey: correlationKey",
												Start: ast.Position{
													Column: 15,
													Line:   67,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   67,
													},
													File:   "geo.flux",
													Source: "correlationKey",
													Start: ast.Position{
														Column: 15,
														Line:   67,
													},
												},
											},
											Name: "correlationKey",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   67,
													},
													File:   "geo.flux",
													Source: "correlationKey",
													Start: ast.Position{
														Column: 31,
														Line:   67,
													},
												},
											},
											Name: "correlationKey",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   67,
										},
										File:   "geo.flux",
										Source: "toRows(correlationKey: correlationKey)",
										Start: ast.Position{
											Column: 8,
											Line:   67,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   67,
											},
											File:   "geo.flux",
											Source: "toRows",
											Start: ast.Position{
												Column: 8,
												Line:   67,
											},
										},
									},
									Name: "toRows",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   71,
								},
								File:   "geo.flux",
								Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows(correlationKey: correlationKey)\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )",
								Start: ast.Position{
									Column: 3,
									Line:   59,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   70,
										},
										File:   "geo.flux",
										Source: "fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
										Start: ast.Position{
											Column: 12,
											Line:   68,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   70,
											},
											File:   "geo.flux",
											Source: "fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
											Start: ast.Position{
												Column: 12,
												Line:   68,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   68,
												},
												File:   "geo.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 12,
													Line:   68,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   70,
												},
												File:   "geo.flux",
												Source: "(r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
												Start: ast.Position{
													Column: 16,
													Line:   68,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   70,
													},
													File:   "geo.flux",
													Source: "({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })",
													Start: ast.Position{
														Column: 23,
														Line:   68,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 8,
															Line:   70,
														},
														File:   "geo.flux",
														Source: "{ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      }",
														Start: ast.Position{
															Column: 24,
															Line:   68,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   69,
															},
															File:   "geo.flux",
															Source: "s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
															Start: ast.Position{
																Column: 9,
																Line:   69,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   69,
																},
																File:   "geo.flux",
																Source: "s2_cell_id",
																Start: ast.Position{
																	Column: 9,
																	Line:   69,
																},
															},
														},
														Name: "s2_cell_id",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   69,
																	},
																	File:   "geo.flux",
																	Source: "point: {lat: r.lat, lon: r.lon}, level: level",
																	Start: ast.Position{
																		Column: 35,
																		Line:   69,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   69,
																		},
																		File:   "geo.flux",
																		Source: "point: {lat: r.lat, lon: r.lon}",
																		Start: ast.Position{
																			Column: 35,
																			Line:   69,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   69,
																			},
																			File:   "geo.flux",
																			Source: "point",
																			Start: ast.Position{
																				Column: 35,
																				Line:   69,
																			},
																		},
																	},
																	Name: "point",
																},
																Value: &ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   69,
																			},
																			File:   "geo.flux",
																			Source: "{lat: r.lat, lon: r.lon}",
																			Start: ast.Position{
																				Column: 42,
																				Line:   69,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 53,
																					Line:   69,
																				},
																				File:   "geo.flux",
																				Source: "lat: r.lat",
																				Start: ast.Position{
																					Column: 43,
																					Line:   69,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   69,
																					},
																					File:   "geo.flux",
																					Source: "lat",
																					Start: ast.Position{
																						Column: 43,
																						Line:   69,
																					},
																				},
																			},
																			Name: "lat",
																		},
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 53,
																						Line:   69,
																					},
																					File:   "geo.flux",
																					Source: "r.lat",
																					Start: ast.Position{
																						Column: 48,
																						Line:   69,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 49,
																							Line:   69,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 48,
																							Line:   69,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 53,
																							Line:   69,
																						},
																						File:   "geo.flux",
																						Source: "lat",
																						Start: ast.Position{
																							Column: 50,
																							Line:   69,
																						},
																					},
																				},
																				Name: "lat",
																			},
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   69,
																				},
																				File:   "geo.flux",
																				Source: "lon: r.lon",
																				Start: ast.Position{
																					Column: 55,
																					Line:   69,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 58,
																						Line:   69,
																					},
																					File:   "geo.flux",
																					Source: "lon",
																					Start: ast.Position{
																						Column: 55,
																						Line:   69,
																					},
																				},
																			},
																			Name: "lon",
																		},
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 65,
																						Line:   69,
																					},
																					File:   "geo.flux",
																					Source: "r.lon",
																					Start: ast.Position{
																						Column: 60,
																						Line:   69,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 61,
																							Line:   69,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 60,
																							Line:   69,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 65,
																							Line:   69,
																						},
																						File:   "geo.flux",
																						Source: "lon",
																						Start: ast.Position{
																							Column: 62,
																							Line:   69,
																						},
																					},
																				},
																				Name: "lon",
																			},
																		},
																	}},
																	With: nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   69,
																		},
																		File:   "geo.flux",
																		Source: "level: level",
																		Start: ast.Position{
																			Column: 68,
																			Line:   69,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   69,
																			},
																			File:   "geo.flux",
																			Source: "level",
																			Start: ast.Position{
																				Column: 68,
																				Line:   69,
																			},
																		},
																	},
																	Name: "level",
																},
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   69,
																			},
																			File:   "geo.flux",
																			Source: "level",
																			Start: ast.Position{
																				Column: 75,
																				Line:   69,
																			},
																		},
																	},
																	Name: "level",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   69,
																},
																File:   "geo.flux",
																Source: "s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																Start: ast.Position{
																	Column: 21,
																	Line:   69,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   69,
																	},
																	File:   "geo.flux",
																	Source: "s2CellIDToken",
																	Start: ast.Position{
																		Column: 21,
																		Line:   69,
																	},
																},
															},
															Name: "s2CellIDToken",
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   68,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 26,
																Line:   68,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   68,
													},
													File:   "geo.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   68,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   68,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 17,
															Line:   68,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   71,
									},
									File:   "geo.flux",
									Source: "map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   68,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   68,
										},
										File:   "geo.flux",
										Source: "map",
										Start: ast.Position{
											Column: 8,
											Line:   68,
										},
									},
								},
								Name: "map",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   75,
							},
							File:   "geo.flux",
							Source: "tables\n    |> map(fn: (r) => ({ r with\n        _field:\n          if r._field == latField then \"lat\"\n          else if r._field == lonField then \"lon\"\n          else r._field\n      })\n    )\n    |> toRows(correlationKey: correlationKey)\n    |> map(fn: (r) => ({ r with\n        s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n      })\n    )\n    |> experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
							Start: ast.Position{
								Column: 3,
								Line:   59,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   74,
									},
									File:   "geo.flux",
									Source: "columns: [\"s2_cell_id\"],\n      mode: \"extend\"",
									Start: ast.Position{
										Column: 7,
										Line:   73,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   73,
										},
										File:   "geo.flux",
										Source: "columns: [\"s2_cell_id\"]",
										Start: ast.Position{
											Column: 7,
											Line:   73,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   73,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 7,
												Line:   73,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   73,
											},
											File:   "geo.flux",
											Source: "[\"s2_cell_id\"]",
											Start: ast.Position{
												Column: 16,
												Line:   73,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   73,
												},
												File:   "geo.flux",
												Source: "\"s2_cell_id\"",
												Start: ast.Position{
													Column: 17,
													Line:   73,
												},
											},
										},
										Value: "s2_cell_id",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   74,
										},
										File:   "geo.flux",
										Source: "mode: \"extend\"",
										Start: ast.Position{
											Column: 7,
											Line:   74,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   74,
											},
											File:   "geo.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 7,
												Line:   74,
											},
										},
									},
									Name: "mode",
								},
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   74,
											},
											File:   "geo.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 13,
												Line:   74,
											},
										},
									},
									Value: "extend",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   75,
								},
								File:   "geo.flux",
								Source: "experimental.group(\n      columns: [\"s2_cell_id\"],\n      mode: \"extend\"\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   72,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   72,
									},
									File:   "geo.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 8,
										Line:   72,
									},
								},
							},
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 8,
											Line:   72,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   72,
										},
										File:   "geo.flux",
										Source: "group",
										Start: ast.Position{
											Column: 21,
											Line:   72,
										},
									},
								},
								Name: "group",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   58,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 14,
								Line:   58,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 14,
									Line:   58,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   58,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 21,
								Line:   58,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   58,
							},
							File:   "geo.flux",
							Source: "latField",
							Start: ast.Position{
								Column: 25,
								Line:   58,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "latField",
								Start: ast.Position{
									Column: 25,
									Line:   58,
								},
							},
						},
						Name: "latField",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   58,
							},
							File:   "geo.flux",
							Source: "lonField",
							Start: ast.Position{
								Column: 35,
								Line:   58,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "lonField",
								Start: ast.Position{
									Column: 35,
									Line:   58,
								},
							},
						},
						Name: "lonField",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   58,
							},
							File:   "geo.flux",
							Source: "level",
							Start: ast.Position{
								Column: 45,
								Line:   58,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 45,
									Line:   58,
								},
							},
						},
						Name: "level",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 76,
								Line:   58,
							},
							File:   "geo.flux",
							Source: "correlationKey=[\"_time\"]",
							Start: ast.Position{
								Column: 52,
								Line:   58,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "correlationKey",
								Start: ast.Position{
									Column: 52,
									Line:   58,
								},
							},
						},
						Name: "correlationKey",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 67,
									Line:   58,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   58,
									},
									File:   "geo.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 68,
										Line:   58,
									},
								},
							},
							Value: "_time",
						}},
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   100,
					},
					File:   "geo.flux",
					Source: "gridFilter = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   84,
						},
						File:   "geo.flux",
						Source: "gridFilter",
						Start: ast.Position{
							Column: 1,
							Line:   84,
						},
					},
				},
				Name: "gridFilter",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   100,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}",
						Start: ast.Position{
							Column: 14,
							Line:   84,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   100,
							},
							File:   "geo.flux",
							Source: "{\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel)\n  return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )\n}",
							Start: ast.Position{
								Column: 89,
								Line:   84,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   90,
								},
								File:   "geo.flux",
								Source: "_s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
								Start: ast.Position{
									Column: 3,
									Line:   85,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   85,
									},
									File:   "geo.flux",
									Source: "_s2cellIDLevel",
									Start: ast.Position{
										Column: 3,
										Line:   85,
									},
								},
							},
							Name: "_s2cellIDLevel",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   90,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel",
										Start: ast.Position{
											Column: 7,
											Line:   90,
										},
									},
								},
								Name: "s2cellIDLevel",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   90,
									},
									File:   "geo.flux",
									Source: "if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
									Start: ast.Position{
										Column: 5,
										Line:   86,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   87,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   87,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   88,
										},
										File:   "geo.flux",
										Source: "tables\n        |> _detectLevel()",
										Start: ast.Position{
											Column: 7,
											Line:   87,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   88,
											},
											File:   "geo.flux",
											Source: "_detectLevel()",
											Start: ast.Position{
												Column: 12,
												Line:   88,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   88,
												},
												File:   "geo.flux",
												Source: "_detectLevel",
												Start: ast.Position{
													Column: 12,
													Line:   88,
												},
											},
										},
										Name: "_detectLevel",
									},
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   86,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel == -1",
										Start: ast.Position{
											Column: 8,
											Line:   86,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   86,
											},
											File:   "geo.flux",
											Source: "s2cellIDLevel",
											Start: ast.Position{
												Column: 8,
												Line:   86,
											},
										},
									},
									Name: "s2cellIDLevel",
								},
								Operator: 17,
								Right: &ast.UnaryExpression{
									Argument: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   86,
												},
												File:   "geo.flux",
												Source: "1",
												Start: ast.Position{
													Column: 26,
													Line:   86,
												},
											},
										},
										Value: int64(1),
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   86,
											},
											File:   "geo.flux",
											Source: "-1",
											Start: ast.Position{
												Column: 25,
												Line:   86,
											},
										},
									},
									Operator: 6,
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   91,
								},
								File:   "geo.flux",
								Source: "_grid = getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel)",
								Start: ast.Position{
									Column: 3,
									Line:   91,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   91,
									},
									File:   "geo.flux",
									Source: "_grid",
									Start: ast.Position{
										Column: 3,
										Line:   91,
									},
								},
							},
							Name: "_grid",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   91,
										},
										File:   "geo.flux",
										Source: "region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel",
										Start: ast.Position{
											Column: 19,
											Line:   91,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   91,
											},
											File:   "geo.flux",
											Source: "region: region",
											Start: ast.Position{
												Column: 19,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 19,
													Line:   91,
												},
											},
										},
										Name: "region",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 27,
													Line:   91,
												},
											},
										},
										Name: "region",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   91,
											},
											File:   "geo.flux",
											Source: "minSize: minSize",
											Start: ast.Position{
												Column: 35,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "minSize",
												Start: ast.Position{
													Column: 35,
													Line:   91,
												},
											},
										},
										Name: "minSize",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "minSize",
												Start: ast.Position{
													Column: 44,
													Line:   91,
												},
											},
										},
										Name: "minSize",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   91,
											},
											File:   "geo.flux",
											Source: "maxSize: maxSize",
											Start: ast.Position{
												Column: 53,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "maxSize",
												Start: ast.Position{
													Column: 53,
													Line:   91,
												},
											},
										},
										Name: "maxSize",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "maxSize",
												Start: ast.Position{
													Column: 62,
													Line:   91,
												},
											},
										},
										Name: "maxSize",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   91,
											},
											File:   "geo.flux",
											Source: "level: level",
											Start: ast.Position{
												Column: 71,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "level",
												Start: ast.Position{
													Column: 71,
													Line:   91,
												},
											},
										},
										Name: "level",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "level",
												Start: ast.Position{
													Column: 78,
													Line:   91,
												},
											},
										},
										Name: "level",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   91,
											},
											File:   "geo.flux",
											Source: "maxLevel: _s2cellIDLevel",
											Start: ast.Position{
												Column: 85,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "maxLevel",
												Start: ast.Position{
													Column: 85,
													Line:   91,
												},
											},
										},
										Name: "maxLevel",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   91,
												},
												File:   "geo.flux",
												Source: "_s2cellIDLevel",
												Start: ast.Position{
													Column: 95,
													Line:   91,
												},
											},
										},
										Name: "_s2cellIDLevel",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 110,
										Line:   91,
									},
									File:   "geo.flux",
									Source: "getGrid(region: region, minSize: minSize, maxSize: maxSize, level: level, maxLevel: _s2cellIDLevel)",
									Start: ast.Position{
										Column: 11,
										Line:   91,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   91,
										},
										File:   "geo.flux",
										Source: "getGrid",
										Start: ast.Position{
											Column: 11,
											Line:   91,
										},
									},
								},
								Name: "getGrid",
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   93,
										},
										File:   "geo.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 5,
											Line:   93,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   99,
									},
									File:   "geo.flux",
									Source: "tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )",
									Start: ast.Position{
										Column: 5,
										Line:   93,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   98,
											},
											File:   "geo.flux",
											Source: "fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
											Start: ast.Position{
												Column: 17,
												Line:   94,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   98,
												},
												File:   "geo.flux",
												Source: "fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
												Start: ast.Position{
													Column: 17,
													Line:   94,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   94,
													},
													File:   "geo.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 17,
														Line:   94,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.FunctionExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   98,
													},
													File:   "geo.flux",
													Source: "(r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
													Start: ast.Position{
														Column: 21,
														Line:   94,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 97,
																	Line:   98,
																},
																File:   "geo.flux",
																Source: "value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set",
																Start: ast.Position{
																	Column: 20,
																	Line:   98,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   98,
																	},
																	File:   "geo.flux",
																	Source: "value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level)",
																	Start: ast.Position{
																		Column: 20,
																		Line:   98,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   98,
																		},
																		File:   "geo.flux",
																		Source: "value",
																		Start: ast.Position{
																			Column: 20,
																			Line:   98,
																		},
																	},
																},
																Name: "value",
															},
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   98,
																			},
																			File:   "geo.flux",
																			Source: "token: r.s2_cell_id, level: _grid.level",
																			Start: ast.Position{
																				Column: 41,
																				Line:   98,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   98,
																				},
																				File:   "geo.flux",
																				Source: "token: r.s2_cell_id",
																				Start: ast.Position{
																					Column: 41,
																					Line:   98,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   98,
																					},
																					File:   "geo.flux",
																					Source: "token",
																					Start: ast.Position{
																						Column: 41,
																						Line:   98,
																					},
																				},
																			},
																			Name: "token",
																		},
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 60,
																						Line:   98,
																					},
																					File:   "geo.flux",
																					Source: "r.s2_cell_id",
																					Start: ast.Position{
																						Column: 48,
																						Line:   98,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 49,
																							Line:   98,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 48,
																							Line:   98,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 60,
																							Line:   98,
																						},
																						File:   "geo.flux",
																						Source: "s2_cell_id",
																						Start: ast.Position{
																							Column: 50,
																							Line:   98,
																						},
																					},
																				},
																				Name: "s2_cell_id",
																			},
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 80,
																					Line:   98,
																				},
																				File:   "geo.flux",
																				Source: "level: _grid.level",
																				Start: ast.Position{
																					Column: 62,
																					Line:   98,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 67,
																						Line:   98,
																					},
																					File:   "geo.flux",
																					Source: "level",
																					Start: ast.Position{
																						Column: 62,
																						Line:   98,
																					},
																				},
																			},
																			Name: "level",
																		},
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 80,
																						Line:   98,
																					},
																					File:   "geo.flux",
																					Source: "_grid.level",
																					Start: ast.Position{
																						Column: 69,
																						Line:   98,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 74,
																							Line:   98,
																						},
																						File:   "geo.flux",
																						Source: "_grid",
																						Start: ast.Position{
																							Column: 69,
																							Line:   98,
																						},
																					},
																				},
																				Name: "_grid",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 80,
																							Line:   98,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 75,
																							Line:   98,
																						},
																					},
																				},
																				Name: "level",
																			},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   98,
																		},
																		File:   "geo.flux",
																		Source: "s2CellIDToken(token: r.s2_cell_id, level: _grid.level)",
																		Start: ast.Position{
																			Column: 27,
																			Line:   98,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   98,
																			},
																			File:   "geo.flux",
																			Source: "s2CellIDToken",
																			Start: ast.Position{
																				Column: 27,
																				Line:   98,
																			},
																		},
																	},
																	Name: "s2CellIDToken",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 97,
																		Line:   98,
																	},
																	File:   "geo.flux",
																	Source: "set: _grid.set",
																	Start: ast.Position{
																		Column: 83,
																		Line:   98,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   98,
																		},
																		File:   "geo.flux",
																		Source: "set",
																		Start: ast.Position{
																			Column: 83,
																			Line:   98,
																		},
																	},
																},
																Name: "set",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 97,
																			Line:   98,
																		},
																		File:   "geo.flux",
																		Source: "_grid.set",
																		Start: ast.Position{
																			Column: 88,
																			Line:   98,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 93,
																				Line:   98,
																			},
																			File:   "geo.flux",
																			Source: "_grid",
																			Start: ast.Position{
																				Column: 88,
																				Line:   98,
																			},
																		},
																	},
																	Name: "_grid",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 97,
																				Line:   98,
																			},
																			File:   "geo.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 94,
																				Line:   98,
																			},
																		},
																	},
																	Name: "set",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 98,
																Line:   98,
															},
															File:   "geo.flux",
															Source: "contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
															Start: ast.Position{
																Column: 11,
																Line:   98,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   98,
																},
																File:   "geo.flux",
																Source: "contains",
																Start: ast.Position{
																	Column: 11,
																	Line:   98,
																},
															},
														},
														Name: "contains",
													},
												},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   98,
														},
														File:   "geo.flux",
														Source: "if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
														Start: ast.Position{
															Column: 9,
															Line:   95,
														},
													},
												},
												Consequent: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   96,
																},
																File:   "geo.flux",
																Source: "value: r.s2_cell_id, set: _grid.set",
																Start: ast.Position{
																	Column: 20,
																	Line:   96,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   96,
																	},
																	File:   "geo.flux",
																	Source: "value: r.s2_cell_id",
																	Start: ast.Position{
																		Column: 20,
																		Line:   96,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   96,
																		},
																		File:   "geo.flux",
																		Source: "value",
																		Start: ast.Position{
																			Column: 20,
																			Line:   96,
																		},
																	},
																},
																Name: "value",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   96,
																		},
																		File:   "geo.flux",
																		Source: "r.s2_cell_id",
																		Start: ast.Position{
																			Column: 27,
																			Line:   96,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   96,
																			},
																			File:   "geo.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 27,
																				Line:   96,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   96,
																			},
																			File:   "geo.flux",
																			Source: "s2_cell_id",
																			Start: ast.Position{
																				Column: 29,
																				Line:   96,
																			},
																		},
																	},
																	Name: "s2_cell_id",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   96,
																	},
																	File:   "geo.flux",
																	Source: "set: _grid.set",
																	Start: ast.Position{
																		Column: 41,
																		Line:   96,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   96,
																		},
																		File:   "geo.flux",
																		Source: "set",
																		Start: ast.Position{
																			Column: 41,
																			Line:   96,
																		},
																	},
																},
																Name: "set",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   96,
																		},
																		File:   "geo.flux",
																		Source: "_grid.set",
																		Start: ast.Position{
																			Column: 46,
																			Line:   96,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   96,
																			},
																			File:   "geo.flux",
																			Source: "_grid",
																			Start: ast.Position{
																				Column: 46,
																				Line:   96,
																			},
																		},
																	},
																	Name: "_grid",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   96,
																			},
																			File:   "geo.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 52,
																				Line:   96,
																			},
																		},
																	},
																	Name: "set",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   96,
															},
															File:   "geo.flux",
															Source: "contains(value: r.s2_cell_id, set: _grid.set)",
															Start: ast.Position{
																Column: 11,
																Line:   96,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   96,
																},
																File:   "geo.flux",
																Source: "contains",
																Start: ast.Position{
																	Column: 11,
																	Line:   96,
																},
															},
														},
														Name: "contains",
													},
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   95,
															},
															File:   "geo.flux",
															Source: "_grid.level == _s2cellIDLevel",
															Start: ast.Position{
																Column: 12,
																Line:   95,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   95,
																},
																File:   "geo.flux",
																Source: "_grid.level",
																Start: ast.Position{
																	Column: 12,
																	Line:   95,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 17,
																		Line:   95,
																	},
																	File:   "geo.flux",
																	Source: "_grid",
																	Start: ast.Position{
																		Column: 12,
																		Line:   95,
																	},
																},
															},
															Name: "_grid",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   95,
																	},
																	File:   "geo.flux",
																	Source: "level",
																	Start: ast.Position{
																		Column: 18,
																		Line:   95,
																	},
																},
															},
															Name: "level",
														},
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   95,
																},
																File:   "geo.flux",
																Source: "_s2cellIDLevel",
																Start: ast.Position{
																	Column: 27,
																	Line:   95,
																},
															},
														},
														Name: "_s2cellIDLevel",
													},
												},
											},
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   94,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 22,
															Line:   94,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   94,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 22,
																Line:   94,
															},
														},
													},
													Name: "r",
												},
												Value: nil,
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   99,
										},
										File:   "geo.flux",
										Source: "filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )",
										Start: ast.Position{
											Column: 10,
											Line:   94,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   94,
											},
											File:   "geo.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 10,
												Line:   94,
											},
										},
									},
									Name: "filter",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 8,
									Line:   99,
								},
								File:   "geo.flux",
								Source: "return\n    tables\n      |> filter(fn: (r) =>\n        if _grid.level == _s2cellIDLevel then\n          contains(value: r.s2_cell_id, set: _grid.set)\n        else\n          contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)\n      )",
								Start: ast.Position{
									Column: 3,
									Line:   92,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   84,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   84,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   84,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 26,
								Line:   84,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 26,
									Line:   84,
								},
							},
						},
						Name: "region",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "minSize=24",
							Start: ast.Position{
								Column: 34,
								Line:   84,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "minSize",
								Start: ast.Position{
									Column: 34,
									Line:   84,
								},
							},
						},
						Name: "minSize",
					},
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "24",
								Start: ast.Position{
									Column: 42,
									Line:   84,
								},
							},
						},
						Value: int64(24),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "maxSize=-1",
							Start: ast.Position{
								Column: 46,
								Line:   84,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "maxSize",
								Start: ast.Position{
									Column: 46,
									Line:   84,
								},
							},
						},
						Name: "maxSize",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   84,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 55,
										Line:   84,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 54,
									Line:   84,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "level=-1",
							Start: ast.Position{
								Column: 58,
								Line:   84,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 58,
									Line:   84,
								},
							},
						},
						Name: "level",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   84,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 65,
										Line:   84,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 64,
									Line:   84,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   84,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 68,
								Line:   84,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 68,
									Line:   84,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   84,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 83,
										Line:   84,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   84,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 82,
									Line:   84,
								},
							},
						},
						Operator: 6,
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   108,
					},
					File:   "geo.flux",
					Source: "strictFilter = (tables=<-, region) =>\n  tables\n    |> filter(fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   104,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   104,
						},
						File:   "geo.flux",
						Source: "strictFilter",
						Start: ast.Position{
							Column: 1,
							Line:   104,
						},
					},
				},
				Name: "strictFilter",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   108,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region) =>\n  tables\n    |> filter(fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)\n    )",
						Start: ast.Position{
							Column: 16,
							Line:   104,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   105,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 3,
									Line:   105,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   108,
							},
							File:   "geo.flux",
							Source: "tables\n    |> filter(fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)\n    )",
							Start: ast.Position{
								Column: 3,
								Line:   105,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   107,
									},
									File:   "geo.flux",
									Source: "fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)",
									Start: ast.Position{
										Column: 15,
										Line:   106,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   107,
										},
										File:   "geo.flux",
										Source: "fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)",
										Start: ast.Position{
											Column: 15,
											Line:   106,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   106,
											},
											File:   "geo.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 15,
												Line:   106,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   107,
											},
											File:   "geo.flux",
											Source: "(r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)",
											Start: ast.Position{
												Column: 19,
												Line:   106,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   107,
													},
													File:   "geo.flux",
													Source: "region: region, lat: r.lat, lon: r.lon",
													Start: ast.Position{
														Column: 22,
														Line:   107,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   107,
														},
														File:   "geo.flux",
														Source: "region: region",
														Start: ast.Position{
															Column: 22,
															Line:   107,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   107,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 22,
																Line:   107,
															},
														},
													},
													Name: "region",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   107,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 30,
																Line:   107,
															},
														},
													},
													Name: "region",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   107,
														},
														File:   "geo.flux",
														Source: "lat: r.lat",
														Start: ast.Position{
															Column: 38,
															Line:   107,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   107,
															},
															File:   "geo.flux",
															Source: "lat",
															Start: ast.Position{
																Column: 38,
																Line:   107,
															},
														},
													},
													Name: "lat",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   107,
															},
															File:   "geo.flux",
															Source: "r.lat",
															Start: ast.Position{
																Column: 43,
																Line:   107,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   107,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 43,
																	Line:   107,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   107,
																},
																File:   "geo.flux",
																Source: "lat",
																Start: ast.Position{
																	Column: 45,
																	Line:   107,
																},
															},
														},
														Name: "lat",
													},
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   107,
														},
														File:   "geo.flux",
														Source: "lon: r.lon",
														Start: ast.Position{
															Column: 50,
															Line:   107,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   107,
															},
															File:   "geo.flux",
															Source: "lon",
															Start: ast.Position{
																Column: 50,
																Line:   107,
															},
														},
													},
													Name: "lon",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   107,
															},
															File:   "geo.flux",
															Source: "r.lon",
															Start: ast.Position{
																Column: 55,
																Line:   107,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   107,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 55,
																	Line:   107,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   107,
																},
																File:   "geo.flux",
																Source: "lon",
																Start: ast.Position{
																	Column: 57,
																	Line:   107,
																},
															},
														},
														Name: "lon",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   107,
												},
												File:   "geo.flux",
												Source: "containsLatLon(region: region, lat: r.lat, lon: r.lon)",
												Start: ast.Position{
													Column: 7,
													Line:   107,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   107,
													},
													File:   "geo.flux",
													Source: "containsLatLon",
													Start: ast.Position{
														Column: 7,
														Line:   107,
													},
												},
											},
											Name: "containsLatLon",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   106,
												},
												File:   "geo.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   106,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   106,
													},
													File:   "geo.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   106,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   108,
								},
								File:   "geo.flux",
								Source: "filter(fn: (r) =>\n      containsLatLon(region: region, lat: r.lat, lon: r.lon)\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   106,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   106,
									},
									File:   "geo.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 8,
										Line:   106,
									},
								},
							},
							Name: "filter",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   104,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   104,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   104,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   104,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   104,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   104,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   104,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 28,
								Line:   104,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   104,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 28,
									Line:   104,
								},
							},
						},
						Name: "region",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   134,
					},
					File:   "geo.flux",
					Source: "filterRows = (tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, correlationKey=[\"_time\"], strict=true) => {\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}",
					Start: ast.Position{
						Column: 1,
						Line:   113,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   113,
						},
						File:   "geo.flux",
						Source: "filterRows",
						Start: ast.Position{
							Column: 1,
							Line:   113,
						},
					},
				},
				Name: "filterRows",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   134,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region, minSize=24, maxSize=-1, level=-1, s2cellIDLevel=-1, correlationKey=[\"_time\"], strict=true) => {\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}",
						Start: ast.Position{
							Column: 14,
							Line:   113,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   134,
							},
							File:   "geo.flux",
							Source: "{\n  _columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")\n  _rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)\n  _result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows\n  return _result\n}",
							Start: ast.Position{
								Column: 128,
								Line:   113,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   118,
								},
								File:   "geo.flux",
								Source: "_columns =\n    tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")",
								Start: ast.Position{
									Column: 3,
									Line:   114,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   114,
									},
									File:   "geo.flux",
									Source: "_columns",
									Start: ast.Position{
										Column: 3,
										Line:   114,
									},
								},
							},
							Name: "_columns",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   115,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 5,
													Line:   115,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   116,
											},
											File:   "geo.flux",
											Source: "tables\n      |> columns(column: \"_value\")",
											Start: ast.Position{
												Column: 5,
												Line:   115,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   116,
													},
													File:   "geo.flux",
													Source: "column: \"_value\"",
													Start: ast.Position{
														Column: 18,
														Line:   116,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   116,
														},
														File:   "geo.flux",
														Source: "column: \"_value\"",
														Start: ast.Position{
															Column: 18,
															Line:   116,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   116,
															},
															File:   "geo.flux",
															Source: "column",
															Start: ast.Position{
																Column: 18,
																Line:   116,
															},
														},
													},
													Name: "column",
												},
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   116,
															},
															File:   "geo.flux",
															Source: "\"_value\"",
															Start: ast.Position{
																Column: 26,
																Line:   116,
															},
														},
													},
													Value: "_value",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   116,
												},
												File:   "geo.flux",
												Source: "columns(column: \"_value\")",
												Start: ast.Position{
													Column: 10,
													Line:   116,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   116,
													},
													File:   "geo.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 10,
														Line:   116,
													},
												},
											},
											Name: "columns",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   117,
										},
										File:   "geo.flux",
										Source: "tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )",
										Start: ast.Position{
											Column: 5,
											Line:   115,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   117,
												},
												File:   "geo.flux",
												Source: "fn: (key) => true",
												Start: ast.Position{
													Column: 20,
													Line:   117,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   117,
													},
													File:   "geo.flux",
													Source: "fn: (key) => true",
													Start: ast.Position{
														Column: 20,
														Line:   117,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   117,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 20,
															Line:   117,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   117,
														},
														File:   "geo.flux",
														Source: "(key) => true",
														Start: ast.Position{
															Column: 24,
															Line:   117,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   117,
															},
															File:   "geo.flux",
															Source: "true",
															Start: ast.Position{
																Column: 33,
																Line:   117,
															},
														},
													},
													Name: "true",
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   117,
															},
															File:   "geo.flux",
															Source: "key",
															Start: ast.Position{
																Column: 25,
																Line:   117,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   117,
																},
																File:   "geo.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 25,
																	Line:   117,
																},
															},
														},
														Name: "key",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   117,
											},
											File:   "geo.flux",
											Source: "tableFind(fn: (key) => true )",
											Start: ast.Position{
												Column: 10,
												Line:   117,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   117,
												},
												File:   "geo.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 10,
													Line:   117,
												},
											},
										},
										Name: "tableFind",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   118,
									},
									File:   "geo.flux",
									Source: "tables\n      |> columns(column: \"_value\")\n      |> tableFind(fn: (key) => true )\n      |> getColumn(column: \"_value\")",
									Start: ast.Position{
										Column: 5,
										Line:   115,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   118,
											},
											File:   "geo.flux",
											Source: "column: \"_value\"",
											Start: ast.Position{
												Column: 20,
												Line:   118,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   118,
												},
												File:   "geo.flux",
												Source: "column: \"_value\"",
												Start: ast.Position{
													Column: 20,
													Line:   118,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   118,
													},
													File:   "geo.flux",
													Source: "column",
													Start: ast.Position{
														Column: 20,
														Line:   118,
													},
												},
											},
											Name: "column",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   118,
													},
													File:   "geo.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 28,
														Line:   118,
													},
												},
											},
											Value: "_value",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   118,
										},
										File:   "geo.flux",
										Source: "getColumn(column: \"_value\")",
										Start: ast.Position{
											Column: 10,
											Line:   118,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   118,
											},
											File:   "geo.flux",
											Source: "getColumn",
											Start: ast.Position{
												Column: 10,
												Line:   118,
											},
										},
									},
									Name: "getColumn",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   126,
								},
								File:   "geo.flux",
								Source: "_rows =\n    if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)",
								Start: ast.Position{
									Column: 3,
									Line:   119,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   119,
									},
									File:   "geo.flux",
									Source: "_rows",
									Start: ast.Position{
										Column: 3,
										Line:   119,
									},
								},
							},
							Name: "_rows",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   124,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 7,
													Line:   124,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   125,
											},
											File:   "geo.flux",
											Source: "tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
											Start: ast.Position{
												Column: 7,
												Line:   124,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 117,
														Line:   125,
													},
													File:   "geo.flux",
													Source: "region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel",
													Start: ast.Position{
														Column: 23,
														Line:   125,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   125,
														},
														File:   "geo.flux",
														Source: "region: region",
														Start: ast.Position{
															Column: 23,
															Line:   125,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 23,
																Line:   125,
															},
														},
													},
													Name: "region",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 31,
																Line:   125,
															},
														},
													},
													Name: "region",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   125,
														},
														File:   "geo.flux",
														Source: "minSize: minSize",
														Start: ast.Position{
															Column: 39,
															Line:   125,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "minSize",
															Start: ast.Position{
																Column: 39,
																Line:   125,
															},
														},
													},
													Name: "minSize",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "minSize",
															Start: ast.Position{
																Column: 48,
																Line:   125,
															},
														},
													},
													Name: "minSize",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   125,
														},
														File:   "geo.flux",
														Source: "maxSize: maxSize",
														Start: ast.Position{
															Column: 57,
															Line:   125,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "maxSize",
															Start: ast.Position{
																Column: 57,
																Line:   125,
															},
														},
													},
													Name: "maxSize",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "maxSize",
															Start: ast.Position{
																Column: 66,
																Line:   125,
															},
														},
													},
													Name: "maxSize",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   125,
														},
														File:   "geo.flux",
														Source: "level: level",
														Start: ast.Position{
															Column: 75,
															Line:   125,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "level",
															Start: ast.Position{
																Column: 75,
																Line:   125,
															},
														},
													},
													Name: "level",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 87,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "level",
															Start: ast.Position{
																Column: 82,
																Line:   125,
															},
														},
													},
													Name: "level",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 117,
															Line:   125,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel: s2cellIDLevel",
														Start: ast.Position{
															Column: 89,
															Line:   125,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 102,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "s2cellIDLevel",
															Start: ast.Position{
																Column: 89,
																Line:   125,
															},
														},
													},
													Name: "s2cellIDLevel",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 117,
																Line:   125,
															},
															File:   "geo.flux",
															Source: "s2cellIDLevel",
															Start: ast.Position{
																Column: 104,
																Line:   125,
															},
														},
													},
													Name: "s2cellIDLevel",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 118,
													Line:   125,
												},
												File:   "geo.flux",
												Source: "gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
												Start: ast.Position{
													Column: 12,
													Line:   125,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   125,
													},
													File:   "geo.flux",
													Source: "gridFilter",
													Start: ast.Position{
														Column: 12,
														Line:   125,
													},
												},
											},
											Name: "gridFilter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   126,
										},
										File:   "geo.flux",
										Source: "tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)",
										Start: ast.Position{
											Column: 7,
											Line:   124,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   126,
												},
												File:   "geo.flux",
												Source: "correlationKey",
												Start: ast.Position{
													Column: 19,
													Line:   126,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   126,
													},
													File:   "geo.flux",
													Source: "correlationKey",
													Start: ast.Position{
														Column: 19,
														Line:   126,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   126,
														},
														File:   "geo.flux",
														Source: "correlationKey",
														Start: ast.Position{
															Column: 19,
															Line:   126,
														},
													},
												},
												Name: "correlationKey",
											},
											Value: nil,
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   126,
											},
											File:   "geo.flux",
											Source: "toRows(correlationKey)",
											Start: ast.Position{
												Column: 12,
												Line:   126,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   126,
												},
												File:   "geo.flux",
												Source: "toRows",
												Start: ast.Position{
													Column: 12,
													Line:   126,
												},
											},
										},
										Name: "toRows",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   126,
									},
									File:   "geo.flux",
									Source: "if contains(value: \"lat\", set: _columns) then\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n    else\n      tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)\n        |> toRows(correlationKey)",
									Start: ast.Position{
										Column: 5,
										Line:   120,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   121,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   121,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 118,
											Line:   122,
										},
										File:   "geo.flux",
										Source: "tables\n        |> gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
										Start: ast.Position{
											Column: 7,
											Line:   121,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 117,
													Line:   122,
												},
												File:   "geo.flux",
												Source: "region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel",
												Start: ast.Position{
													Column: 23,
													Line:   122,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   122,
													},
													File:   "geo.flux",
													Source: "region: region",
													Start: ast.Position{
														Column: 23,
														Line:   122,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 23,
															Line:   122,
														},
													},
												},
												Name: "region",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 31,
															Line:   122,
														},
													},
												},
												Name: "region",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   122,
													},
													File:   "geo.flux",
													Source: "minSize: minSize",
													Start: ast.Position{
														Column: 39,
														Line:   122,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "minSize",
														Start: ast.Position{
															Column: 39,
															Line:   122,
														},
													},
												},
												Name: "minSize",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "minSize",
														Start: ast.Position{
															Column: 48,
															Line:   122,
														},
													},
												},
												Name: "minSize",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   122,
													},
													File:   "geo.flux",
													Source: "maxSize: maxSize",
													Start: ast.Position{
														Column: 57,
														Line:   122,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "maxSize",
														Start: ast.Position{
															Column: 57,
															Line:   122,
														},
													},
												},
												Name: "maxSize",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "maxSize",
														Start: ast.Position{
															Column: 66,
															Line:   122,
														},
													},
												},
												Name: "maxSize",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   122,
													},
													File:   "geo.flux",
													Source: "level: level",
													Start: ast.Position{
														Column: 75,
														Line:   122,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "level",
														Start: ast.Position{
															Column: 75,
															Line:   122,
														},
													},
												},
												Name: "level",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "level",
														Start: ast.Position{
															Column: 82,
															Line:   122,
														},
													},
												},
												Name: "level",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 117,
														Line:   122,
													},
													File:   "geo.flux",
													Source: "s2cellIDLevel: s2cellIDLevel",
													Start: ast.Position{
														Column: 89,
														Line:   122,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel",
														Start: ast.Position{
															Column: 89,
															Line:   122,
														},
													},
												},
												Name: "s2cellIDLevel",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 117,
															Line:   122,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel",
														Start: ast.Position{
															Column: 104,
															Line:   122,
														},
													},
												},
												Name: "s2cellIDLevel",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   122,
											},
											File:   "geo.flux",
											Source: "gridFilter(region: region, minSize: minSize, maxSize: maxSize, level: level, s2cellIDLevel: s2cellIDLevel)",
											Start: ast.Position{
												Column: 12,
												Line:   122,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   122,
												},
												File:   "geo.flux",
												Source: "gridFilter",
												Start: ast.Position{
													Column: 12,
													Line:   122,
												},
											},
										},
										Name: "gridFilter",
									},
								},
							},
							Test: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   120,
											},
											File:   "geo.flux",
											Source: "value: \"lat\", set: _columns",
											Start: ast.Position{
												Column: 17,
												Line:   120,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   120,
												},
												File:   "geo.flux",
												Source: "value: \"lat\"",
												Start: ast.Position{
													Column: 17,
													Line:   120,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   120,
													},
													File:   "geo.flux",
													Source: "value",
													Start: ast.Position{
														Column: 17,
														Line:   120,
													},
												},
											},
											Name: "value",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   120,
													},
													File:   "geo.flux",
													Source: "\"lat\"",
													Start: ast.Position{
														Column: 24,
														Line:   120,
													},
												},
											},
											Value: "lat",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   120,
												},
												File:   "geo.flux",
												Source: "set: _columns",
												Start: ast.Position{
													Column: 31,
													Line:   120,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   120,
													},
													File:   "geo.flux",
													Source: "set",
													Start: ast.Position{
														Column: 31,
														Line:   120,
													},
												},
											},
											Name: "set",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   120,
													},
													File:   "geo.flux",
													Source: "_columns",
													Start: ast.Position{
														Column: 36,
														Line:   120,
													},
												},
											},
											Name: "_columns",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   120,
										},
										File:   "geo.flux",
										Source: "contains(value: \"lat\", set: _columns)",
										Start: ast.Position{
											Column: 8,
											Line:   120,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   120,
											},
											File:   "geo.flux",
											Source: "contains",
											Start: ast.Position{
												Column: 8,
												Line:   120,
											},
										},
									},
									Name: "contains",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "_result =\n    if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows",
								Start: ast.Position{
									Column: 3,
									Line:   127,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   127,
									},
									File:   "geo.flux",
									Source: "_result",
									Start: ast.Position{
										Column: 3,
										Line:   127,
									},
								},
							},
							Name: "_result",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   132,
										},
										File:   "geo.flux",
										Source: "_rows",
										Start: ast.Position{
											Column: 7,
											Line:   132,
										},
									},
								},
								Name: "_rows",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   132,
									},
									File:   "geo.flux",
									Source: "if strict then\n      _rows\n        |> strictFilter(region)\n    else\n      _rows",
									Start: ast.Position{
										Column: 5,
										Line:   128,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   129,
											},
											File:   "geo.flux",
											Source: "_rows",
											Start: ast.Position{
												Column: 7,
												Line:   129,
											},
										},
									},
									Name: "_rows",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   130,
										},
										File:   "geo.flux",
										Source: "_rows\n        |> strictFilter(region)",
										Start: ast.Position{
											Column: 7,
											Line:   129,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   130,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 25,
													Line:   130,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   130,
													},
													File:   "geo.flux",
													Source: "region",
													Start: ast.Position{
														Column: 25,
														Line:   130,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   130,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 25,
															Line:   130,
														},
													},
												},
												Name: "region",
											},
											Value: nil,
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   130,
											},
											File:   "geo.flux",
											Source: "strictFilter(region)",
											Start: ast.Position{
												Column: 12,
												Line:   130,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   130,
												},
												File:   "geo.flux",
												Source: "strictFilter",
												Start: ast.Position{
													Column: 12,
													Line:   130,
												},
											},
										},
										Name: "strictFilter",
									},
								},
							},
							Test: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   128,
										},
										File:   "geo.flux",
										Source: "strict",
										Start: ast.Position{
											Column: 8,
											Line:   128,
										},
									},
								},
								Name: "strict",
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   133,
									},
									File:   "geo.flux",
									Source: "_result",
									Start: ast.Position{
										Column: 10,
										Line:   133,
									},
								},
							},
							Name: "_result",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   133,
								},
								File:   "geo.flux",
								Source: "return _result",
								Start: ast.Position{
									Column: 3,
									Line:   133,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   113,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   113,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 26,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 26,
									Line:   113,
								},
							},
						},
						Name: "region",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "minSize=24",
							Start: ast.Position{
								Column: 34,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "minSize",
								Start: ast.Position{
									Column: 34,
									Line:   113,
								},
							},
						},
						Name: "minSize",
					},
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "24",
								Start: ast.Position{
									Column: 42,
									Line:   113,
								},
							},
						},
						Value: int64(24),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "maxSize=-1",
							Start: ast.Position{
								Column: 46,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "maxSize",
								Start: ast.Position{
									Column: 46,
									Line:   113,
								},
							},
						},
						Name: "maxSize",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   113,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 55,
										Line:   113,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 54,
									Line:   113,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "level=-1",
							Start: ast.Position{
								Column: 58,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 58,
									Line:   113,
								},
							},
						},
						Name: "level",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   113,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 65,
										Line:   113,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 64,
									Line:   113,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 68,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 68,
									Line:   113,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   113,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 83,
										Line:   113,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 82,
									Line:   113,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "correlationKey=[\"_time\"]",
							Start: ast.Position{
								Column: 86,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "correlationKey",
								Start: ast.Position{
									Column: 86,
									Line:   113,
								},
							},
						},
						Name: "correlationKey",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 101,
									Line:   113,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   113,
									},
									File:   "geo.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 102,
										Line:   113,
									},
								},
							},
							Value: "_time",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 123,
								Line:   113,
							},
							File:   "geo.flux",
							Source: "strict=true",
							Start: ast.Position{
								Column: 112,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "strict",
								Start: ast.Position{
									Column: 112,
									Line:   113,
								},
							},
						},
						Name: "strict",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 123,
									Line:   113,
								},
								File:   "geo.flux",
								Source: "true",
								Start: ast.Position{
									Column: 119,
									Line:   113,
								},
							},
						},
						Name: "true",
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   164,
					},
					File:   "geo.flux",
					Source: "groupByArea = (tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   143,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   143,
						},
						File:   "geo.flux",
						Source: "groupByArea",
						Start: ast.Position{
							Column: 1,
							Line:   143,
						},
					},
				},
				Name: "groupByArea",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   164,
						},
						File:   "geo.flux",
						Source: "(tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}",
						Start: ast.Position{
							Column: 15,
							Line:   143,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   164,
							},
							File:   "geo.flux",
							Source: "{\n  _s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel\n  _prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })\n  return\n    _prepared\n      |> group(columns: [newColumn])\n}",
							Start: ast.Position{
								Column: 66,
								Line:   143,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   149,
								},
								File:   "geo.flux",
								Source: "_s2cellIDLevel =\n    if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
								Start: ast.Position{
									Column: 3,
									Line:   144,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   144,
									},
									File:   "geo.flux",
									Source: "_s2cellIDLevel",
									Start: ast.Position{
										Column: 3,
										Line:   144,
									},
								},
							},
							Name: "_s2cellIDLevel",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   149,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel",
										Start: ast.Position{
											Column: 7,
											Line:   149,
										},
									},
								},
								Name: "s2cellIDLevel",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   149,
									},
									File:   "geo.flux",
									Source: "if s2cellIDLevel == -1 then\n      tables\n        |> _detectLevel()\n    else\n      s2cellIDLevel",
									Start: ast.Position{
										Column: 5,
										Line:   145,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   146,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   146,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   147,
										},
										File:   "geo.flux",
										Source: "tables\n        |> _detectLevel()",
										Start: ast.Position{
											Column: 7,
											Line:   146,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   147,
											},
											File:   "geo.flux",
											Source: "_detectLevel()",
											Start: ast.Position{
												Column: 12,
												Line:   147,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   147,
												},
												File:   "geo.flux",
												Source: "_detectLevel",
												Start: ast.Position{
													Column: 12,
													Line:   147,
												},
											},
										},
										Name: "_detectLevel",
									},
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   145,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel == -1",
										Start: ast.Position{
											Column: 8,
											Line:   145,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   145,
											},
											File:   "geo.flux",
											Source: "s2cellIDLevel",
											Start: ast.Position{
												Column: 8,
												Line:   145,
											},
										},
									},
									Name: "s2cellIDLevel",
								},
								Operator: 17,
								Right: &ast.UnaryExpression{
									Argument: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   145,
												},
												File:   "geo.flux",
												Source: "1",
												Start: ast.Position{
													Column: 26,
													Line:   145,
												},
											},
										},
										Value: int64(1),
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   145,
											},
											File:   "geo.flux",
											Source: "-1",
											Start: ast.Position{
												Column: 25,
												Line:   145,
											},
										},
									},
									Operator: 6,
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   160,
								},
								File:   "geo.flux",
								Source: "_prepared =\n    if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })",
								Start: ast.Position{
									Column: 3,
									Line:   150,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   150,
									},
									File:   "geo.flux",
									Source: "_prepared",
									Start: ast.Position{
										Column: 3,
										Line:   150,
									},
								},
							},
							Name: "_prepared",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   155,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 7,
													Line:   155,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   159,
											},
											File:   "geo.flux",
											Source: "tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))",
											Start: ast.Position{
												Column: 7,
												Line:   155,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   159,
													},
													File:   "geo.flux",
													Source: "fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
													Start: ast.Position{
														Column: 16,
														Line:   156,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   159,
														},
														File:   "geo.flux",
														Source: "fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
														Start: ast.Position{
															Column: 16,
															Line:   156,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   156,
															},
															File:   "geo.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 16,
																Line:   156,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   159,
															},
															File:   "geo.flux",
															Source: "(r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
															Start: ast.Position{
																Column: 20,
																Line:   156,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   159,
																},
																File:   "geo.flux",
																Source: "({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           })",
																Start: ast.Position{
																	Column: 27,
																	Line:   156,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 13,
																		Line:   159,
																	},
																	File:   "geo.flux",
																	Source: "{\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }",
																	Start: ast.Position{
																		Column: 28,
																		Line:   156,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 93,
																			Line:   158,
																		},
																		File:   "geo.flux",
																		Source: "_s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																		Start: ast.Position{
																			Column: 16,
																			Line:   158,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   158,
																			},
																			File:   "geo.flux",
																			Source: "_s2_cell_id_xxx",
																			Start: ast.Position{
																				Column: 16,
																				Line:   158,
																			},
																		},
																	},
																	Name: "_s2_cell_id_xxx",
																},
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 92,
																					Line:   158,
																				},
																				File:   "geo.flux",
																				Source: "point: {lat: r.lat, lon: r.lon}, level: level",
																				Start: ast.Position{
																					Column: 47,
																					Line:   158,
																				},
																			},
																		},
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   158,
																					},
																					File:   "geo.flux",
																					Source: "point: {lat: r.lat, lon: r.lon}",
																					Start: ast.Position{
																						Column: 47,
																						Line:   158,
																					},
																				},
																			},
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 52,
																							Line:   158,
																						},
																						File:   "geo.flux",
																						Source: "point",
																						Start: ast.Position{
																							Column: 47,
																							Line:   158,
																						},
																					},
																				},
																				Name: "point",
																			},
																			Value: &ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 78,
																							Line:   158,
																						},
																						File:   "geo.flux",
																						Source: "{lat: r.lat, lon: r.lon}",
																						Start: ast.Position{
																							Column: 54,
																							Line:   158,
																						},
																					},
																				},
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 65,
																								Line:   158,
																							},
																							File:   "geo.flux",
																							Source: "lat: r.lat",
																							Start: ast.Position{
																								Column: 55,
																								Line:   158,
																							},
																						},
																					},
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 58,
																									Line:   158,
																								},
																								File:   "geo.flux",
																								Source: "lat",
																								Start: ast.Position{
																									Column: 55,
																									Line:   158,
																								},
																							},
																						},
																						Name: "lat",
																					},
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 65,
																									Line:   158,
																								},
																								File:   "geo.flux",
																								Source: "r.lat",
																								Start: ast.Position{
																									Column: 60,
																									Line:   158,
																								},
																							},
																						},
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 61,
																										Line:   158,
																									},
																									File:   "geo.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 60,
																										Line:   158,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 65,
																										Line:   158,
																									},
																									File:   "geo.flux",
																									Source: "lat",
																									Start: ast.Position{
																										Column: 62,
																										Line:   158,
																									},
																								},
																							},
																							Name: "lat",
																						},
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 77,
																								Line:   158,
																							},
																							File:   "geo.flux",
																							Source: "lon: r.lon",
																							Start: ast.Position{
																								Column: 67,
																								Line:   158,
																							},
																						},
																					},
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 70,
																									Line:   158,
																								},
																								File:   "geo.flux",
																								Source: "lon",
																								Start: ast.Position{
																									Column: 67,
																									Line:   158,
																								},
																							},
																						},
																						Name: "lon",
																					},
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 77,
																									Line:   158,
																								},
																								File:   "geo.flux",
																								Source: "r.lon",
																								Start: ast.Position{
																									Column: 72,
																									Line:   158,
																								},
																							},
																						},
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 73,
																										Line:   158,
																									},
																									File:   "geo.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 72,
																										Line:   158,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 77,
																										Line:   158,
																									},
																									File:   "geo.flux",
																									Source: "lon",
																									Start: ast.Position{
																										Column: 74,
																										Line:   158,
																									},
																								},
																							},
																							Name: "lon",
																						},
																					},
																				}},
																				With: nil,
																			},
																		}, &ast.Property{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 92,
																						Line:   158,
																					},
																					File:   "geo.flux",
																					Source: "level: level",
																					Start: ast.Position{
																						Column: 80,
																						Line:   158,
																					},
																				},
																			},
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 85,
																							Line:   158,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 80,
																							Line:   158,
																						},
																					},
																				},
																				Name: "level",
																			},
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 92,
																							Line:   158,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 87,
																							Line:   158,
																						},
																					},
																				},
																				Name: "level",
																			},
																		}},
																		With: nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 93,
																				Line:   158,
																			},
																			File:   "geo.flux",
																			Source: "s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																			Start: ast.Position{
																				Column: 33,
																				Line:   158,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   158,
																				},
																				File:   "geo.flux",
																				Source: "s2CellIDToken",
																				Start: ast.Position{
																					Column: 33,
																					Line:   158,
																				},
																			},
																		},
																		Name: "s2CellIDToken",
																	},
																},
															}},
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   157,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 14,
																			Line:   157,
																		},
																	},
																},
																Name: "r",
															},
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   156,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   156,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   156,
																	},
																	File:   "geo.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   156,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   159,
												},
												File:   "geo.flux",
												Source: "map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))",
												Start: ast.Position{
													Column: 12,
													Line:   156,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   156,
													},
													File:   "geo.flux",
													Source: "map",
													Start: ast.Position{
														Column: 12,
														Line:   156,
													},
												},
											},
											Name: "map",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   160,
										},
										File:   "geo.flux",
										Source: "tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })",
										Start: ast.Position{
											Column: 7,
											Line:   155,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   160,
												},
												File:   "geo.flux",
												Source: "columns: { _s2_cell_id_xxx: newColumn }",
												Start: ast.Position{
													Column: 19,
													Line:   160,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   160,
													},
													File:   "geo.flux",
													Source: "columns: { _s2_cell_id_xxx: newColumn }",
													Start: ast.Position{
														Column: 19,
														Line:   160,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   160,
														},
														File:   "geo.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 19,
															Line:   160,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   160,
														},
														File:   "geo.flux",
														Source: "{ _s2_cell_id_xxx: newColumn }",
														Start: ast.Position{
															Column: 28,
															Line:   160,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   160,
															},
															File:   "geo.flux",
															Source: "_s2_cell_id_xxx: newColumn",
															Start: ast.Position{
																Column: 30,
																Line:   160,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   160,
																},
																File:   "geo.flux",
																Source: "_s2_cell_id_xxx",
																Start: ast.Position{
																	Column: 30,
																	Line:   160,
																},
															},
														},
														Name: "_s2_cell_id_xxx",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   160,
																},
																File:   "geo.flux",
																Source: "newColumn",
																Start: ast.Position{
																	Column: 47,
																	Line:   160,
																},
															},
														},
														Name: "newColumn",
													},
												}},
												With: nil,
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   160,
											},
											File:   "geo.flux",
											Source: "rename(columns: { _s2_cell_id_xxx: newColumn })",
											Start: ast.Position{
												Column: 12,
												Line:   160,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   160,
												},
												File:   "geo.flux",
												Source: "rename",
												Start: ast.Position{
													Column: 12,
													Line:   160,
												},
											},
										},
										Name: "rename",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   160,
									},
									File:   "geo.flux",
									Source: "if level == _s2cellIDLevel then\n      tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n      tables\n        |> map(fn: (r) => ({\n             r with\n               _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)\n           }))\n        |> rename(columns: { _s2_cell_id_xxx: newColumn })",
									Start: ast.Position{
										Column: 5,
										Line:   151,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   152,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 7,
												Line:   152,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   153,
										},
										File:   "geo.flux",
										Source: "tables\n\t    |> duplicate(column: \"s2_cell_id\", as: newColumn)",
										Start: ast.Position{
											Column: 7,
											Line:   152,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   153,
												},
												File:   "geo.flux",
												Source: "column: \"s2_cell_id\", as: newColumn",
												Start: ast.Position{
													Column: 19,
													Line:   153,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   153,
													},
													File:   "geo.flux",
													Source: "column: \"s2_cell_id\"",
													Start: ast.Position{
														Column: 19,
														Line:   153,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   153,
														},
														File:   "geo.flux",
														Source: "column",
														Start: ast.Position{
															Column: 19,
															Line:   153,
														},
													},
												},
												Name: "column",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   153,
														},
														File:   "geo.flux",
														Source: "\"s2_cell_id\"",
														Start: ast.Position{
															Column: 27,
															Line:   153,
														},
													},
												},
												Value: "s2_cell_id",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   153,
													},
													File:   "geo.flux",
													Source: "as: newColumn",
													Start: ast.Position{
														Column: 41,
														Line:   153,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   153,
														},
														File:   "geo.flux",
														Source: "as",
														Start: ast.Position{
															Column: 41,
															Line:   153,
														},
													},
												},
												Name: "as",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   153,
														},
														File:   "geo.flux",
														Source: "newColumn",
														Start: ast.Position{
															Column: 45,
															Line:   153,
														},
													},
												},
												Name: "newColumn",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   153,
											},
											File:   "geo.flux",
											Source: "duplicate(column: \"s2_cell_id\", as: newColumn)",
											Start: ast.Position{
												Column: 9,
												Line:   153,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   153,
												},
												File:   "geo.flux",
												Source: "duplicate",
												Start: ast.Position{
													Column: 9,
													Line:   153,
												},
											},
										},
										Name: "duplicate",
									},
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   151,
										},
										File:   "geo.flux",
										Source: "level == _s2cellIDLevel",
										Start: ast.Position{
											Column: 8,
											Line:   151,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   151,
											},
											File:   "geo.flux",
											Source: "level",
											Start: ast.Position{
												Column: 8,
												Line:   151,
											},
										},
									},
									Name: "level",
								},
								Operator: 17,
								Right: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   151,
											},
											File:   "geo.flux",
											Source: "_s2cellIDLevel",
											Start: ast.Position{
												Column: 17,
												Line:   151,
											},
										},
									},
									Name: "_s2cellIDLevel",
								},
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   162,
										},
										File:   "geo.flux",
										Source: "_prepared",
										Start: ast.Position{
											Column: 5,
											Line:   162,
										},
									},
								},
								Name: "_prepared",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   163,
									},
									File:   "geo.flux",
									Source: "_prepared\n      |> group(columns: [newColumn])",
									Start: ast.Position{
										Column: 5,
										Line:   162,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   163,
											},
											File:   "geo.flux",
											Source: "columns: [newColumn]",
											Start: ast.Position{
												Column: 16,
												Line:   163,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   163,
												},
												File:   "geo.flux",
												Source: "columns: [newColumn]",
												Start: ast.Position{
													Column: 16,
													Line:   163,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   163,
													},
													File:   "geo.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 16,
														Line:   163,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   163,
													},
													File:   "geo.flux",
													Source: "[newColumn]",
													Start: ast.Position{
														Column: 25,
														Line:   163,
													},
												},
											},
											Elements: []ast.Expression{&ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   163,
														},
														File:   "geo.flux",
														Source: "newColumn",
														Start: ast.Position{
															Column: 26,
															Line:   163,
														},
													},
												},
												Name: "newColumn",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   163,
										},
										File:   "geo.flux",
										Source: "group(columns: [newColumn])",
										Start: ast.Position{
											Column: 10,
											Line:   163,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   163,
											},
											File:   "geo.flux",
											Source: "group",
											Start: ast.Position{
												Column: 10,
												Line:   163,
											},
										},
									},
									Name: "group",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   163,
								},
								File:   "geo.flux",
								Source: "return\n    _prepared\n      |> group(columns: [newColumn])",
								Start: ast.Position{
									Column: 3,
									Line:   161,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   143,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   143,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   143,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   143,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   143,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   143,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   143,
							},
							File:   "geo.flux",
							Source: "newColumn",
							Start: ast.Position{
								Column: 27,
								Line:   143,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   143,
								},
								File:   "geo.flux",
								Source: "newColumn",
								Start: ast.Position{
									Column: 27,
									Line:   143,
								},
							},
						},
						Name: "newColumn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   143,
							},
							File:   "geo.flux",
							Source: "level",
							Start: ast.Position{
								Column: 38,
								Line:   143,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   143,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 38,
									Line:   143,
								},
							},
						},
						Name: "level",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   143,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 45,
								Line:   143,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   143,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 45,
									Line:   143,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   143,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 60,
										Line:   143,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   143,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 59,
									Line:   143,
								},
							},
						},
						Operator: 6,
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   170,
					},
					File:   "geo.flux",
					Source: "asTracks = (tables=<-, groupBy=[\"id\",\"tid\"], orderBy=[\"_time\"]) =>\n  tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
					Start: ast.Position{
						Column: 1,
						Line:   167,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   167,
						},
						File:   "geo.flux",
						Source: "asTracks",
						Start: ast.Position{
							Column: 1,
							Line:   167,
						},
					},
				},
				Name: "asTracks",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   170,
						},
						File:   "geo.flux",
						Source: "(tables=<-, groupBy=[\"id\",\"tid\"], orderBy=[\"_time\"]) =>\n  tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
						Start: ast.Position{
							Column: 12,
							Line:   167,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   168,
									},
									File:   "geo.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 3,
										Line:   168,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   169,
								},
								File:   "geo.flux",
								Source: "tables\n    |> group(columns: groupBy)",
								Start: ast.Position{
									Column: 3,
									Line:   168,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   169,
										},
										File:   "geo.flux",
										Source: "columns: groupBy",
										Start: ast.Position{
											Column: 14,
											Line:   169,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   169,
											},
											File:   "geo.flux",
											Source: "columns: groupBy",
											Start: ast.Position{
												Column: 14,
												Line:   169,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   169,
												},
												File:   "geo.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   169,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   169,
												},
												File:   "geo.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 23,
													Line:   169,
												},
											},
										},
										Name: "groupBy",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   169,
									},
									File:   "geo.flux",
									Source: "group(columns: groupBy)",
									Start: ast.Position{
										Column: 8,
										Line:   169,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   169,
										},
										File:   "geo.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   169,
										},
									},
								},
								Name: "group",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   170,
							},
							File:   "geo.flux",
							Source: "tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
							Start: ast.Position{
								Column: 3,
								Line:   168,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   170,
									},
									File:   "geo.flux",
									Source: "columns: orderBy",
									Start: ast.Position{
										Column: 13,
										Line:   170,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   170,
										},
										File:   "geo.flux",
										Source: "columns: orderBy",
										Start: ast.Position{
											Column: 13,
											Line:   170,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   170,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   170,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   170,
											},
											File:   "geo.flux",
											Source: "orderBy",
											Start: ast.Position{
												Column: 22,
												Line:   170,
											},
										},
									},
									Name: "orderBy",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   170,
								},
								File:   "geo.flux",
								Source: "sort(columns: orderBy)",
								Start: ast.Position{
									Column: 8,
									Line:   170,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   170,
									},
									File:   "geo.flux",
									Source: "sort",
									Start: ast.Position{
										Column: 8,
										Line:   170,
									},
								},
							},
							Name: "sort",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   167,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   167,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   167,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   167,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   167,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   167,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   167,
							},
							File:   "geo.flux",
							Source: "groupBy=[\"id\",\"tid\"]",
							Start: ast.Position{
								Column: 24,
								Line:   167,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   167,
								},
								File:   "geo.flux",
								Source: "groupBy",
								Start: ast.Position{
									Column: 24,
									Line:   167,
								},
							},
						},
						Name: "groupBy",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   167,
								},
								File:   "geo.flux",
								Source: "[\"id\",\"tid\"]",
								Start: ast.Position{
									Column: 32,
									Line:   167,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   167,
									},
									File:   "geo.flux",
									Source: "\"id\"",
									Start: ast.Position{
										Column: 33,
										Line:   167,
									},
								},
							},
							Value: "id",
						}, &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   167,
									},
									File:   "geo.flux",
									Source: "\"tid\"",
									Start: ast.Position{
										Column: 38,
										Line:   167,
									},
								},
							},
							Value: "tid",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   167,
							},
							File:   "geo.flux",
							Source: "orderBy=[\"_time\"]",
							Start: ast.Position{
								Column: 46,
								Line:   167,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   167,
								},
								File:   "geo.flux",
								Source: "orderBy",
								Start: ast.Position{
									Column: 46,
									Line:   167,
								},
							},
						},
						Name: "orderBy",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   167,
								},
								File:   "geo.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 54,
									Line:   167,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   167,
									},
									File:   "geo.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 55,
										Line:   167,
									},
								},
							},
							Value: "_time",
						}},
					},
				}},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   4,
					},
					File:   "geo.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   4,
						},
						File:   "geo.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "geo.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   2,
					},
					File:   "geo.flux",
					Source: "package geo",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   2,
						},
						File:   "geo.flux",
						Source: "geo",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "geo",
			},
		},
	}},
	Package: "geo",
	Path:    "experimental/geo",
}
